/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.DashboardMatrix;
import classes.DataRightsMatrix;
import classes.JsonResponses;
import classes.Module;
import classes.User;
import classes.UserRoles;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class EditUserRoleController
implements Initializable {
    private UserRoles userRole;
    private User user;
    @FXML
    private VBox root;
    @FXML
    private Label roleId;
    @FXML
    private TextField roleName;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private TabPane tabpane;
    @FXML
    private TableView<DashboardMatrix> dashboardViewTable;
    @FXML
    private TableColumn dashboardSubModule;
    @FXML
    private TableColumn dashboardView;
    @FXML
    private MaskerPane dashboardViewMasker;
    @FXML
    private ListView<Module> dataModuleList;
    @FXML
    private ListView<Module> dashboardViewModules;
    @FXML
    private TableView<DataRightsMatrix> dataRightsTable;
    @FXML
    private TableColumn datSubModule;
    @FXML
    private TableColumn dataRightsInsert;
    @FXML
    private TableColumn dataRightsView;
    @FXML
    private TableColumn dataRightsUpdate;
    @FXML
    private TableColumn dataRightsDelete;
    @FXML
    private TableColumn dataRightsPost;
    @FXML
    private TableColumn dataRightsReverse;
    @FXML
    private MaskerPane dataRightsMasker;

    public UserRoles getUserRole() {
        return this.userRole;
    }

    public void setUserRole(UserRoles userRole) {
        this.userRole = userRole;
        this.roleId.setText(userRole.getId() + "");
        this.roleName.setText(userRole.getName());
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.loadData();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.tabpane);
        this.dashboardSubModule.setCellValueFactory((Callback)new PropertyValueFactory("submodule"));
        this.dashboardView.setCellValueFactory((Callback)new PropertyValueFactory("canView"));
        ContextMenu menu = new ContextMenu();
        MenuItem selectAll = new MenuItem("Assign All");
        selectAll.setOnAction(e -> {
            try {
                Task<Void> task2 = new Task<Void>(){

                    public Void call() {
                        Platform.runLater(() -> {
                            EditUserRoleController.this.dashboardViewMasker.setText("Setting rights. Please wait");
                            EditUserRoleController.this.dashboardViewMasker.setVisible(true);
                        });
                        try {
                            int moduleId = ((Module)EditUserRoleController.this.dashboardViewModules.getSelectionModel().getSelectedItem()).getId();
                            int roleId = EditUserRoleController.this.getUserRole().getId();
                            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                            params.put("moduleId", moduleId);
                            params.put("roleId", roleId);
                            params.put("status", 1);
                            String response = Config.loadDataFromPhp("masterupdate?type=dashboardmatrix", params, EditUserRoleController.this.getUser());
                            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                            if (jr.isStatus()) {
                                Platform.runLater(() -> {
                                    EditUserRoleController.this.notificationPane.setText(jr.getMessage());
                                    EditUserRoleController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                                    EditUserRoleController.this.notificationPane.show();
                                });
                                EditUserRoleController.this.loadDashboardRights();
                            } else {
                                Platform.runLater(() -> {
                                    EditUserRoleController.this.notificationPane.setText(jr.getMessage());
                                    EditUserRoleController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                                    EditUserRoleController.this.notificationPane.show();
                                    EditUserRoleController.this.dashboardViewMasker.setVisible(false);
                                });
                            }
                        }
                        catch (Exception u) {
                            Platform.runLater(() -> {
                                EditUserRoleController.this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                                EditUserRoleController.this.notificationPane.setGraphic((Node)Config.getBanIcon());
                                EditUserRoleController.this.notificationPane.show();
                            });
                        }
                        return null;
                    }
                };
                Thread backgroundThread2 = new Thread((Runnable)task2);
                backgroundThread2.setDaemon(true);
                backgroundThread2.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        MenuItem denyAll = new MenuItem("Deny All");
        denyAll.setOnAction(e -> {
            try {
                Task<Void> task2 = new Task<Void>(){

                    public Void call() {
                        Platform.runLater(() -> {
                            EditUserRoleController.this.dashboardViewMasker.setText("Setting rights. Please wait");
                            EditUserRoleController.this.dashboardViewMasker.setVisible(true);
                        });
                        try {
                            int moduleId = ((Module)EditUserRoleController.this.dashboardViewModules.getSelectionModel().getSelectedItem()).getId();
                            int roleId = EditUserRoleController.this.getUserRole().getId();
                            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                            params.put("moduleId", moduleId);
                            params.put("roleId", roleId);
                            params.put("status", 0);
                            String response = Config.loadDataFromPhp("masterupdate?type=dashboardmatrix", params, EditUserRoleController.this.getUser());
                            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                            if (jr.isStatus()) {
                                Platform.runLater(() -> {
                                    EditUserRoleController.this.notificationPane.setText(jr.getMessage());
                                    EditUserRoleController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                                    EditUserRoleController.this.notificationPane.show();
                                });
                                EditUserRoleController.this.loadDashboardRights();
                            } else {
                                Platform.runLater(() -> {
                                    EditUserRoleController.this.notificationPane.setText(jr.getMessage());
                                    EditUserRoleController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                                    EditUserRoleController.this.notificationPane.show();
                                    EditUserRoleController.this.dashboardViewMasker.setVisible(false);
                                });
                            }
                        }
                        catch (Exception u) {
                            Platform.runLater(() -> {
                                EditUserRoleController.this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                                EditUserRoleController.this.notificationPane.setGraphic((Node)Config.getBanIcon());
                                EditUserRoleController.this.notificationPane.show();
                            });
                        }
                        return null;
                    }
                };
                Thread backgroundThread2 = new Thread((Runnable)task2);
                backgroundThread2.setDaemon(true);
                backgroundThread2.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        menu.getItems().addAll((Object[])new MenuItem[]{selectAll, denyAll});
        this.dashboardView.setContextMenu(menu);
        this.datSubModule.setCellValueFactory((Callback)new PropertyValueFactory("dataRight"));
        this.dataRightsInsert.setCellValueFactory((Callback)new PropertyValueFactory("insertCheck"));
        this.dataRightsView.setCellValueFactory((Callback)new PropertyValueFactory("viewCheck"));
        this.dataRightsUpdate.setCellValueFactory((Callback)new PropertyValueFactory("updateCheck"));
        this.dataRightsDelete.setCellValueFactory((Callback)new PropertyValueFactory("deleteCheck"));
        this.dataRightsPost.setCellValueFactory((Callback)new PropertyValueFactory("postCheck"));
        this.dataRightsReverse.setCellValueFactory((Callback)new PropertyValueFactory("reverseCheck"));
        this.dataModuleList.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            try {
                if (newSelection != null) {
                    int selectedModule = ((Module)this.dataModuleList.getSelectionModel().getSelectedItem()).getId();
                    this.loadModuleDataRights(selectedModule);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.dashboardViewModules.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> this.loadDashboardRights());
    }

    public void loadData() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                ObservableList<Module> allModules = new Module().getAllModules(EditUserRoleController.this.getUser());
                EditUserRoleController.this.dataModuleList.setItems(allModules);
                EditUserRoleController.this.dataModuleList.getSelectionModel().select(0);
                EditUserRoleController.this.dashboardViewModules.setItems(allModules);
                EditUserRoleController.this.dashboardViewModules.getSelectionModel().select(0);
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void loadModuleDataRights(final int moduleId) {
        Task<Void> task2 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> EditUserRoleController.this.dataRightsMasker.setVisible(true));
                ObservableList<DataRightsMatrix> matrix = new DataRightsMatrix().getMatrix(moduleId, EditUserRoleController.this.getUserRole().getId(), EditUserRoleController.this.getUser());
                EditUserRoleController.this.dataRightsTable.setItems(matrix);
                Platform.runLater(() -> EditUserRoleController.this.dataRightsMasker.setVisible(false));
                return null;
            }
        };
        Thread backgroundThread2 = new Thread((Runnable)task2);
        backgroundThread2.setDaemon(true);
        backgroundThread2.start();
    }

    public void loadDashboardRights() {
        Task<Void> task2 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> EditUserRoleController.this.dashboardViewMasker.setVisible(true));
                int selectedModule = ((Module)EditUserRoleController.this.dashboardViewModules.getSelectionModel().getSelectedItem()).getId();
                ObservableList<DashboardMatrix> matrix = new DashboardMatrix().getMatrix(EditUserRoleController.this.getUser(), EditUserRoleController.this.getUserRole().getId(), selectedModule);
                Platform.runLater(() -> {
                    EditUserRoleController.this.dashboardViewTable.setItems(matrix);
                    EditUserRoleController.this.dashboardViewMasker.setVisible(false);
                });
                return null;
            }
        };
        Thread backgroundThread2 = new Thread((Runnable)task2);
        backgroundThread2.setDaemon(true);
        backgroundThread2.start();
    }
}

