/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.Customer;
import classes.Employee;
import classes.JsonResponses;
import classes.PricingGroup;
import classes.ShopLocation;
import classes.User;
import classes.UserRoles;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import java.net.URL;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class EditUserController
implements Initializable {
    private User user;
    @FXML
    private VBox holder;
    @FXML
    private TextField userName;
    @FXML
    private TextField fullName;
    @FXML
    private TextField emailAddress;
    @FXML
    private JFXButton addUser;
    @FXML
    private JFXButton reset;
    @FXML
    private TextField phoneNumber;
    @FXML
    private PasswordField password;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private ComboBox<UserRoles> userRole;
    private User toEdit;
    @FXML
    private ComboBox<ShopLocation> warehouse;
    @FXML
    private ComboBox<PricingGroup> pricingGroup;
    @FXML
    private ComboBox<Customer> receivablesAccount;
    @FXML
    private Button searchCustomer;
    @FXML
    private ComboBox<Bank> defaultBank;
    @FXML
    private ComboBox<Employee> employeeAccount;

    public User getUser() {
        return this.user;
    }

    public void setUser(final User user) {
        this.user = user;
        this.loadCustomers();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    EditUserController.this.notificationPane.setText("Loading Values. Please wait");
                    EditUserController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    EditUserController.this.notificationPane.show();
                });
                ObservableList<UserRoles> allRoles = new UserRoles().getAllRoles(user);
                ObservableList<Employee> allEmployee = new Employee().getAllEmployees(user);
                ObservableList<ShopLocation> allLocations = new ShopLocation().getAllLocations(user);
                ObservableList<PricingGroup> allGroups = new PricingGroup().getPricingGroups(user);
                ObservableList<Bank> allBanks = Bank.getAllBanks(user);
                Platform.runLater(() -> {
                    EditUserController.this.warehouse.setItems(allLocations);
                    EditUserController.this.userRole.setItems(allRoles);
                    EditUserController.this.employeeAccount.setItems(allEmployee);
                    EditUserController.this.pricingGroup.setItems(allGroups);
                    EditUserController.this.defaultBank.setItems(allBanks);
                    EditUserController.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public User getToEdit() {
        return this.toEdit;
    }

    public void setToEdit(User toEdit) {
        this.toEdit = toEdit;
        this.userName.setText(toEdit.getUserName());
        this.fullName.setText(toEdit.getFullName());
        this.phoneNumber.setText(toEdit.getPhone());
        this.emailAddress.setText(toEdit.getEmail());
        this.userRole.setValue((Object)toEdit.getUserRole());
        this.employeeAccount.setValue((Object)toEdit.getEmployee());
        this.receivablesAccount.setValue((Object)toEdit.getReceivablesAccount());
        this.warehouse.setValue((Object)toEdit.getWarehouse());
        this.pricingGroup.setValue((Object)toEdit.getPricingGroup());
        this.defaultBank.setValue((Object)toEdit.getDefaultBank());
    }

    private void loadCustomers() {
        final Node original = this.searchCustomer.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> EditUserController.this.searchCustomer.setGraphic((Node)Config.getLoader()));
                ObservableList<Customer> allCustomers = new Customer().getAllCustomers(EditUserController.this.user);
                allCustomers.sort(Comparator.comparing(Customer::getCustomerName));
                Platform.runLater(() -> {
                    EditUserController.this.receivablesAccount.setItems(allCustomers);
                    EditUserController.this.searchCustomer.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.reset.setOnAction(e -> {
            Stage stage = (Stage)this.reset.getScene().getWindow();
            stage.close();
        });
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.userName, Validator.createEmptyValidator((String)"Username is required"));
        vs.registerValidator((Control)this.fullName, Validator.createEmptyValidator((String)"Full Name is required"));
        this.addUser.setOnAction(e -> {
            String tEmployeeAccount;
            int roleId;
            int tBank;
            int tPricingGroup;
            int tWarehouse;
            String tReceivablesAccount;
            String message = "";
            boolean error = false;
            String tUserName = this.userName.getText().trim();
            try {
                if (tUserName.equals("")) {
                    error = true;
                    message = "Username is mandatory. ";
                } else if (tUserName.length() < 4) {
                    error = true;
                    message = message + "Username must be a minimum of 4 characters. ";
                }
            }
            catch (NullPointerException t) {
                error = true;
                message = "Username is mandatory. ";
            }
            String tFullName = this.fullName.getText().trim();
            try {
                if (tFullName.equals("")) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Full Name is mandatory. ";
                }
            }
            catch (NullPointerException t) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Full Name is mandatory. ";
            }
            try {
                tReceivablesAccount = ((Customer)this.receivablesAccount.getValue()).getCustomerNumber();
            }
            catch (Exception ignored) {
                tReceivablesAccount = "";
            }
            try {
                tWarehouse = ((ShopLocation)this.warehouse.getValue()).getId();
            }
            catch (Exception ignored) {
                tWarehouse = 0;
            }
            try {
                tPricingGroup = ((PricingGroup)this.pricingGroup.getValue()).getId();
            }
            catch (Exception ignored) {
                tPricingGroup = 0;
            }
            try {
                tBank = ((Bank)this.defaultBank.getValue()).getCode();
            }
            catch (Exception ignored) {
                tBank = 0;
            }
            try {
                roleId = ((UserRoles)this.userRole.getValue()).getId();
            }
            catch (Exception t) {
                roleId = 0;
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the user role ";
            }
            String tPassword = this.password.getText().trim();
            try {
                tEmployeeAccount = ((Employee)this.employeeAccount.getValue()).getEmployeeNumber();
            }
            catch (Exception o) {
                tEmployeeAccount = "";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            } else {
                try {
                    String tPhoneNumber = this.phoneNumber.getText().trim();
                    String tEmailAddress = this.emailAddress.getText().trim();
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("userName", tUserName);
                    params.put("fullName", tFullName);
                    params.put("emailAddress", tEmailAddress);
                    params.put("phoneNumber", tPhoneNumber);
                    params.put("roleId", roleId);
                    params.put("employeeAccount", tEmployeeAccount);
                    params.put("receivablesAccount", tReceivablesAccount);
                    params.put("warehouse", tWarehouse);
                    params.put("pricingGroup", tPricingGroup);
                    params.put("defaultBank", tBank);
                    params.put("password", tPassword);
                    String response = Config.loadDataFromPhp("masterupdate?type=updateuser", params, this.getUser());
                    System.out.println(response);
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        this.userName.setText("");
                        this.fullName.setText("");
                        this.phoneNumber.setText("");
                        this.emailAddress.setText("");
                        this.password.setText("");
                        ((Stage)this.addUser.getScene().getWindow()).close();
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
                catch (Exception t) {
                    this.notificationPane.setText("We experienced an error while processing your request. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
        });
        this.searchCustomer.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("customer", gson.toJson((Object)this.receivablesAccount.getItems()), this.getUser());
                this.receivablesAccount.setValue(gson.fromJson(response, Customer.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

