/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.FixedAssets;
import classes.JsonResponses;
import classes.SalesLines;
import classes.ShopItem;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;

public class EditSalesLineController
implements Initializable {
    private String documentType;
    private User user;
    private SalesLines line;
    private ObservableList<ShopItem> items;
    private ObservableList<FixedAssets> assets;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label docNo;
    @FXML
    private Label lineId;
    @FXML
    private ComboBox<ShopItem> product;
    @FXML
    private Button searchItem;
    @FXML
    private TextField unitPrice;
    @FXML
    private TextField quantity;
    @FXML
    private Button cancel;
    @FXML
    private Button save;
    @FXML
    private ComboBox<String> itemType;
    @FXML
    private TextField discount;
    @FXML
    private TextField kilometres;
    @FXML
    private ComboBox<FixedAssets> vehicle;
    @FXML
    private HBox discountHBox;
    @FXML
    private HBox kilometresHBox;
    @FXML
    private HBox vehicleHBox;
    @FXML
    private HBox itemTypeHBox;

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
        if (documentType.equalsIgnoreCase("StoreRequisition")) {
            this.itemTypeHBox.setVisible(false);
            this.discountHBox.setVisible(false);
        } else {
            this.kilometresHBox.setVisible(false);
            this.vehicleHBox.setVisible(false);
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public SalesLines getLine() {
        return this.line;
    }

    public void setLine(SalesLines line) {
        this.line = line;
        this.docNo.setText(line.getDocNo());
        this.lineId.setText(line.getLineId() + "");
        this.quantity.setText(line.getQuantity() + "");
        this.unitPrice.setText(line.getUnitPrice() + "");
        this.quantity.requestFocus();
        try {
            ObservableList selectedItems = FXCollections.observableArrayList((Collection)this.items.stream().filter(v -> v.getCode().equalsIgnoreCase(line.getItemNo())).collect(Collectors.toList()));
            this.product.setValue(selectedItems.get(0));
        }
        catch (Exception selectedItems) {
            // empty catch block
        }
        this.itemType.setValue((Object)line.getItemType());
        this.discount.setText(line.getDiscount() + "");
        this.kilometres.setText(line.getKilometres() + "");
        try {
            ObservableList selectedFA = FXCollections.observableArrayList((Collection)this.assets.stream().filter(v -> v.getAssetNo().equalsIgnoreCase(line.getVehicle().getAssetNo())).collect(Collectors.toList()));
            this.vehicle.setValue(selectedFA.get(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ObservableList<ShopItem> getItems() {
        return this.items;
    }

    public void setItems(ObservableList<ShopItem> items) {
        this.items = items;
        this.product.setItems(items);
    }

    public ObservableList<FixedAssets> getAssets() {
        return this.assets;
    }

    public void setAssets(ObservableList<FixedAssets> assets) {
        this.assets = assets;
        this.vehicle.setItems(assets);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.discountHBox.managedProperty().bind((ObservableValue)this.discountHBox.visibleProperty());
        this.kilometresHBox.managedProperty().bind((ObservableValue)this.kilometresHBox.visibleProperty());
        this.vehicleHBox.managedProperty().bind((ObservableValue)this.vehicleHBox.visibleProperty());
        this.itemTypeHBox.managedProperty().bind((ObservableValue)this.itemTypeHBox.visibleProperty());
        this.unitPrice.setDisable(!Config.editPrices);
        this.discount.setDisable(!Config.editPrices);
        this.searchItem.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("shopitem", gson.toJson((Object)this.product.getItems()), this.getUser());
                this.product.setValue(gson.fromJson(response, ShopItem.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.quantity.requestFocus();
        this.cancel.setOnAction(e -> ((Stage)this.cancel.getScene().getWindow()).close());
        this.save.setOnAction(e -> {
            try {
                double tKilometres = 0.0;
                double tDiscount = 0.0;
                String tVehicle = "";
                try {
                    tKilometres = Double.parseDouble(this.kilometres.getText().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tDiscount = Double.parseDouble(this.discount.getText().trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tVehicle = ((FixedAssets)this.vehicle.getValue()).getAssetNo();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SalesLines line = this.getLine();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("headerNo", line.getDocNo());
                params.put("itemType", this.itemType.getValue());
                params.put("documentType", this.getDocumentType());
                params.put("lineId", line.getLineId());
                params.put("quantity", Double.parseDouble(this.quantity.getText().trim()));
                params.put("unitPrice", Double.parseDouble(this.unitPrice.getText().trim()));
                params.put("discount", tDiscount);
                params.put("kilometres", tKilometres);
                params.put("vehicle", tVehicle);
                params.put("itemNo", ((ShopItem)this.product.getValue()).getCode());
                String response = Config.loadDataFromPhp("masterupdate?type=salesline", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    ((Stage)this.cancel.getScene().getWindow()).close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (Exception y) {
                y.printStackTrace();
                this.notificationPane.setText("We encountered an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
    }

    public void setItemTypes(ObservableList<String> items) {
        this.itemType.setItems(items);
    }
}

