/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.Member;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.AllMembersController;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import sun.misc.BASE64Decoder;

public class EditMemberController
implements Initializable {
    @FXML
    private AnchorPane root;
    @FXML
    private AnchorPane holder;
    @FXML
    private TextField firstName;
    @FXML
    private TextField middleName;
    @FXML
    private TextField lastName;
    @FXML
    private ImageView profilePhoto;
    @FXML
    private TextField idNumber;
    @FXML
    private TextField phoneNumber;
    @FXML
    private TextField emailAddress;
    @FXML
    private DatePicker dateOfBirth;
    @FXML
    private TextField kraPin;
    @FXML
    private JFXButton addMember;
    @FXML
    private JFXButton reset;
    @FXML
    private Hyperlink memberNumber;
    @FXML
    private Hyperlink loanBalance;
    @FXML
    private Hyperlink savings;
    @FXML
    private Hyperlink vehiclesOwned;
    @FXML
    private Hyperlink shares;
    @FXML
    private Hyperlink contributions;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private JFXButton deleteMember;
    @FXML
    private JFXButton memberStatement;
    @FXML
    private JFXButton memberMonthlyStatement;
    @FXML
    private JFXButton allLoansStatement;
    private User user;
    private Member member;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member iMember) {
        this.member = iMember;
        this.memberNumber.setText(iMember.getMemberNumber());
        Platform.runLater(() -> {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("memberNumber", iMember.getMemberNumber());
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterfetch?type=memberdetails", params, this.getUser());
                Member xMember = (Member)g.fromJson(response2, Member.class);
                this.firstName.setText(xMember.getFirstName());
                this.middleName.setText(xMember.getMiddleName());
                this.lastName.setText(xMember.getLastName());
                try {
                    BASE64Decoder decoder = new BASE64Decoder();
                    byte[] imageByte = decoder.decodeBuffer(xMember.getPhotoBlob());
                    ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
                    Image image = new Image((InputStream)bis);
                    this.profilePhoto.setImage(image);
                    bis.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.idNumber.setText(xMember.getIdNumber() + "");
                this.phoneNumber.setText(xMember.getPhoneNumber());
                this.emailAddress.setText(xMember.getEmail());
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("d/MM/yyyy");
                String date = xMember.getDateOfBirth();
                try {
                    LocalDate localDate = LocalDate.parse(date, formatter);
                    this.dateOfBirth.setValue((Object)localDate);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.kraPin.setText(xMember.getPin());
                this.shares.setText(Config.formatNumber(xMember.getShareCapital()));
                this.contributions.setText(Config.formatNumber(xMember.getShareDeposit()));
                this.savings.setText(xMember.getSavingsString());
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        });
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.reset.setOnAction(e -> {
            try {
                AllMembersController.editMemberStage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.deleteMember.setOnAction(e -> {
            try {
                String path = System.getProperty("user.dir");
                path = path.replace("\\", "/");
                String fileLocation = path + "/loading.gif";
                File file = new File(fileLocation);
                Image image2 = new Image(file.toURI().toString());
                ImageView loader = new ImageView(image2);
                loader.setFitHeight(30.0);
                loader.setFitWidth(30.0);
                this.notificationPane.setGraphic((Node)loader);
                this.notificationPane.getStyleClass().add((Object)"dark");
                this.notificationPane.setText("Deleting member. Please wait...");
                this.notificationPane.show();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("memberNumber", this.getMember().getMemberNumber());
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterdelete?type=member", params, this.getUser());
                System.out.println(response2);
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.notificationPane.setText(myResponse.getMessage());
                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.CHECK);
                    icon.setStyle("-fx-fill: #4CAF50;");
                    icon.setSize("24.0");
                    this.notificationPane.setGraphic((Node)icon);
                    this.clear();
                    this.addMember.setDisable(true);
                    this.deleteMember.setDisable(true);
                    this.memberMonthlyStatement.setDisable(true);
                    this.memberStatement.setDisable(true);
                    this.allLoansStatement.setDisable(true);
                } else {
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                }
                this.addMember.setDisable(true);
            }
            catch (Exception t) {
                t.printStackTrace();
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
                icon.setStyle("-fx-fill: #d32f2f;");
                icon.setSize("24.0");
                this.notificationPane.setGraphic((Node)icon);
                this.addMember.setDisable(false);
            }
        });
        this.memberStatement.setOnAction(e -> {
            Member member = new Member();
            member.setMemberNumber(this.memberNumber.getText());
            member.getMemberStatement(this.getUser());
        });
        this.memberMonthlyStatement.setOnAction(e -> {
            Member member = new Member();
            member.setMemberNumber(this.memberNumber.getText());
            member.getMemberMonthlyStatement(this.getUser());
        });
        this.allLoansStatement.setOnAction(e -> {});
        this.addMember.setOnAction(e -> {
            try {
                String path = System.getProperty("user.dir");
                path = path.replace("\\", "/");
                String fileLocation = path + "/loading.gif";
                File file = new File(fileLocation);
                Image image2 = new Image(file.toURI().toString());
                ImageView loader = new ImageView(image2);
                loader.setFitHeight(30.0);
                loader.setFitWidth(30.0);
                this.notificationPane.setGraphic((Node)loader);
                this.notificationPane.getStyleClass().add((Object)"dark");
                this.notificationPane.setText("Updating member details. Please wait...");
                this.notificationPane.show();
                String fName = "";
                try {
                    fName = this.firstName.getText().trim();
                }
                catch (Exception y) {
                    fName = "";
                }
                String mName = "";
                try {
                    mName = this.middleName.getText().trim();
                }
                catch (Exception y) {
                    mName = "";
                }
                String lName = "";
                try {
                    lName = this.lastName.getText().trim();
                }
                catch (Exception y) {
                    lName = "";
                }
                String idNo = "";
                try {
                    idNo = this.idNumber.getText().trim();
                }
                catch (Exception y) {
                    idNo = "";
                }
                String phoneNo = "";
                try {
                    phoneNo = this.phoneNumber.getText().trim();
                }
                catch (Exception y) {
                    phoneNo = "";
                }
                String email = "";
                try {
                    email = this.emailAddress.getText().trim();
                }
                catch (Exception y) {
                    email = "";
                }
                String pin = "";
                try {
                    pin = this.kraPin.getText().trim();
                }
                catch (Exception y) {
                    pin = "";
                }
                LocalDate dob = null;
                try {
                    dob = (LocalDate)this.dateOfBirth.getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String refined = "0000-00-00";
                try {
                    String myDob = dob.toString();
                    String[] info = myDob.split("-");
                    refined = info[2] + "-" + info[0] + "-" + info[1];
                    Date date = Date.from(dob.atStartOfDay(ZoneId.systemDefault()).toInstant());
                }
                catch (NullPointerException t) {
                    Date date = new Date();
                }
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("memberNumber", this.getMember().getMemberNumber());
                params.put("fName", fName);
                params.put("mName", mName);
                params.put("lName", lName);
                params.put("idNo", idNo);
                params.put("phoneNo", phoneNo);
                params.put("email", email);
                params.put("pin", pin);
                params.put("dob", refined);
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterupdate?type=members", params, this.getUser());
                System.out.println(response2);
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                } else {
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                }
                this.addMember.setDisable(false);
            }
            catch (Exception t) {
                t.printStackTrace();
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.addMember.setDisable(false);
            }
        });
        final ContextMenu imageOptions = new ContextMenu();
        MenuItem upload = new MenuItem("Upload");
        upload.setOnAction(e -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select Item Picture");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Images", new String[]{"*.jpg", "*.png"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"})});
            File file = chooser.showOpenDialog((Window)new Stage());
            if (file != null) {
                this.openFile(file);
            }
        });
        MenuItem reset = new MenuItem("Reset to Default");
        reset.setOnAction(e -> {
            String path = System.getProperty("user.dir");
            path = path.replace("\\", "/");
            String fileLocation = path + "/holder.png";
            File imgFile = new File(fileLocation);
            this.openFile(imgFile);
        });
        imageOptions.getItems().addAll((Object[])new MenuItem[]{upload, reset});
        this.profilePhoto.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent event) {
                imageOptions.show((Node)EditMemberController.this.profilePhoto, event.getScreenX(), event.getScreenY());
            }
        });
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator((Control)this.firstName, Validator.createEmptyValidator((String)"First name is required"));
        validationSupport.registerValidator((Control)this.lastName, Validator.createEmptyValidator((String)"Last name is required"));
        validationSupport.registerValidator((Control)this.idNumber, Validator.createEmptyValidator((String)"Id number is required"));
        validationSupport.registerValidator((Control)this.phoneNumber, Validator.createEmptyValidator((String)"Phone number is required"));
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
    }

    private void openFile(File file) {
        try {
            Image image = new Image(file.toURI().toString());
            try {
                Image image2 = new Image(file.toURI().toString());
                ImageView loader = new ImageView(image2);
                loader.setFitHeight(30.0);
                loader.setFitWidth(30.0);
                this.notificationPane.setGraphic((Node)loader);
                this.notificationPane.getStyleClass().add((Object)"dark");
                this.notificationPane.setText("Updating member photo. Please wait...");
                this.notificationPane.show();
                ByteArrayOutputStream ba = Config.convertFileToJson(file.getPath());
                String photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("memberNumber", this.getMember().getMemberNumber());
                params.put("photo", photoJson);
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterupdate?type=memberprofilephoto", params, this.getUser());
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                } else {
                    this.notificationPane.setText(myResponse.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                }
                this.addMember.setDisable(false);
                this.profilePhoto.setImage(image);
            }
            catch (Exception t) {
                t.printStackTrace();
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.addMember.setDisable(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clear() {
        this.firstName.setText(null);
        this.middleName.setText(null);
        this.lastName.setText(null);
        this.idNumber.setText(null);
        this.phoneNumber.setText(null);
        this.emailAddress.setText(null);
        this.dateOfBirth.setValue(null);
        this.kraPin.setText(null);
    }
}

