/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Investment;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;

public class EditInvestmentController
implements Initializable {
    @FXML
    private AnchorPane root;
    @FXML
    private AnchorPane holder;
    @FXML
    private TextField investmentNumber;
    @FXML
    private TextField description;
    @FXML
    private DatePicker startDate;
    @FXML
    private JFXButton editInvestment;
    @FXML
    private JFXButton cancel;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private JFXButton deleteInvestmentTab;
    @FXML
    private FontAwesomeIconView deleteInvestmentIcon;
    @FXML
    private JFXButton investmentCard;
    @FXML
    private JFXButton investmentStatement;
    private Investment investment;

    public Investment getInvestment() {
        return this.investment;
    }

    public void setInvestment(Investment iInvestment) {
        this.investment = iInvestment;
        this.investmentNumber.setText(iInvestment.getInvestmentNo());
        this.description.setText(iInvestment.getDescription());
        String date = iInvestment.getStartDate();
        LocalDate localDate = LocalDate.parse(date);
        this.startDate.setValue((Object)localDate);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.cancel.setOnAction(e -> {
            try {
                Stage stage = (Stage)this.cancel.getScene().getWindow();
                stage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.deleteInvestmentTab.setOnAction(e -> {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("investmentNumber", this.getInvestment().getInvestmentNo());
                String response2 = Config.loadDataFromPhp("masterdelete?type=deleteInvestment", params, new User());
                Gson g = new Gson();
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.notificationPane.setText(myResponse.getMessage());
                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.CHECK);
                    icon.setStyle("-fx-fill: #4CAF50;");
                    icon.setSize("24.0");
                    this.notificationPane.setGraphic((Node)icon);
                    this.notificationPane.show();
                    this.clear();
                    this.editInvestment.setDisable(true);
                    this.deleteInvestmentTab.setDisable(true);
                    this.investmentCard.setDisable(true);
                    this.investmentStatement.setDisable(true);
                } else {
                    this.notificationPane.setText(myResponse.getMessage());
                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TIMES);
                    icon.setStyle("-fx-fill: #d32f2f;");
                    icon.setSize("24.0");
                    this.notificationPane.setGraphic((Node)icon);
                }
                this.editInvestment.setDisable(true);
            }
            catch (Exception t) {
                t.printStackTrace();
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
                icon.setStyle("-fx-fill: #d32f2f;");
                icon.setSize("24.0");
                this.notificationPane.setGraphic((Node)icon);
                this.notificationPane.show();
                this.editInvestment.setDisable(false);
            }
        });
        this.editInvestment.setOnAction(e -> {
            this.editInvestment.setDisable(true);
            String invNo = this.investmentNumber.getText().trim();
            String desc = this.description.getText().trim();
            LocalDate localDate = (LocalDate)this.startDate.getValue();
            String date = "";
            try {
                date = localDate.toString();
            }
            catch (NullPointerException t) {
                date = "";
            }
            boolean error = false;
            String message = "";
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("invNo", invNo);
                params.put("desc", desc);
                params.put("startDate", date);
                String response2 = Config.loadDataFromPhp("masterupdate?type=updateinvestments", params, new User());
                Gson g = new Gson();
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.notificationPane.setText(myResponse.getMessage());
                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.CHECK);
                    icon.setStyle("-fx-fill: #4CAF50;");
                    icon.setSize("24.0");
                    this.notificationPane.setGraphic((Node)icon);
                    this.notificationPane.show();
                    this.clear();
                } else {
                    this.notificationPane.setText(myResponse.getMessage());
                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TIMES);
                    icon.setStyle("-fx-fill: #d32f2f;");
                    icon.setSize("24.0");
                    this.notificationPane.setGraphic((Node)icon);
                    this.notificationPane.show();
                }
                this.editInvestment.setDisable(false);
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
                icon.setStyle("-fx-fill: #d32f2f;");
                icon.setSize("24.0");
                this.notificationPane.setGraphic((Node)icon);
                this.notificationPane.show();
                this.editInvestment.setDisable(false);
            }
        });
    }

    public void clear() {
        this.investmentNumber.setText(null);
        this.description.setText(null);
        this.startDate.setValue(null);
    }
}

