/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.AllowancesDeductions;
import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;

public class DeductionsController
implements Initializable {
    private User user;
    private AllowancesDeductions deduction;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationHolder;
    @FXML
    private Label deductionCode;
    @FXML
    private TextField deductionName;
    @FXML
    private ComboBox vendor;
    @FXML
    private Button search;
    @FXML
    private CheckBox taxable;
    @FXML
    private CheckBox disabled;
    @FXML
    private CheckBox loanAdvance;
    @FXML
    private Button cancel;
    @FXML
    private Button save;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.vendor.setItems(new Vendor().getAllVendors(user));
        this.save.setDisable(false);
    }

    public AllowancesDeductions getDeduction() {
        return this.deduction;
    }

    public void setDeduction(AllowancesDeductions deduction) {
        this.deduction = deduction;
        this.deductionCode.setText(deduction.getCode());
        this.deductionName.setText(deduction.getName());
        this.taxable.setSelected(deduction.isTaxable());
        this.disabled.setSelected(deduction.isDisabled());
        this.loanAdvance.setSelected(deduction.isLoanAdvance());
        if (deduction.isLoanAdvance()) {
            this.vendor.setItems(Account.getAccounts(this.getUser()));
            this.vendor.setValue((Object)deduction.getGlAccount());
        } else {
            this.vendor.setItems(new Vendor().getAllVendors(this.getUser()));
            this.vendor.setValue((Object)deduction.getVendor());
        }
        this.save.setDisable(false);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.notificationHolder);
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.save.setOnAction(e -> this.save());
        this.loanAdvance.setOnAction(e -> {
            this.vendor.setValue(null);
            if (this.loanAdvance.isSelected()) {
                this.vendor.setItems(Account.getAccounts(this.getUser()));
            } else {
                this.vendor.setItems(new Vendor().getAllVendors(this.getUser()));
            }
        });
        this.search.setOnAction(e -> {
            try {
                if (this.loanAdvance.isSelected()) {
                    String response = new Config().getObjectFromSelection("glaccount", this.getUser());
                    this.vendor.setValue(new Gson().fromJson(response, Account.class));
                } else {
                    String response = new Config().getObjectFromSelection("vendor", this.getUser());
                    this.vendor.setValue(new Gson().fromJson(response, Vendor.class));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void save() {
        Object tVendor;
        String tCode = "";
        String tName = "";
        String tVendorCode = "";
        int tTaxable = 0;
        int tDisabled = 0;
        boolean newDeduction = false;
        boolean error = false;
        String message = "";
        NumberSeries nb = new NumberSeries(25, this.getUser());
        try {
            tCode = this.deductionCode.getText().trim();
            if (tCode.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception y) {
            newDeduction = true;
            tCode = nb.getNextNumber();
        }
        try {
            tName = this.deductionName.getText().trim();
            if (tName.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            error = true;
            message = "Please specify a name ";
        }
        if (this.loanAdvance.isSelected()) {
            try {
                tVendor = (Account)this.vendor.getValue();
                tVendorCode = ((Account)tVendor).getAccountNumber().trim();
                if (tVendorCode.length() < 1) {
                    throw new Exception();
                }
            }
            catch (Exception t) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select a vendor ";
            }
        } else {
            try {
                tVendor = (Vendor)this.vendor.getValue();
                tVendorCode = ((Vendor)tVendor).getVendorNumber().trim();
                if (tVendorCode.length() < 1) {
                    throw new Exception();
                }
            }
            catch (Exception t) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select a vendor ";
            }
        }
        tTaxable = this.taxable.isSelected() ? 1 : 0;
        int n = tDisabled = this.disabled.isSelected() ? 1 : 0;
        if (error) {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("deductionCode", tCode);
                params.put("deductionName", tName);
                params.put("deductionVendor", tVendorCode);
                params.put("taxable", tTaxable);
                params.put("disabled", tDisabled);
                params.put("loanAdvance", this.loanAdvance.isSelected() ? 1 : 0);
                String url = newDeduction ? "mastercreate" : "masterupdate";
                String response = Config.loadDataFromPhp(url + "?type=payrolldeductions", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    if (newDeduction) {
                        this.deductionCode.setText(tCode);
                        nb.updateLastUsed(tCode);
                    }
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    ((Stage)this.save.getScene().getWindow()).close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
    }
}

