/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.CustomerReceipt;
import classes.JsonResponses;
import classes.User;
import com.jfoenix.controls.JFXButton;
import controllers.CustomerReceiptController;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class CustomerReceiptsController
implements Initializable {
    private User user;
    private boolean posted;
    ObservableList<CustomerReceipt> toSearch = FXCollections.observableArrayList();
    @FXML
    private JFXButton newReceipt;
    @FXML
    private JFXButton editReceipt;
    @FXML
    private JFXButton deleteReceipt;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton postReceipt;
    @FXML
    private JFXButton viewReceipt;
    @FXML
    private JFXButton printReceipt;
    @FXML
    private StackPane holder;
    @FXML
    private MaskerPane masker;
    @FXML
    private TableView<CustomerReceipt> allReceipts;
    @FXML
    private TableColumn receiptNo;
    @FXML
    private TableColumn customerName;
    @FXML
    private TableColumn paymentDate;
    @FXML
    SplitPane splitPane;
    @FXML
    private TableColumn paymentMethod;
    @FXML
    private TableColumn bank;
    @FXML
    private TableColumn amount;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private TextField search;
    @FXML
    private JFXButton clearFilter;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
        if (posted) {
            this.deleteReceipt.setDisable(true);
            this.postReceipt.setDisable(true);
            this.newReceipt.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.splitPane);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.receiptNo.setCellValueFactory((Callback)new PropertyValueFactory("receiptNo"));
        this.customerName.setCellValueFactory((Callback)new PropertyValueFactory("customer"));
        this.paymentDate.setCellValueFactory((Callback)new PropertyValueFactory("paymentDate"));
        this.paymentMethod.setCellValueFactory((Callback)new PropertyValueFactory("paymentMethod"));
        this.bank.setCellValueFactory((Callback)new PropertyValueFactory("bank"));
        this.amount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.refresh.setOnAction(e -> this.loadReceipts());
        this.viewReceipt.setOnAction(e -> {
            CustomerReceipt receipt = (CustomerReceipt)this.allReceipts.getSelectionModel().getSelectedItem();
            new CustomerReceipt().showReceipt(receipt);
        });
        this.printReceipt.setOnAction(e -> {
            CustomerReceipt receipt = (CustomerReceipt)this.allReceipts.getSelectionModel().getSelectedItem();
            new CustomerReceipt().printReceipt(receipt);
        });
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            ObservableList afterSearch = FXCollections.observableArrayList();
            for (int b = 0; b < this.toSearch.size(); ++b) {
                CustomerReceipt current = (CustomerReceipt)this.toSearch.get(b);
                String tCustomerName = "";
                try {
                    tCustomerName = current.getCustomer().getCustomerName();
                    if (tCustomerName.equals(null)) {
                        tCustomerName = "";
                    }
                }
                catch (Exception t) {
                    tCustomerName = "";
                }
                String tBankName = "";
                try {
                    tBankName = current.getBank().getBankName();
                    if (tBankName.equals(null)) {
                        tBankName = "";
                    }
                }
                catch (Exception t) {
                    tBankName = "";
                }
                String tPaymentMethodName = "";
                try {
                    tPaymentMethodName = current.getPaymentMethod().getPaymentMethod();
                    if (tPaymentMethodName.equals(null)) {
                        tPaymentMethodName = "";
                    }
                }
                catch (Exception t) {
                    tPaymentMethodName = "";
                }
                String tTotal = current.getAmount() + "";
                if (!current.getReceiptNo().toLowerCase().contains(newValue.toLowerCase()) && !tCustomerName.toLowerCase().contains(newValue.toLowerCase()) && !tPaymentMethodName.toLowerCase().contains(newValue.toLowerCase()) && !current.getPaymentDate().toLowerCase().contains(newValue.toLowerCase()) && !tBankName.toLowerCase().contains(newValue.toLowerCase()) && !tTotal.contains(newValue.toLowerCase())) continue;
                afterSearch.add((Object)current);
            }
            this.allReceipts.getItems().removeAll((Collection)this.allReceipts.getItems());
            this.allReceipts.setItems(afterSearch);
        });
        this.postReceipt.setOnAction(e -> {
            block7: {
                try {
                    CustomerReceipt ci = (CustomerReceipt)this.allReceipts.getSelectionModel().getSelectedItem();
                    String receiptNo = ci.getReceiptNo();
                    try {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirm Post");
                        alert.setHeaderText("Posting the customer receipt results in a change in the financial position. ");
                        alert.setContentText("Are you sure you want to post customer receipt number " + receiptNo + "?");
                        Optional result = alert.showAndWait();
                        if (result.get() != ButtonType.OK) break block7;
                        try {
                            JsonResponses jr = new CustomerReceipt().postReceipt(receiptNo, this.getUser());
                            if (jr.isStatus()) {
                                this.loadReceipts();
                            }
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                            this.notificationPane.show();
                        }
                        catch (Exception t) {
                            this.notificationPane.setText("We encountered an error while posting the customer receipt. Please try again later");
                            this.notificationPane.setGraphic((Node)Config.getBanIcon());
                            this.notificationPane.show();
                        }
                    }
                    catch (Exception r) {
                        this.notificationPane.setText("We encountered an error while posting the customer receipt. Please try again later");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
        this.newReceipt.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerreceipt.fxml").openStream());
                CustomerReceiptController controller = (CustomerReceiptController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Create Customer Receipt");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CustomerReceiptsController.this.loadReceipts();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.allReceipts.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    CustomerReceipt rowData = (CustomerReceipt)row.getItem();
                    CustomerReceipt receipt = (CustomerReceipt)this.allReceipts.getSelectionModel().getSelectedItem();
                    if (!receipt.equals(null)) {
                        this.editReceipt(receipt);
                    }
                }
            });
            return row;
        });
        this.editReceipt.setOnAction(r -> {
            try {
                CustomerReceipt xm = (CustomerReceipt)this.allReceipts.getSelectionModel().getSelectedItem();
                if (!xm.equals(null) && !xm.getReceiptNo().equals("")) {
                    this.editReceipt(xm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.deleteReceipt.setOnAction(e -> {
            try {
                CustomerReceipt ci = (CustomerReceipt)this.allReceipts.getSelectionModel().getSelectedItem();
                String tReceiptNo = ci.getReceiptNo();
                JsonResponses jr = new CustomerReceipt().deleteReceipt(tReceiptNo, this.getUser());
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus()) {
                    this.loadReceipts();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.clearFilter.setOnAction(e -> {
            this.search.setText("");
            this.loadReceipts();
        });
        this.loadReceipts();
    }

    public void loadReceipts() {
        Platform.runLater(() -> {
            this.masker.setVisible(true);
            this.allReceipts.setItems(new CustomerReceipt().getAllReceipts(this.posted, this.getUser()));
            this.toSearch = new CustomerReceipt().getAllReceipts(this.posted, this.getUser());
            this.masker.setVisible(false);
        });
    }

    public void editReceipt(CustomerReceipt receipt) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/customerreceipt.fxml").openStream());
            Scene editReceipt = new Scene((Parent)itemPane, 873.0, 396.0);
            final Stage stage = new Stage();
            editReceipt.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editReceipt);
            CustomerReceiptController controller = (CustomerReceiptController)loader.getController();
            controller.setUser(this.getUser());
            controller.setReceipt(receipt);
            stage.setTitle("Edit Receipt");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CustomerReceiptsController.this.loadReceipts();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit customer receipt screen. Please contact support");
            alert.showAndWait();
        }
    }
}

