/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.ChargeItem;
import classes.Config;
import classes.Customer;
import classes.FixedAssets;
import classes.Floor;
import classes.JsonResponses;
import classes.LineNumbersCellFactory;
import classes.Project;
import classes.Property;
import classes.Region;
import classes.SalesHeader;
import classes.SalesLines;
import classes.ShopItem;
import classes.ShopLocation;
import classes.Units;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.EditSalesLineController;
import controllers.GeneralListController;
import edms.FilesController;
import impl.org.controlsfx.tools.PrefixSelectionCustomizer;
import java.io.File;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class CustomerInvoiceController
implements Initializable {
    boolean posted = false;
    private String documentType;
    private ObservableList<ShopItem> allItems;
    ObservableList<Units> allUnits = FXCollections.observableArrayList();
    ObservableList<FixedAssets> myAssets = FXCollections.observableArrayList();
    HashMap<String, Double> pricingEntries = new HashMap();
    int chargeItemCategory = 1;
    private User user;
    SalesHeader salesHeader;
    @FXML
    private HBox shopLocationHbox;
    @FXML
    private Label customerLabel;
    @FXML
    private HBox regionHBox;
    @FXML
    private VBox realEstateOptions;
    @FXML
    private HBox salesRepHbox;
    @FXML
    NotificationPane notificationPane;
    @FXML
    DatePicker invoiceDate;
    @FXML
    SplitPane holder;
    @FXML
    VBox edms;
    @FXML
    private MaskerPane maskerPane;
    @FXML
    private Label totalLabel;
    @FXML
    private Label totalQuantity;
    @FXML
    private Label totalUnitPrice;
    @FXML
    private Label totalDiscount;
    @FXML
    private Label totalAmount;
    @FXML
    private ComboBox<Customer> customer;
    @FXML
    private ComboBox<Region> region;
    @FXML
    private ComboBox<User> salesRep;
    @FXML
    private Button searchSalesRep;
    @FXML
    private Hyperlink invoiceNo;
    @FXML
    private Label docNoLabel;
    @FXML
    private Label docDateLabel;
    @FXML
    private HBox projectHbox;
    @FXML
    private ComboBox<Project> project;
    @FXML
    private HBox propertyHbox;
    @FXML
    private ComboBox<Property> property;
    @FXML
    private HBox floorHBox;
    @FXML
    private ComboBox<Floor> floor;
    @FXML
    private HBox unitHbox;
    @FXML
    private ComboBox<Units> unit;
    @FXML
    private ComboBox<String> type;
    @FXML
    private ComboBox item;
    @FXML
    private TextField description;
    @FXML
    private TextField quantity;
    @FXML
    private TextField unitPrice;
    @FXML
    private TextField discount;
    @FXML
    private VBox unitPriceVBox;
    @FXML
    private JFXButton addLine;
    @FXML
    private JFXButton uploadLines;
    @FXML
    private TableView<SalesLines> invoiceLines;
    @FXML
    private Button searchItem;
    @FXML
    private Button searchVehicle;
    @FXML
    private TableColumn rowCount;
    @FXML
    private TableColumn colType;
    @FXML
    private TableColumn colUnitOfMeasure;
    @FXML
    private TableColumn colItemNo;
    @FXML
    private TableColumn colEdit;
    @FXML
    private TableColumn colDelete;
    @FXML
    private TableColumn colDescription;
    @FXML
    private TableColumn colQuantity;
    @FXML
    private TableColumn colDiscount;
    @FXML
    private TableColumn colUnitPrice;
    @FXML
    private TableColumn colTotalAmount;
    @FXML
    private TableColumn colVehicle;
    @FXML
    private TableColumn colKilometres;
    @FXML
    private JFXButton loadingSheet;
    @FXML
    private JFXButton convertQuote;
    @FXML
    private JFXButton postInvoice;
    @FXML
    private JFXButton sendApproval;
    @FXML
    private JFXButton reject;
    @FXML
    private JFXButton saveInvoice;
    @FXML
    private ComboBox<ShopLocation> shopLocation;
    @FXML
    private HBox commentHbox;
    @FXML
    private TextField comment;
    @FXML
    private HBox invoiceHbox;
    @FXML
    private ComboBox<String> invoice;
    @FXML
    private HBox referenceHbox;
    @FXML
    private HBox customerHBox;
    @FXML
    private TextField reference;
    @FXML
    private VBox typeVBox;
    @FXML
    private VBox descriptionVBox;
    @FXML
    private VBox discountVBox;
    @FXML
    private VBox kilometresVBox;
    @FXML
    private TextField kilometres;
    @FXML
    private VBox vehicleVBox;
    @FXML
    private ComboBox<FixedAssets> vehicle;
    @FXML
    private Button search;

    public ObservableList<Units> getAllUnits() {
        return this.allUnits;
    }

    public void setAllUnits(ObservableList<Units> allUnits) {
        this.allUnits = allUnits;
    }

    public ObservableList<ShopItem> getAllItems() {
        return this.allItems;
    }

    public void setAllItems(ObservableList<ShopItem> allItems) {
        this.allItems = allItems;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
        this.projectHbox.setVisible(false);
        this.regionHBox.setVisible(false);
        this.loadingSheet.setVisible(false);
        this.convertQuote.setVisible(false);
        if (documentType.equalsIgnoreCase("SalesInvoice")) {
            this.invoiceHbox.setVisible(false);
            this.loadingSheet.setVisible(true);
        }
        if (documentType.equalsIgnoreCase("SalesQuote")) {
            this.docNoLabel.setText("Quote No:");
            this.docDateLabel.setText("Quote Date:");
            this.postInvoice.setVisible(false);
            this.saveInvoice.setText("Save Quote");
            this.invoiceHbox.setVisible(false);
            this.shopLocationHbox.setVisible(false);
            this.convertQuote.setVisible(true);
        }
        if (documentType.equalsIgnoreCase("SalesOrder")) {
            this.docNoLabel.setText("Order No:");
            this.docDateLabel.setText("Order Date:");
            this.postInvoice.setVisible(false);
            this.saveInvoice.setText("Save order");
            this.invoiceHbox.setVisible(false);
            this.shopLocationHbox.setVisible(true);
            this.convertQuote.setText("Approve Order");
            this.convertQuote.setVisible(true);
        }
        if (documentType.equalsIgnoreCase("CreditNote")) {
            this.docNoLabel.setText("Credit Note No:");
            this.docDateLabel.setText("Credit Note Date:");
            this.postInvoice.setText("Post Credit Note");
            this.saveInvoice.setText("Save Credit Note");
            this.postInvoice.setVisible(false);
            this.reject.setVisible(false);
            this.sendApproval.setVisible(true);
        }
        if (documentType.equalsIgnoreCase("tenantInvoice")) {
            this.regionHBox.setVisible(false);
            this.salesRepHbox.setVisible(false);
            this.shopLocationHbox.setVisible(false);
            this.projectHbox.setVisible(false);
            this.customerLabel.setText("Tenant: ");
            this.customer.setPromptText("Tenant");
            this.propertyHbox.setVisible(true);
            this.unitHbox.setVisible(true);
            this.floorHBox.setVisible(true);
        }
        if (documentType.equalsIgnoreCase("StoreRequisition")) {
            this.docNoLabel.setText("Doc No:");
            this.docDateLabel.setText("Doc Date:");
            this.postInvoice.setText("Post Requisition");
            this.saveInvoice.setText("Save Requisition");
            this.typeVBox.setVisible(false);
            this.descriptionVBox.setVisible(false);
            this.discountVBox.setVisible(false);
            this.invoiceLines.getColumns().remove((Object)this.colType);
            this.invoiceLines.getColumns().remove((Object)this.colDiscount);
            this.kilometresVBox.setVisible(true);
            this.vehicleVBox.setVisible(true);
            this.invoiceHbox.setVisible(false);
            this.commentHbox.setVisible(false);
            this.referenceHbox.setVisible(false);
            this.customerHBox.setVisible(false);
        } else {
            this.invoiceLines.getColumns().remove((Object)this.colKilometres);
            this.invoiceLines.getColumns().remove((Object)this.colVehicle);
            this.kilometresVBox.setVisible(false);
            this.vehicleVBox.setVisible(false);
        }
        if (this.getDocumentType().equalsIgnoreCase("tenantInvoice")) {
            this.chargeItemCategory = 5;
            try {
                ObservableList<Property> allProperties = new Property().getAllProperties(this.getUser());
                allProperties.sort(Comparator.comparing(Property::getName));
                this.property.setItems(allProperties);
            }
            catch (Exception allProperties) {
                // empty catch block
            }
            this.search.setVisible(false);
        } else {
            this.loadItems();
            this.loadPrices();
            if (this.getDocumentType().equalsIgnoreCase("StoreRequisition")) {
                final Node original = this.searchVehicle.getGraphic();
                Task<Void> task1 = new Task<Void>(){

                    public Void call() {
                        Platform.runLater(() -> {
                            ProgressIndicator loader = new ProgressIndicator();
                            loader.setPrefWidth(15.0);
                            loader.setPrefHeight(15.0);
                            CustomerInvoiceController.this.searchVehicle.setGraphic((Node)loader);
                        });
                        CustomerInvoiceController.this.myAssets = new FixedAssets().getAllAssets(true, CustomerInvoiceController.this.getUser());
                        Platform.runLater(() -> {
                            CustomerInvoiceController.this.vehicle.setItems(CustomerInvoiceController.this.myAssets);
                            CustomerInvoiceController.this.searchVehicle.setGraphic(original);
                        });
                        return null;
                    }
                };
                Thread backgroundThread = new Thread((Runnable)task1);
                backgroundThread.setDaemon(true);
                backgroundThread.start();
            } else {
                this.loadCustomers();
            }
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> {
                        CustomerInvoiceController.this.notificationPane.setText("Loading Values. Please wait");
                        CustomerInvoiceController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                        CustomerInvoiceController.this.notificationPane.show();
                    });
                    CustomerInvoiceController.this.project.setItems(new Project().getAllProjects(CustomerInvoiceController.this.getUser()));
                    ObservableList<ShopLocation> allLocations = new ShopLocation().getAllLocations(CustomerInvoiceController.this.getUser());
                    ObservableList<Region> allRegions = new Region().getAllRegions(CustomerInvoiceController.this.getUser());
                    ObservableList<User> allUsers = new User().getAllUsers(true, CustomerInvoiceController.this.getUser());
                    allUsers.sort(Comparator.comparing(User::getFullName));
                    Platform.runLater(() -> {
                        CustomerInvoiceController.this.shopLocation.setItems(allLocations);
                        if (allLocations.size() == 1) {
                            CustomerInvoiceController.this.shopLocation.setValue(CustomerInvoiceController.this.shopLocation.getItems().get(0));
                        }
                        CustomerInvoiceController.this.region.setItems(allRegions);
                        CustomerInvoiceController.this.salesRep.setItems(allUsers);
                        CustomerInvoiceController.this.notificationPane.hide();
                    });
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    private void loadItems() {
        final Node original = this.searchItem.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> CustomerInvoiceController.this.searchItem.setGraphic((Node)Config.getLoader()));
                ObservableList<ShopItem> myItems = new ShopItem().getAllItems(CustomerInvoiceController.this.getUser());
                myItems.sort(Comparator.comparing(ShopItem::getName));
                CustomerInvoiceController.this.setAllItems(myItems);
                Platform.runLater(() -> {
                    CustomerInvoiceController.this.item.setItems(CustomerInvoiceController.this.allItems);
                    CustomerInvoiceController.this.searchItem.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadPrices() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {});
                String response = Config.loadDataFromPhp("masterfetch?type=pricing_group_entries", new HashMap<String, Object>(), CustomerInvoiceController.this.getUser());
                CustomerInvoiceController.this.pricingEntries = ((HashMap[])new Gson().fromJson(response, HashMap[].class))[0];
                Platform.runLater(() -> {});
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadCustomers() {
        final Node original = this.search.getGraphic();
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> CustomerInvoiceController.this.search.setGraphic((Node)Config.getLoader()));
                ObservableList<Customer> allCustomers = new Customer().getAllCustomers(CustomerInvoiceController.this.user);
                allCustomers.sort(Comparator.comparing(Customer::getCustomerName));
                Platform.runLater(() -> {
                    CustomerInvoiceController.this.customer.setItems(allCustomers);
                    CustomerInvoiceController.this.search.setGraphic(original);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public SalesHeader getInvoice() {
        return this.salesHeader;
    }

    public void setSalesHeader(SalesHeader header1) {
        this.salesHeader = header1;
        try {
            try {
                this.customer.setValue((Object)header1.getCustomer());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.invoiceDate.setValue((Object)Config.stringToLocalDate(header1.getSales_date()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.shopLocation.setValue((Object)header1.getLocation());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                System.out.println("The invoice no is " + header1.getInvoice());
                this.invoice.setValue((Object)header1.getInvoice());
                this.getCustomerInvoices();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.salesRep.setValue((Object)header1.getSalesRep());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (header1.isPosted()) {
                this.postInvoice.setDisable(true);
                this.saveInvoice.setDisable(true);
                this.loadingSheet.setVisible(false);
                this.convertQuote.setVisible(false);
                this.posted = true;
                this.invoiceLines.getColumns().remove((Object)this.colDelete);
                this.invoiceLines.getColumns().remove((Object)this.colEdit);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.invoiceNo.setText(header1.getDoc_no());
        try {
            this.reference.setText(header1.getReference());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.comment.setText(header1.getComment());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadInvoiceLines();
        this.loadFiles(this.invoiceNo.getText().trim());
        if (this.getDocumentType().equalsIgnoreCase("CreditNote")) {
            if (header1.getStatus().equalsIgnoreCase("Pending")) {
                this.postInvoice.setVisible(true);
                this.reject.setVisible(true);
                this.sendApproval.setVisible(false);
                this.shopLocationHbox.setVisible(false);
            } else {
                this.postInvoice.setVisible(false);
                this.reject.setVisible(false);
                this.sendApproval.setVisible(true);
            }
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.maskerPane.setVisible(false);
        this.totalLabel.prefWidthProperty().bind((ObservableValue)this.rowCount.widthProperty().add((ObservableNumberValue)this.colType.widthProperty()).add((ObservableNumberValue)this.colItemNo.widthProperty()).add((ObservableNumberValue)this.colDescription.widthProperty()).add((ObservableNumberValue)this.colUnitOfMeasure.widthProperty()));
        this.totalQuantity.prefWidthProperty().bind((ObservableValue)this.colQuantity.widthProperty());
        this.totalUnitPrice.prefWidthProperty().bind((ObservableValue)this.colUnitPrice.widthProperty());
        this.totalDiscount.prefWidthProperty().bind((ObservableValue)this.colDiscount.widthProperty());
        this.totalAmount.prefWidthProperty().bind((ObservableValue)this.colTotalAmount.widthProperty());
        this.searchItem.setOnAction(e -> this.searchItem());
        this.searchVehicle.setOnAction(e -> {
            try {
                Gson gson = new Gson();
                String response = new Config().getObjectFromSelection("fixedasset", gson.toJson((Object)this.vehicle.getItems()), this.getUser());
                this.vehicle.setValue(gson.fromJson(response, FixedAssets.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.customer.setOnAction(e -> {
            if (this.documentType.equalsIgnoreCase("CreditNote")) {
                this.getCustomerInvoices();
            }
        });
        PrefixSelectionCustomizer.customize(this.customer);
        PrefixSelectionCustomizer.customize((ComboBox)this.item);
        PrefixSelectionCustomizer.customize(this.invoice);
        PrefixSelectionCustomizer.customize(this.salesRep);
        PrefixSelectionCustomizer.customize(this.vehicle);
        this.realEstateOptions.managedProperty().bind((ObservableValue)this.realEstateOptions.visibleProperty());
        this.regionHBox.managedProperty().bind((ObservableValue)this.regionHBox.visibleProperty());
        this.invoiceHbox.managedProperty().bind((ObservableValue)this.invoiceHbox.visibleProperty());
        this.unitPriceVBox.managedProperty().bind((ObservableValue)this.unitPriceVBox.visibleProperty());
        this.salesRepHbox.managedProperty().bind((ObservableValue)this.salesRepHbox.visibleProperty());
        this.shopLocationHbox.managedProperty().bind((ObservableValue)this.shopLocationHbox.visibleProperty());
        this.projectHbox.managedProperty().bind((ObservableValue)this.projectHbox.visibleProperty());
        this.propertyHbox.managedProperty().bind((ObservableValue)this.propertyHbox.visibleProperty());
        this.floorHBox.managedProperty().bind((ObservableValue)this.floorHBox.visibleProperty());
        this.unitHbox.managedProperty().bind((ObservableValue)this.unitHbox.visibleProperty());
        this.postInvoice.managedProperty().bind((ObservableValue)this.postInvoice.visibleProperty());
        this.sendApproval.managedProperty().bind((ObservableValue)this.sendApproval.visibleProperty());
        this.reject.managedProperty().bind((ObservableValue)this.reject.visibleProperty());
        this.typeVBox.managedProperty().bind((ObservableValue)this.typeVBox.visibleProperty());
        this.descriptionVBox.managedProperty().bind((ObservableValue)this.descriptionVBox.visibleProperty());
        this.discountVBox.managedProperty().bind((ObservableValue)this.discountVBox.visibleProperty());
        this.kilometresVBox.managedProperty().bind((ObservableValue)this.kilometresVBox.visibleProperty());
        this.vehicleVBox.managedProperty().bind((ObservableValue)this.vehicleVBox.visibleProperty());
        this.customerHBox.managedProperty().bind((ObservableValue)this.customerHBox.visibleProperty());
        this.commentHbox.managedProperty().bind((ObservableValue)this.commentHbox.visibleProperty());
        this.referenceHbox.managedProperty().bind((ObservableValue)this.referenceHbox.visibleProperty());
        this.loadingSheet.managedProperty().bind((ObservableValue)this.loadingSheet.visibleProperty());
        this.convertQuote.managedProperty().bind((ObservableValue)this.convertQuote.visibleProperty());
        this.salesRep.setOnAction(e -> this.shopLocation.setValue((Object)((User)this.salesRep.getValue()).getWarehouse()));
        this.invoiceDate.setValue((Object)Config.getCurrentLocaldate());
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.sendApproval.setVisible(false);
        this.reject.setVisible(false);
        this.loadingSheet.setOnAction(e -> {
            try {
                HashMap<String, Object> parameters2 = new HashMap<String, Object>();
                parameters2.put("saccoName", Config.saccoName);
                parameters2.put("servedBy", this.user.getUserName());
                parameters2.put("receiptNo", this.invoiceNo.getText().trim());
                parameters2.put("customerName", ((Customer)this.customer.getValue()).getCustomerName());
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("invoiceNo", this.invoiceNo.getText());
                params.put("docNo", this.invoiceNo.getText());
                params.put("docType", this.getDocumentType());
                new Config().printReport("Customer Invoice", "masterfetch?type=salesline", params, "loading_sheet.jasper", parameters2, this.user);
            }
            catch (Exception u) {
                u.printStackTrace();
            }
        });
        this.convertQuote.setOnAction(e -> {
            if (this.getDocumentType().equalsIgnoreCase("SalesOrder")) {
                if (Config.showConfirmDialog("Approve Sales Order", null, "Are you sure you want to approve the sales order?")) {
                    System.out.println("Approve sales order and create stock request");
                }
            } else {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setTitle("Convert Quotation");
                alert.setHeaderText("Which document would you like to convert the quotation to?");
                ButtonType buttonTypeOne = new ButtonType("Standard Invoice");
                ButtonType buttonTypeTwo = new ButtonType("Express Sale");
                ButtonType buttonTypeCancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOne, buttonTypeTwo, buttonTypeCancel});
                Optional result = alert.showAndWait();
                if (result.get() == buttonTypeOne) {
                    this.convertQuote("SalesInvoice");
                } else if (result.get() == buttonTypeTwo) {
                    this.convertQuote("ExpressSale");
                }
            }
        });
        this.invoice.setOnAction(e -> {
            if (this.invoiceLines.getItems().size() == 0 && this.saveInvoice()) {
                Task<Void> task1 = new Task<Void>(){

                    public Void call() {
                        Platform.runLater(() -> {
                            CustomerInvoiceController.this.notificationPane.setText("Creating Lines. Please wait");
                            CustomerInvoiceController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                            CustomerInvoiceController.this.notificationPane.hide();
                        });
                        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                        params.put("creditNoteNo", CustomerInvoiceController.this.invoiceNo.getText().trim());
                        params.put("invoiceNo", ((String)CustomerInvoiceController.this.invoice.getValue()).trim());
                        params.put("documentType", CustomerInvoiceController.this.getDocumentType());
                        String response = Config.loadDataFromPhp("masterupdate?type=credit_note_lines", params, CustomerInvoiceController.this.getUser());
                        JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                        if (jr.isStatus()) {
                            CustomerInvoiceController.this.loadInvoiceLines();
                        }
                        Platform.runLater(() -> {
                            CustomerInvoiceController.this.notificationPane.setText(jr.getMessage());
                            CustomerInvoiceController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                            CustomerInvoiceController.this.notificationPane.show();
                        });
                        return null;
                    }
                };
                Thread backgroundThread = new Thread((Runnable)task1);
                backgroundThread.setDaemon(true);
                backgroundThread.start();
            }
        });
        this.property.setOnAction(e -> {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> {
                        CustomerInvoiceController.this.notificationPane.setText("Loading Values. Please wait");
                        CustomerInvoiceController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                        CustomerInvoiceController.this.notificationPane.show();
                    });
                    ObservableList<Floor> allFloors = new Floor().getAllFloors(((Property)CustomerInvoiceController.this.property.getValue()).getPropertyCode(), CustomerInvoiceController.this.getUser());
                    ObservableList<Units> allUnits = new Units().getAllUnits(((Property)CustomerInvoiceController.this.property.getValue()).getPropertyCode(), CustomerInvoiceController.this.getUser());
                    Platform.runLater(() -> {
                        CustomerInvoiceController.this.floor.setItems(allFloors);
                        CustomerInvoiceController.this.setAllUnits(allUnits);
                        CustomerInvoiceController.this.unit.setItems(CustomerInvoiceController.this.getAllUnits());
                        CustomerInvoiceController.this.notificationPane.hide();
                    });
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        });
        this.floor.setOnAction(e -> {
            ObservableList floorUnits = FXCollections.observableArrayList((Collection)this.getAllUnits().stream().filter(v -> v.getFloor().getFloorId() == ((Floor)this.floor.getValue()).getFloorId()).collect(Collectors.toList()));
            this.unit.setItems(floorUnits);
        });
        this.unit.setOnAction(e -> {
            this.floor.setValue((Object)((Units)this.unit.getValue()).getFloor());
            this.loadCustomers();
        });
        this.search.setOnAction(e -> {
            try {
                if (this.getDocumentType().equalsIgnoreCase("tenantInvoice")) {
                    String response = new Config().getObjectFromSelection("tenant", this.getUser());
                    this.customer.setValue(new Gson().fromJson(response, Customer.class));
                } else {
                    Gson gson = new Gson();
                    String response = new Config().getObjectFromSelection("customer", gson.toJson((Object)this.customer.getItems()), this.getUser());
                    this.customer.setValue(gson.fromJson(response, Customer.class));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchSalesRep.setOnAction(e -> {
            try {
                String response = new Config().getObjectFromSelection("user", this.getUser());
                this.salesRep.setValue(new Gson().fromJson(response, User.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.type.getItems().add((Object)"Items");
        this.type.getItems().add((Object)"Services");
        this.type.setOnAction(e -> {
            String typeValue = (String)this.type.getValue();
            if (typeValue.equalsIgnoreCase("Services")) {
                ObservableList<ChargeItem> allChargeItems = new ChargeItem().getChargeItems(this.chargeItemCategory, this.getUser());
                allChargeItems.sort(Comparator.comparing(ChargeItem::getName));
                this.item.setItems(allChargeItems);
                this.unitPrice.setDisable(false);
                this.unitPriceVBox.setVisible(true);
            } else if (typeValue.equalsIgnoreCase("Items")) {
                ObservableList<ShopItem> allItems = this.getAllItems();
                this.item.setItems(allItems);
                this.unitPrice.setDisable(!Config.editPrices);
            }
        });
        this.item.setOnAction(e -> {
            block7: {
                try {
                    String typeValue = (String)this.type.getValue();
                    if (typeValue.equalsIgnoreCase("Services")) {
                        ChargeItem ci = (ChargeItem)this.item.getValue();
                        this.description.setText(ci.getName());
                        break block7;
                    }
                    if (!typeValue.equalsIgnoreCase("Items")) break block7;
                    ShopItem ci = (ShopItem)this.item.getValue();
                    this.description.setText(ci.getName());
                    if (this.getDocumentType().equalsIgnoreCase("StoreRequisition")) {
                        this.unitPrice.setText(ci.getBuyingPrice() + "");
                        break block7;
                    }
                    try {
                        int pricingGroupId = ((Customer)this.customer.getValue()).getPricingGroup().getId();
                        if (pricingGroupId <= 0) break block7;
                        String key = ci.getCode() + "group" + pricingGroupId;
                        double price = Double.parseDouble(this.pricingEntries.getOrDefault(key, 0.0) + "");
                        if (price > 0.0) {
                            this.unitPrice.setText(price + "");
                            break block7;
                        }
                        throw new Exception();
                    }
                    catch (Exception u) {
                        u.printStackTrace();
                        this.unitPrice.setText(ci.getPrice() + "");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.type.setValue(this.type.getItems().get(0));
        this.unitPrice.setDisable(!Config.editPrices);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.quantity, Validator.createEmptyValidator((String)"Quantity is required"));
        vs.registerValidator((Control)this.unitPrice, Validator.createEmptyValidator((String)"Unit Price is required"));
        vs.registerValidator((Control)this.description, Validator.createEmptyValidator((String)"Description is required"));
        vs.registerValidator((Control)this.item, Validator.createEmptyValidator((String)"Item is required"));
        this.saveInvoice.setOnAction(e -> this.saveInvoice());
        this.rowCount.setCellFactory(new LineNumbersCellFactory());
        this.colType.setCellValueFactory((Callback)new PropertyValueFactory("itemType"));
        this.colItemNo.setCellValueFactory((Callback)new PropertyValueFactory("itemNo"));
        this.colDescription.setCellValueFactory((Callback)new PropertyValueFactory("description"));
        this.colQuantity.setCellValueFactory((Callback)new PropertyValueFactory("quantityString"));
        this.colDiscount.setCellValueFactory((Callback)new PropertyValueFactory("discountString"));
        this.colUnitPrice.setCellValueFactory((Callback)new PropertyValueFactory("unitPriceString"));
        this.colTotalAmount.setCellValueFactory((Callback)new PropertyValueFactory("totalAmountString"));
        this.colUnitOfMeasure.setCellValueFactory((Callback)new PropertyValueFactory("unitOfMeasure"));
        this.colVehicle.setCellValueFactory((Callback)new PropertyValueFactory("vehicle"));
        this.colKilometres.setCellValueFactory((Callback)new PropertyValueFactory("kilometres"));
        this.quantity.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode().equals((Object)KeyCode.ENTER)) {
                    CustomerInvoiceController.this.addLine();
                } else if (ke.getCode().equals((Object)KeyCode.F1)) {
                    CustomerInvoiceController.this.searchItem();
                }
            }
        });
        Callback<TableColumn<SalesLines, SalesLines>, TableCell<SalesLines, SalesLines>> cellFactory = new Callback<TableColumn<SalesLines, SalesLines>, TableCell<SalesLines, SalesLines>>(){

            public TableCell<SalesLines, SalesLines> call(TableColumn<SalesLines, SalesLines> param) {
                TableCell<SalesLines, SalesLines> cell = new TableCell<SalesLines, SalesLines>(){
                    private final Button btn = new Button();
                    {
                        this.btn.setOnAction(e -> {
                            if (CustomerInvoiceController.this.posted) {
                                CustomerInvoiceController.this.showDocumentAlreadyPosted();
                            } else {
                                SalesLines data = (SalesLines)this.getTableView().getItems().get(this.getIndex());
                                if (Config.showConfirmDialog("Delete Invoice Line", "The invoice line will be permanently deleted", "Are you sure you want to remove the item " + data.getDescription() + " from this invoice?")) {
                                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                    params.put("headerNo", CustomerInvoiceController.this.invoiceNo.getText().trim());
                                    params.put("itemType", data.getItemType());
                                    params.put("lineId", data.getLineId());
                                    params.put("documentType", CustomerInvoiceController.this.getDocumentType());
                                    String response = Config.loadDataFromPhp("masterdelete?type=salesline", params, CustomerInvoiceController.this.getUser());
                                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                                    if (jr.isStatus()) {
                                        CustomerInvoiceController.this.loadInvoiceLines();
                                    }
                                    CustomerInvoiceController.this.notificationPane.setText(jr.getMessage());
                                    CustomerInvoiceController.this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                                    CustomerInvoiceController.this.notificationPane.show();
                                }
                            }
                        });
                    }

                    public void updateItem(SalesLines item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            this.btn.setGraphic((Node)Config.getDeleteIcon());
                            this.btn.getStyleClass().add((Object)"transparent_button");
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.colDelete.setCellFactory((Callback)cellFactory);
        this.colDelete.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        Callback<TableColumn<SalesLines, SalesLines>, TableCell<SalesLines, SalesLines>> editCellfactory = new Callback<TableColumn<SalesLines, SalesLines>, TableCell<SalesLines, SalesLines>>(){

            public TableCell<SalesLines, SalesLines> call(TableColumn<SalesLines, SalesLines> param) {
                TableCell<SalesLines, SalesLines> cell = new TableCell<SalesLines, SalesLines>(){
                    private final Button btn = new Button();
                    {
                        this.btn.setOnAction(e -> {
                            if (CustomerInvoiceController.this.posted) {
                                CustomerInvoiceController.this.showDocumentAlreadyPosted();
                            } else {
                                SalesLines data = (SalesLines)this.getTableView().getItems().get(this.getIndex());
                                CustomerInvoiceController.this.editEntry(data);
                            }
                        });
                    }

                    public void updateItem(SalesLines item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            this.btn.setGraphic((Node)Config.getEditIcon());
                            this.btn.getStyleClass().add((Object)"transparent_button");
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.colEdit.setCellFactory((Callback)editCellfactory);
        this.colEdit.setCellValueFactory(features -> new ReadOnlyObjectWrapper(features.getValue()));
        this.uploadLines.setOnAction(e -> {
            if (this.saveInvoice()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FileChooser chooser = new FileChooser();
                        chooser.setTitle("Select Excel to Import Entries From");
                        chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx", "*.csv"})});
                        try {
                            File file = chooser.showOpenDialog((Window)new Stage());
                            if (file != null) {
                                XSSFWorkbook wb = new XSSFWorkbook(file);
                                final XSSFSheet ws = wb.getSheetAt(0);
                                Task<Void> task1 = new Task<Void>(){

                                    public Void call() {
                                        int noOfRecords = ws.getPhysicalNumberOfRows();
                                        Platform.runLater(() -> {
                                            CustomerInvoiceController.this.notificationPane.setText("Importing Entries Please wait");
                                            CustomerInvoiceController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                                            CustomerInvoiceController.this.notificationPane.show();
                                        });
                                        for (int b = 1; b < noOfRecords; ++b) {
                                            int c = b;
                                            this.updateProgress(c + 1, noOfRecords);
                                            Platform.runLater(() -> CustomerInvoiceController.this.notificationPane.setText("Uploading Records. Please wait... " + (c + 1) + " of " + noOfRecords));
                                            XSSFRow myRow = ws.getRow(b);
                                            try {
                                                Cell myCell;
                                                String tType = "";
                                                String itemNo = "";
                                                String tDescription = "";
                                                double tUnitPrice = 0.0;
                                                double tQuantity = 0.0;
                                                try {
                                                    myCell = myRow.getCell(0);
                                                    tType = myCell.toString();
                                                }
                                                catch (Exception t) {
                                                    tType = "";
                                                }
                                                try {
                                                    myCell = myRow.getCell(1);
                                                    itemNo = myCell.toString().trim();
                                                }
                                                catch (Exception t) {
                                                    itemNo = "";
                                                }
                                                try {
                                                    myCell = myRow.getCell(2);
                                                    tDescription = myCell.toString().trim();
                                                }
                                                catch (Exception t) {
                                                    tDescription = "";
                                                }
                                                try {
                                                    myCell = myRow.getCell(3);
                                                    tUnitPrice = myCell.getNumericCellValue();
                                                }
                                                catch (Exception t) {
                                                    tUnitPrice = 0.0;
                                                }
                                                try {
                                                    myCell = myRow.getCell(4);
                                                    tQuantity = myCell.getNumericCellValue();
                                                }
                                                catch (Exception t) {
                                                    tQuantity = 0.0;
                                                }
                                                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                                params.put("headerNo", CustomerInvoiceController.this.invoiceNo.getText());
                                                params.put("documentType", CustomerInvoiceController.this.getDocumentType());
                                                params.put("itemType", tType);
                                                params.put("itemNo", itemNo);
                                                params.put("description", tDescription);
                                                params.put("unitPrice", tUnitPrice);
                                                params.put("quantity", tQuantity);
                                                params.put("discount", 0);
                                                params.put("kilometres", 0);
                                                params.put("vehicle", "");
                                                String response = Config.loadDataFromPhp("mastercreate?type=salesline", params, CustomerInvoiceController.this.getUser());
                                                System.out.println(response);
                                                continue;
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                        CustomerInvoiceController.this.loadInvoiceLines();
                                        Platform.runLater(() -> CustomerInvoiceController.this.notificationPane.hide());
                                        return null;
                                    }
                                };
                                Thread backgroundThread = new Thread((Runnable)task1);
                                backgroundThread.setDaemon(true);
                                backgroundThread.start();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        });
        this.addLine.setOnAction(e -> this.addLine());
        this.postInvoice.setOnAction(e -> {
            block18: {
                String tInvoiceNo;
                boolean error = false;
                try {
                    if (this.getInvoice().isPosted()) {
                        error = true;
                        Stage stage = (Stage)this.postInvoice.getScene().getWindow();
                        stage.close();
                        return;
                    }
                }
                catch (Exception stage) {
                    // empty catch block
                }
                if (this.saveInvoice() && !error && !(tInvoiceNo = this.invoiceNo.getText().trim()).isEmpty()) {
                    try {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirm Post");
                        alert.setHeaderText("Posting the " + this.getDocumentType() + " results in a change in the financial position. ");
                        alert.setContentText("Are you sure you want to post " + this.getDocumentType() + " number " + tInvoiceNo + "?");
                        Optional result = alert.showAndWait();
                        if (result.get() != ButtonType.OK) break block18;
                        try {
                            JsonResponses jr = new SalesHeader().postDocument(tInvoiceNo, this.getDocumentType(), this.getUser());
                            if (jr.isStatus()) {
                                try {
                                    String receiptInfo = jr.getOverLoad1();
                                    if (receiptInfo.length() > 0) {
                                        try {
                                            LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                                            reportVariables.put("saccoName", Config.saccoName);
                                            reportVariables.put("servedBy", this.user.getUserName());
                                            reportVariables.put("printedOn", "Printed on " + Config.getSystemTime());
                                            reportVariables.put("kraPIN", Config.getKRAPin());
                                            reportVariables.put("buyerKraPin", Config.getBuyerKRAPinPrefix() + ((Customer)this.customer.getValue()).getKraPin());
                                            reportVariables.put("address", Config.companyAddress);
                                            reportVariables.put("receiptNo", tInvoiceNo);
                                            reportVariables.put("receiptDate", Config.localDateToString(Config.getCurrentLocaldate()));
                                            new Config().saveJsonReportAsPDF("Express Sale", receiptInfo, "expresssale58mm.jasper", reportVariables, this.getUser(), "receipt" + tInvoiceNo + ".pdf");
                                        }
                                        catch (Exception y) {
                                            y.printStackTrace();
                                        }
                                    }
                                }
                                catch (Exception receiptInfo) {
                                    // empty catch block
                                }
                                Alert alert2 = new Alert(Alert.AlertType.CONFIRMATION);
                                alert2.setTitle("Would you like to print the " + this.getDocumentType() + "?");
                                alert2.setHeaderText(null);
                                alert2.setContentText("Please select the template you would like");
                                ButtonType buttonTypeOne = new ButtonType("A4 Template");
                                ButtonType buttonTypeTwo = new ButtonType("80 MM Template");
                                alert2.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOne, buttonTypeTwo, new ButtonType("None", ButtonBar.ButtonData.CANCEL_CLOSE)});
                                Optional result3 = alert2.showAndWait();
                                if (result3.get() == buttonTypeOne) {
                                    this.printInvoice("customerinvoice.jasper");
                                } else if (result3.get() == buttonTypeTwo) {
                                    this.printInvoice("80mm_customer_invoice.jasper");
                                }
                                if (this.documentType.equalsIgnoreCase("SalesInvoice") && Config.DELIVERY_NOTE_PROMPT && Config.showConfirmDialog("Print delivery Note", "Would you like to print the delivery note?", "Click ok to print delivery note")) {
                                    this.printDeliveryNote();
                                }
                                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                                GeneralListController.publicNotificationPane.show();
                                Stage stage = (Stage)this.postInvoice.getScene().getWindow();
                                stage.close();
                                break block18;
                            }
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                            this.notificationPane.show();
                        }
                        catch (Exception t) {
                            this.notificationPane.setText("We encountered an error while posting the customer invoice. Please try again later");
                            this.notificationPane.setGraphic((Node)Config.getBanIcon());
                            this.notificationPane.show();
                            t.printStackTrace();
                        }
                    }
                    catch (Exception r) {
                        this.notificationPane.setText("We encountered an error while posting the customer invoice. Please try again later");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
            }
        });
        this.sendApproval.setOnAction(e -> {
            block9: {
                String tInvoiceNo;
                boolean error = false;
                try {
                    if (this.getInvoice().isPosted()) {
                        error = true;
                        Stage stage = (Stage)this.sendApproval.getScene().getWindow();
                        stage.close();
                        return;
                    }
                }
                catch (Exception stage) {
                    // empty catch block
                }
                if (this.saveInvoice() && !error && !(tInvoiceNo = this.invoiceNo.getText().trim()).isEmpty()) {
                    try {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirm Approval");
                        alert.setContentText("Are you sure you want to send  document number " + tInvoiceNo + " for approval?");
                        Optional result = alert.showAndWait();
                        if (result.get() != ButtonType.OK) break block9;
                        try {
                            JsonResponses jr = new SalesHeader().sendDocumentForApproval(tInvoiceNo, this.getDocumentType(), this.getUser());
                            if (jr.isStatus()) {
                                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                                GeneralListController.publicNotificationPane.show();
                                Stage stage = (Stage)this.sendApproval.getScene().getWindow();
                                stage.close();
                                break block9;
                            }
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                            this.notificationPane.show();
                        }
                        catch (Exception t) {
                            this.notificationPane.setText("We encountered an error while sending the document for approval. Please try again later");
                            this.notificationPane.setGraphic((Node)Config.getBanIcon());
                            this.notificationPane.show();
                            t.printStackTrace();
                        }
                    }
                    catch (Exception r) {
                        this.notificationPane.setText("We encountered an error while sending the document for approval. Please try again later");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
            }
        });
        this.reject.setOnAction(e -> {
            block9: {
                String tInvoiceNo;
                boolean error = false;
                try {
                    if (this.getInvoice().isPosted()) {
                        error = true;
                        Stage stage = (Stage)this.reject.getScene().getWindow();
                        stage.close();
                        return;
                    }
                }
                catch (Exception stage) {
                    // empty catch block
                }
                if (this.saveInvoice() && !error && !(tInvoiceNo = this.invoiceNo.getText().trim()).isEmpty()) {
                    try {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("Confirm Rejection");
                        alert.setContentText("Are you sure you want to reject  document number " + tInvoiceNo + " for approval?");
                        Optional result = alert.showAndWait();
                        if (result.get() != ButtonType.OK) break block9;
                        try {
                            JsonResponses jr = new SalesHeader().rejectDocument(tInvoiceNo, this.getDocumentType(), this.getUser());
                            if (jr.isStatus()) {
                                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                                GeneralListController.publicNotificationPane.show();
                                Stage stage = (Stage)this.reject.getScene().getWindow();
                                stage.close();
                                break block9;
                            }
                            this.notificationPane.setText(jr.getMessage());
                            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                            this.notificationPane.show();
                        }
                        catch (Exception t) {
                            this.notificationPane.setText("We encountered an error while rejecting the document. Please try again later");
                            this.notificationPane.setGraphic((Node)Config.getBanIcon());
                            this.notificationPane.show();
                            t.printStackTrace();
                        }
                    }
                    catch (Exception r) {
                        this.notificationPane.setText("We encountered an error while rejecting the document. Please try again later");
                        this.notificationPane.setGraphic((Node)Config.getBanIcon());
                        this.notificationPane.show();
                    }
                }
            }
        });
    }

    private void searchItem() {
        try {
            Gson gson = new Gson();
            String response = new Config().getObjectFromSelection("shopitem", gson.toJson((Object)this.item.getItems()), this.getUser());
            this.item.setValue(gson.fromJson(response, ShopItem.class));
            this.quantity.requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean saveInvoice() {
        int shopLocationCode;
        String tInvoice;
        String tComment;
        String tReference;
        String tProjectCode;
        String tCustomerNo;
        String tSalesRep;
        String tRegion;
        String tInvoiceDate;
        String tInvoiceNo;
        block23: {
            tInvoiceNo = this.invoiceNo.getText().trim();
            tInvoiceDate = "";
            try {
                tInvoiceDate = Config.localDateToString((LocalDate)this.invoiceDate.getValue());
            }
            catch (Exception y) {
                tInvoiceDate = "";
            }
            tRegion = "";
            tSalesRep = "";
            try {
                tRegion = ((Region)this.region.getValue()).getId() + "";
            }
            catch (Exception u) {
                tRegion = "";
            }
            try {
                tSalesRep = ((User)this.salesRep.getValue()).getUserName().trim();
            }
            catch (Exception t) {
                tSalesRep = "";
            }
            tCustomerNo = "";
            tProjectCode = "";
            tReference = "";
            tComment = "";
            tInvoice = "";
            shopLocationCode = 0;
            try {
                tCustomerNo = ((Customer)this.customer.getValue()).getCustomerNumber();
                if (tCustomerNo.isEmpty()) {
                    throw new Exception();
                }
            }
            catch (Exception t) {
                if (this.getDocumentType().equalsIgnoreCase("StoreRequisition")) break block23;
                this.notificationPane.setText("Please select the customer");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
                return false;
            }
        }
        try {
            tProjectCode = ((Project)this.project.getValue()).getProjectId();
        }
        catch (Exception u) {
            tProjectCode = "";
        }
        try {
            shopLocationCode = ((ShopLocation)this.shopLocation.getValue()).getId();
        }
        catch (Exception t) {
            shopLocationCode = 0;
        }
        try {
            tInvoice = ((String)this.invoice.getValue()).trim();
        }
        catch (Exception t) {
            tInvoice = "";
        }
        try {
            tComment = this.comment.getText().trim();
        }
        catch (Exception t) {
            tComment = "";
        }
        try {
            tReference = this.reference.getText().trim();
        }
        catch (Exception t) {
            tReference = "";
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("docNo", tInvoiceNo);
        params.put("customer", tCustomerNo);
        params.put("date", tInvoiceDate);
        params.put("sourceLocation", shopLocationCode);
        params.put("invoice", tInvoice);
        params.put("region", tRegion);
        params.put("salesRep", tSalesRep);
        params.put("document_type", this.getDocumentType());
        params.put("projectCode", tProjectCode);
        params.put("comment", tComment);
        params.put("reference", tReference);
        String response = Config.loadDataFromPhp("mastercreate?type=salesheader", params, this.getUser());
        System.out.println(response);
        Gson g = new Gson();
        try {
            JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                this.invoiceNo.setText(jr.getOverLoad1());
                if (tInvoiceNo.length() < 1) {
                    this.loadFiles(this.invoiceNo.getText().trim());
                }
            }
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        catch (Exception ignored) {
            this.notificationPane.setText("We encountered an error while processing your request");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
    }

    public void loadInvoiceLines() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> CustomerInvoiceController.this.maskerPane.setVisible(true));
                String tInvoiceNo = CustomerInvoiceController.this.invoiceNo.getText().trim();
                ObservableList<SalesLines> allLines = new SalesLines().getAllLines(tInvoiceNo, CustomerInvoiceController.this.getDocumentType(), CustomerInvoiceController.this.getUser());
                double tTotalExVAT = allLines.stream().mapToDouble(SalesLines::getTotalExclVAT).sum();
                double tTotalVAT = allLines.stream().mapToDouble(SalesLines::getTotalVAT).sum();
                double tTotal = allLines.stream().mapToDouble(SalesLines::getTotalAmount).sum();
                double tQuantity = allLines.stream().mapToDouble(SalesLines::getQuantity).sum();
                Platform.runLater(() -> {
                    CustomerInvoiceController.this.invoiceLines.setItems(allLines);
                    CustomerInvoiceController.this.maskerPane.setVisible(false);
                    CustomerInvoiceController.this.totalAmount.setText(Config.formatNumber(tTotal));
                    CustomerInvoiceController.this.totalQuantity.setText(Config.formatNumber(tQuantity));
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    private void loadCustomers1() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    CustomerInvoiceController.this.notificationPane.setText("Loading Values. Please wait");
                    CustomerInvoiceController.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    CustomerInvoiceController.this.notificationPane.show();
                });
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("customerType", "tenant");
                params.put("unit", ((Units)CustomerInvoiceController.this.unit.getValue()).getUnitId());
                ObservableList<Customer> allCustomers = new Customer().getAllCustomers(params, CustomerInvoiceController.this.getUser());
                Platform.runLater(() -> {
                    CustomerInvoiceController.this.customer.setItems(allCustomers);
                    CustomerInvoiceController.this.customer.getSelectionModel().select(0);
                    CustomerInvoiceController.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void editEntry(SalesLines details) {
        try {
            final Stage stage = new Stage();
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/edit_sales_line.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane);
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            EditSalesLineController controller = (EditSalesLineController)loader.getController();
            controller.setUser(this.getUser());
            controller.setItemTypes((ObservableList<String>)this.type.getItems());
            controller.setItems((ObservableList<ShopItem>)this.item.getItems());
            controller.setAssets(this.myAssets);
            controller.setDocumentType(this.getDocumentType());
            controller.setLine(details);
            stage.setTitle("Edit Sales");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CustomerInvoiceController.this.loadInvoiceLines();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            this.notificationPane.setText("An error occurred while loading your edit record screen. Please contact support");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    public void loadFiles(String documentNo) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/edmsfxml/files.fxml").openStream());
            FilesController controller = (FilesController)loader.getController();
            controller.setUser(this.getUser());
            controller.setDocumentType(this.getDocumentType());
            controller.setDocumentId(documentNo);
            itemPane.prefHeightProperty().bind((ObservableValue)this.edms.heightProperty());
            this.edms.getChildren().clear();
            this.edms.getChildren().add((Object)itemPane);
        }
        catch (Exception u) {
            u.printStackTrace();
        }
    }

    public void getCustomerInvoices() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {});
                String customerNo = ((Customer)CustomerInvoiceController.this.customer.getValue()).getCustomerNumber();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 0);
                params.put("status", "Approved");
                params.put("documentType", "salesInvoice");
                params.put("customerNo", customerNo);
                String response = Config.loadDataFromPhp("masterfetch?type=salesheader", params, CustomerInvoiceController.this.getUser());
                System.out.println("Response" + response);
                ObservableList allInvoices = FXCollections.observableArrayList();
                ObservableList headers = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, SalesHeader[].class)));
                ObservableList headers2 = FXCollections.observableArrayList((Collection)headers.stream().filter(v -> v.getCustomer().getCustomerNumber().equalsIgnoreCase(((Customer)CustomerInvoiceController.this.customer.getValue()).getCustomerNumber())).collect(Collectors.toList()));
                for (SalesHeader header : headers2) {
                    allInvoices.add((Object)(header.getDoc_no() + " - " + header.getSales_date()));
                }
                CustomerInvoiceController.this.invoice.setItems(allInvoices);
                Platform.runLater(() -> {});
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addLine() {
        Object cI;
        this.notificationPane.hide();
        String tType = (String)this.type.getValue();
        String itemNo = "";
        String typeValue = (String)this.type.getValue();
        boolean error = false;
        String message = "";
        if (typeValue.equalsIgnoreCase("Services")) {
            try {
                cI = (ChargeItem)this.item.getValue();
                itemNo = ((ChargeItem)cI).getCode() + "";
            }
            catch (Exception t) {
                error = true;
                message = message + "Please an item";
            }
        } else if (typeValue.equalsIgnoreCase("Items")) {
            try {
                cI = (ShopItem)this.item.getValue();
                itemNo = ((ShopItem)cI).getCode() + "";
            }
            catch (Exception t) {
                error = true;
                message = message + "Please an item";
            }
        }
        String tDescription = this.description.getText().trim();
        String tUnitPrice = this.unitPrice.getText().trim();
        double mUnitPrice = 0.0;
        double mKilometres = 0.0;
        String tQuantity = this.quantity.getText().trim();
        double mQuantity = 0.0;
        double mDiscount = 0.0;
        String tVehicle = "";
        if (tType.isEmpty()) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select line type";
        }
        if (itemNo.isEmpty()) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter an item for the line";
        }
        if (tDescription.isEmpty()) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a description for the line";
        }
        if (tUnitPrice.isEmpty()) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a unit price for the line";
        } else {
            try {
                mUnitPrice = Double.parseDouble(tUnitPrice);
                if (mUnitPrice < 0.0) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Unit price cannot be less than zero";
                }
            }
            catch (Exception t) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid unit price for the line";
            }
        }
        if (tQuantity.isEmpty()) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter quantity for the line";
        } else {
            try {
                mQuantity = Double.parseDouble(tQuantity);
                if (mQuantity <= 0.0) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Quantity cannot be less or equal to zero";
                }
            }
            catch (Exception t) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid quantity for the line";
            }
        }
        try {
            mDiscount = Double.parseDouble(this.discount.getText().trim());
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid discount for the line";
        }
        try {
            mKilometres = Double.parseDouble(this.kilometres.getText().trim());
        }
        catch (Exception y) {
            mKilometres = 0.0;
        }
        try {
            tVehicle = ((FixedAssets)this.vehicle.getValue()).getAssetNo();
        }
        catch (Exception u) {
            tVehicle = "";
        }
        if (error) {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
            return;
        }
        if (!this.saveInvoice()) return;
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("headerNo", this.invoiceNo.getText());
            params.put("documentType", this.getDocumentType());
            params.put("itemType", tType);
            params.put("itemNo", itemNo);
            params.put("description", tDescription);
            params.put("unitPrice", tUnitPrice);
            params.put("quantity", tQuantity);
            params.put("discount", mDiscount);
            params.put("kilometres", mKilometres);
            params.put("vehicle", tVehicle);
            String response = Config.loadDataFromPhp("mastercreate?type=salesline", params, this.getUser());
            System.out.println(response);
            Gson g = new Gson();
            JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            if (jr.isStatus()) {
                this.loadInvoiceLines();
                this.description.setText("");
                this.item.setValue(null);
                this.unitPrice.setText("0");
                this.discount.setText("0");
                this.quantity.setText("1");
            }
            try {
                String overload = jr.getOverLoad1().trim();
                if (overload.length() <= 1) return;
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                alert.setTitle("Price Mismatch");
                alert.setHeaderText(overload);
                ButtonType buttonTypeTwo = new ButtonType("Match Price");
                ButtonType buttonTypeThree = new ButtonType("View History");
                ButtonType buttonTypeCancel = new ButtonType("Ignore", ButtonBar.ButtonData.CANCEL_CLOSE);
                alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeTwo, buttonTypeThree, buttonTypeCancel});
                Optional result = alert.showAndWait();
                if (result.get() == buttonTypeThree) {
                    return;
                }
                if (result.get() != buttonTypeTwo) return;
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        catch (Exception t) {
            t.printStackTrace();
            this.notificationPane.setText("We encountered an error while adding the invoice line. ");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
        }
    }

    public void printInvoice(String invoiceTemplate) {
        try {
            HashMap<String, Object> parameters2 = new HashMap<String, Object>();
            parameters2.put("saccoName", Config.saccoName);
            parameters2.put("companyAddress", Config.getShopAddress());
            parameters2.put("invoiceNo", this.invoiceNo.getText());
            parameters2.put("invoiceDate", Config.localDateToString((LocalDate)this.invoiceDate.getValue()));
            parameters2.put("required", Config.localDateToString((LocalDate)this.invoiceDate.getValue()));
            parameters2.put("serialNo", "");
            parameters2.put("cu_invoiceNo", "");
            parameters2.put("internalData", "");
            parameters2.put("receiptSignature", "");
            parameters2.put("qrCode", "");
            parameters2.put("documentType", this.getDocumentType());
            parameters2.put("reference", this.reference.getText());
            Customer customer1 = (Customer)this.customer.getValue();
            parameters2.put("customerNo", customer1.getCustomerNumber());
            parameters2.put("paymentTerms", (int)customer1.getCreditPeriod() + " Days From Invoice");
            parameters2.put("customerPhone", customer1.getCustomerPhone());
            parameters2.put("customerEmail", customer1.getCustomerEmail());
            parameters2.put("customerName", customer1.getCustomerName());
            String customerDetails = customer1.getCustomerName().toUpperCase();
            parameters2.put("customerDetails", customerDetails);
            String shippingDetails = customer1.getCustomerName().toUpperCase();
            parameters2.put("shippingDetails", shippingDetails);
            parameters2.put("customerVat", customer1.getKraPin());
            parameters2.put("amountInWords", new Config().amountInWords(this.invoiceLines.getItems().stream().mapToDouble(SalesLines::getTotalAmount).sum()));
            parameters2.put("currentOutstandingBalance", customer1.getLatestBalance(this.user));
            try {
                parameters2.put("salesPerson", ((User)this.salesRep.getValue()).getFullName());
            }
            catch (Exception u) {
                parameters2.put("salesPerson", "");
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("invoiceNo", this.invoiceNo.getText());
            params.put("docNo", this.invoiceNo.getText());
            params.put("docType", this.getDocumentType());
            new Config().printReport("Customer Invoice", "masterfetch?type=salesline", params, invoiceTemplate, parameters2, this.user);
        }
        catch (Exception u) {
            u.printStackTrace();
        }
    }

    public void printDeliveryNote() {
        try {
            HashMap<String, Object> parameters2 = new HashMap<String, Object>();
            parameters2.put("saccoName", Config.saccoName);
            parameters2.put("companyAddress", Config.getShopAddress());
            parameters2.put("invoiceNo", this.invoiceNo.getText());
            parameters2.put("invoiceDate", Config.localDateToString((LocalDate)this.invoiceDate.getValue()));
            parameters2.put("required", Config.localDateToString((LocalDate)this.invoiceDate.getValue()));
            parameters2.put("serialNo", "");
            parameters2.put("cu_invoiceNo", "");
            parameters2.put("internalData", "");
            parameters2.put("receiptSignature", "");
            parameters2.put("qrCode", "");
            parameters2.put("documentType", "Delivery Note");
            parameters2.put("reference", this.reference.getText());
            Customer customer1 = (Customer)this.customer.getValue();
            parameters2.put("customerNo", customer1.getCustomerNumber());
            parameters2.put("paymentTerms", (int)customer1.getCreditPeriod() + " Days From Invoice");
            parameters2.put("customerPhone", customer1.getCustomerPhone());
            parameters2.put("customerEmail", customer1.getCustomerEmail());
            parameters2.put("customerName", customer1.getCustomerName());
            String customerDetails = customer1.getCustomerName().toUpperCase();
            parameters2.put("customerDetails", customerDetails);
            String shippingDetails = customer1.getCustomerName().toUpperCase();
            parameters2.put("shippingDetails", shippingDetails);
            parameters2.put("customerVat", customer1.getKraPin());
            try {
                parameters2.put("salesPerson", ((User)this.salesRep.getValue()).getFullName());
            }
            catch (Exception u) {
                parameters2.put("salesPerson", "");
            }
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("invoiceNo", this.invoiceNo.getText());
            params.put("docNo", this.invoiceNo.getText());
            params.put("docType", "Delivery Note");
            new Config().printReport("Delivery Note", "masterfetch?type=salesline", params, "delivery_note.jasper", parameters2, this.user);
        }
        catch (Exception u) {
            u.printStackTrace();
        }
    }

    public void convertQuote(String desiredDocumentType) {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("quoteNo", this.invoiceNo.getText().trim());
            params.put("documentType", this.getDocumentType());
            params.put("desiredDocumentType", desiredDocumentType);
            String response = Config.loadDataFromPhp("mastercreate?type=convert_quote", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                GeneralListController.publicNotificationPane.show();
                ((Stage)this.convertQuote.getScene().getWindow()).close();
            } else {
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
        }
        catch (Exception u) {
            u.printStackTrace();
        }
    }

    private void showDocumentAlreadyPosted() {
        this.notificationPane.setText("You cannot make any changes as the document has already been posted");
        this.notificationPane.setGraphic((Node)Config.getBanIcon());
        this.notificationPane.show();
    }
}

