/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.ChartOfAccountCategories;
import classes.ChartOfAccountTypes;
import classes.ChartOfAccountsGroups;
import classes.ChartOfAccountsSubCategories;
import classes.Config;
import classes.Currency;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import controllers.ChartOfAccountsController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class CreateGLAccount
implements Initializable {
    private String serverUrl = "mastercreate?type=glaccount";
    private Account glAccount;
    private User user;
    @FXML
    private TextField accountNumber;
    @FXML
    private TextField accountName;
    @FXML
    private ComboBox<ChartOfAccountTypes> accountType;
    @FXML
    private ComboBox<ChartOfAccountCategories> accountCategory;
    @FXML
    private ComboBox<ChartOfAccountsSubCategories> accountSubCategory;
    @FXML
    private ComboBox<ChartOfAccountsGroups> accountGroup;
    @FXML
    private Button addAccount;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationPaneHolder;
    @FXML
    private ComboBox<Currency> accountCurrency;

    public Account getGlAccount() {
        return this.glAccount;
    }

    public void setGlAccount(Account glAccount) {
        this.glAccount = glAccount;
        this.accountName.requestFocus();
        this.accountNumber.setEditable(false);
        this.accountNumber.setText(glAccount.getAccountNumber());
        this.accountName.setText(glAccount.getAccountName());
        this.accountType.setValue((Object)glAccount.getType());
        Platform.runLater(() -> {
            this.loadCategories();
            Platform.runLater(() -> {
                this.loadSubCategories();
                Platform.runLater(() -> this.loadAccountGroups());
            });
        });
        this.accountCurrency.setValue((Object)glAccount.getCurrency());
        this.addAccount.setText("Save Changes");
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    CreateGLAccount.this.notificationPane.setText("Loading Account Types. Please wait..");
                    CreateGLAccount.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    CreateGLAccount.this.notificationPane.show();
                });
                ObservableList<ChartOfAccountTypes> allTypes = new ChartOfAccountTypes().getAllTypes(CreateGLAccount.this.getUser());
                ObservableList<Currency> allCurrencies = new Currency().getAllCurrencies(CreateGLAccount.this.getUser());
                Platform.runLater(() -> {
                    CreateGLAccount.this.accountType.setItems(allTypes);
                    CreateGLAccount.this.accountCurrency.setItems(allCurrencies);
                    CreateGLAccount.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.notificationPaneHolder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.accountNumber, Validator.createEmptyValidator((String)"required"));
        vs.registerValidator((Control)this.accountName, Validator.createEmptyValidator((String)"required"));
        vs.registerValidator(this.accountType, Validator.createEmptyValidator((String)"required"));
        vs.registerValidator(this.accountCategory, Validator.createEmptyValidator((String)"required"));
        vs.registerValidator(this.accountSubCategory, Validator.createEmptyValidator((String)"required"));
        this.accountType.setOnAction(e -> this.loadCategories());
        this.accountCategory.setOnAction(e -> this.loadSubCategories());
        this.accountSubCategory.setOnAction(e -> this.loadAccountGroups());
        this.addAccount.setOnAction(e -> {
            try {
                this.notificationPane.hide();
                String myAccountNumber = this.accountNumber.getText().trim();
                String myAccountName = this.accountName.getText().trim();
                int tAccountType = 0;
                int tAccountCategory = 0;
                int tAccountSubCategory = 0;
                int tAccountGroup = 0;
                Boolean error = false;
                String message = "";
                if (myAccountNumber.equals("") || myAccountNumber.equals(null)) {
                    myAccountNumber = "";
                }
                if (myAccountName.equals("") || myAccountName.equals(null)) {
                    error = true;
                    message = message + (message.length() < 1 ? "\n" : "");
                    message = message + "Please indicate the account name";
                }
                try {
                    tAccountType = ((ChartOfAccountTypes)this.accountType.getValue()).getId();
                    if (tAccountType < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception u) {
                    error = true;
                    message = message + (message.length() < 1 ? "\n" : "");
                    message = message + "Please select the account type";
                }
                try {
                    tAccountCategory = ((ChartOfAccountCategories)this.accountCategory.getValue()).getId();
                    if (tAccountCategory < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception u) {
                    error = true;
                    message = message + (message.length() < 1 ? "\n" : "");
                    message = message + "Please select the account category";
                }
                try {
                    tAccountSubCategory = ((ChartOfAccountsSubCategories)this.accountSubCategory.getValue()).getId();
                    if (tAccountSubCategory < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception u) {
                    error = true;
                    message = message + (message.length() < 1 ? "\n" : "");
                    message = message + "Please select the account sub category";
                }
                try {
                    tAccountGroup = ((ChartOfAccountsGroups)this.accountGroup.getValue()).getId();
                    if (tAccountGroup < 0) {
                        throw new Exception();
                    }
                }
                catch (Exception u) {
                    tAccountGroup = 0;
                }
                int tCurrency = 0;
                try {
                    tCurrency = ((Currency)this.accountCurrency.getValue()).getId();
                }
                catch (Exception y) {
                    tCurrency = 0;
                }
                if (!error.booleanValue()) {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("accountNumber", myAccountNumber);
                    params.put("accountName", myAccountName);
                    params.put("accountType", tAccountType);
                    params.put("accountCategory", tAccountCategory);
                    params.put("accountSubCategory", tAccountSubCategory);
                    params.put("accountGroup", tAccountGroup);
                    params.put("accountCurrency", tCurrency);
                    String response = Config.loadDataFromPhp(this.getServerUrl(), params, this.getUser());
                    System.out.println(response);
                    Gson g = new Gson();
                    JsonResponses response2 = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    if (response2.isStatus()) {
                        ChartOfAccountsController.publicNotificationPane.setGraphic((Node)Config.getCheckIcon());
                        ChartOfAccountsController.publicNotificationPane.setText(response2.getMessage());
                        ChartOfAccountsController.publicNotificationPane.show();
                        this.accountName.setText("");
                        this.accountNumber.setText("");
                        Stage stage = (Stage)this.addAccount.getScene().getWindow();
                        stage.close();
                    } else {
                        this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                        this.notificationPane.setText(response2.getMessage());
                        this.notificationPane.show();
                    }
                } else {
                    this.notificationPane.setText(message);
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
            catch (Exception y) {
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.setText("We experienced an error while trying to add the chart of accounts. Please try again.");
                this.notificationPane.show();
                y.printStackTrace();
            }
        });
    }

    public void loadCategories() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    CreateGLAccount.this.notificationPane.setText("Loading Account Categories. Please wait..");
                    CreateGLAccount.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    CreateGLAccount.this.notificationPane.show();
                });
                ObservableList<ChartOfAccountCategories> allCategories = new ChartOfAccountCategories().getAllCategories(CreateGLAccount.this.getUser(), ((ChartOfAccountTypes)CreateGLAccount.this.accountType.getValue()).getId());
                Platform.runLater(() -> {
                    CreateGLAccount.this.accountCategory.setItems(allCategories);
                    try {
                        if (((ChartOfAccountTypes)CreateGLAccount.this.accountType.getValue()).getId() == CreateGLAccount.this.getGlAccount().getType().getId()) {
                            CreateGLAccount.this.accountCategory.setValue((Object)CreateGLAccount.this.getGlAccount().getCategory());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CreateGLAccount.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void loadSubCategories() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    CreateGLAccount.this.notificationPane.setText("Loading Account Sub Categories. Please wait..");
                    CreateGLAccount.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    CreateGLAccount.this.notificationPane.show();
                });
                ObservableList<ChartOfAccountsSubCategories> allSubCategories = new ChartOfAccountsSubCategories().getAllSubCategories(CreateGLAccount.this.getUser(), ((ChartOfAccountCategories)CreateGLAccount.this.accountCategory.getValue()).getId());
                Platform.runLater(() -> {
                    CreateGLAccount.this.accountSubCategory.setItems(allSubCategories);
                    try {
                        if (((ChartOfAccountCategories)CreateGLAccount.this.accountCategory.getValue()).getId() == CreateGLAccount.this.getGlAccount().getCategory().getId()) {
                            CreateGLAccount.this.accountSubCategory.setValue((Object)CreateGLAccount.this.getGlAccount().getSubCategory());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CreateGLAccount.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }

    public void loadAccountGroups() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> {
                    CreateGLAccount.this.notificationPane.setText("Loading Account Groups. Please wait..");
                    CreateGLAccount.this.notificationPane.setGraphic((Node)new ProgressIndicator());
                    CreateGLAccount.this.notificationPane.show();
                });
                ObservableList<ChartOfAccountsGroups> allGroups = new ChartOfAccountsGroups().getAllGroups(CreateGLAccount.this.getUser(), ((ChartOfAccountsSubCategories)CreateGLAccount.this.accountSubCategory.getValue()).getId());
                Platform.runLater(() -> {
                    CreateGLAccount.this.accountGroup.setItems(allGroups);
                    try {
                        if (((ChartOfAccountsSubCategories)CreateGLAccount.this.accountSubCategory.getValue()).getId() == CreateGLAccount.this.getGlAccount().getSubCategory().getId()) {
                            CreateGLAccount.this.accountGroup.setValue((Object)CreateGLAccount.this.getGlAccount().getGroup());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CreateGLAccount.this.notificationPane.hide();
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }
}

