/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.AllowancesDeductions;
import classes.AppreciationDepreciation;
import classes.AssetAcquisition;
import classes.AssetDisposal;
import classes.BalanceSheet;
import classes.Bank;
import classes.BankTransfer;
import classes.ChequeRegister;
import classes.Config;
import classes.Contact;
import classes.ContactsGroup;
import classes.Customer;
import classes.CustomerReceipt;
import classes.Department;
import classes.DirectIncome;
import classes.DriverConductor;
import classes.Employee;
import classes.EmployeeBadge;
import classes.ExpressSale;
import classes.InvestmentCommissions;
import classes.ItemBrand;
import classes.Journal;
import classes.LeaveApplication;
import classes.LeaveBalance;
import classes.LeaveType;
import classes.LoanTopup;
import classes.ManagementApproval;
import classes.MemberExit;
import classes.MpesaTransactions;
import classes.ParkingReceipt;
import classes.PaymentVoucher;
import classes.PettyCashVoucher;
import classes.PostingGroup;
import classes.ProductionReturn;
import classes.ProfitNLoss;
import classes.Project;
import classes.Property;
import classes.PublicHoliday;
import classes.PurchaseHeader;
import classes.RecoverLoan;
import classes.Region;
import classes.SalaryAdvance;
import classes.SalaryVoucher;
import classes.SalesHeader;
import classes.ShopItem;
import classes.ShopLocation;
import classes.Sms;
import classes.StaffLoan;
import classes.StockConversion;
import classes.StockTake;
import classes.StockTransfer;
import classes.TaxGroup;
import classes.TaxTables;
import classes.Town;
import classes.TransferFunds;
import classes.TransferVehicle;
import classes.TreeItemClass;
import classes.UnitOfMeasure;
import classes.UnitTypes;
import classes.User;
import classes.UserRoles;
import classes.Vehicle;
import classes.VehicleBrands;
import classes.VehicleExit;
import classes.Vendor;
import com.google.gson.reflect.TypeToken;
import com.jfoenix.controls.JFXButton;
import controllers.AddExpressSale;
import controllers.AllAssetsController;
import controllers.AllInvestmentsController;
import controllers.AllMembersController;
import controllers.AllUsersController;
import controllers.AllVehiclesController;
import controllers.AllWithdrawalsController;
import controllers.BanksController;
import controllers.BoardReportsController;
import controllers.CashWithdrawalsController;
import controllers.ChargeItemsController;
import controllers.ChargeServiceFeeController;
import controllers.ChartOfAccountsController;
import controllers.FinanceSetupController;
import controllers.FinancialReportsController;
import controllers.GeneralListController;
import controllers.InterestVouchersController;
import controllers.LoanApplicationList;
import controllers.LoanProductsController;
import controllers.LoanSetupController;
import controllers.LoansRegister;
import controllers.MemberSetupController;
import controllers.MobitillVouchersController;
import controllers.NumberSeriesController;
import controllers.PayrollSetups;
import controllers.PenaltyVouchersController;
import controllers.ReceiptsController;
import controllers.SalesDashboard;
import controllers.TransactionTypesController;
import controllers.VehicleSetupsController;
import controllers.allCapitalController;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import etims.ETimsController;
import java.awt.Desktop;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import org.controlsfx.control.BreadCrumbBar;

public class Controller
implements Initializable {
    private User user;
    @FXML
    private VBox sidebar;
    @FXML
    private VBox holderVbox;
    @FXML
    private Label userName;
    @FXML
    private Label companyName;
    @FXML
    AnchorPane content;
    @FXML
    AnchorPane paneContent;
    @FXML
    Hyperlink copyright;
    @FXML
    public BreadCrumbBar<String> breadCrumbBar;
    TreeView<TreeItemClass> tree = null;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        VBox vbox = this.getSideBarItems();
        vbox.prefHeightProperty().bind((ObservableValue)this.sidebar.heightProperty());
        this.sidebar.getChildren().add((Object)vbox);
        this.userName.setText(user.getFullName());
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/salesdashboard.fxml").openStream());
            SalesDashboard controller = (SalesDashboard)loader.getController();
            controller.setUser(this.getUser());
            itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
            this.holderVbox.getChildren().clear();
            this.holderVbox.getChildren().add((Object)itemPane);
        }
        catch (Exception y) {
            y.printStackTrace();
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.companyName.setText(Config.shortName);
        this.copyright.setOnAction(e -> {
            try {
                URI url = new URI("www.kuzasystems.com");
                Desktop.getDesktop().browse(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        TreeItem model = BreadCrumbBar.buildTreeModel((Object[])new String[]{Config.shortName});
        this.breadCrumbBar.setSelectedCrumb(model);
    }

    /*
     * WARNING - void declaration
     */
    public VBox getSideBarItems() {
        void vbox;
        void communicationChannels;
        void usersRoles;
        void users;
        void numberSeries;
        void itAdministration;
        TreeItem<TreeItemClass> kuzaErp = TreeItemClass.generateTreeItem(1, "Kuza ERP");
        FontAwesomeIconView add = new FontAwesomeIconView();
        add.setIcon((Enum)FontAwesomeIcon.PLUS);
        FontAwesomeIconView list = new FontAwesomeIconView();
        list.setIcon((Enum)FontAwesomeIcon.LIST);
        FontAwesomeIconView setup = new FontAwesomeIconView();
        setup.setIcon((Enum)FontAwesomeIcon.GEAR);
        FontAwesomeIconView dashboardIcon = new FontAwesomeIconView();
        dashboardIcon.setIcon((Enum)FontAwesomeIcon.DASHBOARD);
        FontAwesomeIconView homeIcon = new FontAwesomeIconView();
        homeIcon.setIcon((Enum)FontAwesomeIcon.HOME);
        FontAwesomeIconView old = new FontAwesomeIconView();
        old.setIcon((Enum)FontAwesomeIcon.ARCHIVE);
        FontAwesomeIconView car = new FontAwesomeIconView();
        car.setIcon((Enum)FontAwesomeIcon.CAR);
        FontAwesomeIconView user = new FontAwesomeIconView();
        user.setIcon((Enum)FontAwesomeIcon.USER);
        FontAwesomeIconView smsIcon = new FontAwesomeIconView();
        smsIcon.setIcon((Enum)FontAwesomeIcon.ENVELOPE);
        FontAwesomeIconView hrIcon = new FontAwesomeIconView();
        hrIcon.setIcon((Enum)FontAwesomeIcon.GROUP);
        FontAwesomeIconView hrIcon2 = new FontAwesomeIconView();
        hrIcon2.setIcon((Enum)FontAwesomeIcon.GROUP);
        FontAwesomeIconView financeIcon = new FontAwesomeIconView();
        financeIcon.setIcon((Enum)FontAwesomeIcon.DOLLAR);
        FontAwesomeIconView buildingIcon = new FontAwesomeIconView();
        buildingIcon.setIcon((Enum)FontAwesomeIcon.BUILDING);
        kuzaErp.setExpanded(true);
        TreeItem<TreeItemClass> home = TreeItemClass.generateTreeItem(2, "Home");
        home.setGraphic((Node)homeIcon);
        this.addToTree(kuzaErp, home);
        TreeItem<TreeItemClass> boardReports = TreeItemClass.generateTreeItem(1290, "Board Reports");
        this.addToTree(kuzaErp, boardReports);
        TreeItem<TreeItemClass> dashboard = TreeItemClass.generateTreeItem(3, "Dashboard");
        dashboard.setGraphic((Node)dashboardIcon);
        this.addToTree(kuzaErp, dashboard);
        TreeItem<TreeItemClass> members = TreeItemClass.generateTreeItem(4, "Members");
        members.setGraphic((Node)user);
        TreeItem<TreeItemClass> allMembersList = TreeItemClass.generateTreeItem(5, "All Members List");
        TreeItem<TreeItemClass> inactiveMembers = TreeItemClass.generateTreeItem(6, "Inactive Members");
        TreeItem<TreeItemClass> exitedMembers = TreeItemClass.generateTreeItem(7, "Exited Members");
        TreeItem<TreeItemClass> unpostedWithdrawals = TreeItemClass.generateTreeItem(8, "Unposted Savings Withdrawals");
        TreeItem<TreeItemClass> postedWithdrawals = TreeItemClass.generateTreeItem(9, "Posted Savings Withdrawals");
        TreeItem<TreeItemClass> reversedWithdrawals = TreeItemClass.generateTreeItem(10, "Reversed Savings Withdrawals");
        TreeItem<TreeItemClass> transferFunds = TreeItemClass.generateTreeItem(11, "Transfer Funds");
        TreeItem<TreeItemClass> postedTransferFunds = TreeItemClass.generateTreeItem(12, "Posted Transfer Funds");
        TreeItem<TreeItemClass> memberExits = TreeItemClass.generateTreeItem(13, "Member Exits");
        TreeItem<TreeItemClass> postedMemberExits = TreeItemClass.generateTreeItem(14, "Posted Member Exits");
        TreeItem<TreeItemClass> membersSetups = TreeItemClass.generateTreeItem(15, "Member Setups");
        this.addToTree(members, allMembersList);
        TreeItem<TreeItemClass> vehicles = TreeItemClass.generateTreeItem(16, "Vehicles");
        vehicles.setGraphic((Node)car);
        TreeItem<TreeItemClass> productionModule = TreeItemClass.generateTreeItem(1999, "Production");
        FontAwesomeIconView prodIcon = new FontAwesomeIconView();
        prodIcon.setIcon((Enum)FontAwesomeIcon.COGS);
        productionModule.setGraphic((Node)prodIcon);
        TreeItem<TreeItemClass> pendingProductionReturn = TreeItemClass.generateTreeItem(2000, "Pending Production Return");
        TreeItem<TreeItemClass> postedProductionReturn = TreeItemClass.generateTreeItem(2001, "Posted Production Return");
        this.addToTree(productionModule, pendingProductionReturn);
        this.addToTree(productionModule, postedProductionReturn);
        TreeItem<TreeItemClass> shop = TreeItemClass.generateTreeItem(17, "Warehouse");
        FontAwesomeIconView shopIcon = new FontAwesomeIconView();
        shopIcon.setIcon((Enum)FontAwesomeIcon.CART_ARROW_DOWN);
        shop.setGraphic((Node)shopIcon);
        TreeItem<TreeItemClass> managementApproval = TreeItemClass.generateTreeItem(1318, "Management Approval");
        TreeItem<TreeItemClass> draftStockRequest = TreeItemClass.generateTreeItem(1300, "Draft Stock Requests");
        TreeItem<TreeItemClass> pendingStockRequest = TreeItemClass.generateTreeItem(1301, "Pending Stock Requests");
        TreeItem<TreeItemClass> postedStockRequest = TreeItemClass.generateTreeItem(1302, "Posted Stock Requests");
        TreeItem<TreeItemClass> draftStoreRequisition = TreeItemClass.generateTreeItem(1303, "Draft Store Requisitions");
        TreeItem<TreeItemClass> postedStoreRequisition = TreeItemClass.generateTreeItem(1305, "Posted Store Requisitions");
        TreeItem<TreeItemClass> draftWarehouseReturns = TreeItemClass.generateTreeItem(1306, "Draft Warehouse Returns");
        TreeItem<TreeItemClass> pendingWarehouseReturns = TreeItemClass.generateTreeItem(1307, "Pending Warehouse Returns");
        TreeItem<TreeItemClass> postedWarehouseReturns = TreeItemClass.generateTreeItem(1308, "Posted Warehouse Returns");
        TreeItem<TreeItemClass> draftEndOfDay = TreeItemClass.generateTreeItem(1309, "Draft End of Day Closing Stock");
        TreeItem<TreeItemClass> pendingEndOfDay = TreeItemClass.generateTreeItem(1310, "Pending End of Day Closing Stock");
        TreeItem<TreeItemClass> postedEndOfDay = TreeItemClass.generateTreeItem(1311, "Posted End of Day Closing Stock");
        TreeItem<TreeItemClass> archivedEndOfDay = TreeItemClass.generateTreeItem(1316, "Archived End of Day Closing Stock");
        TreeItem<TreeItemClass> pendingStockTake = TreeItemClass.generateTreeItem(1312, "Pending Stock Take");
        TreeItem<TreeItemClass> postedStockTake = TreeItemClass.generateTreeItem(1313, "Closed Stock Take");
        TreeItem<TreeItemClass> pendingConversion = TreeItemClass.generateTreeItem(1314, "Pending Conversion");
        TreeItem<TreeItemClass> postedConversion = TreeItemClass.generateTreeItem(1315, "Posted Conversion");
        TreeItem<TreeItemClass> pendingSalesOrders = TreeItemClass.generateTreeItem(1320, "Pending Sales Orders");
        TreeItem<TreeItemClass> approvedSalesOrders = TreeItemClass.generateTreeItem(1321, "Approved Sales Orders");
        TreeItem<TreeItemClass> brand = TreeItemClass.generateTreeItem(18, "Item Brand");
        TreeItem<TreeItemClass> taxGroup = TreeItemClass.generateTreeItem(19, "Tax Groups");
        TreeItem<TreeItemClass> uom = TreeItemClass.generateTreeItem(20, "Units Of Measure");
        TreeItem<TreeItemClass> items = TreeItemClass.generateTreeItem(21, "Items");
        TreeItem<TreeItemClass> shopLocation = TreeItemClass.generateTreeItem(22, "Warehouses");
        TreeItem<TreeItemClass> availableStock = TreeItemClass.generateTreeItem(23, "Stock Per Location");
        TreeItem<TreeItemClass> stockTransfer = TreeItemClass.generateTreeItem(24, "Stock Transfer");
        TreeItem<TreeItemClass> postedStockTransfer = TreeItemClass.generateTreeItem(1402, "Posted Stock Transfer");
        TreeItem<TreeItemClass> stockAdjustment = TreeItemClass.generateTreeItem(25, "Stock Adjustment");
        TreeItem<TreeItemClass> expressSale = TreeItemClass.generateTreeItem(26, "Express Sale");
        TreeItem<TreeItemClass> postedExpressSale = TreeItemClass.generateTreeItem(27, "Posted Express Sale");
        TreeItem<TreeItemClass> reversedExpressSale = TreeItemClass.generateTreeItem(28, "Reversed Express Sale");
        TreeItem<TreeItemClass> prepayments = TreeItemClass.generateTreeItem(26, "Prepayments");
        TreeItem<TreeItemClass> itemPostingGroup = TreeItemClass.generateTreeItem(29, "Item Posting Group");
        this.addToTree(shop, items);
        this.addToTree(shop, managementApproval);
        this.addToTree(shop, draftStockRequest);
        this.addToTree(shop, pendingStockRequest);
        this.addToTree(shop, postedStockRequest);
        this.addToTree(shop, pendingSalesOrders);
        this.addToTree(shop, approvedSalesOrders);
        this.addToTree(shop, draftStoreRequisition);
        this.addToTree(shop, postedStoreRequisition);
        this.addToTree(shop, draftWarehouseReturns);
        this.addToTree(shop, pendingWarehouseReturns);
        this.addToTree(shop, postedWarehouseReturns);
        this.addToTree(shop, draftEndOfDay);
        this.addToTree(shop, pendingEndOfDay);
        this.addToTree(shop, postedEndOfDay);
        this.addToTree(shop, archivedEndOfDay);
        this.addToTree(shop, pendingStockTake);
        this.addToTree(shop, postedStockTake);
        this.addToTree(shop, pendingConversion);
        this.addToTree(shop, postedConversion);
        this.addToTree(shop, expressSale);
        this.addToTree(shop, postedExpressSale);
        this.addToTree(shop, reversedExpressSale);
        this.addToTree(shop, prepayments);
        this.addToTree(shop, brand);
        this.addToTree(shop, taxGroup);
        this.addToTree(shop, uom);
        this.addToTree(shop, shopLocation);
        this.addToTree(shop, stockTransfer);
        this.addToTree(shop, postedStockTransfer);
        this.addToTree(shop, itemPostingGroup);
        TreeItem<TreeItemClass> allVehicles = TreeItemClass.generateTreeItem(30, "All Vehicles");
        TreeItem<TreeItemClass> inactiveVehicles = TreeItemClass.generateTreeItem(31, "Inactive Vehicles");
        TreeItem<TreeItemClass> exitedVehicles = TreeItemClass.generateTreeItem(32, "Exited Vehicles");
        TreeItem<TreeItemClass> towns = TreeItemClass.generateTreeItem(33, "Towns");
        TreeItem<TreeItemClass> chargeServiceFee = TreeItemClass.generateTreeItem(34, "Charge Service Fee");
        TreeItem<TreeItemClass> postedServiceFee = TreeItemClass.generateTreeItem(35, "Posted Service Fee");
        TreeItem<TreeItemClass> chargeParkingFee = TreeItemClass.generateTreeItem(36, "Parking Fee Receipts");
        TreeItem<TreeItemClass> postedParkingFee = TreeItemClass.generateTreeItem(37, "Posted Parking Fee Receipts");
        TreeItem<TreeItemClass> vehicleTransfer = TreeItemClass.generateTreeItem(38, "Vehicle Transfer");
        TreeItem<TreeItemClass> postedVehicleTransfer = TreeItemClass.generateTreeItem(39, "Posted Vehicle Transfer");
        TreeItem<TreeItemClass> vehicleExit = TreeItemClass.generateTreeItem(40, "Vehicle Exit");
        TreeItem<TreeItemClass> postedVehicleExit = TreeItemClass.generateTreeItem(41, "Posted Vehicle Exit");
        TreeItem<TreeItemClass> vehicleBrands = TreeItemClass.generateTreeItem(42, "Vehicle Brands");
        TreeItem<TreeItemClass> vehiclesSetups = TreeItemClass.generateTreeItem(43, "Vehicle Setups");
        this.addToTree(vehicles, allVehicles);
        this.addToTree(vehicles, inactiveVehicles);
        this.addToTree(vehicles, exitedVehicles);
        this.addToTree(vehicles, chargeServiceFee);
        this.addToTree(vehicles, postedServiceFee);
        this.addToTree(vehicles, chargeParkingFee);
        this.addToTree(vehicles, postedParkingFee);
        this.addToTree(vehicles, vehicleTransfer);
        this.addToTree(vehicles, postedVehicleTransfer);
        this.addToTree(vehicles, vehicleExit);
        this.addToTree(vehicles, postedVehicleExit);
        this.addToTree(vehicles, towns);
        this.addToTree(vehicles, vehicleBrands);
        this.addToTree(vehicles, vehiclesSetups);
        TreeItem<TreeItemClass> loans = TreeItemClass.generateTreeItem(44, "Loans");
        TreeItem<TreeItemClass> loanApplications = TreeItemClass.generateTreeItem(45, "Loans Applications List");
        TreeItem<TreeItemClass> loanRegister = TreeItemClass.generateTreeItem(46, "Loan Register");
        TreeItem<TreeItemClass> clearedLoans = TreeItemClass.generateTreeItem(47, "Cleared Loans");
        TreeItem<TreeItemClass> unservicedLoans = TreeItemClass.generateTreeItem(48, "Unserviced Loans");
        TreeItem<TreeItemClass> loanProducts = TreeItemClass.generateTreeItem(49, "Loan Products");
        TreeItem<TreeItemClass> chargeInterest = TreeItemClass.generateTreeItem(50, "Charge Interest");
        TreeItem<TreeItemClass> postedInterest = TreeItemClass.generateTreeItem(51, "Posted Interest");
        TreeItem<TreeItemClass> chargePenalty = TreeItemClass.generateTreeItem(52, "Charge Penalty");
        TreeItem<TreeItemClass> postedPenalty = TreeItemClass.generateTreeItem(53, "Posted Penalty");
        TreeItem<TreeItemClass> loanTopUp = TreeItemClass.generateTreeItem(54, "Loan Top Up");
        TreeItem<TreeItemClass> postedLoanTopUp = TreeItemClass.generateTreeItem(55, "Posted Loan Top Up");
        TreeItem<TreeItemClass> reversedLoanTopUp = TreeItemClass.generateTreeItem(56, "Reversed Loan Top Up");
        TreeItem<TreeItemClass> loanRecovery = TreeItemClass.generateTreeItem(57, "Loan Recovery");
        TreeItem<TreeItemClass> postedLoanRecovery = TreeItemClass.generateTreeItem(58, "Posted Loan Recovery");
        TreeItem<TreeItemClass> loansSetups = TreeItemClass.generateTreeItem(59, "Loans Setups");
        this.addToTree(loans, loanApplications);
        this.addToTree(loans, loanRegister);
        this.addToTree(loans, clearedLoans);
        this.addToTree(loans, unservicedLoans);
        this.addToTree(loans, loanProducts);
        this.addToTree(loans, loansSetups);
        TreeItem<TreeItemClass> driversNConductors = TreeItemClass.generateTreeItem(60, "Drivers & Conductors");
        TreeItem<TreeItemClass> allDriversAndConductors = TreeItemClass.generateTreeItem(61, "All Drivers and Conductors");
        TreeItem<TreeItemClass> badgeApplications = TreeItemClass.generateTreeItem(62, "Badge Applications");
        TreeItem<TreeItemClass> appliedBadges = TreeItemClass.generateTreeItem(63, "Applied Badges");
        TreeItem<TreeItemClass> badgeToCollect = TreeItemClass.generateTreeItem(64, "Badge to Collect");
        TreeItem<TreeItemClass> collectedBadges = TreeItemClass.generateTreeItem(65, "Collected Badges");
        this.addToTree(driversNConductors, allDriversAndConductors);
        this.addToTree(driversNConductors, badgeApplications);
        this.addToTree(driversNConductors, appliedBadges);
        this.addToTree(driversNConductors, badgeToCollect);
        this.addToTree(driversNConductors, collectedBadges);
        TreeItem<TreeItemClass> dividends = TreeItemClass.generateTreeItem(66, "Dividends");
        TreeItem<TreeItemClass> processDividends = TreeItemClass.generateTreeItem(67, "Process Dividends");
        TreeItem<TreeItemClass> pastDividendAllocation = TreeItemClass.generateTreeItem(68, "Past Dividend Allocation");
        TreeItem<TreeItemClass> dividendBalances = TreeItemClass.generateTreeItem(69, "Dividend Balances");
        TreeItem<TreeItemClass> dividendSetups = TreeItemClass.generateTreeItem(70, "Dividend Setups");
        this.addToTree(dividends, processDividends);
        this.addToTree(dividends, pastDividendAllocation);
        this.addToTree(dividends, dividendBalances);
        this.addToTree(dividends, dividendSetups);
        TreeItem<TreeItemClass> routes = TreeItemClass.generateTreeItem(71, "Routes");
        TreeItem<TreeItemClass> allRoutes = TreeItemClass.generateTreeItem(72, "All Routes");
        TreeItem<TreeItemClass> routesSchedules = TreeItemClass.generateTreeItem(73, "Routes Schedules History");
        TreeItem<TreeItemClass> generateRouteSchedule = TreeItemClass.generateTreeItem(74, "Generate Route Schedule");
        TreeItem<TreeItemClass> routesSetups = TreeItemClass.generateTreeItem(75, "Routes Setups");
        this.addToTree(routes, allRoutes);
        this.addToTree(routes, routesSchedules);
        this.addToTree(routes, generateRouteSchedule);
        this.addToTree(routes, routesSetups);
        TreeItem<TreeItemClass> parcels = TreeItemClass.generateTreeItem(76, "Parcels");
        TreeItem<TreeItemClass> addParcel = TreeItemClass.generateTreeItem(77, "Add Parcel");
        TreeItem<TreeItemClass> uncollectedParcels = TreeItemClass.generateTreeItem(78, "Uncollected parcels");
        TreeItem<TreeItemClass> collectedParcels = TreeItemClass.generateTreeItem(79, "Collected Parcels");
        TreeItem<TreeItemClass> parcelsSetups = TreeItemClass.generateTreeItem(80, "parcel Setups");
        this.addToTree(parcels, addParcel);
        this.addToTree(parcels, uncollectedParcels);
        this.addToTree(parcels, collectedParcels);
        this.addToTree(parcels, parcelsSetups);
        TreeItem<TreeItemClass> customers = TreeItemClass.generateTreeItem(81, "Receivables");
        TreeItem<TreeItemClass> allCustomers = TreeItemClass.generateTreeItem(82, "All Customers");
        TreeItem<TreeItemClass> proformaInvoice = TreeItemClass.generateTreeItem(83, "Proforma Invoice");
        TreeItem<TreeItemClass> convertedProformaInvoice = TreeItemClass.generateTreeItem(83, "Converted Proforma Invoice");
        TreeItem<TreeItemClass> customerInvoicing = TreeItemClass.generateTreeItem(83, "Sales Invoices");
        TreeItem<TreeItemClass> postedCustomerInvoices = TreeItemClass.generateTreeItem(84, "Posted Sales Invoices");
        TreeItem<TreeItemClass> customerReceipting = TreeItemClass.generateTreeItem(85, "Customer Receipts");
        TreeItem<TreeItemClass> posted_customer_receipts = TreeItemClass.generateTreeItem(86, "Posted Customer Receipts");
        TreeItem<TreeItemClass> voided_customer_receipts = TreeItemClass.generateTreeItem(86, "Voided Customer Receipts");
        TreeItem<TreeItemClass> cheque_register = TreeItemClass.generateTreeItem(86, "Customer Cheque Register");
        TreeItem<TreeItemClass> creditNote = TreeItemClass.generateTreeItem(83, "Credit Note");
        TreeItem<TreeItemClass> pendingCreditNote = TreeItemClass.generateTreeItem(1317, "Pending Credit Note");
        TreeItem<TreeItemClass> postedCreditNote = TreeItemClass.generateTreeItem(84, "Posted Credit Note");
        TreeItem<TreeItemClass> customerPostingGroups = TreeItemClass.generateTreeItem(87, "Customer Posting Groups");
        TreeItem<TreeItemClass> customerChargeItems = TreeItemClass.generateTreeItem(88, "Customer Services");
        this.addToTree(customers, allCustomers);
        this.addToTree(customers, proformaInvoice);
        this.addToTree(customers, convertedProformaInvoice);
        this.addToTree(customers, customerInvoicing);
        this.addToTree(customers, postedCustomerInvoices);
        this.addToTree(customers, customerReceipting);
        this.addToTree(customers, posted_customer_receipts);
        this.addToTree(customers, voided_customer_receipts);
        if (Config.hasPdc) {
            this.addToTree(customers, cheque_register);
        }
        this.addToTree(customers, creditNote);
        this.addToTree(customers, pendingCreditNote);
        this.addToTree(customers, postedCreditNote);
        this.addToTree(customers, customerPostingGroups);
        this.addToTree(customers, customerChargeItems);
        this.addToTree(kuzaErp, customers);
        TreeItem<TreeItemClass> vendors = TreeItemClass.generateTreeItem(89, "Vendors");
        TreeItem<TreeItemClass> all_vendors = TreeItemClass.generateTreeItem(90, "All Suppliers");
        TreeItem<TreeItemClass> salesReps = TreeItemClass.generateTreeItem(1400, "Sales Reps");
        TreeItem<TreeItemClass> draftLPO = TreeItemClass.generateTreeItem(1401, "Draft L.P.O.s");
        TreeItem<TreeItemClass> pendingLPO = TreeItemClass.generateTreeItem(1401, "Pending L.P.O.s");
        TreeItem<TreeItemClass> approvedLPO = TreeItemClass.generateTreeItem(1401, "Approved L.P.O.s");
        TreeItem<TreeItemClass> vendorInvoices = TreeItemClass.generateTreeItem(91, "Purchase Invoice");
        if (!Config.ERP_MODE) {
            vendorInvoices = TreeItemClass.generateTreeItem(91, "Receive Goods");
        }
        TreeItem<TreeItemClass> posted_vendor_invoices = TreeItemClass.generateTreeItem(92, "Posted Purchase Invoices");
        TreeItem<TreeItemClass> debitNote = TreeItemClass.generateTreeItem(192, "Debit Note");
        TreeItem<TreeItemClass> postedDebitNote = TreeItemClass.generateTreeItem(193, "Posted Debit Note");
        TreeItem<TreeItemClass> paymentVouchers = TreeItemClass.generateTreeItem(93, "Payment Vouchers");
        TreeItem<TreeItemClass> postedPaymentVouchers = TreeItemClass.generateTreeItem(94, "Posted Payment Vouchers");
        TreeItem<TreeItemClass> voidedPaymentVouchers = TreeItemClass.generateTreeItem(94, "Voided Payment Vouchers");
        TreeItem<TreeItemClass> vendor_cheque_register = TreeItemClass.generateTreeItem(94, "Vendor Cheque Register");
        TreeItem<TreeItemClass> vendor_posting_groups = TreeItemClass.generateTreeItem(95, "Vendor Posting Groups");
        TreeItem<TreeItemClass> vendor_charge_items = TreeItemClass.generateTreeItem(96, "Vendor Services");
        this.addToTree(vendors, all_vendors);
        this.addToTree(vendors, salesReps);
        this.addToTree(vendors, draftLPO);
        this.addToTree(vendors, pendingLPO);
        this.addToTree(vendors, approvedLPO);
        this.addToTree(vendors, vendorInvoices);
        this.addToTree(vendors, posted_vendor_invoices);
        this.addToTree(vendors, debitNote);
        this.addToTree(vendors, postedDebitNote);
        this.addToTree(vendors, paymentVouchers);
        this.addToTree(vendors, postedPaymentVouchers);
        this.addToTree(vendors, voidedPaymentVouchers);
        if (Config.hasPdc) {
            this.addToTree(vendors, vendor_cheque_register);
        }
        this.addToTree(vendors, vendor_posting_groups);
        this.addToTree(vendors, vendor_charge_items);
        this.addToTree(kuzaErp, vendors);
        TreeItem<TreeItemClass> investments = TreeItemClass.generateTreeItem(97, "Investments");
        FontAwesomeIconView investments_icon = new FontAwesomeIconView();
        investments_icon.setIcon((Enum)FontAwesomeIcon.MONEY);
        investments.setGraphic((Node)investments_icon);
        TreeItem<TreeItemClass> allInvestments = TreeItemClass.generateTreeItem(98, "All Investments");
        TreeItem<TreeItemClass> allCapital = TreeItemClass.generateTreeItem(99, "Capital");
        TreeItem<TreeItemClass> withdrawals = TreeItemClass.generateTreeItem(100, "Withdrawals");
        TreeItem<TreeItemClass> interests = TreeItemClass.generateTreeItem(101, "Investment Commissions");
        this.addToTree(investments, allInvestments);
        this.addToTree(investments, allCapital);
        this.addToTree(investments, withdrawals);
        this.addToTree(investments, interests);
        TreeItem<TreeItemClass> fixedAssests = TreeItemClass.generateTreeItem(102, "Fixed Assets");
        FontAwesomeIconView asset = new FontAwesomeIconView();
        asset.setIcon((Enum)FontAwesomeIcon.BUILDING);
        fixedAssests.setGraphic((Node)asset);
        TreeItem<TreeItemClass> allAssets = TreeItemClass.generateTreeItem(103, "All Assets");
        TreeItem<TreeItemClass> disposal = TreeItemClass.generateTreeItem(104, "Disposal");
        TreeItem<TreeItemClass> postedDisposal = TreeItemClass.generateTreeItem(105, "Posted Disposal");
        TreeItem<TreeItemClass> appreciation = TreeItemClass.generateTreeItem(106, "Appreciation/Depreciation");
        TreeItem<TreeItemClass> postedAppreciation = TreeItemClass.generateTreeItem(107, "Posted Appreciation/Depreciation");
        TreeItem<TreeItemClass> acquisition = TreeItemClass.generateTreeItem(108, "Acquisition");
        TreeItem<TreeItemClass> postedAcquisition = TreeItemClass.generateTreeItem(119, "Posted Acquisition");
        this.addToTree(fixedAssests, allAssets);
        this.addToTree(fixedAssests, acquisition);
        this.addToTree(fixedAssests, postedAcquisition);
        this.addToTree(fixedAssests, disposal);
        this.addToTree(fixedAssests, postedDisposal);
        this.addToTree(fixedAssests, appreciation);
        this.addToTree(fixedAssests, postedAppreciation);
        this.addToTree(kuzaErp, fixedAssests);
        TreeItem<TreeItemClass> finance = TreeItemClass.generateTreeItem(120, "Finance");
        finance.setGraphic((Node)financeIcon);
        TreeItem<TreeItemClass> banks = TreeItemClass.generateTreeItem(121, "Banks");
        TreeItem<TreeItemClass> mpesaTransaction = TreeItemClass.generateTreeItem(1210, "Mpesa Transaction");
        TreeItem<TreeItemClass> regions = TreeItemClass.generateTreeItem(121, "Regions");
        TreeItem<TreeItemClass> projects = TreeItemClass.generateTreeItem(121, "Projects");
        TreeItem<TreeItemClass> bankTransfers = TreeItemClass.generateTreeItem(122, "Bank Transfers");
        TreeItem<TreeItemClass> postedBankTransfers = TreeItemClass.generateTreeItem(123, "Posted Bank Transfers");
        TreeItem<TreeItemClass> reversedBankTransfers = TreeItemClass.generateTreeItem(124, "Reversed Bank Transfers");
        TreeItem<TreeItemClass> bankBalances = TreeItemClass.generateTreeItem(1211, "Bank Balances");
        TreeItem<TreeItemClass> loans1 = TreeItemClass.generateTreeItem(1211, "Bank Loans");
        TreeItem<TreeItemClass> receipting = TreeItemClass.generateTreeItem(125, "Receipting");
        TreeItem<TreeItemClass> postedReceipts = TreeItemClass.generateTreeItem(126, "Posted Receipts");
        TreeItem<TreeItemClass> reversedReceipts = TreeItemClass.generateTreeItem(127, "Reversed Receipts");
        TreeItem<TreeItemClass> directIncome = TreeItemClass.generateTreeItem(128, "Direct Income");
        TreeItem<TreeItemClass> postedDirectIncome = TreeItemClass.generateTreeItem(129, "Posted Direct Income");
        TreeItem<TreeItemClass> reversedDirectIncome = TreeItemClass.generateTreeItem(130, "Reversed Direct Income");
        TreeItem<TreeItemClass> chartofAccounts = TreeItemClass.generateTreeItem(131, "Chart of Accounts");
        TreeItem<TreeItemClass> transactionTypes = TreeItemClass.generateTreeItem(132, "Transaction Types");
        TreeItem<TreeItemClass> financialReports = TreeItemClass.generateTreeItem(133, "Financial Reports");
        TreeItem<TreeItemClass> financeSetups = TreeItemClass.generateTreeItem(136, "Finance Setups");
        TreeItem<TreeItemClass> mobitill_import = TreeItemClass.generateTreeItem(137, "Mobitill Import");
        TreeItem<TreeItemClass> postedMobitillImport = TreeItemClass.generateTreeItem(138, "Posted Mobitill Import");
        TreeItem<TreeItemClass> journals = TreeItemClass.generateTreeItem(139, "Journals");
        TreeItem<TreeItemClass> openJournals = TreeItemClass.generateTreeItem(140, "Open Journals");
        TreeItem<TreeItemClass> postedJournals = TreeItemClass.generateTreeItem(141, "Posted Journals");
        TreeItem<TreeItemClass> reversedJournals = TreeItemClass.generateTreeItem(142, "Reversed Journals");
        this.addToTree(journals, openJournals);
        this.addToTree(journals, postedJournals);
        this.addToTree(journals, reversedJournals);
        this.addToTree(finance, banks);
        this.addToTree(finance, bankBalances);
        this.addToTree(finance, loans1);
        this.addToTree(finance, mpesaTransaction);
        this.addToTree(finance, regions);
        this.addToTree(finance, projects);
        this.addToTree(finance, bankTransfers);
        this.addToTree(finance, postedBankTransfers);
        this.addToTree(finance, reversedBankTransfers);
        this.addToTree(finance, receipting);
        this.addToTree(finance, postedReceipts);
        this.addToTree(finance, reversedReceipts);
        TreeItem<TreeItemClass> pettyCash = TreeItemClass.generateTreeItem(143, "Petty Cash");
        TreeItem<TreeItemClass> pettyCashVouchers = TreeItemClass.generateTreeItem(144, "Petty Cash Vouchers");
        TreeItem<TreeItemClass> postedPettyCashVouchers = TreeItemClass.generateTreeItem(145, "Posted Petty Cash Vouchers");
        TreeItem<TreeItemClass> reversedPettyCashVouchers = TreeItemClass.generateTreeItem(146, "Reversed Petty Cash Vouchers");
        TreeItem<TreeItemClass> pettyCashChargeItems = TreeItemClass.generateTreeItem(147, "Petty Cash Charge Items");
        this.addToTree(pettyCash, pettyCashVouchers);
        this.addToTree(pettyCash, postedPettyCashVouchers);
        this.addToTree(pettyCash, reversedPettyCashVouchers);
        this.addToTree(pettyCash, pettyCashChargeItems);
        this.addToTree(finance, pettyCash);
        TreeItem<TreeItemClass> imprest = TreeItemClass.generateTreeItem(1143, "Imprest");
        TreeItem<TreeItemClass> imprestVouchers = TreeItemClass.generateTreeItem(1144, "Imprest Vouchers");
        TreeItem<TreeItemClass> postedImprestVouchers = TreeItemClass.generateTreeItem(1145, "Posted Imprest Vouchers");
        TreeItem<TreeItemClass> reversedImprestVouchers = TreeItemClass.generateTreeItem(1146, "Reversed Imprest Vouchers");
        TreeItem<TreeItemClass> imprestChargeItems = TreeItemClass.generateTreeItem(1147, "Imprest Charge Items");
        this.addToTree(imprest, imprestVouchers);
        this.addToTree(imprest, postedImprestVouchers);
        this.addToTree(imprest, reversedImprestVouchers);
        this.addToTree(imprest, imprestChargeItems);
        this.addToTree(finance, imprest);
        this.addToTree(finance, chartofAccounts);
        this.addToTree(finance, transactionTypes);
        this.addToTree(finance, financialReports);
        this.addToTree(finance, journals);
        this.addToTree(finance, financeSetups);
        this.addToTree(kuzaErp, finance);
        this.addToTree(kuzaErp, productionModule);
        this.addToTree(kuzaErp, shop);
        TreeItem<TreeItemClass> properties = TreeItemClass.generateTreeItem(225, "Property Management");
        properties.setGraphic((Node)buildingIcon);
        TreeItem<TreeItemClass> landlords = TreeItemClass.generateTreeItem(228, "Landlords");
        TreeItem<TreeItemClass> propertyList = TreeItemClass.generateTreeItem(206, "Properties");
        TreeItem<TreeItemClass> activeTenants = TreeItemClass.generateTreeItem(227, "Active Tenants");
        TreeItem<TreeItemClass> tenantInvoices = TreeItemClass.generateTreeItem(230, "Tenant Invoices");
        TreeItem<TreeItemClass> postedTenantInvoices = TreeItemClass.generateTreeItem(231, "Posted Tenant Invoices");
        TreeItem<TreeItemClass> tenantReceipts = TreeItemClass.generateTreeItem(232, "Tenant Receipts");
        TreeItem<TreeItemClass> postedTenantReceipts = TreeItemClass.generateTreeItem(233, "Posted Tenant Receipts");
        TreeItem<TreeItemClass> landlordDisbursements = TreeItemClass.generateTreeItem(232, "Landlord Disbursements");
        TreeItem<TreeItemClass> postedLandlordDisbursements = TreeItemClass.generateTreeItem(233, "Posted Landlord Disbursements");
        TreeItem<TreeItemClass> waterReadings = TreeItemClass.generateTreeItem(234, "Water Readings");
        TreeItem<TreeItemClass> invoicedWaterReadings = TreeItemClass.generateTreeItem(235, "Invoiced Water readings");
        TreeItem<TreeItemClass> formerTenants = TreeItemClass.generateTreeItem(228, "Former Tenants");
        TreeItem<TreeItemClass> unitTypes = TreeItemClass.generateTreeItem(226, "Unit Types");
        TreeItem<TreeItemClass> chargeItems = TreeItemClass.generateTreeItem(229, "Tenant Charge Items");
        this.addToTree(properties, landlords);
        this.addToTree(properties, propertyList);
        this.addToTree(properties, activeTenants);
        this.addToTree(properties, formerTenants);
        this.addToTree(properties, unitTypes);
        this.addToTree(properties, chargeItems);
        this.addToTree(properties, tenantInvoices);
        this.addToTree(properties, postedTenantInvoices);
        this.addToTree(properties, tenantReceipts);
        this.addToTree(properties, postedTenantReceipts);
        this.addToTree(properties, landlordDisbursements);
        this.addToTree(properties, postedLandlordDisbursements);
        this.addToTree(properties, waterReadings);
        this.addToTree(properties, invoicedWaterReadings);
        TreeItem<TreeItemClass> hrNpayroll = TreeItemClass.generateTreeItem(148, "HR and Payroll");
        hrNpayroll.setGraphic((Node)hrIcon);
        TreeItem<TreeItemClass> hr = TreeItemClass.generateTreeItem(149, "HR");
        TreeItem<TreeItemClass> employeeList = TreeItemClass.generateTreeItem(151, "Employees List");
        TreeItem<TreeItemClass> pastEmployees = TreeItemClass.generateTreeItem(152, "Former Employees");
        TreeItem<TreeItemClass> payroll = TreeItemClass.generateTreeItem(150, "Payroll");
        TreeItem<TreeItemClass> departments = TreeItemClass.generateTreeItem(153, "Departments");
        TreeItem<TreeItemClass> leaveManagement = TreeItemClass.generateTreeItem(155, "Leave Management");
        TreeItem<TreeItemClass> leaveApplication = TreeItemClass.generateTreeItem(156, "Leave Applications");
        TreeItem<TreeItemClass> postedApplication = TreeItemClass.generateTreeItem(157, "Posted Leave Applications");
        TreeItem<TreeItemClass> reversedApplication = TreeItemClass.generateTreeItem(158, "Reversed Leave Applications");
        TreeItem<TreeItemClass> leaveAllocation = TreeItemClass.generateTreeItem(160, "Leave Allocation");
        TreeItem<TreeItemClass> publicHoliday = TreeItemClass.generateTreeItem(161, "Public Holidays");
        TreeItem<TreeItemClass> leaveTypes = TreeItemClass.generateTreeItem(162, "Leave Types");
        this.addToTree(leaveManagement, leaveApplication);
        this.addToTree(leaveManagement, postedApplication);
        this.addToTree(leaveManagement, reversedApplication);
        this.addToTree(leaveManagement, leaveAllocation);
        this.addToTree(leaveManagement, publicHoliday);
        this.addToTree(leaveManagement, leaveTypes);
        this.addToTree(hr, employeeList);
        this.addToTree(hr, pastEmployees);
        this.addToTree(hr, departments);
        this.addToTree(hr, leaveManagement);
        TreeItem<TreeItemClass> payrollEmployees = TreeItemClass.generateTreeItem(163, "Payroll Employees");
        TreeItem<TreeItemClass> suspendedEmployees = TreeItemClass.generateTreeItem(1217, "Suspended Employees");
        TreeItem<TreeItemClass> processPayroll = TreeItemClass.generateTreeItem(164, "Process Payroll");
        TreeItem<TreeItemClass> postedPayroll = TreeItemClass.generateTreeItem(165, "Posted Payroll");
        TreeItem<TreeItemClass> allowancesSetup = TreeItemClass.generateTreeItem(166, "Allowances Setup");
        TreeItem<TreeItemClass> deductionsSetup = TreeItemClass.generateTreeItem(167, "Deductions Setup");
        TreeItem<TreeItemClass> taxBrackets = TreeItemClass.generateTreeItem(168, "Tax Brackets");
        TreeItem<TreeItemClass> nhifRates = TreeItemClass.generateTreeItem(169, "NHIF Rates");
        TreeItem<TreeItemClass> salaryAdvance = TreeItemClass.generateTreeItem(170, "Salary Advance");
        TreeItem<TreeItemClass> newSalaryAdvance = TreeItemClass.generateTreeItem(171, "New Salary Advance");
        TreeItem<TreeItemClass> postedSalaryAdvance = TreeItemClass.generateTreeItem(172, "Posted Salary Advance");
        TreeItem<TreeItemClass> reversedSalaryAdvance = TreeItemClass.generateTreeItem(173, "Reversed Salary Advance");
        this.addToTree(salaryAdvance, newSalaryAdvance);
        this.addToTree(salaryAdvance, postedSalaryAdvance);
        this.addToTree(salaryAdvance, reversedSalaryAdvance);
        TreeItem<TreeItemClass> staffLoans = TreeItemClass.generateTreeItem(174, "Staff Loans");
        TreeItem<TreeItemClass> newStaffLoans = TreeItemClass.generateTreeItem(175, "New Staff Loans");
        TreeItem<TreeItemClass> postedStaffLoans = TreeItemClass.generateTreeItem(176, "Posted Staff Loans");
        TreeItem<TreeItemClass> clearedStaffLoans = TreeItemClass.generateTreeItem(177, "Cleared Staff Loans");
        TreeItem<TreeItemClass> reversedStaffLoans = TreeItemClass.generateTreeItem(178, "Reversed Staff Loans");
        this.addToTree(staffLoans, newStaffLoans);
        this.addToTree(staffLoans, postedStaffLoans);
        this.addToTree(staffLoans, clearedStaffLoans);
        this.addToTree(staffLoans, reversedStaffLoans);
        TreeItem<TreeItemClass> payrollSetups = TreeItemClass.generateTreeItem(179, "Payroll Setups");
        this.addToTree(payroll, payrollEmployees);
        this.addToTree(payroll, suspendedEmployees);
        this.addToTree(payroll, processPayroll);
        this.addToTree(payroll, postedPayroll);
        this.addToTree(payroll, allowancesSetup);
        this.addToTree(payroll, deductionsSetup);
        this.addToTree(payroll, taxBrackets);
        this.addToTree(payroll, nhifRates);
        this.addToTree(payroll, salaryAdvance);
        this.addToTree(payroll, staffLoans);
        this.addToTree(payroll, payrollSetups);
        this.addToTree(hrNpayroll, hr);
        this.addToTree(hrNpayroll, payroll);
        this.addToTree(kuzaErp, hrNpayroll);
        TreeItem<TreeItemClass> sms = TreeItemClass.generateTreeItem(180, "SMS");
        sms.setGraphic((Node)smsIcon);
        TreeItem<TreeItemClass> newSms = TreeItemClass.generateTreeItem(181, "Messages");
        TreeItem<TreeItemClass> sent = TreeItemClass.generateTreeItem(182, "Sent Messages");
        TreeItem<TreeItemClass> outbox = TreeItemClass.generateTreeItem(183, "Message Outbox");
        TreeItem<TreeItemClass> contacts = TreeItemClass.generateTreeItem(184, "Contacts");
        TreeItem<TreeItemClass> groups = TreeItemClass.generateTreeItem(185, "Groups");
        TreeItem<TreeItemClass> systemsMsgs = TreeItemClass.generateTreeItem(186, "System Messages");
        this.addToTree(sms, newSms);
        this.addToTree(sms, sent);
        this.addToTree(sms, contacts);
        this.addToTree(sms, groups);
        this.addToTree(kuzaErp, sms);
        TreeItem<TreeItemClass> treeItem = TreeItemClass.generateTreeItem(187, "IT Administration");
        TreeItem<TreeItemClass> treeItem2 = TreeItemClass.generateTreeItem(187, "E-TIMS");
        TreeItem<TreeItemClass> treeItem3 = TreeItemClass.generateTreeItem(189, "Number Series");
        this.addToTree((TreeItem)itAdministration, (TreeItem<TreeItemClass>)numberSeries);
        TreeItem<TreeItemClass> treeItem4 = TreeItemClass.generateTreeItem(188, "Users");
        TreeItem<TreeItemClass> treeItem5 = TreeItemClass.generateTreeItem(224, "Users Roles");
        TreeItem<TreeItemClass> treeItem6 = TreeItemClass.generateTreeItem(2240, "Communication Channels");
        this.addToTree((TreeItem)itAdministration, (TreeItem<TreeItemClass>)users);
        this.addToTree((TreeItem)itAdministration, (TreeItem<TreeItemClass>)usersRoles);
        this.addToTree((TreeItem)itAdministration, (TreeItem<TreeItemClass>)communicationChannels);
        this.addToTree(kuzaErp, (TreeItem<TreeItemClass>)itAdministration);
        if (Config.eTIMSIntegration) {
            void etims;
            this.addToTree(kuzaErp, (TreeItem<TreeItemClass>)etims);
        }
        TreeItem<TreeItemClass> treeItem7 = TreeItemClass.generateTreeItem(190, "CRM");
        TreeItem<TreeItemClass> treeItem8 = TreeItemClass.generateTreeItem(191, "Settings");
        this.tree = new TreeView(kuzaErp);
        this.tree.setMinHeight(651.0);
        VBox vBox = new VBox();
        vbox.getChildren().add(this.tree);
        vbox.setMinWidth(232.0);
        this.tree.prefHeightProperty().bind((ObservableValue)vbox.heightProperty());
        this.tree.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            TreeItemClass selection = (TreeItemClass)newValue.getValue();
            String nValue = selection.getDescription();
            int selectionCode = selection.getId();
            System.out.println(nValue);
            this.openContent(nValue, selectionCode);
        });
        return vbox;
    }

    public void addToTree(TreeItem tree, TreeItem<TreeItemClass> item) {
        String id = "0";
        if (this.getUser().getUserName().equalsIgnoreCase("victor")) {
            tree.getChildren().add(item);
            return;
        }
        try {
            HashMap<String, Object> matrixDetails = this.getUser().getMatrixDetails();
            id = ((TreeItemClass)item.getValue()).getId() + "";
            String value = matrixDetails.get(id).toString();
            if (value.equalsIgnoreCase("1")) {
                tree.getChildren().add(item);
            } else {
                System.out.println("No permission to view " + ((TreeItemClass)item.getValue()).getDescription());
            }
        }
        catch (Exception y) {
            System.out.println("No permission for " + id + " Item name is " + ((TreeItemClass)item.getValue()).getDescription());
        }
    }

    /*
     * Opcode count of 23989 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public void openContent(String value, int selectionCode) {
        TreeItem model = BreadCrumbBar.buildTreeModel((Object[])new String[]{Config.shortName, value});
        this.breadCrumbBar.setSelectedCrumb(model);
        if (value.equalsIgnoreCase("All Members List")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/allMembers.fxml").openStream());
                AllMembersController controller = (AllMembersController)loader.getController();
                controller.setUser(this.getUser());
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setParams(params);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Inactive Members")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/allMembers.fxml").openStream());
                AllMembersController controller = (AllMembersController)loader.getController();
                controller.setUser(this.getUser());
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("inactive", 1);
                controller.setParams(params);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Exited Members")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/allMembers.fxml").openStream());
                AllMembersController controller = (AllMembersController)loader.getController();
                controller.setUser(this.getUser());
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("exited", 1);
                controller.setParams(params);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("All Vehicles")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/allVehicles.fxml").openStream());
                AllVehiclesController controller = (AllVehiclesController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Unposted Savings Withdrawals")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/cashWithdrawals.fxml").openStream());
                CashWithdrawalsController controller = (CashWithdrawalsController)loader.getController();
                controller.setPosted(false);
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Reversed Savings Withdrawals")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/cashWithdrawals.fxml").openStream());
                CashWithdrawalsController controller = (CashWithdrawalsController)loader.getController();
                controller.setUser(this.getUser());
                controller.setPosted(true);
                controller.setReversed(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Savings Withdrawals")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/cashWithdrawals.fxml").openStream());
                CashWithdrawalsController controller = (CashWithdrawalsController)loader.getController();
                controller.setUser(this.getUser());
                controller.setPosted(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Transfer Funds")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(TransferFunds[].class);
                controller.setSearchPromptText("Search by Transfer no, Transfer date, Member to transfer from,Member to transfer to or amount");
                Type listType = new TypeToken<ArrayList<TransferFunds>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Transfer No", "transferNo", 0.08);
                controller.addTableColumn("Transfer From", "transferFrom", 0.24);
                controller.addTableColumn("Transfer Account", "fromAccount", 0.16);
                controller.addTableColumn("Recipient", "transferTo", 0.24);
                controller.addTableColumn("Recipient Account", "toAccount", 0.16);
                controller.addTableColumn("Transfer Amount", "amountString", 0.1);
                controller.setDataUrl("masterfetch?type=getfundstransfer");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Transfer");
                controller.setEditRecordText("Edit Transfer");
                controller.setDeleteRecordText("Delete Transfer");
                controller.setType("transferfunds");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Transfer Funds")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(TransferFunds[].class);
                controller.setSearchPromptText("Search by Transfer no, Transfer date, Member to transfer from,Member to transfer to or amount");
                Type listType = new TypeToken<ArrayList<TransferFunds>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Transfer No", "transferNo", 0.08);
                controller.addTableColumn("Transfer From", "transferFrom", 0.24);
                controller.addTableColumn("Transfer Account", "fromAccount", 0.16);
                controller.addTableColumn("Recipient", "transferTo", 0.24);
                controller.addTableColumn("Recipient Account", "toAccount", 0.16);
                controller.addTableColumn("Transfer Amount", "amountString", 0.1);
                controller.setDataUrl("masterfetch?type=getfundstransfer");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Transfer");
                controller.setEditRecordText("Edit Transfer");
                controller.setDeleteRecordText("Delete Transfer");
                controller.setType("transferfunds");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Transfer Funds")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(TransferFunds[].class);
                controller.setSearchPromptText("Search by Transfer no, Transfer date, Member to transfer from,Member to transfer to or amount");
                Type listType = new TypeToken<ArrayList<TransferFunds>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Transfer No", "transferNo", 0.08);
                controller.addTableColumn("Transfer From", "transferFrom", 0.24);
                controller.addTableColumn("Transfer Account", "fromAccount", 0.16);
                controller.addTableColumn("Recipient", "transferTo", 0.24);
                controller.addTableColumn("Recipient Account", "toAccount", 0.16);
                controller.addTableColumn("Transfer Amount", "amountString", 0.1);
                controller.setDataUrl("masterfetch?type=getfundstransfer");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Transfer");
                controller.setEditRecordText("Edit Transfer");
                controller.setDeleteRecordText("Delete Transfer");
                controller.setType("transferfunds");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Vehicle Transfer")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(TransferVehicle[].class);
                controller.setSearchPromptText("Search by Transfer no, Transfer date, Owner to transfer from,Owner to transfer to, Vehicle Reg No or amount");
                Type listType = new TypeToken<ArrayList<TransferVehicle>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Transfer No", "transferNo", 0.08);
                controller.addTableColumn("Transfer Date", "transferDate", 0.2);
                controller.addTableColumn("Previous Owner", "previousOwner", 0.25);
                controller.addTableColumn("Vehicle", "vehicle", 0.2);
                controller.addTableColumn("New Owner", "newOwner", 0.25);
                controller.setDataUrl("masterfetch?type=getvehicletransfer");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Transfer");
                controller.setEditRecordText("Edit Transfer");
                controller.setDeleteRecordText("Delete Transfer");
                controller.setType("transfervehicle");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Vehicle Transfer")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(TransferVehicle[].class);
                controller.setSearchPromptText("Search by Transfer no, Transfer date, Owner to transfer from,Owner to transfer to, Vehicle Reg No or amount");
                Type listType = new TypeToken<ArrayList<TransferVehicle>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Transfer No", "transferNo", 0.08);
                controller.addTableColumn("Transfer Date", "transferDate", 0.2);
                controller.addTableColumn("Previous Owner", "previousOwner", 0.25);
                controller.addTableColumn("Vehicle", "vehicle", 0.2);
                controller.addTableColumn("New Owner", "newOwner", 0.25);
                controller.setDataUrl("masterfetch?type=getvehicletransfer");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Transfer");
                controller.setEditRecordText("Edit Transfer");
                controller.setDeleteRecordText("Delete Transfer");
                controller.setType("transfervehicle");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Vehicle Exit")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(VehicleExit[].class);
                controller.setSearchPromptText("Search by Exit no, Exit date, Owner, Vehicle Reg No or Receiving Bank");
                Type listType = new TypeToken<ArrayList<VehicleExit>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Exit No", "exitNumber", 0.08);
                controller.addTableColumn("Exit Date", "exitDate", 0.24);
                controller.addTableColumn("Owner", "owner", 0.39);
                controller.addTableColumn("Vehicle", "vehicle", 0.24);
                controller.setDataUrl("masterfetch?type=getvehicleexit");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Vehicle Exit");
                controller.setEditRecordText("Edit Vehicle Exit");
                controller.setDeleteRecordText("Delete Vehicle Exit");
                controller.setType("vehicleexit");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Bank Reconciliation")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(VehicleExit[].class);
                controller.setSearchPromptText("Rec No, Bank, From Date, To Date");
                Type listType = new TypeToken<ArrayList<VehicleExit>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Rec No", "recNo", 0.08);
                controller.addTableColumn("Bank", "bank", 0.24);
                controller.addTableColumn("From Date", "fromDate", 0.39);
                controller.addTableColumn("To Date", "toDate", 0.24);
                controller.setDataUrl("masterfetch?type=bankrec");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Reconciliation");
                controller.setEditRecordText("Edit Reconciliation");
                controller.setDeleteRecordText("Delete Reconciliation");
                controller.setType("bankreconciliation");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Bank Balances")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Bank.BankBalance[].class);
                controller.setSearchPromptText("Voucher No, Bank, Date, Balance");
                Type listType = new TypeToken<ArrayList<Bank.BankBalance>>(){}.getType();
                controller.showDatesFilters(7);
                controller.setListType(listType);
                controller.addTableColumn("Id", "id", 0.08);
                controller.addTableColumn("Bank", "bank", 0.3);
                controller.addTableColumn("Balance Date", "date", 0.15);
                controller.addTableColumn("Balance", "balanceString", 0.15);
                controller.setDataUrl("masterfetch?type=bank_balances");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Balance");
                controller.setEditRecordText("Edit Balance");
                controller.setDeleteRecordText("Delete Balance");
                controller.setType("bank_balance");
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("Bank Discrepancy");
                controller.addNonRecordButton(voucher, "bank_discrepancy");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Bank Loans")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Account.class);
                controller.setSearchPromptText("Account No, Name, Balance");
                Type listType = new TypeToken<ArrayList<Account>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Account No", "accountNumber", 0.08);
                controller.addTableColumn("Account Name", "accountName", 0.3);
                controller.addTableColumn("Current Balance", "balanceString", 0.15);
                controller.setDataUrl("masterfetch?type=glaccounts");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("accountType", 1);
                params.put("accountCategory", 2);
                params.put("accountSubCategory", 5);
                params.put("accountGroup", 12);
                controller.setDataParams(params);
                controller.setNewRecordText("New Loan Account");
                controller.setEditRecordText("View Entries");
                controller.setDeleteRecordText("Delete Entries");
                controller.setType("bank_loan");
                JFXButton repay = new JFXButton("Repay Loan");
                FontAwesomeIconView floorsView = new FontAwesomeIconView();
                floorsView.setStyle("-fx-fill: BLUE;");
                floorsView.setSize("24.0");
                floorsView.setIcon((Enum)FontAwesomeIcon.DOLLAR);
                repay.setGraphic((Node)floorsView);
                repay.setContentDisplay(ContentDisplay.TOP);
                controller.addRecordActionButton(repay, "repay_loan");
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("Loan Statement");
                controller.addRecordButton(voucher, "gl_account_statement");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Member Exits")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(MemberExit[].class);
                controller.setSearchPromptText("Search by Exit no, Exit date,Member, Refundable Contributions");
                Type listType = new TypeToken<ArrayList<MemberExit>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Exit No", "exitNo", 0.08);
                controller.addTableColumn("Exit Date", "exitDate", 0.24);
                controller.addTableColumn("Member", "member", 0.39);
                controller.addTableColumn("Refundable Contributions", "refundableContributionsString", 0.24);
                controller.setDataUrl("masterfetch?type=getmemberexit");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Member Exit");
                controller.setEditRecordText("Edit Member Exit");
                controller.setDeleteRecordText("Delete Member Exit");
                controller.setType("memberexit");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                JFXButton masterRoll = new JFXButton("Member Exit Form");
                masterRoll.setGraphic((Node)Config.getPDFIcon());
                masterRoll.setContentDisplay(ContentDisplay.TOP);
                masterRoll.setStyle("-fx-background-color: transparent;");
                LinkedHashMap<String, String> reportVariables = new LinkedHashMap<String, String>();
                reportVariables.put("saccoName", Config.saccoName);
                controller.addRecordButton(masterRoll, "Member Exit Form");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Member Exits")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(MemberExit[].class);
                controller.setSearchPromptText("Search by Exit no, Exit date,Member, Refundable Contributions");
                Type listType = new TypeToken<ArrayList<MemberExit>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Exit No", "exitNo", 0.08);
                controller.addTableColumn("Exit Date", "exitDate", 0.24);
                controller.addTableColumn("Member", "member", 0.39);
                controller.addTableColumn("Refundable Contributions", "refundableContributionsString", 0.24);
                controller.setDataUrl("masterfetch?type=getmemberexit");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Member Exit");
                controller.setEditRecordText("Edit Member Exit");
                controller.setDeleteRecordText("Delete Member Exit");
                controller.setType("memberexit");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                JFXButton masterRoll = new JFXButton("Member Exit Form");
                masterRoll.setGraphic((Node)Config.getPDFIcon());
                masterRoll.setContentDisplay(ContentDisplay.TOP);
                masterRoll.setStyle("-fx-background-color: transparent;");
                LinkedHashMap<String, String> reportVariables = new LinkedHashMap<String, String>();
                reportVariables.put("saccoName", Config.saccoName);
                controller.addRecordButton(masterRoll, "Member Exit Form");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Vehicle Exit")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(VehicleExit[].class);
                controller.setSearchPromptText("Search by Exit no, Exit date, Owner, Vehicle Reg No or Receiving Bank");
                Type listType = new TypeToken<ArrayList<VehicleExit>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Exit No", "exitNumber", 0.08);
                controller.addTableColumn("Exit Date", "exitDate", 0.24);
                controller.addTableColumn("Owner", "owner", 0.39);
                controller.addTableColumn("Vehicle", "vehicle", 0.24);
                controller.setDataUrl("masterfetch?type=getvehicleexit");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Vehicle Exit");
                controller.setEditRecordText("Edit Vehicle Exit");
                controller.setDeleteRecordText("Delete Vehicle Exit");
                controller.setType("vehicleexit");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Exited Vehicles")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Vehicle[].class);
                controller.setSearchPromptText("Search by Vehicle Reg No, Fleet Number, Alias or owner name");
                Type listType = new TypeToken<ArrayList<Vehicle>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Vehicle Reg No", "regNo", 0.14);
                controller.addTableColumn("Fleet Number", "fleetNumber", 0.09);
                controller.addTableColumn("Make", "make", 0.13);
                controller.addTableColumn("Model", "model", 0.12);
                controller.addTableColumn("Name(alias)", "name", 0.16);
                controller.addTableColumn("Owner", "owner", 0.23);
                controller.addTableColumn("Service Arrears", "serviceArrearsString", 0.12);
                controller.setDataUrl("masterfetch?type=vehicles");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("exited", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Vehicle");
                controller.setEditRecordText("Edit Vehicle");
                controller.setDeleteRecordText("Delete Vehicle");
                controller.setType("vehicles");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Inactive Vehicles")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Vehicle[].class);
                controller.setSearchPromptText("Search by Vehicle Reg No, Fleet Number, Alias or owner name");
                Type listType = new TypeToken<ArrayList<Vehicle>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Vehicle Reg No", "regNo", 0.14);
                controller.addTableColumn("Fleet Number", "fleetNumber", 0.09);
                controller.addTableColumn("Make", "make", 0.13);
                controller.addTableColumn("Model", "model", 0.12);
                controller.addTableColumn("Name(alias)", "name", 0.16);
                controller.addTableColumn("Owner", "owner", 0.23);
                controller.addTableColumn("Service Arrears", "serviceArrearsString", 0.12);
                controller.setDataUrl("masterfetch?type=vehicles");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("active", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Vehicle");
                controller.setEditRecordText("Edit Vehicle");
                controller.setDeleteRecordText("Delete Vehicle");
                controller.setType("vehicles");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("All Drivers and Conductors")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(DriverConductor[].class);
                controller.setSearchPromptText("Search by Employee no, Name, Email, Phone, Employer or Vehicle Reg No");
                Type listType = new TypeToken<ArrayList<DriverConductor>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Employee No", "employeeNo", 0.08);
                controller.addTableColumn("Name", "name", 0.2);
                controller.addTableColumn("Id No", "idNo", 0.12);
                controller.addTableColumn("Phone No", "phoneNo", 0.1);
                controller.addTableColumn("Position", "position", 0.1);
                controller.addTableColumn("Employer", "employer", 0.25);
                controller.addTableColumn("Vehicle", "vehicle", 0.14);
                controller.setDataUrl("masterfetch?type=driverconductor");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Employee");
                controller.setEditRecordText("Edit Employee");
                controller.setDeleteRecordText("Delete Employee");
                controller.setType("driverconductor");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Badge Applications")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(EmployeeBadge[].class);
                controller.setSearchPromptText("Search by Application no, Employee Name, Email, Phone, Employer or Vehicle Reg No");
                Type listType = new TypeToken<ArrayList<EmployeeBadge>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Application No", "applicationNo", 0.1);
                controller.addTableColumn("Employee", "employee", 0.2);
                controller.addTableColumn("Application Date", "applicationDate", 0.12);
                controller.addTableColumn("Phone No", "phoneNo", 0.1);
                controller.addTableColumn("Position", "position", 0.1);
                controller.addTableColumn("Employer", "employer", 0.23);
                controller.addTableColumn("Vehicle", "vehicle", 0.14);
                controller.addTableColumn("Vehicle", "vehicle", 0.14);
                controller.setDataUrl("masterfetch?type=badgeapplication");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("applied", 0);
                params.put("received", 0);
                params.put("issued", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Application");
                controller.setEditRecordText("Edit Application");
                controller.setDeleteRecordText("Delete Application");
                controller.setType("badgeapplication");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Applied Badges")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(EmployeeBadge[].class);
                controller.setSearchPromptText("Search by Application no, Employee Name, Email, Phone, Employer or Vehicle Reg No");
                Type listType = new TypeToken<ArrayList<EmployeeBadge>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Application No", "applicationNo", 0.1);
                controller.addTableColumn("Employee", "employee", 0.2);
                controller.addTableColumn("Application Date", "applicationDate", 0.12);
                controller.addTableColumn("Phone No", "phoneNo", 0.1);
                controller.addTableColumn("Position", "position", 0.1);
                controller.addTableColumn("Employer", "employer", 0.23);
                controller.addTableColumn("Vehicle", "vehicle", 0.14);
                controller.addTableColumn("Vehicle", "vehicle", 0.14);
                controller.setDataUrl("masterfetch?type=badgeapplication");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("applied", 1);
                params.put("received", 0);
                params.put("issued", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Application");
                controller.setEditRecordText("Edit Application");
                controller.setDeleteRecordText("Delete Application");
                controller.setType("badgeapplication");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Badge to Collect")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(EmployeeBadge[].class);
                controller.setSearchPromptText("Search by Application no, Employee Name, Email, Phone, Employer or Vehicle Reg No");
                Type listType = new TypeToken<ArrayList<EmployeeBadge>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Application No", "applicationNo", 0.1);
                controller.addTableColumn("Employee", "employee", 0.2);
                controller.addTableColumn("Application Date", "applicationDate", 0.12);
                controller.addTableColumn("Phone No", "phoneNo", 0.1);
                controller.addTableColumn("Position", "position", 0.1);
                controller.addTableColumn("Employer", "employer", 0.23);
                controller.addTableColumn("Vehicle", "vehicle", 0.14);
                controller.addTableColumn("Vehicle", "vehicle", 0.14);
                controller.setDataUrl("masterfetch?type=badgeapplication");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("applied", 1);
                params.put("received", 1);
                params.put("issued", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Application");
                controller.setEditRecordText("Edit Application");
                controller.setDeleteRecordText("Delete Application");
                controller.setType("badgeapplication");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Collected Badges")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(EmployeeBadge[].class);
                controller.setSearchPromptText("Search by Application no, Employee Name, Email, Phone, Employer or Vehicle Reg No");
                Type listType = new TypeToken<ArrayList<EmployeeBadge>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Application No", "applicationNo", 0.1);
                controller.addTableColumn("Employee", "employee", 0.2);
                controller.addTableColumn("Application Date", "applicationDate", 0.12);
                controller.addTableColumn("Phone No", "phoneNo", 0.1);
                controller.addTableColumn("Position", "position", 0.1);
                controller.addTableColumn("Employer", "employer", 0.23);
                controller.addTableColumn("Vehicle", "vehicle", 0.14);
                controller.addTableColumn("Vehicle", "vehicle", 0.14);
                controller.setDataUrl("masterfetch?type=badgeapplication");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("applied", 1);
                params.put("received", 1);
                params.put("issued", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Application");
                controller.setEditRecordText("Edit Application");
                controller.setDeleteRecordText("Delete Application");
                controller.setType("badgeapplication");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Loan Recovery")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(RecoverLoan[].class);
                controller.setSearchPromptText("Search by Application no, Employee Name, Email, Phone, Employer or Vehicle Reg No");
                Type listType = new TypeToken<ArrayList<RecoverLoan>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Recovery No", "recoveryNo", 0.1);
                controller.addTableColumn("Recovery Date", "recoveryDate", 0.12);
                controller.addTableColumn("Member", "member", 0.25);
                controller.addTableColumn("Loan No", "loanNumber", 0.1);
                controller.addTableColumn("Amount Issued", "amountIssued", 0.23);
                controller.addTableColumn("Total Recovered", "totalAmountString", 0.14);
                controller.setDataUrl("masterfetch?type=loanrecovered");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Recovery");
                controller.setEditRecordText("Edit Recovery");
                controller.setDeleteRecordText("Delete Recovery");
                controller.setType("loanrecovered");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Loan Recovery")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(RecoverLoan[].class);
                controller.setSearchPromptText("Search by Application no, Employee Name, Email, Phone, Employer or Vehicle Reg No");
                Type listType = new TypeToken<ArrayList<RecoverLoan>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Recovery No", "recoveryNo", 0.1);
                controller.addTableColumn("Recovery Date", "recoveryDate", 0.12);
                controller.addTableColumn("Member", "member", 0.25);
                controller.addTableColumn("Loan No", "loanNumber", 0.1);
                controller.addTableColumn("Amount Issued", "amountIssued", 0.23);
                controller.addTableColumn("Total Recovered", "totalAmountString", 0.14);
                controller.setDataUrl("masterfetch?type=loanrecovered");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Recovery");
                controller.setEditRecordText("Edit Recovery");
                controller.setDeleteRecordText("Delete Recovery");
                controller.setType("loanrecovered");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Member Setups")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/memberSetups.fxml").openStream());
                MemberSetupController controller = (MemberSetupController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Vehicle Setups")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/vehicleSetups.fxml").openStream());
                VehicleSetupsController controller = (VehicleSetupsController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Vehicle Brands")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(VehicleBrands[].class);
                controller.setSearchPromptText("Search by Brand Id, Brand name, Monthly Service Fee, daily Service Fee, No of Vehicles");
                Type listType = new TypeToken<ArrayList<VehicleBrands>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Brand Id", "brandId", 0.1);
                controller.addTableColumn("Brand Name", "brandName", 0.3);
                controller.addTableColumn("Monthly Service Fee", "monthlyServiceFeeString", 0.2);
                controller.addTableColumn("Daily Service Fee", "dailyServiceFeeString", 0.2);
                controller.addTableColumn("No of Vehicles", "noOfVehicles", 0.18);
                controller.setDataUrl("masterfetch?type=vehiclebrands");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Brand");
                controller.setEditRecordText("Edit Brand");
                controller.setDeleteRecordText("Delete Brand");
                controller.setType("vehiclebrands");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("All Customers")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Customer[].class);
                controller.setSearchPromptText("Search by name, Id No, Phone No, Sales Person ");
                Type listType = new TypeToken<ArrayList<Customer>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Customer No", "customerNumber", 0.09);
                controller.addTableColumn("Customer Name", "customerName", 0.2);
                controller.addTableColumn("Phone No.", "customerPhone", 0.1);
                controller.addTableColumn("Email", "customerEmail", 0.1);
                controller.addTableColumn("KRA PIN", "kraPin", 0.12);
                controller.addTableColumn("Sales Person", "salesRep", 0.16);
                controller.addTableColumn("Region", "region", 0.12);
                controller.addTableColumn("Balance", "balanceString", 0.1);
                controller.setDataUrl("masterfetch?type=customer");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("customerType", "General Customer");
                controller.setType("customer");
                controller.setDataParams(params);
                controller.setNewRecordText("New Customer");
                controller.setEditRecordText("Edit Customer");
                controller.setDeleteRecordText("Delete Customer");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setModality(Modality.WINDOW_MODAL);
                controller.setNewRecordResizable(true);
                controller.allowExcelImport();
                if (Config.showDMSNo) {
                    JFXButton dmsSales = Config.getDefaultReportButton();
                    dmsSales.setText("All EABL Sales");
                    controller.addNonRecordButton(dmsSales, "dms_sales");
                    JFXButton dmsProducts = Config.getDefaultReportButton();
                    dmsProducts.setText("EABL Products");
                    controller.addRecordButton(dmsProducts, "dms_products");
                }
                JFXButton allCustomers = Config.getDefaultReportButton();
                allCustomers.setText("All Customers");
                controller.addNonRecordButton(allCustomers, "allcustomers");
                JFXButton statementReport = Config.getDefaultReportButton();
                statementReport.setText("Customer Statement");
                controller.addRecordButton(statementReport, "customerstatement");
                JFXButton customerStatementProducts = Config.getDefaultReportButton();
                customerStatementProducts.setText("Customer Statement Products");
                controller.addRecordButton(customerStatementProducts, "customer_statement_products");
                JFXButton salesPersonReport = Config.getDefaultReportButton();
                salesPersonReport.setText("Sales Person Report");
                controller.addNonRecordButton(salesPersonReport, "sales_person_report");
                JFXButton importTransactions = Config.getDefaultReportButton();
                importTransactions.setText("Import Transactions");
                JFXButton importExpenses = Config.getDefaultReportButton();
                importExpenses.setText("Import Expenses");
                JFXButton importQB = Config.getDefaultReportButton();
                importQB.setText("Import Quick Books");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Active Tenants")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Customer[].class);
                controller.setSearchPromptText("Search by name, Id No, Phone No, Gender ");
                Type listType = new TypeToken<ArrayList<Customer>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Tenant No", "customerNumber", 0.1);
                controller.addTableColumn("Tenant Name", "customerName", 0.2);
                controller.addTableColumn("Phone No.", "customerPhone", 0.15);
                controller.addTableColumn("Customer Id", "customerId", 0.15);
                controller.addTableColumn("Email", "customerEmail", 0.15);
                controller.addTableColumn("Gender", "gender", 0.075);
                controller.addTableColumn("Property", "property", 0.15);
                controller.addTableColumn("Unit", "unit", 0.075);
                controller.addTableColumn("Balance", "balanceString", 0.1);
                controller.setDataUrl("masterfetch?type=customer");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("customerType", "Tenant");
                params.put("status", "Active");
                controller.setType("tenant");
                controller.setDataParams(params);
                controller.setNewRecordText("New Tenant");
                controller.setEditRecordText("Edit Tenant");
                controller.setDeleteRecordText("Delete Tenant");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setModality(Modality.WINDOW_MODAL);
                controller.setNewRecordResizable(true);
                JFXButton statementReport = Config.getDefaultReportButton();
                statementReport.setText("Tenant Statement");
                controller.addRecordButton(statementReport, "customerstatement");
                JFXButton tenantAgreement = Config.getDefaultReportButton();
                tenantAgreement.setText("Tenant Agreement");
                controller.addRecordButton(tenantAgreement, "tenantagreement");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Landlord Disbursements")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PaymentVoucher[].class);
                controller.setSearchPromptText("Disbursement No, Landlord, Property, Payment Date, Amount");
                Type listType = new TypeToken<ArrayList<Customer>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Voucher No", "pvNo", 0.1);
                controller.addTableColumn("Vendor", "vendor", 0.1);
                controller.addTableColumn("Payment Date", "paymentDate", 0.2);
                controller.addTableColumn("Payment Method", "paymentMethod", 0.15);
                controller.addTableColumn("Amount", "amount", 0.15);
                controller.addTableColumn("Payment Description", "paymentDescription", 0.15);
                controller.addTableColumn("Created On", "createdOn", 0.15);
                controller.setDataUrl("masterfetch?type=paymentvouchers");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setType("landlorddisbursement");
                controller.setDataParams(params);
                controller.setNewRecordText("New Disbursement");
                controller.setEditRecordText("Edit Disbursement");
                controller.setDeleteRecordText("Delete Disbursement");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setModality(Modality.WINDOW_MODAL);
                controller.setNewRecordResizable(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Landlord Disbursements")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Customer[].class);
                controller.setSearchPromptText("Disbursement No, Landlord, Property, Payment Date, Amount");
                Type listType = new TypeToken<ArrayList<Customer>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Tenant No", "customerNumber", 0.1);
                controller.addTableColumn("Tenant Name", "customerName", 0.2);
                controller.addTableColumn("Phone No.", "customerPhone", 0.15);
                controller.addTableColumn("Customer Id", "customerId", 0.15);
                controller.addTableColumn("Email", "customerEmail", 0.15);
                controller.addTableColumn("Gender", "gender", 0.075);
                controller.addTableColumn("Property", "property", 0.15);
                controller.addTableColumn("Unit", "unit", 0.075);
                controller.addTableColumn("Balance", "balanceString", 0.1);
                controller.setDataUrl("masterfetch?type=customer1");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("customerType", "Tenant");
                params.put("status", "Active");
                controller.setType("landlorddisbursement");
                controller.setDataParams(params);
                controller.setNewRecordText("New Disbursement");
                controller.setEditRecordText("Edit Disbursement");
                controller.setDeleteRecordText("Delete Disbursement");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setModality(Modality.WINDOW_MODAL);
                controller.setNewRecordResizable(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Water Readings")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Customer[].class);
                controller.setSearchPromptText("Search by Property, Unit, Last Reading ");
                Type listType = new TypeToken<ArrayList<Customer>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Invoice No", "customerNumber", 0.1);
                controller.addTableColumn("Property", "customerName", 0.3);
                controller.addTableColumn("Unit", "customerPhone", 0.15);
                controller.addTableColumn("Last Reading", "customerEmail", 0.25);
                controller.addTableColumn("Current Reading", "gender", 0.075);
                controller.addTableColumn("Consumption", "balanceString", 0.1);
                controller.addTableColumn("Amount", "balanceString", 0.1);
                controller.setDataUrl("masterfetch?type=waterreading");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("customerType", "Tenant");
                params.put("status", "Active");
                controller.setType("waterreading");
                controller.setDataParams(params);
                controller.setNewRecordText("New Reading");
                controller.setEditRecordText("Edit Reading");
                controller.setDeleteRecordText("Delete Reading");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setModality(Modality.WINDOW_MODAL);
                controller.setNewRecordResizable(true);
                JFXButton statementReport = Config.getDefaultReportButton();
                statementReport.setText("Tenant Statement");
                controller.addRecordButton(statementReport, "customerstatement");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Former Tenants")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Customer[].class);
                controller.setSearchPromptText("Search by name, Id No, Phone No, Gender ");
                Type listType = new TypeToken<ArrayList<Customer>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Tenant No", "customerNumber", 0.1);
                controller.addTableColumn("Tenant Name", "customerName", 0.3);
                controller.addTableColumn("Phone No.", "customerPhone", 0.15);
                controller.addTableColumn("Email", "customerEmail", 0.25);
                controller.addTableColumn("Gender", "gender", 0.075);
                controller.addTableColumn("Balance", "balanceString", 0.1);
                controller.setDataUrl("masterfetch?type=customer");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("customerType", "Tenant");
                params.put("status", "Exited");
                controller.setType("tenant");
                controller.setDataParams(params);
                controller.setNewRecordText("New Tenant");
                controller.setEditRecordText("Edit Tenant");
                controller.setDeleteRecordText("Delete Tenant");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setModality(Modality.WINDOW_MODAL);
                controller.setNewRecordResizable(true);
                JFXButton statementReport = Config.getDefaultReportButton();
                statementReport.setText("Tenant Statement");
                controller.addRecordButton(statementReport, "customerstatement");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Receipting")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/receipting.fxml").openStream());
                ReceiptsController controller = (ReceiptsController)loader.getController();
                controller.setUser(this.user);
                controller.setPosted(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Receipts")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/receipting.fxml").openStream());
                ReceiptsController controller = (ReceiptsController)loader.getController();
                controller.setUser(this.user);
                controller.setPosted(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Reversed Receipts")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/receipting.fxml").openStream());
                ReceiptsController controller = (ReceiptsController)loader.getController();
                controller.setUser(this.user);
                controller.setReversed(true);
                controller.setPosted(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Direct Income")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.user);
                controller.setObject(DirectIncome[].class);
                controller.setSearchPromptText("Search by Voucher no, Income date, Bank, G/l Account, Description or amount");
                Type listType = new TypeToken<ArrayList<DirectIncome>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Voucher No", "voucherNo", 0.08);
                controller.addTableColumn("Income Date", "voucherDate", 0.15);
                controller.addTableColumn("Bank", "bank", 0.2);
                controller.addTableColumn("G/L Account", "glAccount", 0.2);
                controller.addTableColumn("Description", "description", 0.25);
                controller.addTableColumn("Income Amount", "amountString", 0.1);
                controller.setDataUrl("masterfetch?type=directincome");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Voucher");
                controller.setEditRecordText("Edit Voucher");
                controller.setDeleteRecordText("Delete Voucher");
                controller.setType("directincome");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Direct Income")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.user);
                controller.setObject(DirectIncome[].class);
                controller.setSearchPromptText("Search by Voucher no, Income date, Bank, G/l Account, Description or amount");
                Type listType = new TypeToken<ArrayList<DirectIncome>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Voucher No", "voucherNo", 0.08);
                controller.addTableColumn("Income Date", "voucherDate", 0.15);
                controller.addTableColumn("Bank", "bank", 0.2);
                controller.addTableColumn("G/L Account", "glAccount", 0.2);
                controller.addTableColumn("Description", "description", 0.25);
                controller.addTableColumn("Income Amount", "amountString", 0.1);
                controller.setDataUrl("masterfetch?type=directincome");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Voucher");
                controller.setEditRecordText("Edit Voucher");
                controller.setDeleteRecordText("Delete Voucher");
                controller.setType("directincome");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Reversed Direct Income")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.user);
                controller.setObject(DirectIncome[].class);
                controller.setSearchPromptText("Search by Voucher no, Income date, Bank, G/l Account, Description or amount");
                Type listType = new TypeToken<ArrayList<DirectIncome>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Voucher No", "voucherNo", 0.08);
                controller.addTableColumn("Income Date", "voucherDate", 0.15);
                controller.addTableColumn("Bank", "bank", 0.2);
                controller.addTableColumn("G/L Account", "glAccount", 0.2);
                controller.addTableColumn("Description", "description", 0.25);
                controller.addTableColumn("Income Amount", "amountString", 0.1);
                controller.setDataUrl("masterfetch?type=directincome");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Voucher");
                controller.setEditRecordText("Edit Voucher");
                controller.setDeleteRecordText("Delete Voucher");
                controller.setType("directincome");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Chart of Accounts")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/chartOfAccounts.fxml").openStream());
                ChartOfAccountsController controller = (ChartOfAccountsController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Transaction Types")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/transactionTypes.fxml").openStream());
                TransactionTypesController controller = (TransactionTypesController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Banks")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/banks.fxml").openStream());
                BanksController controller = (BanksController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Bank Transfers")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(BankTransfer[].class);
                controller.setSearchPromptText("Search by Transfer no, Transfer date, Bank to transfer from,Bank to transfer to , Description or amount");
                Type listType = new TypeToken<ArrayList<BankTransfer>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Transfer No", "transferNo", 0.08);
                controller.addTableColumn("Transfer Date", "transferDate", 0.1);
                controller.addTableColumn("Transfer From", "fromBank", 0.24);
                controller.addTableColumn("Transfer To", "toBank", 0.24);
                controller.addTableColumn("Description", "description", 0.16);
                controller.addTableColumn("Transfer Amount", "amountString", 0.1);
                controller.setDataUrl("masterfetch?type=banktransfer");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Transfer");
                controller.setEditRecordText("Edit Transfer");
                controller.setDeleteRecordText("Delete Transfer");
                controller.setType("banktransfer");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Bank Transfers")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(BankTransfer[].class);
                controller.setSearchPromptText("Search by Transfer no, Transfer date, Bank to transfer from,Bank to transfer to , Description or amount");
                Type listType = new TypeToken<ArrayList<BankTransfer>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Transfer No", "transferNo", 0.08);
                controller.addTableColumn("Transfer Date", "transferDate", 0.1);
                controller.addTableColumn("Transfer From", "fromBank", 0.24);
                controller.addTableColumn("Transfer To", "toBank", 0.24);
                controller.addTableColumn("Description", "description", 0.16);
                controller.addTableColumn("Transfer Amount", "amountString", 0.1);
                controller.setDataUrl("masterfetch?type=banktransfer");
                controller.showNavigatePosting();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Transfer");
                controller.setEditRecordText("Edit Transfer");
                controller.setDeleteRecordText("Delete Transfer");
                controller.setType("banktransfer");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Reversed Bank Transfers")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(BankTransfer[].class);
                controller.setSearchPromptText("Search by Transfer no, Transfer date, Bank to transfer from,Bank to transfer to , Description or amount");
                Type listType = new TypeToken<ArrayList<BankTransfer>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Transfer No", "transferNo", 0.08);
                controller.addTableColumn("Transfer Date", "transferDate", 0.1);
                controller.addTableColumn("Transfer From", "fromBank", 0.24);
                controller.addTableColumn("Transfer To", "toBank", 0.24);
                controller.addTableColumn("Description", "description", 0.16);
                controller.addTableColumn("Transfer Amount", "amountString", 0.1);
                controller.setDataUrl("masterfetch?type=banktransfer");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Transfer");
                controller.setEditRecordText("Edit Transfer");
                controller.setDeleteRecordText("Delete Transfer");
                controller.setType("banktransfer");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Finance Setups")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/financesetup.fxml").openStream());
                FinanceSetupController controller = (FinanceSetupController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Financial Reports")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/financialreports.fxml").openStream());
                FinancialReportsController controller = (FinancialReportsController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Board Reports")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/board_reports.fxml").openStream());
                BoardReportsController controller = (BoardReportsController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Profit & Loss")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(ProfitNLoss[].class);
                controller.setSearchPromptText("Search by P&L Code or P&L Name");
                Type listType = new TypeToken<ArrayList<ProfitNLoss>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("P&L Code", "code", 0.1);
                controller.addTableColumn("P&L Name", "name", 0.3);
                controller.setDataUrl("masterfetch?type=profitnloss");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New P&L");
                controller.setEditRecordText("Edit P&L");
                controller.setDeleteRecordText("Delete P&L");
                controller.setType("profitnloss");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Balance Sheet")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(BalanceSheet[].class);
                controller.setSearchPromptText("Search by Balance Sheet Code or Balance Sheet Name");
                Type listType = new TypeToken<ArrayList<BalanceSheet>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Balance Sheet Code", "code", 0.2);
                controller.addTableColumn("Balance Sheet Name", "name", 0.4);
                controller.setDataUrl("masterfetch?type=balancesheet");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Balance Sheet");
                controller.setEditRecordText("Edit Balance Sheet");
                controller.setDeleteRecordText("Delete Balance Sheet");
                controller.setType("balancesheet");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Loan Products")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/loanproducts.fxml").openStream());
                LoanProductsController controller = (LoanProductsController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Loans Applications List")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/loansapplicationslist.fxml").openStream());
                LoanApplicationList controller = (LoanApplicationList)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Loans Setups")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/loansetups.fxml").openStream());
                LoanSetupController controller = (LoanSetupController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Loan Register")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/loansregister.fxml").openStream());
                LoansRegister controller = (LoansRegister)loader.getController();
                controller.setUser(this.getUser());
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("issued", 1);
                params.put("cleared", 0);
                controller.setParams(params);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Unserviced Loans")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/loansregister.fxml").openStream());
                LoansRegister controller = (LoansRegister)loader.getController();
                controller.setUser(this.getUser());
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("issued", 1);
                params.put("cleared", 0);
                params.put("unserviced", 0);
                controller.setParams(params);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Cleared Loans")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/loansregister.fxml").openStream());
                LoansRegister controller = (LoansRegister)loader.getController();
                controller.setUser(this.getUser());
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("issued", 1);
                params.put("cleared", 1);
                controller.setParams(params);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Charge Interest")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/interestVouchers.fxml").openStream());
                InterestVouchersController controller = (InterestVouchersController)loader.getController();
                controller.setUser(this.getUser());
                controller.setPosted(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Interest")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/interestVouchers.fxml").openStream());
                InterestVouchersController controller = (InterestVouchersController)loader.getController();
                controller.setUser(this.getUser());
                controller.setPosted(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Charge Penalty")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/penaltyVouchers.fxml").openStream());
                PenaltyVouchersController controller = (PenaltyVouchersController)loader.getController();
                controller.setUser(this.getUser());
                controller.setPosted(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Penalty")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/penaltyVouchers.fxml").openStream());
                PenaltyVouchersController controller = (PenaltyVouchersController)loader.getController();
                controller.setUser(this.getUser());
                controller.setPosted(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Loan Top Up")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(LoanTopup[].class);
                controller.setSearchPromptText("Search by Top up no,  Member, Loan, Bank or amount");
                Type listType = new TypeToken<ArrayList<LoanTopup>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Top up No", "number", 0.1);
                controller.addTableColumn("Top up Date", "date", 0.12);
                controller.addTableColumn("Member", "member", 0.3);
                controller.addTableColumn("Bank", "bank", 0.24);
                controller.addTableColumn("Amount", "amountString", 0.2);
                controller.setDataUrl("masterfetch?type=loantopup");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                params.put("reversed", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Top Up");
                controller.setEditRecordText("Edit Top Up");
                controller.setDeleteRecordText("Delete Top Up");
                controller.setType("loantopup");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Employees List")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Employee[].class);
                controller.setSearchPromptText("Search by Employee Number, Name, Phone Number");
                Type listType = new TypeToken<ArrayList<Employee>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Employee No", "employeeNumber", 0.1);
                controller.addTableColumn("Employee Name", "fullName", 0.25);
                controller.addTableColumn("Phone Number", "phoneNumber", 0.15);
                controller.addTableColumn("Email Address", "email", 0.15);
                controller.addTableColumn("Job Title", "jobTitle", 0.12);
                controller.addTableColumn("Department", "department", 0.12);
                controller.setDataUrl("masterfetch?type=employees");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("exited", 0);
                controller.setType("employee");
                controller.setDataParams(params);
                controller.setNewRecordText("New Employee");
                controller.setEditRecordText("Edit Employee");
                controller.setDeleteRecordText("Delete Employee");
                controller.allowExcelImport();
                JFXButton academic = new JFXButton("Academic Qualifications");
                FontAwesomeIconView academicView = new FontAwesomeIconView();
                academicView.setStyle("-fx-fill: #ff9933;");
                academicView.setSize("24.0");
                academicView.setIcon((Enum)FontAwesomeIcon.GRADUATION_CAP);
                academic.setGraphic((Node)academicView);
                academic.setContentDisplay(ContentDisplay.TOP);
                controller.addRecordActionButton(academic, "academicqualification");
                JFXButton deactivateEmployee = new JFXButton("Terminate Employee");
                FontAwesomeIconView deactivateEmployeeView = new FontAwesomeIconView();
                deactivateEmployeeView.setStyle("-fx-fill: #d32f2f;");
                deactivateEmployeeView.setSize("24.0");
                deactivateEmployeeView.setIcon((Enum)FontAwesomeIcon.HOURGLASS_END);
                deactivateEmployee.setGraphic((Node)deactivateEmployeeView);
                deactivateEmployee.setContentDisplay(ContentDisplay.TOP);
                controller.addRecordActionButton(deactivateEmployee, "deactivateemployee");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton allEmployees = Config.getDefaultReportButton();
                allEmployees.setText("All Employees");
                controller.addNonRecordButton(allEmployees, "allemployees");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Suspended Employees")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Employee[].class);
                controller.setSearchPromptText("Search by Employee Number, Name, Phone Number");
                Type listType = new TypeToken<ArrayList<Employee>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Employee No", "employeeNumber", 0.1);
                controller.addTableColumn("Employee Name", "fullName", 0.25);
                controller.addTableColumn("Phone Number", "phoneNumber", 0.15);
                controller.addTableColumn("Email Address", "email", 0.15);
                controller.addTableColumn("Job Title", "jobTitle", 0.12);
                controller.addTableColumn("Department", "department", 0.12);
                controller.setDataUrl("masterfetch?type=employees");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("exited", 0);
                params.put("suspendPay", 1);
                controller.setType("suspendedemployee");
                controller.setDataParams(params);
                controller.setNewRecordText("New Employee");
                controller.setEditRecordText("Edit Employee");
                controller.setDeleteRecordText("Delete Employee");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Former Employees")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Employee[].class);
                controller.setSearchPromptText("Search by Employee Number, Name, Phone Number");
                Type listType = new TypeToken<ArrayList<Employee>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Employee No", "employeeNumber", 0.1);
                controller.addTableColumn("Employee Name", "fullName", 0.25);
                controller.addTableColumn("Phone Number", "phoneNumber", 0.15);
                controller.addTableColumn("Email Address", "email", 0.15);
                controller.addTableColumn("Job Title", "jobTitle", 0.12);
                controller.addTableColumn("Department", "department", 0.12);
                controller.setDataUrl("masterfetch?type=employees");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("exited", 1);
                controller.setType("employee");
                controller.setDataParams(params);
                controller.setNewRecordText("New");
                controller.setEditRecordText("View Former Employee");
                controller.setDeleteRecordText("Delete");
                JFXButton deactivateEmployee = new JFXButton("Resume Former Employee");
                FontAwesomeIconView deactivateEmployeeView = new FontAwesomeIconView();
                deactivateEmployeeView.setStyle("-fx-fill: #71a436;");
                deactivateEmployeeView.setSize("24.0");
                deactivateEmployeeView.setIcon((Enum)FontAwesomeIcon.HISTORY);
                deactivateEmployee.setGraphic((Node)deactivateEmployeeView);
                deactivateEmployee.setContentDisplay(ContentDisplay.TOP);
                controller.addRecordActionButton(deactivateEmployee, "activateemployee");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Departments")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Department[].class);
                controller.setSearchPromptText("Search by Department Code, Name, H.O.D");
                Type listType = new TypeToken<ArrayList<Department>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Code", "code", 0.15);
                controller.addTableColumn("Name", "departmentName", 0.3);
                controller.addTableColumn("Head of Department", "hod", 0.3);
                controller.setDataUrl("masterfetch?type=departments");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setType("department");
                controller.setDataParams(params);
                controller.setNewRecordText("New Department");
                controller.setEditRecordText("Edit Department");
                controller.setDeleteRecordText("Delete Department");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton allowance = new JFXButton("View Employees");
                FontAwesomeIconView allowanceView = new FontAwesomeIconView();
                allowanceView.setStyle("-fx-fill: #336633;");
                allowanceView.setSize("24.0");
                allowanceView.setIcon((Enum)FontAwesomeIcon.USERS);
                allowance.setGraphic((Node)allowanceView);
                allowance.setContentDisplay(ContentDisplay.TOP);
                controller.addRecordActionButton(allowance, "departmentemployees");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Leave Applications")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(LeaveApplication[].class);
                controller.setSearchPromptText("Search by employee number, name etc");
                Type listType = new TypeToken<ArrayList<LeaveApplication>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Application Id", "id", 0.1);
                controller.addTableColumn("Employee", "employee", 0.15);
                controller.addTableColumn("Reliever", "reliever", 0.15);
                controller.addTableColumn("Leave Type", "leaveType", 0.2);
                controller.addTableColumn("Start Date", "startDate", 0.2);
                controller.addTableColumn("Return Date", "returnDate", 0.2);
                controller.setDataUrl("masterfetch?type=leaveapplications");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("Add Application");
                controller.setEditRecordText("Edit Application");
                controller.setDeleteRecordText("Delete Application");
                controller.setType("leaveapplication");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Leave Applications")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(LeaveApplication[].class);
                controller.setSearchPromptText("Search by employee number, name etc");
                Type listType = new TypeToken<ArrayList<LeaveApplication>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Application Id", "id", 0.1);
                controller.addTableColumn("Employee", "employee", 0.15);
                controller.addTableColumn("Reliever", "reliever", 0.15);
                controller.addTableColumn("Leave Type", "leaveType", 0.2);
                controller.addTableColumn("Start Date", "startDate", 0.2);
                controller.addTableColumn("Return Date", "returnDate", 0.2);
                controller.setDataUrl("masterfetch?type=leaveapplications");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                params.put("posted", 1);
                controller.setNewRecordText("Add Application");
                controller.setEditRecordText("Edit Application");
                controller.setDeleteRecordText("Delete Application");
                controller.setType("leaveapplication");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                controller.addRecordButton(Config.getDefaultReportButton("Report"), "leaveApplications");
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Reversed Leave Applications")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(LeaveApplication[].class);
                controller.setSearchPromptText("Search by employee number, name etc");
                Type listType = new TypeToken<ArrayList<LeaveApplication>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Application Id", "id", 0.1);
                controller.addTableColumn("Employee", "employee", 0.15);
                controller.addTableColumn("Reliever", "reliever", 0.15);
                controller.addTableColumn("Leave Type", "leaveType", 0.2);
                controller.addTableColumn("Start Date", "startDate", 0.2);
                controller.addTableColumn("Return Date", "returnDate", 0.2);
                controller.setDataUrl("masterfetch?type=leaveapplications");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                params.put("posted", 1);
                params.put("reversed", 1);
                controller.setNewRecordText("Add Application");
                controller.setEditRecordText("Edit Application");
                controller.setDeleteRecordText("Delete Application");
                controller.setType("leaveapplication");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Leave Allocation")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(LeaveBalance[].class);
                controller.setSearchPromptText("Search by Employee No, Employee Name, Leave Balance ");
                Type listType = new TypeToken<ArrayList<LeaveBalance>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Employee No", "employeeNo", 0.21);
                controller.addTableColumn("Employee Name", "employee", 0.57);
                controller.addTableColumn("Leave Balance", "balanceHyperLink", 0.19);
                controller.setDataUrl("masterfetch?type=leavebalances");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("Adjust Leave Days");
                controller.setEditRecordText("View Leave Days");
                controller.setDeleteRecordText("Delete");
                controller.setType("leavebalance");
                controller.setNewRecordResizable(false);
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Public Holidays")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PublicHoliday[].class);
                controller.setSearchPromptText("Search by name etc");
                Type listType = new TypeToken<ArrayList<PublicHoliday>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Holiday Id", "id", 0.2);
                controller.addTableColumn("Name", "name", 0.3);
                controller.addTableColumn("Date", "date", 0.3);
                controller.addTableColumn("Annual", "annualBox", 0.2);
                controller.setDataUrl("masterfetch?type=holidays");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("Add Holiday");
                controller.setEditRecordText("Edit Holiday");
                controller.setDeleteRecordText("Delete Holiday");
                controller.setType("publicholiday");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Leave Types")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(LeaveType[].class);
                controller.setSearchPromptText("Search by name ");
                Type listType = new TypeToken<ArrayList<LeaveType>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Id", "no", 0.1);
                controller.addTableColumn("Description", "description", 0.3);
                controller.addTableColumn("Gender", "gender", 0.2);
                controller.addTableColumn("Minimum Days", "minDays", 0.2);
                controller.addTableColumn("Maximum Days", "maxDays", 0.2);
                controller.setDataUrl("masterfetch?type=leavetypes");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("Add Leave Type");
                controller.setEditRecordText("Edit Leave Type");
                controller.setDeleteRecordText("Delete Leave Type");
                controller.setType("leavetype");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Payroll Employees")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Employee[].class);
                controller.setSearchPromptText("Search by Employee Number, Name, Phone Number");
                Type listType = new TypeToken<ArrayList<Employee>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Employee No", "employeeNumber", 0.1);
                controller.addTableColumn("Employee Name", "fullName", 0.25);
                controller.addTableColumn("Phone Number", "phoneNumber", 0.1);
                controller.addTableColumn("Email Address", "email", 0.15);
                controller.addTableColumn("Job Title", "jobTitle", 0.12);
                controller.addTableColumn("Department", "department", 0.12);
                controller.addTableColumn("Basic Salary", "basicSalaryString", 0.12);
                controller.setDataUrl("masterfetch?type=employees");
                controller.allowExcelImport();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("exited", 0);
                params.put("suspendPay", 0);
                controller.setType("payrollemployee");
                controller.setDataParams(params);
                controller.setNewRecordText("New Employee");
                controller.setEditRecordText("Edit Employee");
                controller.setDeleteRecordText("Delete Employee");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton allowance = new JFXButton("Allowances");
                FontAwesomeIconView allowanceView = new FontAwesomeIconView();
                allowanceView.setStyle("-fx-fill: #71a436;");
                allowanceView.setSize("24.0");
                allowanceView.setIcon((Enum)FontAwesomeIcon.PLUS);
                allowance.setGraphic((Node)allowanceView);
                allowance.setContentDisplay(ContentDisplay.TOP);
                controller.addRecordActionButton(allowance, "payrollallowances");
                JFXButton deduction = new JFXButton("Deductions");
                FontAwesomeIconView deductionView = new FontAwesomeIconView();
                deductionView.setStyle("-fx-fill: #d32f2f;");
                deductionView.setSize("24.0");
                deductionView.setIcon((Enum)FontAwesomeIcon.MINUS);
                deduction.setGraphic((Node)deductionView);
                deduction.setContentDisplay(ContentDisplay.TOP);
                controller.addRecordActionButton(deduction, "payrolldeductions");
                JFXButton masterRoll = Config.getDefaultReportButton();
                masterRoll.setText("Master Roll");
                controller.addNonRecordButton(masterRoll, "masterroll");
                JFXButton paySlip = Config.getDefaultReportButton();
                paySlip.setText("Pay Slip");
                controller.addRecordButton(paySlip, "payslip");
                JFXButton p9a = Config.getDefaultReportButton();
                p9a.setText("P9 A");
                controller.addRecordButton(p9a, "p9a");
                JFXButton bankExport = Config.getDefaultReportButton();
                bankExport.setText("Bank Export");
                controller.addNonRecordButton(bankExport, "bank_export");
                JFXButton payeExport = Config.getDefaultReportButton();
                payeExport.setText("PAYE Export");
                controller.addNonRecordButton(payeExport, "paye_export");
                JFXButton nhifExport = Config.getDefaultReportButton();
                nhifExport.setText("NHIF Export");
                controller.addNonRecordButton(nhifExport, "nhif_export");
                JFXButton nssfExport = Config.getDefaultReportButton();
                nssfExport.setText("NSSF Export");
                controller.addNonRecordButton(nssfExport, "nssf_export");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Deductions Setup")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(AllowancesDeductions[].class);
                controller.setSearchPromptText("Search by Deduction Code, Name or Vendor");
                Type listType = new TypeToken<ArrayList<AllowancesDeductions>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Code", "code", 0.14);
                controller.addTableColumn("Name", "name", 0.3);
                controller.addTableColumn("Vendor/Gl Account", "vendorGlAccount", 0.3);
                controller.addTableColumn("Taxable", "taxableCheckbox", 0.12);
                controller.addTableColumn("Disabled", "disabledCheckbox", 0.12);
                controller.setDataUrl("masterfetch?type=payrolldeductions");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Deduction");
                controller.setEditRecordText("Edit Deduction");
                controller.setDeleteRecordText("Delete Deduction");
                controller.setType("payrolldeductions");
                controller.setNewRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Allowances Setup")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(AllowancesDeductions[].class);
                controller.setSearchPromptText("Search by Allowance Code, Name or GLAccount");
                Type listType = new TypeToken<ArrayList<AllowancesDeductions>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Code", "code", 0.14);
                controller.addTableColumn("Name", "name", 0.3);
                controller.addTableColumn("G/L Account", "glAccount", 0.3);
                controller.addTableColumn("Taxable", "taxableCheckbox", 0.12);
                controller.addTableColumn("Disabled", "disabledCheckbox", 0.12);
                controller.setDataUrl("masterfetch?type=payrollallowances");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Allowance");
                controller.setEditRecordText("Edit Allowance");
                controller.setDeleteRecordText("Delete Allowance");
                controller.setType("payrollallowances");
                controller.setNewRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Tax Brackets")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(TaxTables[].class);
                controller.setSearchPromptText("Search by Band Number, Band description, Lower Limit, Upper Limit or Percentage rate");
                Type listType = new TypeToken<ArrayList<TaxTables>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Band No", "bandNo", 0.14);
                controller.addTableColumn("Band Description", "bandDescription", 0.3);
                controller.addTableColumn("Lower Limit", "lowerLimit", 0.3);
                controller.addTableColumn("Upper Limit", "upperLimit", 0.12);
                controller.addTableColumn("Percentage Rate", "percentageRate", 0.12);
                controller.setDataUrl("masterfetch?type=taxtables");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Entry");
                controller.setEditRecordText("Edit Entry");
                controller.setDeleteRecordText("Delete Entry");
                controller.setType("taxtables");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("NHIF Rates")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(TaxTables[].class);
                controller.setSearchPromptText("Search by Band Number,  Lower Limit, Upper Limit or Monthly rate");
                Type listType = new TypeToken<ArrayList<TaxTables>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Band No", "bandNo", 0.14);
                controller.addTableColumn("Lower Limit", "lowerLimit", 0.3);
                controller.addTableColumn("Upper Limit", "upperLimit", 0.3);
                controller.addTableColumn("Monthly Rate", "percentageRate", 0.25);
                controller.setDataUrl("masterfetch?type=nhifrates");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Entry");
                controller.setEditRecordText("Edit Entry");
                controller.setDeleteRecordText("Delete Entry");
                controller.setType("nhifrates");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Process Payroll")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalaryVoucher[].class);
                controller.setSearchPromptText("Search by Voucher No, Payroll Period, Total Net Pay");
                Type listType = new TypeToken<ArrayList<SalaryVoucher>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Voucher No", "voucherNo", 0.15);
                controller.addTableColumn("Payroll Period", "period", 0.15);
                controller.addTableColumn("Total Basic Salary", "totalNetPayString", 0.18);
                controller.addTableColumn("Total Allowances", "totalNetPayString", 0.18);
                controller.addTableColumn("Total Deductions", "totalNetPayString", 0.18);
                controller.addTableColumn("Total Net Pay", "totalNetPayString", 0.18);
                controller.setDataUrl("masterfetch?type=salaryvoucher");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Voucher");
                controller.setEditRecordText("Edit Voucher");
                controller.setDeleteRecordText("Delete Voucher");
                controller.setType("salaryvoucher");
                JFXButton masterRoll = Config.getDefaultReportButton();
                masterRoll.setText("Master Roll");
                controller.addRecordButton(masterRoll, "masterroll");
                JFXButton payrollSummary = Config.getDefaultReportButton();
                payrollSummary.setText("Payroll Summary");
                controller.addRecordButton(payrollSummary, "payroll_summary");
                JFXButton paySlip = Config.getDefaultReportButton();
                paySlip.setText("Pay Slip");
                controller.addRecordButton(paySlip, "payslip");
                JFXButton p9a = Config.getDefaultReportButton();
                p9a.setText("P9 A");
                controller.addRecordButton(p9a, "p9a");
                JFXButton bankExport = Config.getDefaultReportButton();
                bankExport.setText("Bank Export");
                controller.addRecordButton(bankExport, "bank_export");
                JFXButton payeExport = Config.getDefaultReportButton();
                payeExport.setText("PAYE Export");
                controller.addRecordButton(payeExport, "paye_export");
                JFXButton nhifExport = Config.getDefaultReportButton();
                nhifExport.setText("NHIF Export");
                controller.addRecordButton(nhifExport, "nhif_export");
                JFXButton nssfExport = Config.getDefaultReportButton();
                nssfExport.setText("NSSF Export");
                controller.addRecordButton(nssfExport, "nssf_export");
                JFXButton thirdRule = Config.getDefaultReportButton();
                thirdRule.setText("Third Rule");
                controller.addRecordButton(thirdRule, "third_rule");
                JFXButton changesInPayroll = Config.getDefaultReportButton();
                changesInPayroll.setText("Changes In Payroll");
                controller.addRecordButton(changesInPayroll, "changes_in_payroll");
                JFXButton earningDeductionsReport = Config.getDefaultReportButton();
                earningDeductionsReport.setText("Earning/Deductions Report");
                controller.addRecordButton(earningDeductionsReport, "earning_deductions_report");
                JFXButton allPayslips = Config.getDefaultReportButton();
                allPayslips.setText("All Payslips");
                controller.addRecordButton(allPayslips, "all_payslips");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(true);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Payroll")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalaryVoucher[].class);
                controller.setSearchPromptText("Search by Voucher No, Payroll Period, Total Net Pay");
                Type listType = new TypeToken<ArrayList<SalaryVoucher>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Voucher No", "voucherNo", 0.15);
                controller.addTableColumn("Payroll Period", "period", 0.25);
                controller.addTableColumn("Total Net Pay", "totalNetPayString", 0.25);
                controller.setDataUrl("masterfetch?type=salaryvoucher");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Voucher");
                controller.setEditRecordText("Edit Voucher");
                controller.setDeleteRecordText("Delete Voucher");
                controller.setType("salaryvoucher");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(true);
                controller.setModality(Modality.WINDOW_MODAL);
                controller.showNavigatePosting();
                JFXButton masterRoll = Config.getDefaultReportButton();
                masterRoll.setText("Master Roll");
                controller.addRecordButton(masterRoll, "masterroll");
                JFXButton payrollSummary = Config.getDefaultReportButton();
                payrollSummary.setText("Payroll Summary");
                controller.addRecordButton(payrollSummary, "payroll_summary");
                JFXButton paySlip = Config.getDefaultReportButton();
                paySlip.setText("Pay Slip");
                controller.addRecordButton(paySlip, "payslip");
                JFXButton p9a = Config.getDefaultReportButton();
                p9a.setText("P9 A");
                controller.addRecordButton(p9a, "p9a");
                JFXButton bankExport = Config.getDefaultReportButton();
                bankExport.setText("Bank Export");
                controller.addRecordButton(bankExport, "bank_export");
                JFXButton payeExport = Config.getDefaultReportButton();
                payeExport.setText("PAYE Export");
                controller.addRecordButton(payeExport, "paye_export");
                JFXButton nhifExport = Config.getDefaultReportButton();
                nhifExport.setText("NHIF Export");
                controller.addRecordButton(nhifExport, "nhif_export");
                JFXButton nssfExport = Config.getDefaultReportButton();
                nssfExport.setText("NSSF Export");
                controller.addRecordButton(nssfExport, "nssf_export");
                JFXButton thirdRule = Config.getDefaultReportButton();
                thirdRule.setText("Third Rule");
                controller.addRecordButton(thirdRule, "third_rule");
                JFXButton changesInPayroll = Config.getDefaultReportButton();
                changesInPayroll.setText("Changes In Payroll");
                controller.addRecordButton(changesInPayroll, "changes_in_payroll");
                JFXButton earningDeductionsReport = Config.getDefaultReportButton();
                earningDeductionsReport.setText("Earning/Deductions Report");
                controller.addRecordButton(earningDeductionsReport, "earning_deductions_report");
                JFXButton allPayslips = Config.getDefaultReportButton();
                allPayslips.setText("All Payslips");
                controller.addRecordButton(allPayslips, "all_payslips");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("New Salary Advance")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalaryAdvance[].class);
                controller.setSearchPromptText("Search by name ");
                Type listType = new TypeToken<ArrayList<SalaryAdvance>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Id", "id", 0.2);
                controller.addTableColumn("Employee", "employee", 0.2);
                controller.addTableColumn("Bank", "bank", 0.2);
                controller.addTableColumn("Date", "date", 0.1);
                controller.addTableColumn("Amount", "amountString", 0.2);
                controller.setDataUrl("masterfetch?type=salaryadvances");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Salary Advance");
                controller.setEditRecordText("Edit Salary Advance");
                controller.setDeleteRecordText("Delete Salary Advance");
                controller.setType("salaryadvance");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Salary Advance")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalaryAdvance[].class);
                controller.setSearchPromptText("Search by name ");
                Type listType = new TypeToken<ArrayList<SalaryAdvance>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Id", "id", 0.2);
                controller.addTableColumn("Employee", "employee", 0.4);
                controller.addTableColumn("Amount", "amountString", 0.2);
                controller.setDataUrl("masterfetch?type=salaryadvances");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Salary Advance");
                controller.setEditRecordText("Edit Salary Advance");
                controller.setDeleteRecordText("Delete Salary Advance");
                controller.setType("salaryadvance");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Reversed Salary Advance")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalaryAdvance[].class);
                controller.setSearchPromptText("Search by name ");
                Type listType = new TypeToken<ArrayList<SalaryAdvance>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Id", "id", 0.2);
                controller.addTableColumn("Employee", "employee", 0.4);
                controller.addTableColumn("Amount", "amountString", 0.2);
                controller.setDataUrl("masterfetch?type=salaryadvances");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Salary Advance");
                controller.setEditRecordText("Edit Salary Advance");
                controller.setDeleteRecordText("Delete Salary Advance");
                controller.setType("salaryadvance");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("New Staff Loans")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(StaffLoan[].class);
                controller.setSearchPromptText("Search by name ");
                Type listType = new TypeToken<ArrayList<StaffLoan>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Id", "id", 0.2);
                controller.addTableColumn("Employee", "employee", 0.2);
                controller.addTableColumn("Bank", "bank", 0.2);
                controller.addTableColumn("Date", "date", 0.1);
                controller.addTableColumn("Amount", "amountString", 0.2);
                controller.addTableColumn("Installments", "installments", 0.1);
                controller.setDataUrl("masterfetch?type=staffloans");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Staff Loan");
                controller.setEditRecordText("Edit Staff Loan");
                controller.setDeleteRecordText("Delete Staff Loan");
                controller.setType("staffloan");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Staff Loans")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(StaffLoan[].class);
                controller.setSearchPromptText("Search by name ");
                Type listType = new TypeToken<ArrayList<StaffLoan>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Id", "id", 0.2);
                controller.addTableColumn("Employee", "employee", 0.3);
                controller.addTableColumn("Amount", "amountString", 0.15);
                controller.addTableColumn("Installments", "installments", 0.15);
                controller.addTableColumn("Loan Balance", "loanBalanceString", 0.15);
                controller.setDataUrl("masterfetch?type=staffloans");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("reversed", 0);
                params.put("posted", 1);
                params.put("cleared", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Staff Loan");
                controller.setEditRecordText("Edit Staff Loan");
                controller.setDeleteRecordText("Delete Staff Loan");
                controller.setType("staffloan");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton statement = Config.getDefaultReportButton();
                statement.setText("Loan Statement");
                controller.addRecordButton(statement, "staff_loan_statement");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Cleared Staff Loans")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(StaffLoan[].class);
                controller.setSearchPromptText("Search by name ");
                Type listType = new TypeToken<ArrayList<StaffLoan>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Id", "id", 0.2);
                controller.addTableColumn("Employee", "employee", 0.4);
                controller.addTableColumn("Amount", "amountString", 0.2);
                controller.addTableColumn("Installments", "installments", 0.2);
                controller.setDataUrl("masterfetch?type=staffloans");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("reversed", 0);
                params.put("posted", 1);
                params.put("cleared", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Staff Loan");
                controller.setEditRecordText("Edit Staff Loan");
                controller.setDeleteRecordText("Delete Staff Loan");
                controller.setType("staffloan");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton statement = Config.getDefaultReportButton();
                statement.setText("Loan Statement");
                controller.addRecordButton(statement, "staff_loan_statement");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Reversed Staff Loans")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(StaffLoan[].class);
                controller.setSearchPromptText("Search by name ");
                Type listType = new TypeToken<ArrayList<StaffLoan>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Id", "id", 0.2);
                controller.addTableColumn("Employee", "employee", 0.4);
                controller.addTableColumn("Amount", "amountString", 0.2);
                controller.addTableColumn("Installments", "installments", 0.2);
                controller.setDataUrl("masterfetch?type=staffloans");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Staff Loan");
                controller.setEditRecordText("Edit Staff Loan");
                controller.setDeleteRecordText("Delete Staff Loan");
                controller.setType("staffloan");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Payroll Setups")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/payroll_setups.fxml").openStream());
                PayrollSetups controller = (PayrollSetups)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Unit Types")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(UnitTypes[].class);
                controller.setSearchPromptText("Search by name ");
                Type listType = new TypeToken<ArrayList<UnitTypes>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Id", "id", 0.2);
                controller.addTableColumn("Name", "name", 0.6);
                controller.setDataUrl("masterfetch?type=unittype");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("Add Unit Type");
                controller.setEditRecordText("Edit Unit Type");
                controller.setDeleteRecordText("Delete Unit Type");
                controller.setType("unittype");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Tenants")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(UnitTypes[].class);
                controller.setSearchPromptText("Search by Tenant no, Name, Phone No, Property, Floor, Unit, Balance ");
                Type listType = new TypeToken<ArrayList<UnitTypes>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Tenant No", "id", 0.1);
                controller.addTableColumn("Tenant Name", "id", 0.3);
                controller.addTableColumn("Phone No", "name", 0.2);
                controller.addTableColumn("Property", "name", 0.1);
                controller.addTableColumn("Floor", "name", 0.1);
                controller.addTableColumn("Unit", "name", 0.1);
                controller.addTableColumn("Balance", "name", 0.1);
                controller.setDataUrl("masterfetch?type=tenants");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Tenant");
                controller.setEditRecordText("Edit Tenant");
                controller.setDeleteRecordText("Delete Tenant");
                controller.setType("tenant");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Properties")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Property[].class);
                controller.setSearchPromptText("Search by name ");
                Type listType = new TypeToken<ArrayList<Property>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Property Code", "propertyCode", 0.2);
                controller.addTableColumn("Name", "name", 0.6);
                controller.setDataUrl("masterfetch?type=property");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("Add Property");
                controller.setEditRecordText("Edit Property");
                controller.setDeleteRecordText("Delete Property");
                controller.setType("property");
                JFXButton floors = new JFXButton("Floors");
                FontAwesomeIconView floorsView = new FontAwesomeIconView();
                floorsView.setStyle("-fx-fill: BLUE;");
                floorsView.setSize("24.0");
                floorsView.setIcon((Enum)FontAwesomeIcon.BUILDING);
                floors.setGraphic((Node)floorsView);
                floors.setContentDisplay(ContentDisplay.TOP);
                controller.addRecordActionButton(floors, "floors");
                JFXButton units = new JFXButton("Units");
                FontAwesomeIconView unitsIconView = new FontAwesomeIconView();
                unitsIconView.setStyle("-fx-fill: #71a436;");
                unitsIconView.setSize("24.0");
                unitsIconView.setIcon((Enum)FontAwesomeIcon.HOME);
                units.setGraphic((Node)unitsIconView);
                units.setContentDisplay(ContentDisplay.TOP);
                controller.addRecordActionButton(units, "units");
                JFXButton monthlyCharges = new JFXButton("Monthly Charges");
                FontAwesomeIconView monthlyChargesView = new FontAwesomeIconView();
                monthlyChargesView.setStyle("-fx-fill: BLUE;");
                monthlyChargesView.setSize("24.0");
                monthlyChargesView.setIcon((Enum)FontAwesomeIcon.DOLLAR);
                monthlyCharges.setGraphic((Node)monthlyChargesView);
                monthlyCharges.setContentDisplay(ContentDisplay.TOP);
                controller.addRecordActionButton(monthlyCharges, "monthlycharges");
                JFXButton landlordStatement = Config.getDefaultReportButton();
                landlordStatement.setText("Landlord Statement");
                controller.addRecordButton(landlordStatement, "propertylandlordstatement");
                JFXButton createBills = Config.getDefaultReportButton();
                createBills.setText("Create Bill");
                controller.addRecordButton(createBills, "propertybilling");
                controller.setEditRecordText("Edit Property");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Number Series")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/numberSeries.fxml").openStream());
                NumberSeriesController controller = (NumberSeriesController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Towns")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Town[].class);
                controller.setSearchPromptText("Search by Town, County, Amount");
                Type listType = new TypeToken<ArrayList<Town>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Town Id", "townId", 0.1);
                controller.addTableColumn("Town", "townName", 0.25);
                controller.addTableColumn("County", "county", 0.25);
                controller.addTableColumn("Monthly Parking Fee (County)", "countyParkingFeeString", 0.19);
                controller.addTableColumn("Monthly Parking Fee (Sacco)", "saccoParkingFeeString", 0.19);
                controller.setDataUrl("masterfetch?type=towns");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Town");
                controller.setEditRecordText("Edit Town");
                controller.setDeleteRecordText("Delete Town");
                controller.setType("town");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Parking Fee Receipts")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(ParkingReceipt[].class);
                controller.setSearchPromptText("Search by Receipt No, Member, Vehicle, Amount ");
                Type listType = new TypeToken<ArrayList<ParkingReceipt>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Receipt No", "receiptNo", 0.1);
                controller.addTableColumn("Member", "member", 0.25);
                controller.addTableColumn("Vehicle", "vehicle", 0.25);
                controller.addTableColumn("Period", "period", 0.19);
                controller.addTableColumn("Amount Paid", "amountString", 0.19);
                controller.setDataUrl("masterfetch?type=parkingreceipts");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Receipt");
                controller.setEditRecordText("Edit Receipt");
                controller.setDeleteRecordText("Delete Receipt");
                controller.setType("parkingreceipts");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Parking Fee Receipts")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(ParkingReceipt[].class);
                controller.setSearchPromptText("Search by Receipt No, Member, Vehicle, Amount ");
                Type listType = new TypeToken<ArrayList<ParkingReceipt>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Receipt No", "receiptNo", 0.1);
                controller.addTableColumn("Member", "member", 0.25);
                controller.addTableColumn("Vehicle", "vehicle", 0.25);
                controller.addTableColumn("Period", "period", 0.19);
                controller.addTableColumn("Amount Paid", "amountString", 0.19);
                controller.setDataUrl("masterfetch?type=parkingreceipts");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Receipt");
                controller.setEditRecordText("Edit Receipt");
                controller.setDeleteRecordText("Delete Receipt");
                controller.setType("parkingreceipts");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Charge Service Fee")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/chargeServiceFee.fxml").openStream());
                ChargeServiceFeeController controller = (ChargeServiceFeeController)loader.getController();
                controller.setUser(this.getUser());
                controller.setPosted(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception loader) {}
        } else if (value.equalsIgnoreCase("Posted Service Fee")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/chargeServiceFee.fxml").openStream());
                ChargeServiceFeeController controller = (ChargeServiceFeeController)loader.getController();
                controller.setUser(this.getUser());
                controller.setPosted(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception loader) {}
        } else if (value.equalsIgnoreCase("Customer Posting Groups")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PostingGroup[].class);
                controller.setSearchPromptText("Search by Code, Name, GL Account");
                Type listType = new TypeToken<ArrayList<PostingGroup>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Code", "code", 0.05);
                controller.addTableColumn("Name", "name", 0.15);
                controller.addTableColumn("G/L Account", "account", 0.2);
                controller.addTableColumn("No. of Customers", "recordsCount", 0.2);
                controller.setDataUrl("masterfetch?type=postinggroups");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("category", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Posting Group");
                controller.setEditRecordText("Edit Posting Group");
                controller.setDeleteRecordText("Delete Posting Group");
                controller.setType("customerspostinggroup");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Customer Receipts")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(CustomerReceipt[].class);
                controller.setSearchPromptText("Search by Receipt No, Customer Name, Payment Date, Payment Method, Bank or Amount");
                Type listType = new TypeToken<ArrayList<CustomerReceipt>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Receipt No", "receiptNo", 0.15);
                controller.addTableColumn("Customer Name", "customer", 0.25);
                controller.addTableColumn("Payment Date", "paymentDate", 0.15);
                controller.addTableColumn("Payment Method", "paymentMethod", 0.15);
                controller.addTableColumn("Bank", "bank", 0.1);
                controller.addTableColumn("External Ref", "externalRef", 0.08);
                controller.addTableColumn("Amount", "amountString", 0.08);
                controller.setDataUrl("masterfetch?type=customerreceipts");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                params.put("reversed", 0);
                params.put("document_type", "customer_receipt");
                controller.setType("customerreceipt");
                controller.setDataParams(params);
                controller.setNewRecordText("New Receipt");
                controller.setEditRecordText("Edit Receipt");
                controller.setDeleteRecordText("Delete Receipt");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("View Receipt");
                controller.addRecordButton(voucher, "customerreceipt");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Customer Receipts")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(CustomerReceipt[].class);
                controller.setSearchPromptText("Search by Receipt No, Customer Name, Payment Date, Payment Method, Bank or Amount");
                Type listType = new TypeToken<ArrayList<CustomerReceipt>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Receipt No", "receiptNo", 0.15);
                controller.addTableColumn("Customer Name", "customer", 0.25);
                controller.addTableColumn("Payment Date", "paymentDate", 0.15);
                controller.addTableColumn("Payment Method", "paymentMethod", 0.15);
                controller.addTableColumn("Bank", "bank", 0.1);
                controller.addTableColumn("External Ref", "externalRef", 0.08);
                controller.addTableColumn("Amount", "amountString", 0.08);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=customerreceipts");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 0);
                params.put("document_type", "customer_receipt");
                controller.setType("customerreceipt");
                controller.setDataParams(params);
                controller.setNewRecordText("New Receipt");
                controller.setEditRecordText("Edit Receipt");
                controller.setDeleteRecordText("Delete Receipt");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("View Receipt");
                controller.addRecordButton(voucher, "customerreceipt");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Voided Customer Receipts")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(CustomerReceipt[].class);
                controller.setSearchPromptText("Search by Receipt No, Customer Name, Payment Date, Payment Method, Bank or Amount");
                Type listType = new TypeToken<ArrayList<CustomerReceipt>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Receipt No", "receiptNo", 0.15);
                controller.addTableColumn("Customer Name", "customer", 0.25);
                controller.addTableColumn("Payment Date", "paymentDate", 0.15);
                controller.addTableColumn("Payment Method", "paymentMethod", 0.15);
                controller.addTableColumn("Bank", "bank", 0.1);
                controller.addTableColumn("External Ref", "externalRef", 0.08);
                controller.addTableColumn("Amount", "amountString", 0.08);
                controller.setDataUrl("masterfetch?type=customerreceipts");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 1);
                params.put("document_type", "customer_receipt");
                controller.setType("customerreceipt");
                controller.setDataParams(params);
                controller.setNewRecordText("New Receipt");
                controller.setEditRecordText("Edit Receipt");
                controller.setDeleteRecordText("Delete Receipt");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("View Receipt");
                controller.addRecordButton(voucher, "customerreceipt");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Prepayments")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(CustomerReceipt[].class);
                controller.setSearchPromptText("Search by Voucher No, Customer Name, Payment Date, Payment Method or Amount");
                Type listType = new TypeToken<ArrayList<CustomerReceipt>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Voucher No", "receiptNo", 0.15);
                controller.addTableColumn("Customer Name", "customer", 0.25);
                controller.addTableColumn("Payment Date", "paymentDate", 0.15);
                controller.addTableColumn("Payment Method", "bank", 0.1);
                controller.addTableColumn("External Ref", "externalRef", 0.08);
                controller.addTableColumn("Amount", "amountString", 0.08);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=customerreceipts");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 0);
                params.put("document_type", "customer_receipt");
                controller.setType("prepayments");
                controller.setDataParams(params);
                controller.setNewRecordText("New Prepayments");
                controller.setEditRecordText("Edit Prepayments");
                controller.setDeleteRecordText("Delete Prepayments");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Customer Cheque Register")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(ChequeRegister[].class);
                controller.setSearchPromptText("Search by Id, Customer, Issue Date, Maturity Date, Amount");
                Type listType = new TypeToken<ArrayList<ChequeRegister>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Id", "id", 0.15);
                controller.addTableColumn("Customer", "customer", 0.25);
                controller.addTableColumn("Issue Date", "issueDate", 0.15);
                controller.addTableColumn("Maturity Date", "maturityDate", 0.15);
                controller.addTableColumn("Amount", "amountString", 0.08);
                controller.setDataUrl("masterfetch?type=cheque_register");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("type", "CUSTOMER");
                params.put("banked", "0");
                controller.setType("customer_cheque_register");
                controller.setDataParams(params);
                controller.setNewRecordText("New Cheque");
                controller.setEditRecordText("Edit Cheque");
                controller.setDeleteRecordText("Delete Cheque");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Vendor Cheque Register")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(ChequeRegister[].class);
                controller.setSearchPromptText("Search by Id, Vendor, Issue Date, Maturity Date, Amount, Issuing Bank");
                Type listType = new TypeToken<ArrayList<ChequeRegister>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Id", "id", 0.15);
                controller.addTableColumn("Vendor", "vendor", 0.25);
                controller.addTableColumn("Issue Date", "issueDate", 0.15);
                controller.addTableColumn("Maturity Date", "maturityDate", 0.15);
                controller.addTableColumn("Amount", "amountString", 0.08);
                controller.addTableColumn("Issuing Bank", "issuingBank", 0.15);
                controller.setDataUrl("masterfetch?type=cheque_register");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("type", "VENDOR");
                params.put("banked", "0");
                controller.setType("vendor_cheque_register");
                controller.setDataParams(params);
                controller.setNewRecordText("New Cheque");
                controller.setEditRecordText("Edit Cheque");
                controller.setDeleteRecordText("Delete Cheque");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Customer Services")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/chargeItems.fxml").openStream());
                ChargeItemsController controller = (ChargeItemsController)loader.getController();
                controller.setCategory(1);
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Proforma Invoice")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Quote Number, Customer Name, Total Excl. VAT,Total V.A.T or Total Amount");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Quote No", "doc_no", 0.15);
                controller.addTableColumn("Customer", "customer", 0.2);
                controller.addTableColumn("Warehouse", "location", 0.15);
                controller.addTableColumn("Date", "sales_date", 0.15);
                controller.addTableColumn("Excl. V.A.T", "totalExclVATString", 0.15);
                controller.addTableColumn("V.A.T", "totalVATString", 0.1);
                controller.addTableColumn("Total", "totalAmountString", 0.1);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                params.put("reversed", 0);
                params.put("status", "Draft");
                params.put("documentType", "SalesQuote");
                controller.setType("SalesQuote");
                controller.showDatesFilters(14);
                controller.setDataParams(params);
                controller.setNewRecordText("New Quote");
                controller.setEditRecordText("Edit Quote");
                controller.setDeleteRecordText("Delete Quote");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("View Quote");
                controller.addRecordButton(voucher, "salesinvoice");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Converted Proforma Invoice")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Quote Number, Customer Name, Total Excl. VAT,Total V.A.T or Total Amount");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Quote No", "doc_no", 0.15);
                controller.addTableColumn("Customer", "customer", 0.2);
                controller.addTableColumn("Warehouse", "location", 0.15);
                controller.addTableColumn("Date", "sales_date", 0.15);
                controller.addTableColumn("Excl. V.A.T", "totalExclVATString", 0.15);
                controller.addTableColumn("V.A.T", "totalVATString", 0.1);
                controller.addTableColumn("Total", "totalAmountString", 0.1);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 0);
                params.put("status", "Approved");
                params.put("documentType", "SalesQuote");
                controller.setType("SalesQuote");
                controller.showDatesFilters(14);
                controller.setDataParams(params);
                controller.setNewRecordText("New Quote");
                controller.setEditRecordText("Edit Quote");
                controller.setDeleteRecordText("Delete Quote");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("View Quote");
                controller.addRecordButton(voucher, "salesinvoice");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Credit Note")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Quote Number, Customer Name, Total Excl. VAT,Total V.A.T or Total Amount");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Quote No", "doc_no", 0.15);
                controller.addTableColumn("Customer", "customer", 0.2);
                controller.addTableColumn("Warehouse", "location", 0.15);
                controller.addTableColumn("Date", "sales_date", 0.15);
                controller.addTableColumn("Excl. V.A.T", "totalExclVATString", 0.15);
                controller.addTableColumn("V.A.T", "totalVATString", 0.1);
                controller.addTableColumn("Total", "totalAmountString", 0.1);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                params.put("reversed", 0);
                params.put("status", "Draft");
                params.put("documentType", "CreditNote");
                controller.setType("CreditNote");
                controller.setDataParams(params);
                controller.setNewRecordText("New Credit Note");
                controller.setEditRecordText("Edit Credit Note");
                controller.setDeleteRecordText("Delete Credit Note");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("View Credit Note");
                controller.addRecordButton(voucher, "salesinvoice");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Pending Credit Note")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Quote Number, Customer Name, Total Excl. VAT,Total V.A.T or Total Amount");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Quote No", "doc_no", 0.15);
                controller.addTableColumn("Customer", "customer", 0.2);
                controller.addTableColumn("Warehouse", "location", 0.15);
                controller.addTableColumn("Date", "sales_date", 0.15);
                controller.addTableColumn("Excl. V.A.T", "totalExclVATString", 0.15);
                controller.addTableColumn("V.A.T", "totalVATString", 0.1);
                controller.addTableColumn("Total", "totalAmountString", 0.1);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                params.put("reversed", 0);
                params.put("status", "Pending");
                params.put("documentType", "CreditNote");
                controller.setType("CreditNote");
                controller.setDataParams(params);
                controller.setNewRecordText("New Credit Note");
                controller.setEditRecordText("Edit Credit Note");
                controller.setDeleteRecordText("Delete Credit Note");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("View Credit Note");
                controller.addRecordButton(voucher, "salesinvoice");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Credit Note")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Quote Number, Customer Name, Total Excl. VAT,Total V.A.T or Total Amount");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Quote No", "doc_no", 0.15);
                controller.addTableColumn("Customer", "customer", 0.2);
                controller.addTableColumn("Warehouse", "location", 0.15);
                controller.addTableColumn("Date", "sales_date", 0.15);
                controller.addTableColumn("Excl. V.A.T", "totalExclVATString", 0.15);
                controller.addTableColumn("V.A.T", "totalVATString", 0.1);
                controller.addTableColumn("Total", "totalAmountString", 0.1);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 0);
                params.put("status", "Approved");
                params.put("documentType", "CreditNote");
                controller.setType("CreditNote");
                controller.setDataParams(params);
                controller.setNewRecordText("New Credit Note");
                controller.setEditRecordText("Edit Credit Note");
                controller.setDeleteRecordText("Delete Credit Note");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.showNavigatePosting();
                controller.showNavigatePosting();
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("View Credit Note");
                controller.addRecordButton(voucher, "salesinvoice");
                JFXButton invoice80MM = Config.getDefaultReportButton();
                invoice80MM.setText("80MM Credit Note");
                controller.addRecordButton(invoice80MM, "80mm_invoice");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Sales Invoices")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Invoice Number, Customer Name, Total Excl. VAT,Total V.A.T or Total Amount");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Invoice No", "doc_no", 0.08);
                controller.addTableColumn("Date", "sales_date", 0.08);
                controller.addTableColumn("Customer", "customer", 0.2);
                controller.addTableColumn("Warehouse", "location", 0.1);
                controller.addTableColumn("Sales Person", "salesRep", 0.1);
                controller.addTableColumn("Excl. V.A.T", "totalExclVATString", 0.1);
                controller.addTableColumn("V.A.T", "totalVATString", 0.1);
                controller.addTableColumn("Total", "totalAmountString", 0.1);
                controller.addTableColumn("Payment Status", "paymentStatus", 0.1);
                controller.addTableColumn("Balance", "balance", 0.1);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                params.put("reversed", 0);
                params.put("status", "Draft");
                params.put("documentType", "salesInvoice");
                controller.setType("salesInvoice");
                controller.setDataParams(params);
                controller.setNewRecordText("New Invoice");
                controller.setEditRecordText("Edit Invoice");
                controller.setDeleteRecordText("Delete Invoice");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.allowExcelImport();
                JFXButton invoice = Config.getDefaultReportButton();
                invoice.setText("View Invoice");
                JFXButton deliveryNote = Config.getDefaultReportButton();
                deliveryNote.setText("Delivery Note");
                JFXButton allInvoices = Config.getDefaultReportButton();
                allInvoices.setText("Sales Invoices");
                controller.setModality(Modality.WINDOW_MODAL);
                JFXButton salesReport = Config.getDefaultReportButton();
                salesReport.setText("Sales Report");
                controller.addNonRecordButton(salesReport, "salesReport");
                JFXButton salesSummary = Config.getDefaultReportButton();
                salesSummary.setText("Sales Summary");
                controller.addNonRecordButton(salesSummary, "rep_sales_summary");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Management Approval")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(ManagementApproval[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date, reason");
                Type listType = new TypeToken<ArrayList<ManagementApproval>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Id", "id", 0.15);
                controller.addTableColumn("VSM", "user", 0.15);
                controller.addTableColumn("Request Type", "requestType", 0.1);
                controller.addTableColumn("Status", "status", 0.1);
                controller.addTableColumn("Date", "requestDate", 0.1);
                controller.addTableColumn("Reason", "rejectionReason", 0.25);
                controller.setDataUrl("masterfetch?type=management_approval");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setType("management_approval");
                controller.setDataParams(params);
                controller.setNewRecordText("New Approval");
                controller.setEditRecordText("Edit Approval");
                controller.setDeleteRecordText("Delete Approval");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Pending Production Return")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(ProductionReturn[].class);
                controller.setSearchPromptText("Search by Voucher Number, Date, Product, Quantity,Unit cost, Batch No");
                Type listType = new TypeToken<ArrayList<ProductionReturn>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Voucher No", "voucherNo", 0.15);
                controller.addTableColumn("Production Date", "productionDate", 0.15);
                controller.addTableColumn("Product", "product", 0.3);
                controller.addTableColumn("Quantity", "quantity", 0.1);
                controller.addTableColumn("Batch No", "batchNo", 0.1);
                controller.addTableColumn("Unit Cost", "unitCost", 0.1);
                controller.showDatesFilters(30);
                controller.setDataUrl("masterfetch?type=production_return");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setType("production_return");
                controller.setDataParams(params);
                controller.setNewRecordText("New Return");
                controller.setEditRecordText("Edit Return");
                controller.setDeleteRecordText("Delete Return");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Production Return")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(ProductionReturn[].class);
                controller.setSearchPromptText("Search by Voucher Number, Date, Product, Quantity,Unit cost, Batch No");
                Type listType = new TypeToken<ArrayList<ProductionReturn>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Voucher No", "voucherNo", 0.15);
                controller.addTableColumn("Production Date", "productionDate", 0.15);
                controller.addTableColumn("Product", "product", 0.3);
                controller.addTableColumn("Quantity", "quantity", 0.1);
                controller.addTableColumn("Batch No", "batchNo", 0.1);
                controller.addTableColumn("Unit Cost", "unitCost", 0.1);
                controller.showDatesFilters(30);
                controller.setDataUrl("masterfetch?type=production_return");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setType("production_return");
                controller.setDataParams(params);
                controller.setNewRecordText("New Return");
                controller.setEditRecordText("Edit Return");
                controller.setDeleteRecordText("Delete Return");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Draft Stock Requests")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Doc No", "doc_no", 0.15);
                controller.addTableColumn("Request Date", "sales_date", 0.15);
                controller.addTableColumn("VSM", "userFullName", 0.25);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", "StockRequest");
                params.put("status", "Draft");
                controller.setType("stockrequest");
                controller.setDataParams(params);
                controller.setNewRecordText("New Request");
                controller.setEditRecordText("Edit Request");
                controller.setDeleteRecordText("Delete Request");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Pending Stock Requests")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Doc No", "doc_no", 0.15);
                controller.addTableColumn("Request Date", "sales_date", 0.15);
                controller.addTableColumn("VSM", "salesRep", 0.25);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", "StockRequest");
                params.put("status", "Pending");
                controller.setType("stockrequest");
                controller.setDataParams(params);
                controller.setNewRecordText("New Request");
                controller.setEditRecordText("Edit Request");
                controller.setDeleteRecordText("Delete Request");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Stock Requests")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Doc No", "doc_no", 0.15);
                controller.addTableColumn("Request Date", "sales_date", 0.15);
                controller.addTableColumn("VSM", "salesRep", 0.25);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", "StockRequest");
                params.put("status", "approved");
                controller.setType("stockrequest");
                controller.setDataParams(params);
                controller.setNewRecordText("New Request");
                controller.setEditRecordText("Edit Request");
                controller.setDeleteRecordText("Delete Request");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("Stock Request Form");
                controller.addRecordButton(voucher, "stock_request_form");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Pending Sales Orders")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Order No", "doc_no", 0.08);
                controller.addTableColumn("Date", "sales_date", 0.08);
                controller.addTableColumn("Customer", "customer", 0.2);
                controller.addTableColumn("Warehouse", "location", 0.1);
                controller.addTableColumn("Sales Person", "salesRep", 0.1);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", "SalesOrder");
                params.put("status", "Pending");
                controller.setType("SalesOrder");
                controller.setDataParams(params);
                controller.setNewRecordText("New Order");
                controller.setEditRecordText("Edit Order");
                controller.setDeleteRecordText("Delete Order");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Approved Sales Orders")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Order No", "doc_no", 0.08);
                controller.addTableColumn("Date", "sales_date", 0.08);
                controller.addTableColumn("Customer", "customer", 0.2);
                controller.addTableColumn("Warehouse", "location", 0.1);
                controller.addTableColumn("Sales Person", "salesRep", 0.1);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", "SalesOrder");
                params.put("status", "approved");
                controller.setType("SalesOrder");
                controller.setDataParams(params);
                controller.setNewRecordText("New Order");
                controller.setEditRecordText("Edit Order");
                controller.setDeleteRecordText("Delete Order");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Draft Store Requisitions")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Requisitions No", "doc_no", 0.15);
                controller.addTableColumn("Requisitions Date", "sales_date", 0.15);
                controller.addTableColumn("VSM", "salesRep", 0.25);
                controller.addTableColumn("Amount", "totalAmountString", 0.25);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", "StoreRequisition");
                params.put("status", "draft");
                controller.setType("StoreRequisition");
                controller.setDataParams(params);
                controller.setNewRecordText("New Requisitions");
                controller.setEditRecordText("Edit Requisitions");
                controller.setDeleteRecordText("Delete Requisitions");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Store Requisitions")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Requisitions No", "doc_no", 0.15);
                controller.addTableColumn("Requisitions Date", "sales_date", 0.15);
                controller.addTableColumn("VSM", "salesRep", 0.25);
                controller.addTableColumn("Amount", "totalAmountString", 0.25);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 0);
                params.put("status", "Approved");
                params.put("documentType", "StoreRequisition");
                controller.setType("StoreRequisition");
                controller.setDataParams(params);
                controller.setNewRecordText("New Requisitions");
                controller.setEditRecordText("Edit Requisitions");
                controller.setDeleteRecordText("Delete Requisitions");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton fuelConsumption = Config.getDefaultReportButton();
                fuelConsumption.setText("Fuel, Repairs & Maintenance");
                controller.addNonRecordButton(fuelConsumption, "fuel_consumption");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Draft Warehouse Returns")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Doc No", "doc_no", 0.15);
                controller.addTableColumn("Request Date", "sales_date", 0.15);
                controller.addTableColumn("VSM", "userFullName", 0.25);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", "WarehouseReturn");
                params.put("status", "draft");
                controller.setType("warehousereturn");
                controller.setDataParams(params);
                controller.setNewRecordText("New Return");
                controller.setEditRecordText("Edit Return");
                controller.setDeleteRecordText("Delete Return");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Pending Warehouse Returns")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Doc No", "doc_no", 0.15);
                controller.addTableColumn("Request Date", "sales_date", 0.15);
                controller.addTableColumn("VSM", "userFullName", 0.25);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", "WarehouseReturn");
                params.put("status", "pending");
                controller.setType("warehousereturn");
                controller.setDataParams(params);
                controller.setNewRecordText("New Return");
                controller.setEditRecordText("Edit Return");
                controller.setDeleteRecordText("Delete Return");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Warehouse Returns")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Doc No", "doc_no", 0.15);
                controller.addTableColumn("Request Date", "sales_date", 0.15);
                controller.addTableColumn("VSM", "userFullName", 0.25);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", "WarehouseReturn");
                params.put("status", "pending");
                controller.setType("warehousereturn");
                controller.setDataParams(params);
                controller.setNewRecordText("New Return");
                controller.setEditRecordText("Edit Return");
                controller.setDeleteRecordText("Delete Return");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Pending Stock Take")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(StockTake[].class);
                controller.setSearchPromptText("Search by Doc Number, Date, Warehouse,Total Discrepancy");
                Type listType = new TypeToken<ArrayList<StockTake>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Doc No", "docNo", 0.16);
                controller.addTableColumn("Date", "date", 0.16);
                controller.addTableColumn("Warehouse", "warehouse", 0.16);
                controller.addTableColumn("Created On", "createdOn", 0.16);
                controller.addTableColumn("Created By", "createdBy", 0.16);
                controller.addTableColumn("Total Discrepancy", "totalDiscrepancyString", 0.16);
                controller.setDataUrl("masterfetch?type=stock_take");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("closed", "0");
                controller.setType("stock_take");
                controller.setDataParams(params);
                controller.setNewRecordText("New Stock Take");
                controller.setEditRecordText("Edit Stock Take");
                controller.setDeleteRecordText("Delete Stock Take");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("Discrepancy Report");
                controller.addRecordButton(voucher, "discrepancy_report");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Closed Stock Take")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(StockTake[].class);
                controller.setSearchPromptText("Search by Doc Number, Date, Warehouse,Total Discrepancy");
                Type listType = new TypeToken<ArrayList<StockTake>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Doc No", "docNo", 0.16);
                controller.addTableColumn("Date", "date", 0.16);
                controller.addTableColumn("Warehouse", "warehouse", 0.16);
                controller.addTableColumn("Created On", "createdOn", 0.16);
                controller.addTableColumn("Created By", "createdBy", 0.16);
                controller.addTableColumn("Total Discrepancy", "totalDiscrepancyString", 0.16);
                controller.setDataUrl("masterfetch?type=stock_take");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("closed", "1");
                controller.setType("stock_take");
                controller.setDataParams(params);
                controller.setNewRecordText("New Stock Take");
                controller.setEditRecordText("Edit Stock Take");
                controller.setDeleteRecordText("Delete Stock Take");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("Discrepancy Report");
                controller.addRecordButton(voucher, "discrepancy_report");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Draft End of Day Closing Stock")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Doc No", "doc_no", 0.15);
                controller.addTableColumn("Request Date", "sales_date", 0.15);
                controller.addTableColumn("VSM", "userFullName", 0.25);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", "EndofDay");
                params.put("status", "draft");
                controller.setType("endofday");
                controller.setDataParams(params);
                controller.setNewRecordText("New E.O.D");
                controller.setEditRecordText("Edit E.O.D");
                controller.setDeleteRecordText("Delete E.O.D");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Pending Conversion")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(StockConversion[].class);
                controller.setSearchPromptText("Search by Code, Product, Quantity, Value, Date");
                Type listType = new TypeToken<ArrayList<StockConversion>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Code", "code", 0.09);
                controller.addTableColumn("Source Product", "sourceProduct", 0.4);
                controller.addTableColumn("Quantity", "quantity", 0.1);
                controller.addTableColumn("Value", "value", 0.15);
                controller.addTableColumn("Conversion Date", "conversionDate", 0.13);
                controller.addTableColumn("Added By", "addedBy", 0.1);
                controller.setDataUrl("masterfetch?type=stock_conversion");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setType("stock_conversion");
                controller.setDataParams(params);
                controller.setNewRecordText("New Conversion");
                controller.setEditRecordText("Edit Conversion");
                controller.setDeleteRecordText("Delete Conversion");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(true);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Conversion")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(StockConversion[].class);
                controller.setSearchPromptText("Search by Code, Product, Quantity, Value, Date");
                Type listType = new TypeToken<ArrayList<StockConversion>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Code", "code", 0.09);
                controller.addTableColumn("Source Product", "sourceProduct", 0.4);
                controller.addTableColumn("Quantity", "quantity", 0.1);
                controller.addTableColumn("Value", "value", 0.15);
                controller.addTableColumn("Conversion Date", "conversionDate", 0.13);
                controller.addTableColumn("Added By", "addedBy", 0.1);
                controller.setDataUrl("masterfetch?type=stock_conversion");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setType("stock_conversion");
                controller.setDataParams(params);
                controller.setNewRecordText("New Conversion");
                controller.setEditRecordText("Edit Conversion");
                controller.setDeleteRecordText("Delete Conversion");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(true);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Pending End of Day Closing Stock")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Doc No", "doc_no", 0.15);
                controller.addTableColumn("Request Date", "sales_date", 0.15);
                controller.addTableColumn("VSM", "userFullName", 0.12);
                controller.addTableColumn("Computed Sales", "totalAmountString", 0.12);
                controller.addTableColumn("Payments", "payments", 0.12);
                controller.addTableColumn("Variance", "variance", 0.12);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", "EndofDay");
                params.put("status", "pending");
                controller.setType("endofday");
                controller.setDataParams(params);
                controller.setNewRecordText("New E.O.D");
                controller.setEditRecordText("Edit E.O.D");
                controller.setDeleteRecordText("Delete E.O.D");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("End of Day Report");
                controller.addRecordButton(voucher, "end_of_day");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted End of Day Closing Stock")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.showNavigatePosting();
                controller.addTableColumn("Doc No", "doc_no", 0.15);
                controller.addTableColumn("Request Date", "sales_date", 0.15);
                controller.addTableColumn("VSM", "userFullName", 0.12);
                controller.addTableColumn("Computed Sales", "totalAmountString", 0.12);
                controller.addTableColumn("Payments", "payments", 0.12);
                controller.addTableColumn("Variance", "variance", 0.12);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", "EndofDay");
                params.put("status", "Approved");
                controller.setType("endofday");
                controller.setDataParams(params);
                controller.setNewRecordText("New E.O.D");
                controller.setEditRecordText("Edit E.O.D");
                controller.setDeleteRecordText("Delete E.O.D");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Archived End of Day Closing Stock")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Doc Number, VSM Name, Request Date");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.showNavigatePosting();
                controller.addTableColumn("Doc No", "doc_no", 0.15);
                controller.addTableColumn("Request Date", "sales_date", 0.15);
                controller.addTableColumn("VSM", "userFullName", 0.12);
                controller.addTableColumn("Computed Sales", "totalAmountString", 0.12);
                controller.addTableColumn("Payments", "payments", 0.12);
                controller.addTableColumn("Variance", "variance", 0.12);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("documentType", "EndofDay");
                params.put("status", "Approved");
                params.put("accountsConfirmed", "1");
                controller.setType("endofday");
                controller.setDataParams(params);
                controller.setNewRecordText("New E.O.D");
                controller.setEditRecordText("Edit E.O.D");
                controller.setDeleteRecordText("Delete E.O.D");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Sales Invoices")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(SalesHeader[].class);
                controller.setSearchPromptText("Search by Invoice Number, Customer Name, Total Excl. VAT,Total V.A.T or Total Amount");
                Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Invoice No", "doc_no", 0.08);
                controller.addTableColumn("Date", "sales_date", 0.08);
                controller.addTableColumn("Customer", "customer", 0.2);
                controller.addTableColumn("Warehouse", "location", 0.1);
                controller.addTableColumn("Sales Person", "salesRep", 0.1);
                controller.addTableColumn("Excl. V.A.T", "totalExclVATString", 0.1);
                controller.addTableColumn("V.A.T", "totalVATString", 0.1);
                controller.addTableColumn("Total", "totalAmountString", 0.1);
                controller.addTableColumn("Payment Status", "paymentStatus", 0.1);
                controller.addTableColumn("Balance", "balanceString", 0.1);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=salesheader");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 0);
                params.put("status", "Approved");
                params.put("documentType", "salesInvoice");
                controller.setType("salesInvoice");
                controller.showNavigatePosting();
                controller.setDataParams(params);
                controller.setNewRecordText("New Invoice");
                controller.setEditRecordText("Edit Invoice");
                controller.setDeleteRecordText("Delete Invoice");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton invoice = Config.getDefaultReportButton();
                invoice.setText("View Invoice");
                controller.addRecordButton(invoice, "salesinvoice");
                JFXButton invoice80MM = Config.getDefaultReportButton();
                invoice80MM.setText("80MM Invoice");
                controller.addRecordButton(invoice80MM, "80mm_invoice");
                JFXButton deliveryNote = Config.getDefaultReportButton();
                deliveryNote.setText("Delivery Note");
                controller.addRecordButton(deliveryNote, "deliveryNote");
                JFXButton allInvoices = Config.getDefaultReportButton();
                allInvoices.setText("Sales Invoices");
                controller.addNonRecordButton(allInvoices, "allcustomerinvoices");
                JFXButton stockReport = Config.getDefaultReportButton();
                stockReport.setText("Stock Report");
                controller.addNonRecordButton(stockReport, "stock_report");
                JFXButton accountsReport = Config.getDefaultReportButton();
                accountsReport.setText("Accounts Report");
                controller.addNonRecordButton(accountsReport, "accounts_report");
                JFXButton commissionsReport = Config.getDefaultReportButton();
                commissionsReport.setText("Commissions Report");
                controller.addNonRecordButton(commissionsReport, "commissions_report");
                JFXButton salesSummary = Config.getDefaultReportButton();
                salesSummary.setText("Distributor Sales Summary");
                controller.addNonRecordButton(salesSummary, "distributor_sales_summary");
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("All Investments")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/allInvestments.fxml").openStream());
                AllInvestmentsController controller = (AllInvestmentsController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Investment Commissions")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(InvestmentCommissions[].class);
                controller.setSearchPromptText("Search by Investment No, Name, Bank Name, Amount, Payment date");
                Type listType = new TypeToken<ArrayList<InvestmentCommissions>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Investment Name", "investment", 0.32);
                controller.addTableColumn("Receiving Bank", "bankName", 0.32);
                controller.addTableColumn("Payment Date", "paymentDate", 0.17);
                controller.addTableColumn("Commission", "amountString", 0.17);
                controller.setDataUrl("masterfetch?type=investmentcommissions");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Commission");
                controller.setEditRecordText("Edit Commission");
                controller.setDeleteRecordText("Delete Commission");
                controller.setType("investmentcommissions");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Capital")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/allCapital.fxml").openStream());
                allCapitalController controller = (allCapitalController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Withdrawals")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/allWithdrawals.fxml").openStream());
                AllWithdrawalsController controller = (AllWithdrawalsController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("All Assets")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/allAssets.fxml").openStream());
                AllAssetsController controller = (AllAssetsController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Acquisition")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(AssetAcquisition[].class);
                controller.setSearchPromptText("Search by Asset No, Asset Name, Vendor, Purchase Date, Buying Price");
                Type listType = new TypeToken<ArrayList<AssetAcquisition>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Acquisition No", "acquisitionNo", 0.15);
                controller.addTableColumn("Asset", "asset", 0.25);
                controller.addTableColumn("Vendor", "vendor", 0.25);
                controller.addTableColumn("Purchase Date", "purchaseDate", 0.17);
                controller.addTableColumn("Buying Price", "buyingPriceString", 0.16);
                controller.setDataUrl("masterfetch?type=assetacquisition");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Acquisition");
                controller.setEditRecordText("Edit Acquisition");
                controller.setDeleteRecordText("Delete Acquisition");
                controller.setType("assetacquisition");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Acquisition")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(AssetAcquisition[].class);
                controller.setSearchPromptText("Search by Asset No, Asset Name, Vendor, Purchase Date, Buying Price");
                Type listType = new TypeToken<ArrayList<AssetAcquisition>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Acquisition No", "acquisitionNo", 0.15);
                controller.addTableColumn("Asset", "asset", 0.25);
                controller.addTableColumn("Vendor", "vendor", 0.25);
                controller.addTableColumn("Purchase Date", "purchaseDate", 0.17);
                controller.addTableColumn("Buying Price", "buyingPriceString", 0.16);
                controller.setDataUrl("masterfetch?type=assetacquisition");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Acquisition");
                controller.setEditRecordText("Edit Acquisition");
                controller.setDeleteRecordText("Delete Acquisition");
                controller.setType("assetacquisition");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Disposal")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(AssetDisposal[].class);
                controller.setSearchPromptText("Search by Asset No, Asset Name, Customer, Selling Date, Selling Price");
                Type listType = new TypeToken<ArrayList<AssetDisposal>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Disposal No", "disposalNo", 0.15);
                controller.addTableColumn("Asset", "asset", 0.25);
                controller.addTableColumn("Customer", "customer", 0.25);
                controller.addTableColumn("Disposal Date", "disposalDate", 0.17);
                controller.addTableColumn("Selling Price", "sellingPriceString", 0.16);
                controller.setDataUrl("masterfetch?type=assetdisposal");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Disposal");
                controller.setEditRecordText("Edit Disposal");
                controller.setDeleteRecordText("Delete Disposal");
                controller.setType("assetdisposal");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Disposal")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(AssetDisposal[].class);
                controller.setSearchPromptText("Search by Asset No, Asset Name, Customer, Selling Date, Selling Price");
                Type listType = new TypeToken<ArrayList<AssetDisposal>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Disposal No", "disposalNo", 0.15);
                controller.addTableColumn("Asset", "asset", 0.25);
                controller.addTableColumn("Customer", "customer", 0.25);
                controller.addTableColumn("Disposal Date", "disposalDate", 0.17);
                controller.addTableColumn("Selling Price", "sellingPriceString", 0.16);
                controller.setDataUrl("masterfetch?type=assetdisposal");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Disposal");
                controller.setEditRecordText("Edit Disposal");
                controller.setDeleteRecordText("Delete Disposal");
                controller.setType("assetdisposal");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Appreciation/Depreciation")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(AppreciationDepreciation[].class);
                controller.setSearchPromptText("Search by Voucher No, Asset, Computation Date, Computation type, Computation Method, Rate/Method, Current Book Value");
                Type listType = new TypeToken<ArrayList<AppreciationDepreciation>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Voucher No", "voucherNo", 0.15);
                controller.addTableColumn("Asset", "asset", 0.25);
                controller.addTableColumn("Computation Type", "computationType", 0.25);
                controller.addTableColumn("Computation Method", "computationMethod", 0.17);
                controller.addTableColumn("Rate/Amount", "rateAmountString", 0.16);
                controller.setDataUrl("masterfetch?type=appreciationdepreciation");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Voucher");
                controller.setEditRecordText("Edit Voucher");
                controller.setDeleteRecordText("Delete Voucher");
                controller.setType("appreciationdepreciation");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Appreciation/Depreciation")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(AppreciationDepreciation[].class);
                controller.setSearchPromptText("Search by Voucher No, Asset, Computation Date, Computation type, Computation Method, Rate/Method, Current Book Value");
                Type listType = new TypeToken<ArrayList<AppreciationDepreciation>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Voucher No", "voucherNo", 0.15);
                controller.addTableColumn("Asset", "asset", 0.25);
                controller.addTableColumn("Computation Type", "computationType", 0.25);
                controller.addTableColumn("Computation Method", "computationMethod", 0.17);
                controller.addTableColumn("Rate/Amount", "rateAmountString", 0.16);
                controller.setDataUrl("masterfetch?type=appreciationdepreciation");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Voucher");
                controller.setEditRecordText("Edit Voucher");
                controller.setDeleteRecordText("Delete Voucher");
                controller.setType("appreciationdepreciation");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Imprest Charge Items")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/chargeItems.fxml").openStream());
                ChargeItemsController controller = (ChargeItemsController)loader.getController();
                controller.setUser(this.getUser());
                controller.setCategory(4);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Tenant Charge Items")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/chargeItems.fxml").openStream());
                ChargeItemsController controller = (ChargeItemsController)loader.getController();
                controller.setUser(this.getUser());
                controller.setCategory(5);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Petty Cash Charge Items")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/chargeItems.fxml").openStream());
                ChargeItemsController controller = (ChargeItemsController)loader.getController();
                controller.setUser(this.getUser());
                controller.setCategory(3);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Petty Cash Vouchers")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PettyCashVoucher[].class);
                controller.setSearchPromptText("Search by PCV No, Bank, Payee, Date Created or Amount");
                Type listType = new TypeToken<ArrayList<PettyCashVoucher>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("PCV No", "pcvNo", 0.15);
                controller.addTableColumn("PCV Date", "pcvDate", 0.15);
                controller.addTableColumn("Bank", "bank", 0.25);
                controller.addTableColumn("Payee", "payee", 0.25);
                controller.addTableColumn("Total", "totalString", 0.15);
                controller.setDataUrl("masterfetch?type=pettycashvouchers");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                params.put("reversed", 0);
                controller.setType("pcv");
                controller.setDataParams(params);
                controller.setNewRecordText("New PCV");
                controller.setEditRecordText("Edit PCV");
                controller.setDeleteRecordText("Delete PCV");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("Voucher");
                controller.addRecordButton(voucher, "pcvvoucher");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Petty Cash Vouchers")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PettyCashVoucher[].class);
                controller.setSearchPromptText("Search by PCV No, Bank, Payee, Date Created or Amount");
                Type listType = new TypeToken<ArrayList<PettyCashVoucher>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("PCV No", "pcvNo", 0.15);
                controller.addTableColumn("PCV Date", "pcvDate", 0.15);
                controller.addTableColumn("Bank", "bank", 0.25);
                controller.addTableColumn("Payee", "payee", 0.25);
                controller.addTableColumn("Total", "totalString", 0.15);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=pettycashvouchers");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 0);
                controller.setType("pcv");
                controller.setDataParams(params);
                controller.setNewRecordText("New PCV");
                controller.setEditRecordText("Edit PCV");
                controller.setDeleteRecordText("Delete PCV");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("Voucher");
                controller.addRecordButton(voucher, "pcvvoucher");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Reversed Petty Cash Vouchers")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PettyCashVoucher[].class);
                controller.setSearchPromptText("Search by PCV No, Bank, Payee, Date Created or Amount");
                Type listType = new TypeToken<ArrayList<PettyCashVoucher>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("PCV No", "pcvNo", 0.15);
                controller.addTableColumn("PCV Date", "pcvDate", 0.15);
                controller.addTableColumn("Bank", "bank", 0.25);
                controller.addTableColumn("Payee", "payee", 0.25);
                controller.addTableColumn("Total", "totalString", 0.15);
                controller.setDataUrl("masterfetch?type=pettycashvouchers");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 1);
                controller.setType("pcv");
                controller.setDataParams(params);
                controller.setNewRecordText("New PCV");
                controller.setEditRecordText("Edit PCV");
                controller.setDeleteRecordText("Delete PCV");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("Voucher");
                controller.addRecordButton(voucher, "pcvvoucher");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("All Suppliers")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Vendor[].class);
                controller.setSearchPromptText("Search by name, Reg. No, Phone No, Balance ");
                Type listType = new TypeToken<ArrayList<Vendor>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Vendor No", "vendorNumber", 0.1);
                controller.addTableColumn("Vendor Name", "fullName", 0.3);
                controller.addTableColumn("Phone No.", "vendorPhone", 0.15);
                controller.addTableColumn("Email", "vendorEmail", 0.25);
                controller.addTableColumn("Balance", "balanceString", 0.1);
                controller.setDataUrl("masterfetch?type=vendor");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setType("generalvendor");
                controller.setDataParams(params);
                controller.setNewRecordText("New Vendor");
                controller.setEditRecordText("Edit Vendor");
                controller.setDeleteRecordText("Delete Vendor");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setModality(Modality.WINDOW_MODAL);
                controller.setNewRecordResizable(true);
                controller.allowExcelImport();
                JFXButton allVendors = Config.getDefaultReportButton();
                allVendors.setText("All Suppliers");
                controller.addNonRecordButton(allVendors, "allvendors");
                JFXButton vendorBalances = Config.getDefaultReportButton();
                vendorBalances.setText("Vendor Balances");
                JFXButton statementReport = Config.getDefaultReportButton();
                statementReport.setText("Supplier Statement");
                controller.addRecordButton(statementReport, "vendorstatement");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Sales Reps")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Vendor[].class);
                controller.setSearchPromptText("Search by name, Id No, Phone No, Gender ");
                Type listType = new TypeToken<ArrayList<Vendor>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Vendor No", "vendorNumber", 0.1);
                controller.addTableColumn("Vendor Name", "fullName", 0.3);
                controller.addTableColumn("Phone No.", "vendorPhone", 0.15);
                controller.addTableColumn("Email", "vendorEmail", 0.25);
                controller.addTableColumn("Gender", "gender", 0.075);
                controller.addTableColumn("Balance", "balanceString", 0.1);
                controller.setDataUrl("masterfetch?type=vendor");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("vendortype", "Sales Rep");
                controller.setType("salesrep");
                controller.setDataParams(params);
                controller.setNewRecordText("New Sales Rep");
                controller.setEditRecordText("Edit Sales Rep");
                controller.setDeleteRecordText("Delete Sales Rep");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setModality(Modality.WINDOW_MODAL);
                controller.setNewRecordResizable(true);
                JFXButton statementReport = Config.getDefaultReportButton();
                statementReport.setText("Vendor Statement");
                controller.addRecordButton(statementReport, "vendorstatement");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Landlords")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Vendor[].class);
                controller.setSearchPromptText("Search by name, Id No, Phone No, Gender ");
                Type listType = new TypeToken<ArrayList<Vendor>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Vendor No", "vendorNumber", 0.1);
                controller.addTableColumn("Vendor Name", "fullName", 0.3);
                controller.addTableColumn("Phone No.", "vendorPhone", 0.15);
                controller.addTableColumn("Email", "vendorEmail", 0.25);
                controller.addTableColumn("Gender", "gender", 0.075);
                controller.addTableColumn("Balance", "balanceString", 0.1);
                controller.setDataUrl("masterfetch?type=vendor");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("vendortype", "landlord");
                controller.setType("landlord");
                controller.setDataParams(params);
                controller.setNewRecordText("New Landlord");
                controller.setEditRecordText("Edit Landlord");
                controller.setDeleteRecordText("Delete Landlord");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setModality(Modality.WINDOW_MODAL);
                controller.setNewRecordResizable(true);
                JFXButton statementReport = Config.getDefaultReportButton();
                statementReport.setText("Landlord Statement");
                controller.addRecordButton(statementReport, "vendorstatement");
                JFXButton landlordStatement = Config.getDefaultReportButton();
                landlordStatement.setText(" Statement");
                controller.addRecordButton(landlordStatement, "landlordstatement");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Regions")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Region[].class);
                controller.setSearchPromptText("Search by Region Name, RSM Manager");
                Type listType = new TypeToken<ArrayList<Region>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Region Id", "id", 0.1);
                controller.addTableColumn("Region Name", "name", 0.3);
                controller.addTableColumn("Regional Sales Manager", "rsmManager", 0.15);
                controller.setDataUrl("masterfetch?type=region");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setType("region");
                controller.setDataParams(params);
                controller.setNewRecordText("New Region");
                controller.setEditRecordText("Edit Region");
                controller.setDeleteRecordText("Delete Region");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setModality(Modality.WINDOW_MODAL);
                controller.setNewRecordResizable(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Projects")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(Project[].class);
                controller.setSearchPromptText("Search by Project ID,Project Name,Start Date, End Date");
                Type listType = new TypeToken<ArrayList<Project>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Project Id", "projectId", 0.1);
                controller.addTableColumn("Project Name", "projectName", 0.3);
                controller.addTableColumn("Start Date", "startDate", 0.15);
                controller.addTableColumn("End Date", "endDate", 0.15);
                controller.setDataUrl("masterfetch?type=project");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setType("project");
                controller.setDataParams(params);
                controller.setNewRecordText("New Project");
                controller.setEditRecordText("Edit Project");
                controller.setDeleteRecordText("Delete Project");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setModality(Modality.WINDOW_MODAL);
                controller.setNewRecordResizable(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Mpesa Transaction")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(MpesaTransactions[].class);
                controller.setSearchPromptText("Search by Transaction Id, Sender Name, Account Number");
                Type listType = new TypeToken<ArrayList<MpesaTransactions>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Trans. Code", "transID", 0.1);
                controller.addTableColumn("Trans. Time", "transTime", 0.1);
                controller.addTableColumn("Customer Phone", "MSISDN", 0.1);
                controller.addTableColumn("Customer Name", "customerName", 0.3);
                controller.addTableColumn("Account Number", "billRefNumber", 0.15);
                controller.addTableColumn("Transaction Amount", "transAmountString", 0.15);
                controller.setDataUrl("masterfetch?type=mpesatransactions");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setType("mpesatransactions");
                controller.setDataParams(params);
                controller.setNewRecordText("New Transaction");
                controller.setEditRecordText("Edit Transaction");
                controller.setDeleteRecordText("Delete Transaction");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(false);
                controller.setModality(Modality.WINDOW_MODAL);
                controller.setNewRecordResizable(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Vendor Services")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/chargeItems.fxml").openStream());
                ChargeItemsController controller = (ChargeItemsController)loader.getController();
                controller.setUser(this.getUser());
                controller.setCategory(2);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Vendor Posting Groups")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PostingGroup[].class);
                controller.setSearchPromptText("Search by Code, Name, GL Account");
                Type listType = new TypeToken<ArrayList<PostingGroup>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Code", "code", 0.05);
                controller.addTableColumn("Name", "name", 0.15);
                controller.addTableColumn("G/L Account", "account", 0.2);
                controller.addTableColumn("No. of Vendors", "recordsCount", 0.2);
                controller.setDataUrl("masterfetch?type=postinggroups");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("category", 2);
                controller.setDataParams(params);
                controller.setNewRecordText("New Posting Group");
                controller.setEditRecordText("Edit Posting Group");
                controller.setDeleteRecordText("Delete Posting Group");
                controller.setType("vendorspostinggroup");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Draft L.P.O.s")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PurchaseHeader[].class);
                controller.setSearchPromptText("Search by Order No, Supplier, Amount");
                Type listType = new TypeToken<ArrayList<PurchaseHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("L.P.O. No", "documentNo", 0.1);
                controller.addTableColumn("Location", "location", 0.1);
                controller.addTableColumn("Supplier", "vendor", 0.25);
                controller.addTableColumn("Order Date", "invoiceDate", 0.2);
                controller.addTableColumn("Total Excl. VAT", "totalExclVATString", 0.12);
                controller.addTableColumn("Total VAT", "totalVATString", 0.12);
                controller.addTableColumn("Total Amount", "totalAmountString", 0.12);
                controller.setDataUrl("masterfetch?type=vendorinvoices");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                params.put("documentType", "lpo");
                params.put("status", "Draft");
                controller.setDataParams(params);
                controller.setNewRecordText("New Order");
                controller.setEditRecordText("Edit Order");
                controller.setDeleteRecordText("Delete Order");
                controller.setType("lpo");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.APPLICATION_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Pending L.P.O.s")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PurchaseHeader[].class);
                controller.setSearchPromptText("Search by Order No, Supplier, Amount");
                Type listType = new TypeToken<ArrayList<PurchaseHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("L.P.O. No", "documentNo", 0.1);
                controller.addTableColumn("Location", "location", 0.1);
                controller.addTableColumn("Supplier", "vendor", 0.25);
                controller.addTableColumn("Order Date", "invoiceDate", 0.2);
                controller.addTableColumn("Total Excl. VAT", "totalExclVATString", 0.12);
                controller.addTableColumn("Total VAT", "totalVATString", 0.12);
                controller.addTableColumn("Total Amount", "totalAmountString", 0.12);
                controller.setDataUrl("masterfetch?type=vendorinvoices");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                params.put("documentType", "lpo");
                params.put("status", "Pending");
                controller.setDataParams(params);
                controller.setNewRecordText("New Order");
                controller.setEditRecordText("Edit Order");
                controller.setDeleteRecordText("Delete Order");
                controller.setType("lpo");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.APPLICATION_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Approved L.P.O.s")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PurchaseHeader[].class);
                controller.setSearchPromptText("Search by Order No, Supplier, Amount");
                Type listType = new TypeToken<ArrayList<PurchaseHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("L.P.O. No", "documentNo", 0.1);
                controller.addTableColumn("Location", "location", 0.1);
                controller.addTableColumn("Supplier", "vendor", 0.25);
                controller.addTableColumn("Order Date", "invoiceDate", 0.2);
                controller.addTableColumn("Total Excl. VAT", "totalExclVATString", 0.12);
                controller.addTableColumn("Total VAT", "totalVATString", 0.12);
                controller.addTableColumn("Total Amount", "totalAmountString", 0.12);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=vendorinvoices");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("documentType", "lpo");
                params.put("status", "Approved");
                controller.setDataParams(params);
                controller.setNewRecordText("New Order");
                controller.setEditRecordText("Edit Order");
                controller.setDeleteRecordText("Delete Order");
                controller.setType("lpo");
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("View L.P.O");
                controller.addRecordButton(voucher, "lpo");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.APPLICATION_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Purchase Invoice") || value.equalsIgnoreCase("Receive Goods")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PurchaseHeader[].class);
                controller.setSearchPromptText("Search by Invoice No, Supplier, Amount");
                Type listType = new TypeToken<ArrayList<PurchaseHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("INV No", "documentNo", 0.08);
                controller.addTableColumn("Supplier", "vendor", 0.2);
                controller.addTableColumn("Order Date", "invoiceDate", 0.1);
                controller.addTableColumn("Ext. INV No", "externalDocNo", 0.1);
                controller.addTableColumn("L.P.O. No.", "lpoNo", 0.1);
                controller.addTableColumn("Total Excl. VAT", "totalExclVATString", 0.12);
                controller.addTableColumn("Total VAT", "totalVATString", 0.12);
                controller.addTableColumn("Total Amount", "totalAmountString", 0.12);
                controller.setDataUrl("masterfetch?type=vendorinvoices");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                params.put("documentType", "purchaseInvoice");
                controller.setDataParams(params);
                controller.setNewRecordText("New Invoice");
                controller.setEditRecordText("Edit Invoice");
                controller.setDeleteRecordText("Delete Invoice");
                controller.setType("purchaseInvoice");
                controller.setNewRecordEnabled(true);
                if (!Config.ERP_MODE) {
                    controller.setNewRecordEnabled(false);
                }
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.APPLICATION_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Purchase Invoices")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PurchaseHeader[].class);
                controller.setSearchPromptText("Search by Invoice No, Supplier, Amount");
                Type listType = new TypeToken<ArrayList<PurchaseHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("INV No", "documentNo", 0.08);
                controller.addTableColumn("Supplier", "vendor", 0.2);
                controller.addTableColumn("Warehouse", "location", 0.1);
                controller.addTableColumn("Order Date", "invoiceDate", 0.1);
                controller.addTableColumn("Ext. INV No", "externalDocNo", 0.1);
                controller.addTableColumn("L.P.O. No.", "lpoNo", 0.1);
                controller.addTableColumn("Excl. VAT", "totalExclVATString", 0.1);
                controller.addTableColumn("VAT", "totalVATString", 0.1);
                controller.addTableColumn("Total Amount", "totalAmountString", 0.12);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=vendorinvoices");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("documentType", "purchaseInvoice");
                controller.setDataParams(params);
                controller.setNewRecordText("New Invoice");
                controller.setEditRecordText("Edit Invoice");
                controller.setDeleteRecordText("Delete Invoice");
                controller.setType("purchaseInvoice");
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("View Invoice");
                controller.addRecordButton(voucher, "purchaseinvoice");
                JFXButton purchaseSummary = Config.getDefaultReportButton();
                purchaseSummary.setText("Purchase Summary");
                controller.addNonRecordButton(purchaseSummary, "purchase_summary");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.APPLICATION_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Debit Note")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PurchaseHeader[].class);
                controller.setSearchPromptText("Search by Debit Note No, Supplier, Amount");
                Type listType = new TypeToken<ArrayList<PurchaseHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Debit Note No", "documentNo", 0.1);
                controller.addTableColumn("Supplier", "vendor", 0.3);
                controller.addTableColumn("Order Date", "invoiceDate", 0.2);
                controller.addTableColumn("Total Excl. VAT", "totalExclVATString", 0.12);
                controller.addTableColumn("Total VAT", "totalVATString", 0.12);
                controller.addTableColumn("Total Amount", "totalAmountString", 0.12);
                controller.setDataUrl("masterfetch?type=vendorinvoices");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                params.put("documentType", "debitNote");
                controller.setDataParams(params);
                controller.setNewRecordText("New Debit Note");
                controller.setEditRecordText("Edit Debit Note");
                controller.setDeleteRecordText("Delete Debit Note");
                controller.setType("debitNote");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.APPLICATION_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Debit Note")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PurchaseHeader[].class);
                controller.setSearchPromptText("Search by Debit Note No, Supplier, Amount");
                Type listType = new TypeToken<ArrayList<PurchaseHeader>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Debit Note No", "documentNo", 0.1);
                controller.addTableColumn("Supplier", "vendor", 0.3);
                controller.addTableColumn("Order Date", "invoiceDate", 0.2);
                controller.addTableColumn("Total Excl. VAT", "totalExclVATString", 0.12);
                controller.addTableColumn("Total VAT", "totalVATString", 0.12);
                controller.addTableColumn("Total Amount", "totalAmountString", 0.12);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=vendorinvoices");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("documentType", "debitNote");
                controller.setDataParams(params);
                controller.setNewRecordText("New Debit Note");
                controller.setEditRecordText("Edit Debit Note");
                controller.setDeleteRecordText("Delete Debit Note");
                controller.setType("debitNote");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton voucher = Config.getDefaultReportButton();
                voucher.setText("View Debit Note");
                controller.addRecordButton(voucher, "purchaseinvoice");
                controller.setModality(Modality.APPLICATION_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Payment Vouchers")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PaymentVoucher[].class);
                controller.setSearchPromptText("Search by Voucher No, Vendor , Payment Date, Payment Method, Bank or Amount");
                Type listType = new TypeToken<ArrayList<PaymentVoucher>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("P.V. No", "pvNo", 0.15);
                controller.addTableColumn("Vendor", "vendor", 0.25);
                controller.addTableColumn("Payment Date", "paymentDate", 0.15);
                controller.addTableColumn("Bank", "bank", 0.1);
                controller.addTableColumn("Payment Method", "paymentMethod", 0.15);
                controller.addTableColumn("External Ref", "externalRef", 0.08);
                controller.addTableColumn("Amount", "amountString", 0.08);
                controller.setDataUrl("masterfetch?type=paymentvouchers");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                params.put("reversed", 0);
                params.put("document_type", "payment_voucher");
                controller.setType("payment_voucher");
                controller.setDataParams(params);
                controller.setNewRecordText("New Voucher");
                controller.setEditRecordText("Edit Voucher");
                controller.setDeleteRecordText("Delete Voucher");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Voided Payment Vouchers")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PaymentVoucher[].class);
                controller.setSearchPromptText("Search by Voucher No, Vendor , Payment Date, Payment Method, Bank or Amount");
                Type listType = new TypeToken<ArrayList<PaymentVoucher>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("P.V. No", "pvNo", 0.15);
                controller.addTableColumn("Vendor", "vendor", 0.25);
                controller.addTableColumn("Payment Date", "paymentDate", 0.15);
                controller.addTableColumn("Bank", "bank", 0.1);
                controller.addTableColumn("Payment Method", "paymentMethod", 0.15);
                controller.addTableColumn("External Ref", "externalRef", 0.08);
                controller.addTableColumn("Amount", "amountString", 0.08);
                controller.setDataUrl("masterfetch?type=paymentvouchers");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 1);
                params.put("document_type", "payment_voucher");
                controller.setType("payment_voucher");
                controller.setDataParams(params);
                controller.setNewRecordText("New Voucher");
                controller.setEditRecordText("Edit Voucher");
                controller.setDeleteRecordText("Delete Voucher");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Payment Vouchers")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(PaymentVoucher[].class);
                controller.setSearchPromptText("Search by Voucher No, Vendor , Payment Date, Payment Method, Bank or Amount");
                Type listType = new TypeToken<ArrayList<PaymentVoucher>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("P.V. No", "pvNo", 0.15);
                controller.addTableColumn("Vendor", "vendor", 0.25);
                controller.addTableColumn("Payment Date", "paymentDate", 0.15);
                controller.addTableColumn("Bank", "bank", 0.1);
                controller.addTableColumn("Payment Method", "paymentMethod", 0.15);
                controller.addTableColumn("External Ref", "externalRef", 0.08);
                controller.addTableColumn("Amount", "amountString", 0.08);
                controller.showDatesFilters(14);
                controller.setDataUrl("masterfetch?type=paymentvouchers");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                params.put("reversed", 0);
                params.put("document_type", "payment_voucher");
                controller.setType("payment_voucher");
                controller.setDataParams(params);
                controller.setNewRecordText("New Voucher");
                controller.setEditRecordText("Edit Voucher");
                controller.setDeleteRecordText("Delete Voucher");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Users")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/allusers.fxml").openStream());
                AllUsersController controller = (AllUsersController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Users Roles")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(UserRoles[].class);
                controller.setSearchPromptText("Search by Role Id, Role Name");
                Type listType = new TypeToken<ArrayList<UserRoles>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Role Id", "id", 0.1);
                controller.addTableColumn("Role Name", "name", 0.3);
                controller.setDataUrl("masterfetch?type=userroles");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Role");
                controller.setEditRecordText("Edit Role");
                controller.setDeleteRecordText("Delete Role");
                controller.setType("userrole");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.APPLICATION_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Mobitill Import")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/mobitillvouchers.fxml").openStream());
                MobitillVouchersController controller = (MobitillVouchersController)loader.getController();
                controller.setUser(this.getUser());
                controller.setPosted(false);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Mobitill Import")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/mobitillvouchers.fxml").openStream());
                MobitillVouchersController controller = (MobitillVouchersController)loader.getController();
                controller.setUser(this.getUser());
                controller.setPosted(true);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Dashboard")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/salesdashboard.fxml").openStream());
                SalesDashboard controller = (SalesDashboard)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("E-TIMS")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/etims/etims.fxml").openStream());
                ETimsController controller = (ETimsController)loader.getController();
                controller.setUser(this.getUser());
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Home")) {
            try {
                AnchorPane membersView = (AnchorPane)FXMLLoader.load((URL)this.getClass().getResource("/fxml/main.fxml"));
                for (Node node : membersView.getChildren()) {
                    try {
                        if (!node.getId().equalsIgnoreCase("content")) continue;
                        this.content.getChildren().clear();
                        AnchorPane pane = (AnchorPane)node;
                        pane.setLayoutX(0.0);
                        pane.setLayoutY(0.0);
                        this.content.getChildren().add((Object)pane);
                    }
                    catch (NullPointerException y) {
                    }
                }
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Item Brand")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(ItemBrand[].class);
                controller.setSearchPromptText("Search by brand name or id");
                Type listType = new TypeToken<ArrayList<ItemBrand>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Brand Id", "id", 0.35);
                controller.addTableColumn("Brand Name", "name", 0.65);
                controller.setDataUrl("masterfetch?type=itembrand");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Brand");
                controller.setEditRecordText("Edit Brand");
                controller.setDeleteRecordText("Delete Brand");
                controller.setType("itembrand");
                controller.setEditRecordText("Edit Brand");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Tax Groups")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(TaxGroup[].class);
                controller.setSearchPromptText("Search tax group of measure by name or code");
                Type listType = new TypeToken<ArrayList<TaxGroup>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Tax Group Code", "code", 0.2);
                controller.addTableColumn("Tax Group Name", "name", 0.4);
                controller.addTableColumn("Tax Group percentage", "percentage", 0.4);
                controller.setDataUrl("masterfetch?type=taxgroup");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Group");
                controller.setEditRecordText("Edit Group");
                controller.setDeleteRecordText("Delete Group");
                controller.setType("taxgroup");
                controller.setEditRecordText("Edit Tax Group");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Units Of Measure")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(UnitOfMeasure[].class);
                controller.setSearchPromptText("Search unit of measure by name or id");
                Type listType = new TypeToken<ArrayList<ItemBrand>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("UOM Id", "id", 0.35);
                controller.addTableColumn("UOM Name", "name", 0.65);
                controller.setDataUrl("masterfetch?type=unitofmeasure");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New UOM");
                controller.setEditRecordText("Edit UOM");
                controller.setDeleteRecordText("Delete UOM");
                controller.setType("unitofmeasure");
                controller.setEditRecordText("Edit UOM");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Items")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(ShopItem[].class);
                controller.setSearchPromptText("Search item of measure by name, code, brand, tax group, unit of measure etc...");
                Type listType = new TypeToken<ArrayList<ShopItem>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Item Id", "code", 0.1);
                controller.addTableColumn("Item Name", "name", 0.2);
                controller.addTableColumn("Brand", "brand", 0.1);
                controller.addTableColumn("Posting Group", "postingGroup", 0.1);
                controller.addTableColumn("Unit of measure", "unitOfMeasure", 0.2);
                controller.addNumericTableColumn("Buying Price", "buyingPriceString", 0.1);
                controller.addNumericTableColumn("Selling Price", "priceString", 0.1);
                controller.addHyperlinkTableColumn("Available", "balanceHyperlink", 0.1);
                controller.setDataUrl("masterfetch?type=item");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Item");
                controller.setEditRecordText("Edit Item");
                controller.setDeleteRecordText("Delete Item");
                controller.setType("item");
                controller.setEditRecordText("Edit Item");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(true);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                JFXButton itemsPerLocation = Config.getDefaultReportButton();
                itemsPerLocation.setText("All Warehouses");
                controller.addNonRecordButton(itemsPerLocation, "stockperlocation");
                JFXButton countSheet = Config.getDefaultReportButton();
                countSheet.setText("Count Sheet");
                controller.addNonRecordButton(countSheet, "countsheet");
                JFXButton price_list = Config.getDefaultReportButton();
                price_list.setText("Price List");
                controller.addNonRecordButton(price_list, "price_list");
                JFXButton productMargins = Config.getDefaultReportButton();
                productMargins.setText("Product Margins");
                controller.addNonRecordButton(productMargins, "product_margins");
                controller.setModality(Modality.WINDOW_MODAL);
                controller.allowExcelImport();
                JFXButton stockAnalysis = Config.getDefaultReportButton();
                stockAnalysis.setText("Stock Movement Analysis");
                controller.addNonRecordButton(stockAnalysis, "stockanalysis");
                JFXButton salesPerRep = Config.getDefaultReportButton();
                salesPerRep.setText("Sales Per Sales Rep");
                controller.addNonRecordButton(salesPerRep, "sales_per_sales_rep");
                JFXButton salesPerGroup = Config.getDefaultReportButton();
                salesPerGroup.setText("Sales Per Posting Group");
                controller.addNonRecordButton(salesPerGroup, "sales_per_posting_group");
                JFXButton routeProfitability = Config.getDefaultReportButton();
                routeProfitability.setText("Route Profitability");
                controller.addNonRecordButton(routeProfitability, "route_profitability");
                JFXButton emptyMovement = Config.getDefaultReportButton();
                emptyMovement.setText("Empty Movement");
                controller.addNonRecordButton(emptyMovement, "complete_empty_movement");
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Warehouses")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(ShopLocation[].class);
                controller.setSearchPromptText("Search location by name or id");
                Type listType = new TypeToken<ArrayList<ShopLocation>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Warehouse Id", "id", 0.1);
                controller.addTableColumn("Warehouse Name", "name", 0.3);
                controller.addTableColumn("VSM", "vsm", 0.2);
                controller.setDataUrl("masterfetch?type=shoplocation");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("New Warehouse");
                controller.setEditRecordText("Edit Warehouse");
                controller.setDeleteRecordText("Delete Warehouse");
                controller.setType("shoplocation");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Stock Transfer")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(StockTransfer[].class);
                controller.setSearchPromptText("Search by  item or location");
                Type listType = new TypeToken<ArrayList<StockTransfer>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Code", "code", 0.1);
                controller.addTableColumn("Stock Transfer Date", "dateCreated", 0.3);
                controller.addTableColumn("Transfer From", "transferFrom", 0.3);
                controller.addTableColumn("Transfer To", "transferTo", 0.3);
                controller.setDataUrl("masterfetch?type=stocktransfer");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 0);
                controller.setDataParams(params);
                controller.setNewRecordText("New Transfer");
                controller.setEditRecordText("Edit Transfer");
                controller.setDeleteRecordText("Delete Transfer");
                controller.setType("stocktransfer");
                controller.setEditRecordText("Edit Transfer");
                controller.setNewRecordEnabled(true);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Posted Stock Transfer")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(StockTransfer[].class);
                controller.setSearchPromptText("Search by  item or location");
                Type listType = new TypeToken<ArrayList<StockTransfer>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Code", "code", 0.1);
                controller.addTableColumn("Stock Transfer Date", "dateCreated", 0.3);
                controller.addTableColumn("Transfer From", "transferFrom", 0.3);
                controller.addTableColumn("Transfer To", "transferTo", 0.3);
                controller.showDatesFilters(30);
                controller.setDataUrl("masterfetch?type=stocktransfer");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("posted", 1);
                controller.setDataParams(params);
                controller.setNewRecordText("New Transfer");
                controller.setEditRecordText("Edit Transfer");
                controller.setDeleteRecordText("Delete Transfer");
                controller.setType("stocktransfer");
                controller.setEditRecordText("Edit Transfer");
                JFXButton delivery_note = Config.getDefaultReportButton();
                delivery_note.setText("Delivery Note");
                controller.addRecordButton(delivery_note, "transfer_delivery_note");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(true);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (value.equalsIgnoreCase("Stock Per Location")) {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                GeneralListController controller = (GeneralListController)loader.getController();
                controller.setUser(this.getUser());
                controller.setObject(ShopItem[].class);
                controller.setSearchPromptText("Search by Item Name");
                Type listType = new TypeToken<ArrayList<ShopItem>>(){}.getType();
                controller.setListType(listType);
                controller.addTableColumn("Item Name", "name", 0.2);
                controller.addTableColumn("Unit of Measure", "uniOfmeasure", 0.1);
                controller.setDataUrl("masterfetch?type=stockperlocation");
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                controller.setDataParams(params);
                controller.setNewRecordText("NA");
                controller.setEditRecordText("NA");
                controller.setDeleteRecordText("NA");
                controller.setNewRecordEnabled(false);
                controller.setDeleteRecordEnabled(false);
                controller.setEditRecordEnabled(false);
                controller.setNewRecordResizable(false);
                controller.setModality(Modality.WINDOW_MODAL);
                itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                this.holderVbox.getChildren().clear();
                this.holderVbox.getChildren().add((Object)itemPane);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (!value.equalsIgnoreCase("Stock Adjustment")) {
            if (value.equalsIgnoreCase("Express Sale")) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                    GeneralListController controller = (GeneralListController)loader.getController();
                    controller.setUser(this.getUser());
                    controller.setObject(SalesHeader[].class);
                    controller.setSearchPromptText("Search by location, item or description");
                    Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                    controller.setListType(listType);
                    controller.addTableColumn("Code", "doc_no", 0.1);
                    controller.addTableColumn("Sale Date", "sales_date", 0.15);
                    controller.addTableColumn("Location", "location", 0.15);
                    controller.addTableColumn("Customer Name", "customerName", 0.15);
                    controller.addTableColumn("CustomerPin", "customerPin", 0.15);
                    controller.addTableColumn("Total", "totalAmountString", 0.15);
                    controller.setDataUrl("masterfetch?type=salesheader");
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("posted", 0);
                    params.put("reversed", 0);
                    params.put("status", "Draft");
                    params.put("documentType", AddExpressSale.DOCUMENT_TYPE);
                    controller.setType("expresssale");
                    controller.setDataParams(params);
                    controller.setNewRecordText("New Sale");
                    controller.setEditRecordText("Edit Sale");
                    controller.setDeleteRecordText("Delete Sale");
                    controller.setNewRecordEnabled(true);
                    controller.setDeleteRecordEnabled(true);
                    controller.setEditRecordEnabled(true);
                    controller.setNewRecordResizable(true);
                    JFXButton salesSummary = Config.getDefaultReportButton();
                    salesSummary.setText("Sales Summary");
                    controller.addNonRecordButton(salesSummary, "sales_summary");
                    JFXButton paymentsReport = Config.getDefaultReportButton();
                    paymentsReport.setText("Payments Summary");
                    controller.addNonRecordButton(paymentsReport, "payments_summary");
                    JFXButton detailedSales = Config.getDefaultReportButton();
                    detailedSales.setText("Detailed Sales");
                    controller.addNonRecordButton(detailedSales, "detailed_sales");
                    JFXButton detailedPayments = Config.getDefaultReportButton();
                    detailedPayments.setText("Detailed Payments");
                    controller.addNonRecordButton(detailedPayments, "detailed_payments");
                    controller.setModality(Modality.WINDOW_MODAL);
                    itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                    this.holderVbox.getChildren().clear();
                    this.holderVbox.getChildren().add((Object)itemPane);
                }
                catch (Exception y) {
                    y.printStackTrace();
                }
            } else if (value.equalsIgnoreCase("Posted Express Sale")) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                    GeneralListController controller = (GeneralListController)loader.getController();
                    controller.setUser(this.getUser());
                    controller.setObject(SalesHeader[].class);
                    controller.setSearchPromptText("Search by location, item or description");
                    Type listType = new TypeToken<ArrayList<SalesHeader>>(){}.getType();
                    controller.setListType(listType);
                    controller.addTableColumn("Code", "doc_no", 0.1);
                    controller.addTableColumn("Sale Date", "sales_date", 0.15);
                    controller.addTableColumn("Location", "location", 0.15);
                    controller.addTableColumn("Customer Name", "customerName", 0.15);
                    controller.addTableColumn("CustomerPin", "customerPin", 0.15);
                    controller.addTableColumn("Total", "totalAmountString", 0.15);
                    controller.showDatesFilters(7);
                    controller.setDataUrl("masterfetch?type=salesheader");
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("posted", 1);
                    params.put("reversed", 0);
                    params.put("status", "Approved");
                    params.put("documentType", AddExpressSale.DOCUMENT_TYPE);
                    controller.setType("expresssale");
                    controller.setDataParams(params);
                    controller.setNewRecordText("New Sale");
                    controller.setEditRecordText("Edit Sale");
                    controller.setDeleteRecordText("Delete Sale");
                    controller.setNewRecordEnabled(false);
                    controller.setDeleteRecordEnabled(false);
                    controller.setEditRecordEnabled(true);
                    controller.setNewRecordResizable(false);
                    controller.showNavigatePosting();
                    if (Config.ERP_MODE || this.user.getUserName().equalsIgnoreCase("victor")) {
                        JFXButton expresSale = Config.getDefaultReportButton();
                        expresSale.setText("Receipt");
                        controller.addRecordButton(expresSale, "expresssale");
                        JFXButton a4Receipt = Config.getDefaultReportButton();
                        a4Receipt.setText("A4 Receipt");
                        controller.addRecordButton(a4Receipt, "a4_receipt");
                        JFXButton salesSummary = Config.getDefaultReportButton();
                        salesSummary.setText("Distributor Sales Summary");
                        controller.addNonRecordButton(salesSummary, "distributor_sales_summary");
                    }
                    JFXButton salesSummary = Config.getDefaultReportButton();
                    salesSummary.setText("Sales Summary");
                    controller.addNonRecordButton(salesSummary, "sales_summary");
                    JFXButton paymentsReport = Config.getDefaultReportButton();
                    paymentsReport.setText("Payments Summary");
                    controller.addNonRecordButton(paymentsReport, "payments_summary");
                    JFXButton detailedSales = Config.getDefaultReportButton();
                    detailedSales.setText("Detailed Sales");
                    controller.addNonRecordButton(detailedSales, "detailed_sales");
                    JFXButton detailedPayments = Config.getDefaultReportButton();
                    detailedPayments.setText("Detailed Payments");
                    controller.addNonRecordButton(detailedPayments, "detailed_payments");
                    controller.setModality(Modality.WINDOW_MODAL);
                    itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                    this.holderVbox.getChildren().clear();
                    this.holderVbox.getChildren().add((Object)itemPane);
                }
                catch (Exception y) {
                    y.printStackTrace();
                }
            } else if (value.equalsIgnoreCase("Reversed Express Sale")) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                    GeneralListController controller = (GeneralListController)loader.getController();
                    controller.setUser(this.getUser());
                    controller.setObject(ExpressSale[].class);
                    controller.setSearchPromptText("Search by location, item or description");
                    Type listType = new TypeToken<ArrayList<ExpressSale>>(){}.getType();
                    controller.setListType(listType);
                    controller.addTableColumn("Code", "code", 0.1);
                    controller.addTableColumn("Sale Date", "saleDate", 0.15);
                    controller.addTableColumn("Location", "location", 0.15);
                    controller.addTableColumn("Bank", "bank", 0.15);
                    controller.addTableColumn("Total", "totalString", 0.15);
                    controller.setDataUrl("masterfetch?type=expresssale");
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("posted", 1);
                    params.put("reversed", 1);
                    controller.setDataParams(params);
                    controller.setNewRecordText("New Sale");
                    controller.setEditRecordText("Edit Sale");
                    controller.setDeleteRecordText("Delete Sale");
                    controller.setType("expresssale");
                    controller.setEditRecordText("Edit Sale");
                    controller.setNewRecordEnabled(false);
                    controller.setDeleteRecordEnabled(false);
                    controller.setEditRecordEnabled(true);
                    controller.setNewRecordResizable(false);
                    controller.setModality(Modality.WINDOW_MODAL);
                    itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                    JFXButton salesSummary = Config.getDefaultReportButton();
                    salesSummary.setText("Sales Summary");
                    controller.addNonRecordButton(salesSummary, "sales_summary");
                    JFXButton paymentsReport = Config.getDefaultReportButton();
                    paymentsReport.setText("Payments Summary");
                    controller.addNonRecordButton(paymentsReport, "payments_summary");
                    this.holderVbox.getChildren().clear();
                    this.holderVbox.getChildren().add((Object)itemPane);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (value.equalsIgnoreCase("Item Posting Group")) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                    GeneralListController controller = (GeneralListController)loader.getController();
                    controller.setUser(this.getUser());
                    controller.setObject(PostingGroup[].class);
                    controller.setSearchPromptText("Search by Id, name, Inventory GL, COG GL or Revenue GL");
                    Type listType = new TypeToken<ArrayList<PostingGroup>>(){}.getType();
                    controller.setListType(listType);
                    controller.addTableColumn("Id", "code", 0.05);
                    controller.addTableColumn("Name", "name", 0.15);
                    controller.addTableColumn("Inventory GL", "account", 0.2);
                    controller.addTableColumn("COG GL", "COGAccount", 0.2);
                    controller.addTableColumn("Revenue GL", "revenueAccount", 0.2);
                    controller.addTableColumn("No. of Items", "recordsCount", 0.2);
                    controller.setDataUrl("masterfetch?type=postinggroups");
                    JFXButton bankStatement = Config.getDefaultReportButton();
                    bankStatement.setText("Trading Account");
                    controller.addRecordButton(bankStatement, "tradingaccount");
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("category", 3);
                    controller.setDataParams(params);
                    controller.setNewRecordText("New Posting Group");
                    controller.setEditRecordText("Edit Posting Group");
                    controller.setDeleteRecordText("Delete Posting Group");
                    controller.setType("itemspostinggroup");
                    controller.setNewRecordEnabled(true);
                    controller.setDeleteRecordEnabled(true);
                    controller.setEditRecordEnabled(true);
                    controller.setNewRecordResizable(false);
                    controller.setModality(Modality.WINDOW_MODAL);
                    itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                    this.holderVbox.getChildren().clear();
                    this.holderVbox.getChildren().add((Object)itemPane);
                }
                catch (Exception y) {
                    y.printStackTrace();
                }
            } else if (value.equalsIgnoreCase("Messages")) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                    GeneralListController controller = (GeneralListController)loader.getController();
                    controller.setUser(this.getUser());
                    controller.setObject(Sms[].class);
                    controller.setSearchPromptText("Search by recipient name or message");
                    Type listType = new TypeToken<ArrayList<Sms>>(){}.getType();
                    controller.setListType(listType);
                    controller.addTableColumn("Recipient", "name", 0.3);
                    controller.addTableColumn("Number", "number", 0.1);
                    controller.addTableColumn("Message", "message", 0.3);
                    controller.addTableColumn("Status", "status", 0.1);
                    controller.addTableColumn("Entered On", "enteredOn", 0.2);
                    controller.setDataUrl("masterfetch?type=sms");
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("status", "saved");
                    controller.setDataParams(params);
                    controller.setNewRecordText("Compose");
                    controller.setEditRecordText("Edit Sms");
                    controller.setDeleteRecordText("Delete Sms");
                    controller.setType("sms");
                    controller.setEditRecordText("Edit Message");
                    controller.setNewRecordEnabled(true);
                    controller.setDeleteRecordEnabled(true);
                    controller.setEditRecordEnabled(true);
                    controller.setNewRecordResizable(false);
                    controller.setModality(Modality.WINDOW_MODAL);
                    itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                    this.holderVbox.getChildren().clear();
                    this.holderVbox.getChildren().add((Object)itemPane);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (value.equalsIgnoreCase("Sent Messages")) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                    GeneralListController controller = (GeneralListController)loader.getController();
                    controller.setUser(this.getUser());
                    controller.setObject(Sms[].class);
                    controller.setSearchPromptText("Search by recipient name or message");
                    Type listType = new TypeToken<ArrayList<Sms>>(){}.getType();
                    controller.setListType(listType);
                    controller.addTableColumn("Recipient", "name", 0.3);
                    controller.addTableColumn("Number", "number", 0.1);
                    controller.addTableColumn("Message", "message", 0.3);
                    controller.addTableColumn("Status", "status", 0.1);
                    controller.addTableColumn("Sent On", "sentOn", 0.2);
                    controller.setDataUrl("masterfetch?type=sms");
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("status", "sent");
                    controller.setDataParams(params);
                    controller.setNewRecordText("Compose");
                    controller.setEditRecordText("View Sms");
                    controller.setDeleteRecordText("Delete Sms");
                    controller.setType("sms");
                    controller.setEditRecordText("View Message");
                    controller.setNewRecordEnabled(false);
                    controller.setDeleteRecordEnabled(false);
                    controller.setEditRecordEnabled(true);
                    controller.setNewRecordResizable(false);
                    controller.setModality(Modality.WINDOW_MODAL);
                    itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                    this.holderVbox.getChildren().clear();
                    this.holderVbox.getChildren().add((Object)itemPane);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (value.equalsIgnoreCase("Contacts")) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                    GeneralListController controller = (GeneralListController)loader.getController();
                    controller.setUser(this.getUser());
                    controller.setObject(Contact[].class);
                    controller.setSearchPromptText("Search by name or number");
                    Type listType = new TypeToken<ArrayList<Contact>>(){}.getType();
                    controller.setListType(listType);
                    controller.addTableColumn("Recipient Id", "id", 0.2);
                    controller.addTableColumn("Recipient Name", "name", 0.5);
                    controller.addTableColumn("Number", "phoneNumber", 0.3);
                    controller.setDataUrl("masterfetch?type=contact");
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    controller.setDataParams(params);
                    controller.setNewRecordText("Add Contact");
                    controller.setEditRecordText("Edit Contact");
                    controller.setDeleteRecordText("Delete Contact");
                    controller.setType("contact");
                    controller.setEditRecordText("Edit Contact");
                    controller.setNewRecordEnabled(true);
                    controller.setDeleteRecordEnabled(true);
                    controller.setEditRecordEnabled(true);
                    controller.setNewRecordResizable(false);
                    controller.setModality(Modality.WINDOW_MODAL);
                    itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                    this.holderVbox.getChildren().clear();
                    this.holderVbox.getChildren().add((Object)itemPane);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (value.equalsIgnoreCase("Groups")) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                    GeneralListController controller = (GeneralListController)loader.getController();
                    controller.setUser(this.getUser());
                    controller.setObject(ContactsGroup[].class);
                    controller.setSearchPromptText("Search by name ");
                    Type listType = new TypeToken<ArrayList<ContactsGroup>>(){}.getType();
                    controller.setListType(listType);
                    controller.addTableColumn("Group Id", "id", 0.3);
                    controller.addTableColumn("Group Name", "name", 0.7);
                    controller.setDataUrl("masterfetch?type=contactgroup");
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    controller.setDataParams(params);
                    controller.setNewRecordText("Add Group");
                    controller.setEditRecordText("Edit Group");
                    controller.setDeleteRecordText("Delete Group");
                    controller.setType("contactgroup");
                    controller.setEditRecordText("Edit Group");
                    controller.setNewRecordEnabled(true);
                    controller.setDeleteRecordEnabled(true);
                    controller.setEditRecordEnabled(true);
                    controller.setNewRecordResizable(false);
                    controller.setModality(Modality.WINDOW_MODAL);
                    itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                    this.holderVbox.getChildren().clear();
                    this.holderVbox.getChildren().add((Object)itemPane);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (value.equalsIgnoreCase("Open Journals")) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                    GeneralListController controller = (GeneralListController)loader.getController();
                    controller.setUser(this.getUser());
                    controller.setObject(Journal[].class);
                    controller.setSearchPromptText("Search by Journal No, Transaction Date or Amount ");
                    Type listType = new TypeToken<ArrayList<Journal>>(){}.getType();
                    controller.setListType(listType);
                    controller.addTableColumn("Journal No", "journalNo", 0.3);
                    controller.addTableColumn("Transaction Date", "transactionDate", 0.3);
                    controller.addTableColumn("Total Amount", "totalAmountString", 0.3);
                    controller.setDataUrl("masterfetch?type=journals");
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("posted", 0);
                    params.put("reversed", 0);
                    controller.setDataParams(params);
                    controller.setNewRecordText("New Journal");
                    controller.setEditRecordText("Edit Journal");
                    controller.setDeleteRecordText("Delete Journal");
                    controller.setType("journal");
                    controller.setNewRecordEnabled(true);
                    controller.setDeleteRecordEnabled(true);
                    controller.setEditRecordEnabled(true);
                    controller.setNewRecordResizable(true);
                    controller.setModality(Modality.WINDOW_MODAL);
                    itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                    this.holderVbox.getChildren().clear();
                    this.holderVbox.getChildren().add((Object)itemPane);
                }
                catch (Exception y) {
                    y.printStackTrace();
                }
            } else if (value.equalsIgnoreCase("Posted Journals")) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                    GeneralListController controller = (GeneralListController)loader.getController();
                    controller.setUser(this.getUser());
                    controller.setObject(Journal[].class);
                    controller.setSearchPromptText("Search by Journal No, Transaction Date or Amount ");
                    Type listType = new TypeToken<ArrayList<Journal>>(){}.getType();
                    controller.setListType(listType);
                    controller.addTableColumn("Journal No", "journalNo", 0.3);
                    controller.addTableColumn("Transaction Date", "transactionDate", 0.3);
                    controller.addTableColumn("Total Amount", "totalAmountString", 0.3);
                    controller.setDataUrl("masterfetch?type=journals");
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("posted", 1);
                    params.put("reversed", 0);
                    controller.setDataParams(params);
                    controller.setNewRecordText("New Journal");
                    controller.setEditRecordText("Edit Journal");
                    controller.setDeleteRecordText("Delete Journal");
                    controller.setType("journal");
                    controller.setNewRecordEnabled(false);
                    controller.setDeleteRecordEnabled(false);
                    controller.setEditRecordEnabled(true);
                    controller.setNewRecordResizable(true);
                    controller.setModality(Modality.WINDOW_MODAL);
                    itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                    this.holderVbox.getChildren().clear();
                    this.holderVbox.getChildren().add((Object)itemPane);
                }
                catch (Exception y) {
                    y.printStackTrace();
                }
            } else if (value.equalsIgnoreCase("Reversed Journals")) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                    GeneralListController controller = (GeneralListController)loader.getController();
                    controller.setUser(this.getUser());
                    controller.setObject(Journal[].class);
                    controller.setSearchPromptText("Search by Journal No, Transaction Date or Amount ");
                    Type listType = new TypeToken<ArrayList<Journal>>(){}.getType();
                    controller.setListType(listType);
                    controller.addTableColumn("Journal No", "journalNo", 0.3);
                    controller.addTableColumn("Transaction Date", "transactionDate", 0.3);
                    controller.addTableColumn("Total Amount", "totalAmountString", 0.3);
                    controller.setDataUrl("masterfetch?type=journals");
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("posted", 1);
                    params.put("reversed", 1);
                    controller.setDataParams(params);
                    controller.setNewRecordText("New Journal");
                    controller.setEditRecordText("Edit Journal");
                    controller.setDeleteRecordText("Delete Journal");
                    controller.setType("journal");
                    controller.setNewRecordEnabled(false);
                    controller.setDeleteRecordEnabled(false);
                    controller.setEditRecordEnabled(true);
                    controller.setNewRecordResizable(true);
                    controller.setModality(Modality.WINDOW_MODAL);
                    itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                    this.holderVbox.getChildren().clear();
                    this.holderVbox.getChildren().add((Object)itemPane);
                }
                catch (Exception y) {
                    y.printStackTrace();
                }
            } else if (value.equalsIgnoreCase("Communication Channels")) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/generallist.fxml").openStream());
                    GeneralListController controller = (GeneralListController)loader.getController();
                    controller.setUser(this.getUser());
                    controller.setObject(StaffLoan[].class);
                    controller.setSearchPromptText("Search...");
                    Type listType = new TypeToken<ArrayList<StaffLoan>>(){}.getType();
                    controller.setListType(listType);
                    controller.addTableColumn("Id", "id", 0.2);
                    controller.addTableColumn("Employee", "employee", 0.4);
                    controller.addTableColumn("Amount", "amountString", 0.2);
                    controller.addTableColumn("Monthly Repayments", "monthlyRepayment", 0.2);
                    controller.setDataUrl("masterfetch?type=staffloans");
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("posted", 1);
                    params.put("reversed", 1);
                    params.put("caretaker", 1);
                    controller.setType("communicationchannels");
                    controller.setDataParams(params);
                    controller.setNewRecordText("New Channel");
                    controller.setEditRecordText("Edit Channel");
                    controller.setDeleteRecordText("Delete Channel");
                    controller.setNewRecordEnabled(true);
                    controller.setDeleteRecordEnabled(false);
                    controller.setEditRecordEnabled(true);
                    controller.setNewRecordResizable(false);
                    controller.setModality(Modality.WINDOW_MODAL);
                    itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                    this.holderVbox.getChildren().clear();
                    this.holderVbox.getChildren().add((Object)itemPane);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (value.equalsIgnoreCase("Payroll Setups")) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/payroll_setups.fxml").openStream());
                    PayrollSetups controller = (PayrollSetups)loader.getController();
                    controller.setUser(this.getUser());
                    itemPane.prefHeightProperty().bind((ObservableValue)this.holderVbox.heightProperty().subtract(20));
                    this.holderVbox.getChildren().clear();
                    this.holderVbox.getChildren().add((Object)itemPane);
                }
                catch (Exception y) {
                    y.printStackTrace();
                }
            } else if (!value.equalsIgnoreCase("System Messages")) {
                // empty if block
            }
        }
    }
}

