/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.User;
import classes.VehicleImport;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.AllVehiclesController;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;

public class ConfirmVehiclestoImport
implements Initializable {
    private User user;
    private ObservableList<VehicleImport> dataSource;
    @FXML
    private AnchorPane holder;
    @FXML
    private TableView<VehicleImport> vehiclesToImport;
    @FXML
    private TableColumn colRegNo;
    @FXML
    private TableColumn colFleetNo;
    @FXML
    private TableColumn colMemberNo;
    @FXML
    private TableColumn colOwner;
    @FXML
    private TableColumn colMake;
    @FXML
    private TableColumn colModel;
    @FXML
    private TableColumn colAlias;
    @FXML
    private ProgressBar progress;
    @FXML
    private JFXButton importVehicles;
    @FXML
    private JFXButton cancel;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ObservableList<VehicleImport> getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ObservableList<VehicleImport> dataSource) {
        this.dataSource = dataSource;
        this.vehiclesToImport.setItems(dataSource);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.colRegNo.setCellValueFactory((Callback)new PropertyValueFactory("regNo"));
        this.colFleetNo.setCellValueFactory((Callback)new PropertyValueFactory("fleetNumber"));
        this.colMemberNo.setCellValueFactory((Callback)new PropertyValueFactory("memberNo"));
        this.colOwner.setCellValueFactory((Callback)new PropertyValueFactory("memberName"));
        this.colMake.setCellValueFactory((Callback)new PropertyValueFactory("vehicleMake"));
        this.colModel.setCellValueFactory((Callback)new PropertyValueFactory("vehicleModel"));
        this.colAlias.setCellValueFactory((Callback)new PropertyValueFactory("alias \n"));
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.importVehicles.setOnAction(e -> {
            this.notificationPane.setGraphic((Node)new ProgressIndicator());
            this.notificationPane.setText("Validating your data. Please wait...");
            this.notificationPane.show();
            this.startTask();
        });
    }

    public void startTask() {
        this.notificationPane.setText("Importing vehicles. Please wait...");
        this.notificationPane.show();
        Task<Void> task = new Task<Void>(){

            public Void call() throws InterruptedException {
                ObservableList myImports = ConfirmVehiclestoImport.this.vehiclesToImport.getItems();
                Gson g = new Gson();
                try {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Gson g = new Gson();
                                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                String response2 = Config.loadDataFromPhp("mastercreate?type=importvehicles", params, ConfirmVehiclestoImport.this.getUser());
                                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                                if (myResponse.isStatus()) {
                                    AllVehiclesController.confirmImport.close();
                                } else {
                                    ConfirmVehiclestoImport.this.notificationPane.setText(myResponse.getMessage());
                                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TIMES);
                                    icon.setStyle("-fx-fill: #d32f2f;");
                                    icon.setSize("24.0");
                                    ConfirmVehiclestoImport.this.notificationPane.setGraphic((Node)icon);
                                }
                            }
                            catch (Exception o) {
                                ConfirmVehiclestoImport.this.notificationPane.setText("We encountered an error while importing your vehicle list. Please try again later. ");
                                FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
                                icon.setStyle("-fx-fill: #d32f2f;");
                                icon.setSize("24.0");
                                ConfirmVehiclestoImport.this.notificationPane.setGraphic((Node)icon);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task);
        backgroundThread.setDaemon(true);
        this.progress.progressProperty().bind((ObservableValue)task.progressProperty());
        backgroundThread.start();
    }
}

