/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.LoanImport;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.LoansRegister;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;

public class ConfirmLoanImport
implements Initializable {
    private User user;
    @FXML
    private AnchorPane holder;
    @FXML
    private TableView<LoanImport> loansToImport;
    @FXML
    private TableColumn colLoanNo;
    @FXML
    private TableColumn colMemberNumber;
    @FXML
    private TableColumn colMemberName;
    @FXML
    private TableColumn colDate;
    @FXML
    private TableColumn colPrincipal;
    @FXML
    private TableColumn colAmountPaid;
    @FXML
    private TableColumn issuedOn;
    @FXML
    private TableColumn colInterest;
    @FXML
    private TableColumn colPenalty;
    @FXML
    private TableColumn colPrincipalPaid;
    @FXML
    private TableColumn colInterestPaid;
    @FXML
    private ProgressBar progress;
    @FXML
    private JFXButton importLoans;
    @FXML
    private JFXButton cancel;
    @FXML
    private NotificationPane notificationPane;
    ObservableList<LoanImport> dataSource;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public ObservableList<LoanImport> getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(ObservableList<LoanImport> dataSource) {
        this.dataSource = dataSource;
        this.loansToImport.setItems(dataSource);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.colLoanNo.setCellValueFactory((Callback)new PropertyValueFactory("loanNo"));
        this.colMemberNumber.setCellValueFactory((Callback)new PropertyValueFactory("memberNo"));
        this.colMemberName.setCellValueFactory((Callback)new PropertyValueFactory("memberName"));
        this.colDate.setCellValueFactory((Callback)new PropertyValueFactory("date"));
        this.colPrincipal.setCellValueFactory((Callback)new PropertyValueFactory("principal"));
        this.colAmountPaid.setCellValueFactory((Callback)new PropertyValueFactory("amountPaid"));
        this.colInterest.setCellValueFactory((Callback)new PropertyValueFactory("interest"));
        this.colPenalty.setCellValueFactory((Callback)new PropertyValueFactory("penalty"));
        this.colPrincipalPaid.setCellValueFactory((Callback)new PropertyValueFactory("principalPaid"));
        this.colInterestPaid.setCellValueFactory((Callback)new PropertyValueFactory("interestPaid"));
        this.issuedOn.setCellValueFactory((Callback)new PropertyValueFactory("issuedOn"));
        this.importLoans.setOnAction(e -> {
            this.notificationPane.setGraphic((Node)new ProgressIndicator());
            this.notificationPane.setText("Validating your data. Please wait...");
            this.notificationPane.show();
            this.startTask();
        });
    }

    public void startTask() {
        Task<Void> task = new Task<Void>(){

            public Void call() throws InterruptedException {
                ObservableList myImports = ConfirmLoanImport.this.loansToImport.getItems();
                Gson g = new Gson();
                try {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ConfirmLoanImport.this.notificationPane.setText("Importing loans. Please wait...");
                            ConfirmLoanImport.this.notificationPane.show();
                            try {
                                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                                Gson g = new Gson();
                                String response2 = Config.loadDataFromPhp("mastercreate?type=importloans", params, ConfirmLoanImport.this.getUser());
                                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                                if (myResponse.isStatus()) {
                                    LoansRegister.confirmImport.close();
                                } else {
                                    ConfirmLoanImport.this.notificationPane.setText(myResponse.getMessage());
                                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TIMES);
                                    icon.setStyle("-fx-fill: #d32f2f;");
                                    icon.setSize("24.0");
                                    ConfirmLoanImport.this.notificationPane.setGraphic((Node)icon);
                                }
                            }
                            catch (Exception o) {
                                ConfirmLoanImport.this.notificationPane.setText("We encountered an error while importing your loans list. Please try again later. ");
                                FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
                                icon.setStyle("-fx-fill: #d32f2f;");
                                icon.setSize("24.0");
                                ConfirmLoanImport.this.notificationPane.setGraphic((Node)icon);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task);
        backgroundThread.setDaemon(true);
        this.progress.progressProperty().bind((ObservableValue)task.progressProperty());
        backgroundThread.start();
    }
}

