/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;

public class ClosingStockController
implements Initializable {
    private User user;
    private HashMap details;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label lineId;
    @FXML
    private Label productCode;
    @FXML
    private Label productName;
    @FXML
    private Label openingStock;
    @FXML
    private Label issuedStock;
    @FXML
    private Label confirmedSales;
    @FXML
    private Label sales;
    @FXML
    private TextField returnToWarehouse;
    @FXML
    private TextField closingStock;
    @FXML
    private TextField missingBottles;
    @FXML
    private Button cancel;
    @FXML
    private Button save;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public HashMap getDetails() {
        return this.details;
    }

    public void setDetails(HashMap details) {
        this.details = details;
        this.lineId.setText(details.get("lineId").toString());
        this.productCode.setText(details.get("itemNo").toString());
        this.productName.setText(details.get("description").toString());
        this.openingStock.setText(details.get("opening_stock").toString());
        this.issuedStock.setText(details.get("issued_stock").toString());
        this.confirmedSales.setText(details.get("confirmed_sales").toString());
        this.returnToWarehouse.setText(details.get("warehouse_return").toString());
        this.sales.setText(details.get("quantity").toString());
        this.closingStock.setText(details.get("closing_stock").toString());
        this.missingBottles.setText(details.get("missing_bottles").toString());
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.cancel.setOnAction(e -> ((Stage)this.cancel.getScene().getWindow()).close());
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.save.setOnAction(e -> {
            double closingQuantity = Double.parseDouble(this.closingStock.getText().trim());
            double tMissingBottles = Double.parseDouble(this.missingBottles.getText().trim());
            double wReturn = Double.parseDouble(this.returnToWarehouse.getText().trim());
            double tOpeningStock = Double.parseDouble(this.details.get("opening_stock").toString());
            double tIssuedStock = Double.parseDouble(this.details.get("issued_stock").toString());
            double tConfirmedSales = Double.parseDouble(this.details.get("confirmed_sales").toString());
            double sales = tOpeningStock + tIssuedStock - tConfirmedSales - closingQuantity - wReturn;
            try {
                HashMap details = this.getDetails();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("headerNo", details.get("header_no").toString());
                params.put("documentType", details.get("document_type").toString());
                params.put("itemType", details.get("itemType").toString());
                params.put("itemNo", details.get("itemNo").toString());
                params.put("closingStock", closingQuantity);
                params.put("missingBottles", tMissingBottles);
                params.put("quantity", sales);
                params.put("lineId", this.lineId.getText().trim());
                params.put("returnToWarehouse", wReturn);
                String response = Config.loadDataFromPhp("masterupdate?type=salesline", params, this.getUser());
                Gson g = new Gson();
                JsonResponses js = (JsonResponses)g.fromJson(response, JsonResponses.class);
                if (js.isStatus()) {
                    ((Stage)this.cancel.getScene().getWindow()).close();
                } else {
                    this.notificationPane.setText(js.getMessage());
                    this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                    this.notificationPane.show();
                }
            }
            catch (Exception u) {
                u.printStackTrace();
                this.notificationPane.setText("We encountered an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
    }
}

