/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.ChequeRegister;
import classes.Config;
import classes.Customer;
import classes.JsonResponses;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import controllers.GeneralListController;
import impl.org.controlsfx.tools.PrefixSelectionCustomizer;
import java.net.URL;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;

public class ChequeRegisterController
implements Initializable {
    private Type type;
    private User user;
    private ChequeRegister register;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private HBox entryHBox;
    @FXML
    private Label entryId;
    @FXML
    private Label drawerDraweeLabel;
    @FXML
    private ComboBox drawerDrawee;
    @FXML
    private Button searchDrawerDrawee;
    @FXML
    private TextField amount;
    @FXML
    private TextField chequeNo;
    @FXML
    private DatePicker issueDate;
    @FXML
    private DatePicker maturityDate;
    @FXML
    private HBox issuingBankHBox;
    @FXML
    private ComboBox<Bank> issuingBank;
    @FXML
    private Button bank;
    @FXML
    private Button saveChanges;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
        this.drawerDraweeLabel.setText(type.name() + ":");
        this.drawerDrawee.setPromptText(type.name());
        this.issuingBankHBox.setVisible(!this.getType().equals((Object)Type.CUSTOMER));
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        final Node original = this.searchDrawerDrawee.getGraphic();
        if (this.getType().equals((Object)Type.CUSTOMER)) {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> ChequeRegisterController.this.searchDrawerDrawee.setGraphic((Node)Config.getLoader()));
                    ObservableList<Customer> allCustomers = new Customer().getAllCustomers(ChequeRegisterController.this.getUser());
                    allCustomers.sort(Comparator.comparing(Customer::getCustomerName));
                    Platform.runLater(() -> {
                        ChequeRegisterController.this.drawerDrawee.setItems(allCustomers);
                        ChequeRegisterController.this.searchDrawerDrawee.setGraphic(original);
                        ChequeRegisterController.this.drawerDrawee.setDisable(false);
                    });
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        } else {
            Task<Void> task1 = new Task<Void>(){

                public Void call() {
                    Platform.runLater(() -> ChequeRegisterController.this.searchDrawerDrawee.setGraphic((Node)Config.getLoader()));
                    ObservableList<Vendor> allVendors = new Vendor().getAllVendors(ChequeRegisterController.this.getUser());
                    allVendors.sort(Comparator.comparing(Vendor::getName));
                    ObservableList<Bank> allBanks = Bank.getAllBanks(ChequeRegisterController.this.getUser());
                    Platform.runLater(() -> {
                        ChequeRegisterController.this.drawerDrawee.setItems(allVendors);
                        ChequeRegisterController.this.issuingBank.setItems(allBanks);
                        ChequeRegisterController.this.searchDrawerDrawee.setGraphic(original);
                        ChequeRegisterController.this.drawerDrawee.setDisable(false);
                    });
                    return null;
                }
            };
            Thread backgroundThread = new Thread((Runnable)task1);
            backgroundThread.setDaemon(true);
            backgroundThread.start();
        }
    }

    public ChequeRegister getRegister() {
        return this.register;
    }

    public void setRegister(ChequeRegister register) {
        this.register = register;
        this.entryHBox.setVisible(true);
        this.entryId.setText(register.getId() + "");
        if (this.getType().equals((Object)Type.CUSTOMER)) {
            this.drawerDrawee.setValue((Object)register.getCustomer());
        } else {
            this.drawerDrawee.setValue((Object)register.getVendor());
            this.issuingBank.setValue((Object)register.getIssuingBank());
        }
        this.amount.setText(register.getAmount() + "");
        this.chequeNo.setText(register.getChequeNo());
        this.issueDate.setValue((Object)Config.stringToLocalDate(register.getIssueDate()));
        this.maturityDate.setValue((Object)Config.stringToLocalDate(register.getMaturityDate()));
        if (register.isBanked()) {
            this.saveChanges.setDisable(true);
            this.bank.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.entryHBox.managedProperty().bind((ObservableValue)this.entryHBox.visibleProperty());
        this.issuingBankHBox.managedProperty().bind((ObservableValue)this.issuingBankHBox.visibleProperty());
        this.issueDate.setValue((Object)Config.getCurrentLocaldate());
        PrefixSelectionCustomizer.customize((ComboBox)this.drawerDrawee);
        this.saveChanges.setOnAction(e -> {
            int myId;
            int myIssuingBank = 0;
            String drawerDraweeCode = null;
            String myChequeNo = null;
            String myIssueDate = null;
            String myMaturityDate = null;
            double myAmount = 0.0;
            boolean error = false;
            String message = "";
            try {
                myId = Integer.parseInt(this.entryId.getText().trim());
            }
            catch (Exception ignored) {
                myId = 0;
            }
            try {
                myChequeNo = this.chequeNo.getText().trim();
                if (myChequeNo.length() < 4) {
                    throw new Exception();
                }
            }
            catch (Exception ignored) {
                error = true;
                message = "Please enter a valid cheque no. At least 4 characters";
            }
            try {
                myIssueDate = Config.localDateToString((LocalDate)this.issueDate.getValue());
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the issue date";
            }
            try {
                myMaturityDate = Config.localDateToString((LocalDate)this.maturityDate.getValue());
                if (((LocalDate)this.maturityDate.getValue()).isBefore(Config.getCurrentLocaldate())) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select a valid maturity date. not before today";
                }
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the maturity date";
            }
            if (this.getType().equals((Object)Type.CUSTOMER)) {
                try {
                    System.out.println("Drawe Values: " + this.drawerDrawee.getValue());
                    drawerDraweeCode = ((Customer)this.drawerDrawee.getValue()).getCustomerNumber();
                    if (drawerDraweeCode.length() < 1) {
                        throw new Exception();
                    }
                }
                catch (Exception ignored) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the customer issuing the cheque";
                }
            } else {
                try {
                    drawerDraweeCode = ((Vendor)this.drawerDrawee.getValue()).getVendorNumber();
                    if (drawerDraweeCode.length() < 1) {
                        throw new Exception();
                    }
                }
                catch (Exception ignored) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the vendor receiving the cheque";
                }
                try {
                    myIssuingBank = ((Bank)this.issuingBank.getValue()).getCode();
                    if (myIssuingBank < 1) {
                        throw new Exception();
                    }
                }
                catch (Exception ignored) {
                    error = true;
                    message = message + (message.length() > 0 ? "\n" : "");
                    message = message + "Please select the bank issuing the cheque";
                }
            }
            try {
                myAmount = Double.parseDouble(this.amount.getText().trim());
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid amount";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            } else {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("id", myId);
                params.put("drawerDraweeCode", drawerDraweeCode);
                params.put("chequeNo", myChequeNo);
                params.put("issueDate", myIssueDate);
                params.put("maturityDate", myMaturityDate);
                params.put("amount", myAmount);
                params.put("issuingBank", myIssuingBank);
                params.put("type", (Object)this.getType());
                String response = Config.loadDataFromPhp("mastercreate?type=cheque_register", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    ((Stage)this.saveChanges.getScene().getWindow()).close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
        });
        this.searchDrawerDrawee.setOnAction(e -> {
            Gson gson = new Gson();
            if (this.getType().equals((Object)Type.CUSTOMER)) {
                String response = new Config().getObjectFromSelection("customer", gson.toJson((Object)this.drawerDrawee.getItems()), this.getUser());
                Customer customer = (Customer)gson.fromJson(response, Customer.class);
                this.drawerDrawee.setValue((Object)customer);
            } else {
                String response = new Config().getObjectFromSelection("vendor", gson.toJson((Object)this.drawerDrawee.getItems()), this.getUser());
                Vendor vendor = (Vendor)gson.fromJson(response, Vendor.class);
                this.drawerDrawee.setValue((Object)vendor);
            }
        });
        this.bank.setOnAction(e -> {
            if (this.getType().equals((Object)Type.CUSTOMER)) {
                // empty if block
            }
        });
    }

    public static enum Type {
        CUSTOMER,
        VENDOR;

    }
}

