/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.Config;
import classes.JsonResponses;
import classes.Town;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.CreateGLAccount;
import controllers.ShowGLEntries;
import filterscontrollers.GLAccountFilter;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.TreeItemPropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class ChartOfAccountsController
implements Initializable {
    private User user;
    @FXML
    private TreeTableView<Account> accountsTreeView;
    @FXML
    private TreeTableColumn treeAccountNo;
    @FXML
    private TreeTableColumn treeAccountName;
    @FXML
    private TreeTableColumn treeBalance;
    @FXML
    private TreeTableColumn treeNoOfGl;
    @FXML
    private TreeTableColumn treeLastTrans;
    @FXML
    private TreeTableColumn treePostingallowed;
    @FXML
    private JFXButton newAccount;
    @FXML
    private JFXButton editAccount;
    @FXML
    private JFXButton accountStatement;
    @FXML
    private TextField search;
    @FXML
    private JFXButton clearFilter;
    @FXML
    private JFXButton showEntries;
    @FXML
    private JFXButton deleteAccount;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton blockAccount;
    @FXML
    private JFXButton unblockAccount;
    @FXML
    MaskerPane masker;
    @FXML
    StackPane stack;
    @FXML
    private NotificationPane notificationPane;
    public static NotificationPane publicNotificationPane = new NotificationPane();
    ObservableList<Account> myAccounts = FXCollections.observableArrayList();

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.loadData();
    }

    public void initialize(URL location, ResourceBundle resources) {
        publicNotificationPane = this.notificationPane;
        this.newAccount.setOnAction(e -> {
            try {
                Stage stage = new Stage();
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/newGlAccount.fxml").openStream());
                CreateGLAccount controller = (CreateGLAccount)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                scene.setOnKeyPressed(t -> {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                });
                stage.setScene(scene);
                stage.setTitle("New G/L Account");
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setOnHiding(ef -> this.loadData());
                stage.showAndWait();
            }
            catch (NullPointerException stage) {
            }
            catch (Exception i) {
                this.notificationPane.setText("We encountered an error while loading the new GL Screen. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.editAccount.setOnAction(e -> {
            try {
                Stage stage = new Stage();
                FXMLLoader loader = new FXMLLoader();
                Account account = (Account)((TreeItem)this.accountsTreeView.getSelectionModel().getSelectedItem()).getValue();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/newGlAccount.fxml").openStream());
                CreateGLAccount controller = (CreateGLAccount)loader.getController();
                controller.setGlAccount(account);
                controller.setServerUrl("masterupdate?type=glaccount");
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                scene.setOnKeyPressed(t -> {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                });
                stage.setScene(scene);
                stage.setTitle("Edit G/L Account");
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setOnHiding(ef -> this.loadData());
                stage.showAndWait();
            }
            catch (NullPointerException stage) {
            }
            catch (Exception i) {
                this.notificationPane.setText("We encountered an error while loading the edit GL Screen. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.accountStatement.setOnAction(e -> {
            try {
                Stage stage = new Stage();
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/filtersfxml/glaccountfilter.fxml").openStream());
                Scene scene = new Scene((Parent)itemPane);
                scene.setOnKeyPressed(t -> {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                });
                stage.setScene(scene);
                GLAccountFilter controller = (GLAccountFilter)loader.getController();
                Account account = (Account)((TreeItem)this.accountsTreeView.getSelectionModel().getSelectedItem()).getValue();
                controller.setAccount(account);
                controller.setUser(this.getUser());
                controller.setReportName("accountstatement");
                stage.setTitle("View G/L Account Statement");
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.showAndWait();
            }
            catch (NullPointerException t2) {
                t2.printStackTrace();
            }
            catch (Exception i) {
                i.printStackTrace();
                this.notificationPane.setText("We encountered an error while loading the G/L Account filter. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.clearFilter.setOnAction(e -> {
            this.search.setText("");
            this.loadData();
        });
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            String searchString = newValue.trim().toLowerCase();
            ObservableList allAccounts = FXCollections.observableArrayList();
            for (int b = 0; b < this.myAccounts.size(); ++b) {
                Account current = (Account)this.myAccounts.get(b);
                String accountNo = "";
                String accountName = "";
                String balance = "";
                String noGl = "";
                try {
                    accountNo = current.getAccountNumber().toLowerCase();
                }
                catch (Exception y) {
                    accountNo = "";
                }
                try {
                    accountName = current.getAccountName().toLowerCase();
                }
                catch (Exception y) {
                    accountName = "";
                }
                try {
                    balance = current.getAccountBalance() + "";
                }
                catch (Exception y) {
                    balance = "";
                }
                try {
                    noGl = current.getNoOfGlEntries() + "";
                }
                catch (Exception y) {
                    noGl = "";
                }
                if (!accountNo.contains(searchString) && !accountName.contains(searchString) && !balance.contains(searchString) && !noGl.contains(searchString)) continue;
                allAccounts.add((Object)current);
            }
        });
        this.accountsTreeView.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                this.deleteAccount.setDisable(false);
                this.showEntries.setDisable(false);
                if (((Account)newSelection.getValue()).isPostingAllowed()) {
                    this.unblockAccount.setDisable(true);
                    this.blockAccount.setDisable(false);
                } else {
                    this.unblockAccount.setDisable(false);
                    this.blockAccount.setDisable(true);
                }
            }
        });
        this.showEntries.setOnAction(e -> {
            try {
                Account account = (Account)((TreeItem)this.accountsTreeView.getSelectionModel().getSelectedItem()).getValue();
                this.showEntries(account);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.treeAccountNo.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("accountNumber"));
        this.treeAccountName.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("accountName"));
        this.treeBalance.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("accountBalanceString"));
        this.treeNoOfGl.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("noOfTransactionString"));
        this.treeLastTrans.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("lastTransactionDate"));
        this.treePostingallowed.setCellValueFactory((Callback)new TreeItemPropertyValueFactory("postingAllowed"));
        this.deleteAccount.setOnAction(e -> {
            try {
                Account y = (Account)((TreeItem)this.accountsTreeView.getSelectionModel().getSelectedItem()).getValue();
                this.deleteAccount(y.getAccountNumber());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.refresh.setOnAction(e -> this.loadData());
        this.unblockAccount.setOnAction(e -> {
            Account account = (Account)((TreeItem)this.accountsTreeView.getSelectionModel().getSelectedItem()).getValue();
            try {
                this.unBlockAccount(account);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.blockAccount.setOnAction(e -> {
            Account account = (Account)((TreeItem)this.accountsTreeView.getSelectionModel().getSelectedItem()).getValue();
            try {
                this.blockAccount(account);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    public void loadData() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                try {
                    Platform.runLater(() -> {
                        ChartOfAccountsController.this.unblockAccount.setDisable(true);
                        ChartOfAccountsController.this.blockAccount.setDisable(true);
                        ChartOfAccountsController.this.deleteAccount.setDisable(true);
                        ChartOfAccountsController.this.showEntries.setDisable(true);
                        ChartOfAccountsController.this.masker.setVisible(true);
                    });
                    String response = Config.loadDataFromPhp("masterfetch?type=chartofaccountslist", new LinkedHashMap<String, Object>(), ChartOfAccountsController.this.getUser());
                    System.out.println(response);
                    Gson gson = new Gson();
                    ObservableList tResponse = FXCollections.observableArrayList((Object[])((Object[])gson.fromJson(response, Map[].class)));
                    TreeItem coa = new TreeItem((Object)new Account("Chart of Accounts"));
                    coa.setExpanded(true);
                    Platform.runLater(() -> ChartOfAccountsController.this.accountsTreeView.setRoot(coa));
                    for (Map level1 : tResponse) {
                        String type = level1.get("type_name").toString();
                        TreeItem level1Item = new TreeItem((Object)new Account(type));
                        ObservableList categories = FXCollections.observableArrayList((Object[])((Object[])gson.fromJson(level1.get("categories").toString(), Map[].class)));
                        for (Map category : categories) {
                            TreeItem categoryItem = new TreeItem((Object)new Account(category.get("category_name").toString()));
                            categoryItem.setExpanded(true);
                            ObservableList subCategories = FXCollections.observableArrayList((Object[])((Object[])gson.fromJson(category.get("subCategories").toString(), Map[].class)));
                            for (Map subCategory : subCategories) {
                                TreeItem subCategoryItem = new TreeItem((Object)new Account(subCategory.get("sub_category_name").toString()));
                                subCategoryItem.setExpanded(true);
                                ObservableList groups = FXCollections.observableArrayList((Object[])((Object[])gson.fromJson(subCategory.get("groups").toString(), Map[].class)));
                                for (Map group : groups) {
                                    TreeItem groupItem = new TreeItem((Object)new Account(group.get("name").toString()));
                                    groupItem.setExpanded(true);
                                    ObservableList groupAccounts = FXCollections.observableArrayList((Object[])((Object[])gson.fromJson(group.get("accounts").toString(), Account[].class)));
                                    for (Account tAccount : groupAccounts) {
                                        groupItem.getChildren().add((Object)new TreeItem((Object)tAccount));
                                    }
                                    subCategoryItem.getChildren().add((Object)groupItem);
                                }
                                ObservableList subCategoryAccounts = FXCollections.observableArrayList((Object[])((Object[])gson.fromJson(subCategory.get("accounts").toString(), Account[].class)));
                                for (Account tAccount : subCategoryAccounts) {
                                    subCategoryItem.getChildren().add((Object)new TreeItem((Object)tAccount));
                                }
                                categoryItem.getChildren().add((Object)subCategoryItem);
                            }
                            ObservableList categoryAccounts = FXCollections.observableArrayList((Object[])((Object[])gson.fromJson(category.get("accounts").toString(), Account[].class)));
                            for (Account tAccount : categoryAccounts) {
                                categoryItem.getChildren().add((Object)new TreeItem((Object)tAccount));
                            }
                            level1Item.getChildren().add((Object)categoryItem);
                        }
                        ObservableList level1Accounts = FXCollections.observableArrayList((Object[])((Object[])gson.fromJson(level1.get("accounts").toString(), Account[].class)));
                        for (Account tAccount : level1Accounts) {
                            level1Item.getChildren().add((Object)new TreeItem((Object)tAccount));
                        }
                        level1Item.setExpanded(true);
                        coa.getChildren().add((Object)level1Item);
                    }
                    Platform.runLater(() -> ChartOfAccountsController.this.masker.setVisible(false));
                }
                catch (Exception ty) {
                    ty.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void blockAccount(Account account) {
        this.updateAccount(account.getAccountNumber(), false);
    }

    public void unBlockAccount(Account account) {
        this.updateAccount(account.getAccountNumber(), true);
    }

    public void updateAccount(String accountNumber, boolean newStatus) {
        try {
            this.notificationPane.hide();
            boolean oldStatus = !newStatus;
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("accountNumber", accountNumber);
            params.put("currentStatus", oldStatus);
            params.put("newStatus", newStatus);
            String response = Config.loadDataFromPhp("masterupdate?type=chartofaccounts", params, this.getUser());
            Gson g = new Gson();
            JsonResponses response2 = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (response2.isStatus()) {
                this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                this.notificationPane.setText(response2.getMessage());
                this.notificationPane.show();
                this.loadData();
            } else {
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.setText(response2.getMessage());
                this.notificationPane.show();
            }
        }
        catch (Exception y) {
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.setText("We experienced an error while trying to update the chart of accounts. Please try again.");
            this.notificationPane.show();
        }
    }

    public void deleteAccount(String aNumber) {
        try {
            this.notificationPane.hide();
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("accountNumber", aNumber);
            String response = Config.loadDataFromPhp("masterdelete?type=glaccount", params, this.getUser());
            Gson g = new Gson();
            JsonResponses response2 = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (response2.isStatus()) {
                this.notificationPane.setGraphic((Node)Config.getCheckIcon());
                this.notificationPane.setText(response2.getMessage());
                this.notificationPane.show();
                this.loadData();
            } else {
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.setText(response2.getMessage());
                this.notificationPane.show();
            }
        }
        catch (Exception y) {
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.setText("We experienced an error while trying to delete the account. Please try again.");
            this.notificationPane.show();
        }
    }

    public void showEntries(Account account) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox entriesPane = (VBox)loader.load(this.getClass().getResource("/fxml/glentries.fxml").openStream());
            Scene scene = new Scene((Parent)entriesPane, 1375.0, 652.0);
            ShowGLEntries controller = (ShowGLEntries)loader.getController();
            controller.setUser(this.getUser());
            controller.setGlAccount(account);
            final Stage stage = new Stage();
            scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(scene);
            stage.setTitle("Show Entries");
            stage.show();
        }
        catch (Exception j) {
            j.printStackTrace();
        }
    }

    public void showEntries(Account account, LocalDate startDate, LocalDate endDate, ObservableList<Town> allTowns, String office, String addedBy, User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox entriesPane = (VBox)loader.load(this.getClass().getResource("/fxml/glentries.fxml").openStream());
            Scene scene = new Scene((Parent)entriesPane, 1375.0, 652.0);
            ShowGLEntries controller = (ShowGLEntries)loader.getController();
            controller.setUser(user);
            controller.setStartDate(startDate);
            controller.setEndDate(endDate);
            controller.setGlAccount(account);
            final Stage stage = new Stage();
            scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(scene);
            stage.setTitle("Show Entries");
            stage.show();
        }
        catch (Exception j) {
            j.printStackTrace();
        }
    }
}

