/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.ChargeItem;
import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.ChargeItemController;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class ChargeItemsController
implements Initializable {
    private User user;
    private int category;
    ObservableList<ChargeItem> toSearch = FXCollections.observableArrayList();
    @FXML
    private JFXButton addChargeItem;
    @FXML
    private JFXButton editChargeItem;
    @FXML
    private JFXButton deleteChargeItem;
    @FXML
    private JFXButton refresh;
    @FXML
    private MaskerPane masker;
    @FXML
    private TableView<ChargeItem> allChargeItems;
    @FXML
    private TableColumn code;
    @FXML
    private TableColumn description;
    @FXML
    private TableColumn glAccount;
    @FXML
    private TableColumn taxable;
    @FXML
    private TableColumn taxRate;
    @FXML
    private TableColumn colAmount;
    @FXML
    private TextField search;
    @FXML
    StackPane holder;
    @FXML
    private JFXButton clearFilter;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getCategory() {
        return this.category;
    }

    public void setCategory(int category) {
        this.category = category;
        this.loadChargeItems();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.code.setCellValueFactory((Callback)new PropertyValueFactory("code"));
        this.description.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.glAccount.setCellValueFactory((Callback)new PropertyValueFactory("account"));
        this.taxable.setCellValueFactory((Callback)new PropertyValueFactory("taxableString"));
        this.taxRate.setCellValueFactory((Callback)new PropertyValueFactory("taxRate"));
        this.colAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.addChargeItem.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/chargeItem.fxml").openStream());
                Scene scene = new Scene((Parent)itemPane, itemPane.getPrefWidth(), itemPane.getPrefHeight());
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                ChargeItemController controller = (ChargeItemController)loader.getController();
                controller.setUser(this.getUser());
                controller.setCategory(this.getCategory());
                stage.setTitle("Add Charge Item");
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ChargeItemsController.this.loadChargeItems();
                            }
                        });
                    }
                });
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your add charge item screen. Please contact support");
                alert.showAndWait();
            }
        });
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            ObservableList afterSearch = FXCollections.observableArrayList();
            for (int b = 0; b < this.toSearch.size(); ++b) {
                ChargeItem current = (ChargeItem)this.toSearch.get(b);
                String tCode = current.getCode() + "";
                String tTaxRate = current.getTaxRate() + "";
                if (!tCode.contains(newValue.toLowerCase()) && !tTaxRate.contains(newValue.toLowerCase()) && !current.getName().toLowerCase().contains(newValue.toLowerCase()) && !current.getAccount().getAccountName().toLowerCase().contains(newValue.toLowerCase())) continue;
                afterSearch.add((Object)current);
            }
            this.allChargeItems.getItems().removeAll((Collection)this.allChargeItems.getItems());
            this.allChargeItems.setItems(afterSearch);
        });
        this.clearFilter.setOnAction(e -> {
            this.search.setText("");
            this.loadChargeItems();
        });
        this.editChargeItem.setOnAction(e -> {
            try {
                ChargeItem chargeItem = (ChargeItem)this.allChargeItems.getSelectionModel().getSelectedItem();
                chargeItem.getCode();
                this.editChargeItem(chargeItem);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.allChargeItems.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    ChargeItem rowData = (ChargeItem)row.getItem();
                    ChargeItem chargeItem = (ChargeItem)this.allChargeItems.getSelectionModel().getSelectedItem();
                    if (!chargeItem.equals(null)) {
                        this.editChargeItem(chargeItem);
                    }
                }
            });
            return row;
        });
        this.refresh.setOnAction(e -> this.loadChargeItems());
        this.deleteChargeItem.setOnAction(e -> {
            try {
                ChargeItem cI = (ChargeItem)this.allChargeItems.getSelectionModel().getSelectedItem();
                int code = cI.getCode();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("code", code);
                try {
                    String response = Config.loadDataFromPhp("masterdelete?type=chargeitem", params, this.getUser());
                    Gson g = new Gson();
                    JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        this.loadChargeItems();
                    }
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
                catch (Exception y) {
                    this.notificationPane.setText("We experienced an error while deleting the charge item. Please try again later");
                    this.notificationPane.setGraphic((Node)Config.getBanIcon());
                    this.notificationPane.show();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void loadChargeItems() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                try {
                    Platform.runLater(() -> ChargeItemsController.this.masker.setVisible(true));
                    ChargeItemsController.this.allChargeItems.setItems(new ChargeItem().getChargeItems(ChargeItemsController.this.getCategory(), ChargeItemsController.this.getUser()));
                    ChargeItemsController.this.toSearch = new ChargeItem().getChargeItems(ChargeItemsController.this.getCategory(), ChargeItemsController.this.getUser());
                    Platform.runLater(() -> ChargeItemsController.this.masker.setVisible(false));
                }
                catch (Exception ty) {
                    ty.printStackTrace();
                }
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void editChargeItem(ChargeItem chargeItem) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/chargeItem.fxml").openStream());
            Scene scene = new Scene((Parent)itemPane, itemPane.getPrefWidth(), itemPane.getPrefHeight());
            final Stage stage = new Stage();
            scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(scene);
            ChargeItemController controller = (ChargeItemController)loader.getController();
            controller.setUser(this.getUser());
            controller.setCategory(this.getCategory());
            controller.setChargeItem(chargeItem);
            stage.setTitle("Edit Charge Item");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ChargeItemsController.this.loadChargeItems();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit charge item screen. Please contact support");
            alert.showAndWait();
        }
    }
}

