/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.CashWithdrawal;
import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.WithdrawCashController;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class CashWithdrawalsController
implements Initializable {
    private User user;
    private boolean reversed;
    private boolean posted;
    ObservableList<CashWithdrawal> toSearch = FXCollections.observableArrayList();
    @FXML
    private StackPane stackPane;
    @FXML
    private VBox root;
    @FXML
    private JFXButton newVoucher;
    @FXML
    private JFXButton editVoucher;
    @FXML
    private JFXButton deleteVoucher;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton viewVoucher;
    @FXML
    private JFXButton allVouchersReport;
    @FXML
    private TextField search;
    @FXML
    private JFXButton clearFilter;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private MaskerPane maskerPane;
    @FXML
    private TableView<CashWithdrawal> allVouchers;
    @FXML
    private TableColumn colVoucherNo;
    @FXML
    private TableColumn colDate;
    @FXML
    private TableColumn colBank;
    @FXML
    private TableColumn colMemberNo;
    @FXML
    private TableColumn colMemberName;
    @FXML
    private TableColumn colAmount;
    @FXML
    private TableColumn colChequeNo;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
        this.loadItems();
        if (posted) {
            this.deleteVoucher.setDisable(true);
            this.newVoucher.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane.setContent((Node)this.stackPane);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.setCloseButtonVisible(true);
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.colVoucherNo.setCellValueFactory((Callback)new PropertyValueFactory("voucherNo"));
        this.colBank.setCellValueFactory((Callback)new PropertyValueFactory("bank"));
        this.colMemberNo.setCellValueFactory((Callback)new PropertyValueFactory("memberNo"));
        this.colMemberName.setCellValueFactory((Callback)new PropertyValueFactory("member"));
        this.colAmount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.colChequeNo.setCellValueFactory((Callback)new PropertyValueFactory("chequeNo"));
        this.colDate.setCellValueFactory((Callback)new PropertyValueFactory("withdrawalDate"));
        this.refresh.setOnAction(e -> this.loadItems());
        this.clearFilter.setOnAction(e -> {
            this.search.setText("");
            this.loadItems();
        });
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            ObservableList afterSearch = FXCollections.observableArrayList();
            String searchString = newValue.toLowerCase();
            for (int b = 0; b < this.toSearch.size(); ++b) {
                CashWithdrawal current = (CashWithdrawal)this.toSearch.get(b);
                String myAmount = "";
                String myAmountString = "";
                try {
                    myAmount = current.getAmount() + "";
                }
                catch (Exception r) {
                    myAmount = "0";
                }
                try {
                    myAmountString = Config.formatNumber(current.getAmount());
                }
                catch (Exception t) {
                    myAmountString = "0";
                }
                String tVoucherNo = "";
                String tBankName = "";
                String tFullName = "";
                String tMemberNumber = "";
                String tDate = "";
                String tChequeNo = "";
                try {
                    tVoucherNo = current.getVoucherNo().toLowerCase();
                }
                catch (Exception r) {
                    tVoucherNo = "";
                }
                try {
                    tChequeNo = current.getChequeNo().toLowerCase();
                }
                catch (Exception r) {
                    tChequeNo = "";
                }
                try {
                    tBankName = current.getBank().toString().toLowerCase();
                }
                catch (Exception r) {
                    tBankName = "";
                }
                try {
                    tFullName = current.getMember().getFullName().toLowerCase();
                }
                catch (Exception r) {
                    tFullName = "";
                }
                try {
                    tMemberNumber = current.getMember().getMemberNumber().toLowerCase();
                }
                catch (Exception r) {
                    tMemberNumber = "";
                }
                try {
                    tDate = current.getWithdrawalDate().toLowerCase();
                }
                catch (Exception r) {
                    tMemberNumber = "";
                }
                if (!tVoucherNo.contains(searchString) && !tBankName.contains(searchString) && !tFullName.contains(searchString) && !tMemberNumber.contains(searchString) && !myAmount.toLowerCase().contains(searchString) && !myAmountString.toLowerCase().contains(searchString) && !tDate.contains(searchString) && !tChequeNo.contains(searchString)) continue;
                afterSearch.add((Object)current);
            }
            this.allVouchers.getItems().removeAll((Collection)this.allVouchers.getItems());
            this.allVouchers.setItems(afterSearch);
        });
        this.allVouchersReport.setOnAction(e -> {
            try {
                LinkedHashMap<String, Object> dataVariables = new LinkedHashMap<String, Object>();
                dataVariables.put("posted", true);
                LinkedHashMap<String, Object> reportVariables = new LinkedHashMap<String, Object>();
                reportVariables.put("saccoName", Config.saccoName);
                new Config().getReport("Savings Withdrawal", "masterfetch?type=savingswithdrawal", dataVariables, "savingswithdrawal.jasper", reportVariables, this.getUser());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.deleteVoucher.setOnAction(e -> {
            try {
                CashWithdrawal voucher = (CashWithdrawal)this.allVouchers.getSelectionModel().getSelectedItem();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", voucher.getVoucherNo());
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterdelete?type=savingswithdrawal", params, this.getUser());
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.loadItems();
                }
                this.notificationPane.setText(myResponse.getMessage());
                this.notificationPane.setGraphic((Node)myResponse.getIconFromStatus());
                this.notificationPane.show();
            }
            catch (Exception t) {
                this.notificationPane.setText("We encountered an error while deleting the withdrawal voucher. Please try again later");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.newVoucher.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/withdrawCash.fxml").openStream());
                WithdrawCashController controller = (WithdrawCashController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("New Withdrawal Voucher");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CashWithdrawalsController.this.loadItems();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.allVouchers.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    CashWithdrawal rowData = (CashWithdrawal)row.getItem();
                    CashWithdrawal voucher = (CashWithdrawal)this.allVouchers.getSelectionModel().getSelectedItem();
                    if (!voucher.equals(null)) {
                        this.editVoucher(voucher);
                    }
                }
            });
            return row;
        });
        this.editVoucher.setOnAction(r -> {
            try {
                CashWithdrawal xm = (CashWithdrawal)this.allVouchers.getSelectionModel().getSelectedItem();
                if (!xm.equals(null) && !xm.getVoucherNo().equals("")) {
                    this.editVoucher(xm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    public void loadItems() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> CashWithdrawalsController.this.maskerPane.setVisible(true));
                ObservableList<CashWithdrawal> myVouchers = new CashWithdrawal().getAllVouchers(CashWithdrawalsController.this.isPosted(), CashWithdrawalsController.this.isReversed(), CashWithdrawalsController.this.getUser());
                CashWithdrawalsController.this.allVouchers.setItems(myVouchers);
                CashWithdrawalsController.this.toSearch = new CashWithdrawal().getAllVouchers(CashWithdrawalsController.this.isPosted(), CashWithdrawalsController.this.isReversed(), CashWithdrawalsController.this.getUser());
                Platform.runLater(() -> CashWithdrawalsController.this.maskerPane.setVisible(false));
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void editVoucher(CashWithdrawal voucher) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/withdrawCash.fxml").openStream());
            Scene scene = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(scene);
            WithdrawCashController controller = (WithdrawCashController)loader.getController();
            controller.setUser(this.getUser());
            controller.setVoucher(voucher);
            stage.setTitle("Edit Cash Withdrawal Voucher");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CashWithdrawalsController.this.loadItems();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit Cash Withdrawal voucher screen. Please contact support");
            alert.showAndWait();
        }
    }
}

