/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.BankTransfer;
import classes.Config;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class BankTransferController
implements Initializable {
    private User user;
    private BankTransfer bankTransfer;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox notificationHolder;
    @FXML
    private Label transferNo;
    @FXML
    private DatePicker transferDate;
    @FXML
    private ComboBox<Bank> transferFrom;
    @FXML
    private ComboBox<Bank> transferTo;
    @FXML
    private TextField description;
    @FXML
    private TextField transferAmount;
    @FXML
    private TextField externalRefNo;
    @FXML
    private Button cancel;
    @FXML
    private Button save;
    @FXML
    private Button post;
    @FXML
    private Button reverse;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public BankTransfer getBankTransfer() {
        return this.bankTransfer;
    }

    public void setBankTransfer(BankTransfer bankTransfer) {
        this.bankTransfer = bankTransfer;
        try {
            this.transferNo.setText(bankTransfer.getTransferNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.transferDate.setValue((Object)Config.stringToLocalDate(bankTransfer.getTransferDate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.transferFrom.setValue((Object)bankTransfer.getFromBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.transferTo.setValue((Object)bankTransfer.getToBank());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.description.setText(bankTransfer.getDescription());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.transferAmount.setText(bankTransfer.getAmount() + "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.externalRefNo.setText(bankTransfer.getExternalRefNo());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bankTransfer.isPosted()) {
            this.save.setDisable(true);
            this.post.setDisable(true);
            this.transferDate.setDisable(true);
            this.transferFrom.setDisable(true);
            this.transferTo.setDisable(true);
            this.description.setDisable(true);
            this.transferAmount.setDisable(true);
            this.externalRefNo.setDisable(true);
            this.reverse.setDisable(false);
        }
        if (bankTransfer.isReversed()) {
            this.reverse.setDisable(true);
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.transferDate.setValue((Object)Config.getCurrentLocaldate());
        Platform.runLater(() -> {
            ObservableList<Bank> allBanks = Bank.getAllBanks(this.getUser());
            this.transferFrom.setItems(allBanks);
            this.transferTo.setItems(allBanks);
        });
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.notificationHolder);
        this.transferAmount = new Config().setDoubleTextField(this.transferAmount);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator(this.transferFrom, Validator.createEmptyValidator((String)"The bank to transfer from is required"));
        vs.registerValidator(this.transferTo, Validator.createEmptyValidator((String)"The bank to transfer to is required"));
        vs.registerValidator((Control)this.transferAmount, Validator.createEmptyValidator((String)"The transfer amount is required"));
        vs.registerValidator((Control)this.transferDate, Validator.createEmptyValidator((String)"The transfer date is required"));
        vs.registerValidator((Control)this.description, Validator.createEmptyValidator((String)"The transfer description is required"));
        this.save.setOnAction(e -> this.save());
        this.cancel.setOnAction(e -> {
            Stage stage = (Stage)this.cancel.getScene().getWindow();
            stage.close();
        });
        this.post.setOnAction(e -> {
            if (this.save() && this.post()) {
                GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
                GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.post.getScene().getWindow();
                stage.close();
            }
        });
        this.reverse.setOnAction(e -> {
            if (this.reverse()) {
                GeneralListController.publicNotificationPane.setText(this.notificationPane.getText());
                GeneralListController.publicNotificationPane.setGraphic(this.notificationPane.getGraphic());
                GeneralListController.publicNotificationPane.show();
                Stage stage = (Stage)this.post.getScene().getWindow();
                stage.close();
            }
        });
    }

    public boolean save() {
        String tTransferNo = "";
        String tTransferDate = "";
        int tTransferFrom = 0;
        int tTransferTo = 0;
        double tTransferAmount = 0.0;
        String tDescription = "";
        String tExternalRefNo = "";
        boolean error = false;
        String message = "";
        boolean newTransfer = false;
        NumberSeries nb = new NumberSeries(23, this.getUser());
        try {
            tTransferNo = this.transferNo.getText().trim();
            if (tTransferNo.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            newTransfer = true;
            tTransferNo = nb.getNextNumber();
        }
        try {
            tTransferDate = Config.localDateToString((LocalDate)this.transferDate.getValue());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid value for transfer date";
        }
        try {
            tTransferFrom = ((Bank)this.transferFrom.getValue()).getCode();
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the bank account to transfer from";
        }
        try {
            tTransferTo = ((Bank)this.transferTo.getValue()).getCode();
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the bank account to transfer to";
        }
        try {
            tTransferAmount = Double.parseDouble(this.transferAmount.getText().trim());
        }
        catch (Exception t) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid value for transfer amount";
        }
        try {
            tDescription = this.description.getText().trim();
            if (tDescription.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter some description for the transfer";
        }
        try {
            tExternalRefNo = this.externalRefNo.getText().trim();
        }
        catch (Exception y) {
            error = true;
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter a valid value for external ref no";
        }
        if (error) {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("transferNo", tTransferNo);
                params.put("transferDate", tTransferDate);
                params.put("transferFrom", tTransferFrom);
                params.put("transferTo", tTransferTo);
                params.put("transferAmount", tTransferAmount);
                params.put("description", tDescription);
                params.put("externalRefNo", tExternalRefNo);
                String response = Config.loadDataFromPhp("mastercreate?type=banktranfer", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus() && newTransfer) {
                    System.out.println("Am here");
                    nb.updateLastUsed(tTransferNo);
                    this.transferNo.setText(tTransferNo);
                }
                return jr.isStatus();
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again later.");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }

    public boolean post() {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("transferNo", this.transferNo.getText().trim());
            String response = Config.loadDataFromPhp("masterpost?type=banktransfer", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        catch (Exception t) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
    }

    public boolean reverse() {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("transferNo", this.transferNo.getText().trim());
            String response = Config.loadDataFromPhp("masterpost?type=reversebanktransfer", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            return jr.isStatus();
        }
        catch (Exception t) {
            this.notificationPane.setText("We encountered an error while processing your request. Please try again");
            this.notificationPane.setGraphic((Node)Config.getBanIcon());
            this.notificationPane.show();
            return false;
        }
    }
}

