/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.Bank;
import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class BankLoanRepaymentController
implements Initializable {
    private User user;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private DatePicker repaymentDate;
    @FXML
    private ComboBox<Account> loan;
    @FXML
    private ComboBox<Bank> payingBank;
    @FXML
    private TextField transactionRef;
    @FXML
    private TextField interestAmount;
    @FXML
    private TextField principalAmount;
    @FXML
    private Hyperlink totalRepayment;
    @FXML
    private Hyperlink loanBalance;
    @FXML
    private Button createPayment;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("accountType", 1);
        params.put("accountCategory", 2);
        params.put("accountSubCategory", 4);
        params.put("accountGroup", 12);
        ObservableList<Account> allAccounts = new Account().getAccounts(user, params);
        this.loan.setItems(allAccounts);
        this.payingBank.setItems(Bank.getAllBanks(user));
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        ValidationSupport vs = new ValidationSupport();
        vs.registerValidator((Control)this.repaymentDate, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.loan, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator(this.payingBank, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.interestAmount, Validator.createEmptyValidator((String)"Required"));
        vs.registerValidator((Control)this.principalAmount, Validator.createEmptyValidator((String)"Required"));
        this.loan.setOnAction(e -> this.computeRepayment());
        this.createPayment.setOnAction(e -> {
            String tTransactionRef;
            String tRepaymentDate = "";
            String tLoanNo = "";
            double tInterest = 0.0;
            double tPrincipal = 0.0;
            int tBankCode = 0;
            boolean error = false;
            String message = "";
            try {
                tRepaymentDate = Config.localDateToString((LocalDate)this.repaymentDate.getValue());
            }
            catch (Exception ignored) {
                error = true;
                message = "Please select the repayment date";
            }
            try {
                tLoanNo = ((Account)this.loan.getValue()).getAccountNumber();
                if (tLoanNo.length() < 1) {
                    throw new Exception();
                }
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the loan account";
            }
            try {
                tTransactionRef = this.transactionRef.getText().trim();
            }
            catch (Exception ignored) {
                tTransactionRef = "";
            }
            try {
                tInterest = Double.parseDouble(this.interestAmount.getText().trim());
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid value for interest amount";
            }
            try {
                tPrincipal = Double.parseDouble(this.principalAmount.getText().trim());
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid value for principal amount";
            }
            try {
                tBankCode = ((Bank)this.payingBank.getValue()).getCode();
            }
            catch (Exception ignored) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter a valid value for paying bank";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            } else {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("repaymentDate", tRepaymentDate);
                params.put("accountNo", tLoanNo);
                params.put("transactionRef", tTransactionRef);
                params.put("interest", tInterest);
                params.put("principal", tPrincipal);
                params.put("bankCode", tBankCode);
                String response = Config.loadDataFromPhp("mastercreate?type=loan_repayment", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    ((Stage)this.createPayment.getScene().getWindow()).close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
        });
        this.interestAmount.textProperty().addListener((observable, oldValue, newValue) -> this.computeRepayment());
        this.principalAmount.textProperty().addListener((observable, oldValue, newValue) -> this.computeRepayment());
    }

    private void computeRepayment() {
        double tPrincipal;
        double tInterest;
        double mOpeningBalance = ((Account)this.loan.getValue()).getAccountBalance();
        try {
            tInterest = Double.parseDouble(this.interestAmount.getText().trim());
        }
        catch (Exception u) {
            tInterest = 0.0;
        }
        try {
            tPrincipal = Double.parseDouble(this.principalAmount.getText().trim());
        }
        catch (Exception u) {
            tPrincipal = 0.0;
        }
        this.totalRepayment.setText(Config.formatNumber(tInterest + tPrincipal));
        this.loanBalance.setText(Config.formatNumber(mOpeningBalance - tPrincipal));
    }

    public void setLoan(Account tLoan) {
        this.loan.setValue((Object)tLoan);
        this.computeRepayment();
    }
}

