/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Bank;
import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import org.controlsfx.control.NotificationPane;

public class BankDiscrepancyController
implements Initializable {
    private User user;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private VBox holder;
    @FXML
    private Label voucherNo;
    @FXML
    private DatePicker balanceDate;
    @FXML
    private ComboBox<Bank> bank;
    @FXML
    private TextField bankBalance;
    @FXML
    private Button save;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.bank.setItems(Bank.getAllBanks(user));
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.save.setOnAction(e -> {
            int bankCode = 0;
            String myDate = "";
            String message = "";
            double myBalance = 0.0;
            boolean error = false;
            try {
                bankCode = ((Bank)this.bank.getValue()).getCode();
            }
            catch (Exception i) {
                error = true;
                message = "Please select a bank";
            }
            try {
                myDate = Config.localDateToString((LocalDate)this.balanceDate.getValue());
            }
            catch (Exception i) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please select the balance date";
            }
            try {
                myBalance = Double.parseDouble(this.bankBalance.getText().trim());
            }
            catch (Exception i) {
                error = true;
                message = message + (message.length() > 0 ? "\n" : "");
                message = message + "Please enter the bank balance";
            }
            if (error) {
                this.notificationPane.setText(message);
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            } else {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("voucherNo", this.voucherNo.getText().trim());
                params.put("bankCode", bankCode);
                params.put("balanceDate", myDate);
                params.put("bankBalance", myBalance);
                String response = Config.loadDataFromPhp("mastercreate?type=bank_balance", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                    Stage stage = (Stage)this.save.getScene().getWindow();
                    stage.close();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
        });
    }

    public void setBalance(Bank.BankBalance balance) {
        this.voucherNo.setText(balance.getId() + "");
        this.bankBalance.setText(balance.getBalance() + "");
        this.balanceDate.setValue((Object)Config.stringToLocalDate(balance.getDate()));
        this.bank.setValue((Object)balance.getBank());
    }
}

