/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.BalanceSheet;
import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import filterscontrollers.BSFilter;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.controlsfx.control.NotificationPane;

public class BalanceSheetController
implements Initializable {
    private User user;
    private BalanceSheet sheet;
    @FXML
    private Label bsCode;
    @FXML
    private TextField bsName;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private TabPane tabpane;
    @FXML
    private TableView<BalanceSheet.BalanceSheetBanks> allBanks;
    @FXML
    private TableColumn bankName;
    @FXML
    private TableColumn includeBank;
    @FXML
    private TableView<BalanceSheet.BalanceSheetPostingGroup> customerPostingGroups;
    @FXML
    private TableColumn customerPostingGroup;
    @FXML
    private TableColumn includeCustomerPostingGroup;
    @FXML
    private CheckBox includeLoans;
    @FXML
    private TableView<BalanceSheet.BalanceSheetInvestment> allInvestments;
    @FXML
    private TableColumn investment;
    @FXML
    private TableColumn includeInvestment;
    @FXML
    private TableView<BalanceSheet.BalanceSheetFixedAsset> allPropertyEquipment;
    @FXML
    private TableColumn propertyEquipment;
    @FXML
    private TableColumn includeProperty;
    @FXML
    private CheckBox includeDeposits;
    @FXML
    private TableView<BalanceSheet.BalanceSheetPostingGroup> allVendorPostingGroups;
    @FXML
    private TableColumn vendorPostingGroup;
    @FXML
    private TableColumn includeVendorPostingGroup;
    @FXML
    private CheckBox includeInterestOnMemberDeposits;
    @FXML
    private CheckBox includeShareCapital;
    @FXML
    private CheckBox includeReserves;
    @FXML
    private Button delete;
    @FXML
    private Button save;
    @FXML
    private Button generate;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public BalanceSheet getSheet() {
        return this.sheet;
    }

    public void setSheet(BalanceSheet sheet) {
        String code;
        Gson g;
        String response2;
        this.sheet = sheet;
        this.bsCode.setText(sheet.getCode() + "");
        this.bsName.setText(sheet.getName());
        this.includeLoans.setSelected(sheet.isIncludeLoans());
        this.includeDeposits.setSelected(sheet.isIncludeDeposits());
        this.includeInterestOnMemberDeposits.setSelected(sheet.isIncludeInterestOnMemberDeposits());
        this.includeShareCapital.setSelected(sheet.isIncludeShareCapital());
        this.includeReserves.setSelected(sheet.isIncludeReserves());
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("bsCode", sheet.getCode());
        try {
            response2 = Config.loadDataFromPhp("masterfetch?type=bsreceivables", params, this.getUser());
            g = new Gson();
            String[] tReceivables = (String[])g.fromJson(response2, String[].class);
            ObservableList mReceivables = this.customerPostingGroups.getItems();
            ObservableList selectedReceivables = FXCollections.observableArrayList();
            for (BalanceSheet.BalanceSheetPostingGroup group : mReceivables) {
                code = group.getGroup().getCode() + "";
                if (Arrays.stream(tReceivables).anyMatch(code::equals)) {
                    group.setInclude(true);
                    selectedReceivables.add((Object)group);
                    continue;
                }
                selectedReceivables.add((Object)group);
            }
            this.customerPostingGroups.setItems(selectedReceivables);
        }
        catch (Exception response2) {
            // empty catch block
        }
        try {
            response2 = Config.loadDataFromPhp("masterfetch?type=bspayables", params, this.getUser());
            g = new Gson();
            String[] tPayables = (String[])g.fromJson(response2, String[].class);
            ObservableList mPayables = this.allVendorPostingGroups.getItems();
            ObservableList selectedPayables = FXCollections.observableArrayList();
            for (BalanceSheet.BalanceSheetPostingGroup group : mPayables) {
                code = group.getGroup().getCode() + "";
                if (Arrays.stream(tPayables).anyMatch(code::equals)) {
                    group.setInclude(true);
                    selectedPayables.add((Object)group);
                    continue;
                }
                selectedPayables.add((Object)group);
            }
            this.allVendorPostingGroups.setItems(selectedPayables);
        }
        catch (Exception response3) {
            // empty catch block
        }
        try {
            response2 = Config.loadDataFromPhp("masterfetch?type=bsbanks", params, this.getUser());
            g = new Gson();
            String[] tBanks = (String[])g.fromJson(response2, String[].class);
            ObservableList mBank = this.allBanks.getItems();
            ObservableList selectedBanks = FXCollections.observableArrayList();
            for (BalanceSheet.BalanceSheetBanks bank : mBank) {
                code = bank.getBank().getCode() + "";
                if (Arrays.stream(tBanks).anyMatch(code::equals)) {
                    bank.setInclude(true);
                    selectedBanks.add((Object)bank);
                    continue;
                }
                selectedBanks.add((Object)bank);
            }
            this.allBanks.setItems(selectedBanks);
        }
        catch (Exception response4) {
            // empty catch block
        }
        try {
            response2 = Config.loadDataFromPhp("masterfetch?type=bsinvestments", params, this.getUser());
            g = new Gson();
            String[] tInvestments = (String[])g.fromJson(response2, String[].class);
            ObservableList mInvestment = this.allInvestments.getItems();
            ObservableList selectedInvestments = FXCollections.observableArrayList();
            for (BalanceSheet.BalanceSheetInvestment investment : mInvestment) {
                code = investment.getInvestment().getInvestmentNo();
                if (Arrays.stream(tInvestments).anyMatch(code::equals)) {
                    investment.setInclude(true);
                    selectedInvestments.add((Object)investment);
                    continue;
                }
                selectedInvestments.add((Object)investment);
            }
            this.allInvestments.setItems(selectedInvestments);
        }
        catch (Exception response5) {
            // empty catch block
        }
        try {
            response2 = Config.loadDataFromPhp("masterfetch?type=bspropertyequipment", params, this.getUser());
            g = new Gson();
            String[] tProperty = (String[])g.fromJson(response2, String[].class);
            ObservableList mAssets = this.allPropertyEquipment.getItems();
            ObservableList selectedAssets = FXCollections.observableArrayList();
            for (BalanceSheet.BalanceSheetFixedAsset asset : mAssets) {
                code = asset.getFixedAsset().getAssetNo();
                if (Arrays.stream(tProperty).anyMatch(code::equals)) {
                    asset.setInclude(true);
                    selectedAssets.add((Object)asset);
                    continue;
                }
                selectedAssets.add((Object)asset);
            }
            this.allPropertyEquipment.setItems(selectedAssets);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.tabpane);
        BalanceSheet bs = new BalanceSheet();
        this.bankName.setCellValueFactory((Callback)new PropertyValueFactory("bank"));
        this.includeBank.setCellValueFactory((Callback)new PropertyValueFactory("checkInclude"));
        this.vendorPostingGroup.setCellValueFactory((Callback)new PropertyValueFactory("group"));
        this.includeVendorPostingGroup.setCellValueFactory((Callback)new PropertyValueFactory("checkInclude"));
        this.customerPostingGroup.setCellValueFactory((Callback)new PropertyValueFactory("group"));
        this.includeCustomerPostingGroup.setCellValueFactory((Callback)new PropertyValueFactory("checkInclude"));
        this.propertyEquipment.setCellValueFactory((Callback)new PropertyValueFactory("fixedAsset"));
        this.includeProperty.setCellValueFactory((Callback)new PropertyValueFactory("checkInclude"));
        this.investment.setCellValueFactory((Callback)new PropertyValueFactory("investment"));
        this.includeInvestment.setCellValueFactory((Callback)new PropertyValueFactory("checkInclude"));
        Platform.runLater(() -> {
            this.allBanks.setItems(bs.new BalanceSheet.BalanceSheetBanks().getAllBanks(this.getUser()));
            this.customerPostingGroups.setItems(bs.new BalanceSheet.BalanceSheetPostingGroup().getPostingGroups(1, this.getUser()));
            this.allVendorPostingGroups.setItems(bs.new BalanceSheet.BalanceSheetPostingGroup().getPostingGroups(2, this.getUser()));
            this.allPropertyEquipment.setItems(bs.new BalanceSheet.BalanceSheetFixedAsset().getAllFixedAssets(this.getUser()));
            this.allInvestments.setItems(bs.new BalanceSheet.BalanceSheetInvestment().getAllInvestments(this.getUser()));
        });
        this.save.setOnAction(e -> this.save());
        this.generate.setOnAction(e -> {
            if (this.save()) {
                try {
                    FXMLLoader loader = new FXMLLoader();
                    AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/bsfilter.fxml").openStream());
                    Scene editMember = new Scene((Parent)itemPane);
                    final Stage stage = new Stage();
                    editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                        public void handle(KeyEvent t) {
                            KeyCode key = t.getCode();
                            if (key == KeyCode.ESCAPE) {
                                stage.close();
                            }
                        }
                    });
                    stage.setScene(editMember);
                    BSFilter controller = (BSFilter)loader.getController();
                    controller.setUser(this.getUser());
                    BalanceSheet balanceSheet = new BalanceSheet();
                    balanceSheet.setCode(Integer.parseInt(this.bsCode.getText().trim()));
                    balanceSheet.setName(this.bsName.getText().trim());
                    controller.setBalanceSheet(balanceSheet);
                    stage.setTitle("Balance Sheet Filter");
                    stage.setResizable(false);
                    stage.show();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public boolean save() {
        boolean newStatement = false;
        boolean error = false;
        String message = "";
        int tBsCode = 0;
        String tBsName = "";
        try {
            tBsCode = Integer.parseInt(this.bsCode.getText().trim());
        }
        catch (Exception u) {
            tBsCode = 0;
            newStatement = true;
        }
        try {
            tBsName = this.bsName.getText().trim();
            if (tBsName.length() == 0) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            tBsName = "";
            error = true;
            message = "Please enter the balance sheet name";
        }
        if (error) {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            try {
                Gson gson = new Gson();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("bsCode", tBsCode);
                params.put("bsName", tBsName);
                params.put("includeLoans", this.includeLoans.isSelected() ? 1 : 0);
                params.put("includeDeposits", this.includeDeposits.isSelected() ? 1 : 0);
                params.put("includeInterestOnMemberDeposits", this.includeInterestOnMemberDeposits.isSelected() ? 1 : 0);
                params.put("includeShareCapital", this.includeShareCapital.isSelected() ? 1 : 0);
                params.put("includeReserves", this.includeReserves.isSelected() ? 1 : 0);
                params.put("banks", gson.toJson((Object)this.allBanks.getItems().filtered(BalanceSheet.BalanceSheetBanks::isInclude)));
                params.put("customerPostingGroups", gson.toJson((Object)this.customerPostingGroups.getItems().filtered(BalanceSheet.BalanceSheetPostingGroup::isInclude)));
                params.put("investments", gson.toJson((Object)this.allInvestments.getItems().filtered(BalanceSheet.BalanceSheetInvestment::isInclude)));
                params.put("propertyEquipment", gson.toJson((Object)this.allPropertyEquipment.getItems().filtered(BalanceSheet.BalanceSheetFixedAsset::isInclude)));
                params.put("vendorPostingGroups", gson.toJson((Object)this.allVendorPostingGroups.getItems().filtered(BalanceSheet.BalanceSheetPostingGroup::isInclude)));
                String response = Config.loadDataFromPhp("mastercreate?type=balancesheet", params, this.getUser());
                JsonResponses jr = (JsonResponses)gson.fromJson(response, JsonResponses.class);
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
                if (jr.isStatus() && newStatement) {
                    this.bsCode.setText(jr.getOverLoad1());
                }
                return jr.isStatus();
            }
            catch (Exception y) {
                this.notificationPane.setText("We encountered an error while processing your request. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
        return false;
    }
}

