/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.User;
import classes.Withdrawal;
import com.jfoenix.controls.JFXButton;
import controllers.WithdrawCapitalController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;

public class AllWithdrawalsController
implements Initializable {
    private User user;
    @FXML
    private VBox root;
    @FXML
    private SplitPane splitPane;
    @FXML
    private AnchorPane details;
    @FXML
    private JFXButton addCapital;
    @FXML
    private JFXButton editCapital;
    @FXML
    private JFXButton delete;
    @FXML
    private JFXButton refresh;
    @FXML
    private JFXButton capitalStatement;
    @FXML
    private JFXButton allCapital;
    @FXML
    private TableView<Withdrawal> allCapitalTable;
    @FXML
    private TableColumn bankName;
    @FXML
    private TableColumn investment;
    @FXML
    private TableColumn amount;
    @FXML
    private TableColumn investmentDate;
    @FXML
    private MaskerPane masker;
    @FXML
    private HBox searchBox;
    @FXML
    private TextField searchBar;
    @FXML
    private JFXButton clearFilter;
    @FXML
    private AnchorPane preview;
    @FXML
    private AnchorPane previewCapital;
    @FXML
    private Label previewBank;
    @FXML
    private Label previewInvestment;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.loadItems();
        this.bankName.setCellValueFactory((Callback)new PropertyValueFactory("bankName"));
        this.investment.setCellValueFactory((Callback)new PropertyValueFactory("investment"));
        this.amount.setCellValueFactory((Callback)new PropertyValueFactory("amountString"));
        this.investmentDate.setCellValueFactory((Callback)new PropertyValueFactory("withdrawalDate"));
        this.refresh.setOnAction(e -> this.loadItems());
        this.addCapital.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/withdrawCapital.fxml").openStream());
                WithdrawCapitalController controller = (WithdrawCapitalController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent event) {
                        KeyCode key = event.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AllWithdrawalsController.this.loadItems();
                            }
                        });
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("New Withdrawal");
                stage.show();
            }
            catch (Exception y) {
                y.printStackTrace();
            }
        });
        this.allCapitalTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Withdrawal rowData = (Withdrawal)row.getItem();
                    Withdrawal withdrawal = (Withdrawal)this.allCapitalTable.getSelectionModel().getSelectedItem();
                    if (!this.investment.equals(null)) {
                        this.editWithdrawal(withdrawal);
                    }
                }
            });
            return row;
        });
        this.editCapital.setOnAction(r -> {
            try {
                Withdrawal capital = (Withdrawal)this.allCapitalTable.getSelectionModel().getSelectedItem();
                if (!capital.equals(null) && !capital.getBankName().equals("")) {
                    this.editWithdrawal(capital);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }

    private void editWithdrawal(Withdrawal withdrawal) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/withdrawCapital.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            WithdrawCapitalController controller = (WithdrawCapitalController)loader.getController();
            controller.setUser(this.getUser());
            controller.setWithdrawal(withdrawal);
            stage.setTitle("Edit Withdrawal");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AllWithdrawalsController.this.loadItems();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your withdrawal screen. Please contact support");
            alert.showAndWait();
        }
    }

    private void loadItems() {
        Platform.runLater(() -> {
            this.masker.setVisible(true);
            ObservableList<Withdrawal> allcapitallist = new Withdrawal().getAllWithdrawals(false, this.getUser());
            this.allCapitalTable.setItems(allcapitallist);
            this.masker.setVisible(false);
        });
    }
}

