/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.User;
import classes.Vehicle;
import classes.VehicleImport;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.AddVehicleController;
import controllers.ConfirmVehiclestoImport;
import controllers.EditVehicleController;
import filterscontrollers.AllVehiclesReportFilter;
import filterscontrollers.VehicleMonthlyArrears;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.controlsfx.control.MaskerPane;

public class AllVehiclesController
implements Initializable {
    private User user;
    ObservableList<Vehicle> toSearch = FXCollections.observableArrayList();
    public static Stage confirmImport = new Stage();
    @FXML
    private JFXButton addVehicle;
    @FXML
    private JFXButton excelImport;
    @FXML
    private JFXButton vehicleStatement;
    @FXML
    private JFXButton vehicleMonthlyStatement;
    @FXML
    private JFXButton allVehiclesMonthly;
    @FXML
    private JFXButton deleteVehicle;
    @FXML
    private JFXButton editVehicle;
    @FXML
    private JFXButton allVehiclesReport;
    @FXML
    private JFXButton refresh;
    @FXML
    private TableView<Vehicle> allVehicles;
    @FXML
    private TableColumn colVehicleRegNo;
    @FXML
    private TableColumn colFleetNumber;
    @FXML
    private TableColumn colMake;
    @FXML
    private TableColumn colModel;
    @FXML
    private TableColumn serviceArrears;
    @FXML
    private TableColumn colName;
    @FXML
    private TableColumn colOwner;
    @FXML
    private TextField searchBar;
    @FXML
    private JFXButton clearFilter;
    @FXML
    MaskerPane masker;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @FXML
    void onEnter(ActionEvent event) {
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.loadVehicles();
        this.refresh.setOnAction(e -> this.loadVehicles());
        this.colVehicleRegNo.setCellValueFactory((Callback)new PropertyValueFactory("regNo"));
        this.colFleetNumber.setCellValueFactory((Callback)new PropertyValueFactory("fleetNumber"));
        this.colMake.setCellValueFactory((Callback)new PropertyValueFactory("make"));
        this.colModel.setCellValueFactory((Callback)new PropertyValueFactory("model"));
        this.colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.colOwner.setCellValueFactory((Callback)new PropertyValueFactory("owner"));
        this.serviceArrears.setCellValueFactory((Callback)new PropertyValueFactory("serviceArrearsString"));
        this.deleteVehicle.setOnAction(e -> {
            try {
                Vehicle m = (Vehicle)this.allVehicles.getSelectionModel().getSelectedItem();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("vehicleReg", m.getRegNo());
                Gson g = new Gson();
                String response2 = Config.loadDataFromPhp("masterdelete?type=vehicle", params, this.getUser());
                JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                if (myResponse.isStatus()) {
                    this.loadVehicles();
                } else {
                    Alert alert = new Alert(Alert.AlertType.ERROR);
                    alert.setTitle("Could not delete");
                    alert.setHeaderText("The vehicle could not be deleted");
                    alert.setContentText(myResponse.getMessage());
                    alert.showAndWait();
                }
            }
            catch (Exception t) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Could not delete");
                alert.setHeaderText("We encountered an error while deleting the vehicle. Please try again later");
                alert.showAndWait();
            }
        });
        this.allVehicles.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Vehicle rowData = (Vehicle)row.getItem();
                    Vehicle vehicle = (Vehicle)this.allVehicles.getSelectionModel().getSelectedItem();
                    if (!vehicle.equals(null)) {
                        this.editVehicle(vehicle);
                    }
                }
            });
            return row;
        });
        this.clearFilter.setOnAction(e -> this.searchBar.setText(""));
        this.vehicleStatement.setOnAction(e -> {
            try {
                Vehicle h = (Vehicle)this.allVehicles.getSelectionModel().getSelectedItem();
                LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
                dataParams.put("regNo", h.getRegNo());
                LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", Config.saccoName);
                reportParams.put("owner.memberNumber", h.getOwner().getMemberNumber());
                reportParams.put("owner.fullName", h.getOwner().getFullName());
                reportParams.put("model.description", h.getModel().getDescription());
                reportParams.put("make.description", h.getMake().getDescription());
                reportParams.put("fleetNumber", h.getFleetNumber());
                reportParams.put("regNo", h.getRegNo());
                new Config().getReport("Vehicle Statement", "masterfetch?type=vehicleentries", dataParams, "vehiclestatement.jasper", reportParams, this.getUser());
            }
            catch (NullPointerException h) {
            }
            catch (Exception t) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your report. Please contact support");
                alert.showAndWait();
            }
        });
        this.vehicleMonthlyStatement.setOnAction(e -> {
            try {
                Vehicle h = (Vehicle)this.allVehicles.getSelectionModel().getSelectedItem();
                LinkedHashMap<String, Object> dataParams = new LinkedHashMap<String, Object>();
                dataParams.put("regNo", h.getRegNo());
                LinkedHashMap<String, Object> reportParams = new LinkedHashMap<String, Object>();
                reportParams.put("saccoName", Config.saccoName);
                reportParams.put("owner.memberNumber", h.getOwner().getMemberNumber());
                reportParams.put("owner.fullName", h.getOwner().getFullName());
                reportParams.put("model.description", h.getModel().getDescription());
                reportParams.put("make.description", h.getMake().getDescription());
                reportParams.put("fleetNumber", h.getFleetNumber());
                reportParams.put("regNo", h.getRegNo());
                new Config().getReport("Vehicle Monthly Statement", "masterfetch?type=vehiclemonthlystatement", dataParams, "vehiclemonthlystatement.jasper", reportParams, this.getUser());
            }
            catch (NullPointerException h) {
            }
            catch (Exception t) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your report. Please contact support");
                alert.showAndWait();
            }
        });
        this.allVehiclesReport.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/allvehiclesreportfilter.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane);
                AllVehiclesReportFilter controller = (AllVehiclesReportFilter)loader.getController();
                controller.setUser(this.getUser());
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                stage.setTitle("Filter Report");
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading the filter report screen. Please contact support");
                alert.showAndWait();
            }
        });
        this.allVehiclesMonthly.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/vehiclemonthlyarrears.fxml").openStream());
                VehicleMonthlyArrears controller = (VehicleMonthlyArrears)loader.getController();
                controller.setUser(this.getUser());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                stage.setTitle("Filter Report");
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading the filter report screen. Please contact support");
                alert.showAndWait();
            }
        });
        this.excelImport.setOnAction(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                block23: {
                    FileChooser chooser = new FileChooser();
                    chooser.setTitle("Select Excel to Import Vehicles from");
                    chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Excel Files", new String[]{"*.xlsx", "*.csv"})});
                    try {
                        File file = chooser.showOpenDialog((Window)new Stage());
                        if (file == null) break block23;
                        XSSFWorkbook wb = new XSSFWorkbook(file);
                        XSSFSheet ws = wb.getSheetAt(0);
                        ObservableList toImport = FXCollections.observableArrayList();
                        for (int a = 1; a < ws.getPhysicalNumberOfRows(); ++a) {
                            XSSFRow myRow = ws.getRow(a);
                            try {
                                Cell myCell;
                                VehicleImport myImport = new VehicleImport();
                                try {
                                    myCell = myRow.getCell(0);
                                    myImport.setRegNo(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setMemberNo("");
                                }
                                try {
                                    myCell = myRow.getCell(1);
                                    myImport.setFleetNumber(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setFleetNumber("");
                                }
                                try {
                                    myCell = myRow.getCell(2);
                                    myImport.setMemberNo(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setMemberNo("");
                                }
                                try {
                                    myCell = myRow.getCell(3);
                                    myImport.setMemberName(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setMemberName("");
                                }
                                try {
                                    myCell = myRow.getCell(4);
                                    myImport.setVehicleMake(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setVehicleMake("");
                                }
                                try {
                                    myCell = myRow.getCell(5);
                                    myImport.setVehicleModel(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setVehicleModel("");
                                }
                                try {
                                    myCell = myRow.getCell(6);
                                    myImport.setAlias(myCell.toString());
                                }
                                catch (Exception t) {
                                    myImport.setAlias("");
                                }
                                if (myImport.getRegNo().contains("/")) {
                                    String mReg = myImport.getRegNo();
                                    String[] regs = mReg.split("/");
                                    for (int b = 0; b < regs.length; ++b) {
                                        VehicleImport currentVehicle = new VehicleImport();
                                        currentVehicle.setRegNo(regs[b]);
                                        currentVehicle.setFleetNumber(myImport.getFleetNumber());
                                        currentVehicle.setMemberNo(myImport.getMemberNo());
                                        currentVehicle.setMemberName(myImport.getMemberName());
                                        currentVehicle.setVehicleMake(myImport.getVehicleMake());
                                        currentVehicle.setVehicleModel(myImport.getVehicleModel());
                                        currentVehicle.setAlias(myImport.getAlias());
                                        System.out.println(regs[b]);
                                        currentVehicle.setRegNo(regs[b]);
                                        toImport.add((Object)currentVehicle);
                                    }
                                    continue;
                                }
                                toImport.add((Object)myImport);
                                continue;
                            }
                            catch (NullPointerException myImport) {
                                // empty catch block
                            }
                        }
                        try {
                            FXMLLoader loader = new FXMLLoader();
                            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/confirmVehicleImport.fxml").openStream());
                            Scene confirmImportScene = new Scene((Parent)itemPane, 1060.0, 600.0);
                            confirmImportScene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                                public void handle(KeyEvent t) {
                                    KeyCode key = t.getCode();
                                    if (key == KeyCode.ESCAPE) {
                                        confirmImport.close();
                                    }
                                }
                            });
                            confirmImport.setScene(confirmImportScene);
                            ConfirmVehiclestoImport controller = (ConfirmVehiclestoImport)loader.getController();
                            controller.setUser(AllVehiclesController.this.getUser());
                            controller.setDataSource((ObservableList<VehicleImport>)toImport);
                            confirmImport.setTitle("Confirm Vehicle Import");
                            confirmImport.setResizable(false);
                            confirmImport.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                                public void handle(WindowEvent event) {
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            AllVehiclesController.this.loadVehicles();
                                        }
                                    });
                                }
                            });
                            confirmImport.showAndWait();
                        }
                        catch (Exception p) {
                            p.printStackTrace();
                            Alert alert = new Alert(Alert.AlertType.ERROR);
                            alert.setTitle("An error occurred");
                            alert.setHeaderText("An error occurred while loading your confirm  vehicle import screen. Please contact support");
                            alert.showAndWait();
                        }
                    }
                    catch (Exception ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        }));
        this.searchBar.textProperty().addListener((observable, oldValue, newValue) -> {
            ObservableList afterSearch = FXCollections.observableArrayList();
            for (int b = 0; b < this.toSearch.size(); ++b) {
                Vehicle current = (Vehicle)this.toSearch.get(b);
                if (!current.getRegNo().toLowerCase().contains(newValue.toLowerCase()) && !current.getOwner().getFullName().toLowerCase().contains(newValue.toLowerCase()) && !current.getFleetNumber().toLowerCase().contains(newValue.toLowerCase()) && !current.getName().toLowerCase().contains(newValue.toLowerCase()) && !current.getRegNo().toLowerCase().replace(" ", "").contains(newValue.toLowerCase().replace(" ", ""))) continue;
                afterSearch.add((Object)current);
            }
            this.allVehicles.getItems().removeAll((Collection)this.allVehicles.getItems());
            this.allVehicles.setItems(afterSearch);
        });
        this.addVehicle.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/addVehicle.fxml").openStream());
                AddVehicleController controller = (AddVehicleController)loader.getController();
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                stage.setResizable(false);
                stage.initModality(Modality.APPLICATION_MODAL);
                stage.setTitle("Add Vehicle");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AllVehiclesController.this.loadVehicles();
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.editVehicle.setOnAction(e -> {
            try {
                Vehicle mv = (Vehicle)this.allVehicles.getSelectionModel().getSelectedItem();
                if (!mv.getRegNo().equals(null) && !mv.getRegNo().trim().equals("")) {
                    this.editVehicle(mv);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void loadVehicles() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> AllVehiclesController.this.masker.setVisible(true));
                Platform.runLater(() -> {
                    int selectedIndex = 0;
                    try {
                        selectedIndex = AllVehiclesController.this.allVehicles.getSelectionModel().getSelectedIndex();
                    }
                    catch (Exception t) {
                        selectedIndex = 0;
                    }
                    AllVehiclesController.this.toSearch = new Vehicle().getAllVehicles(AllVehiclesController.this.getUser());
                    AllVehiclesController.this.allVehicles.setItems(new Vehicle().getAllVehicles(AllVehiclesController.this.getUser()));
                    AllVehiclesController.this.allVehicles.getSelectionModel().select(0);
                    AllVehiclesController.this.allVehicles.getSelectionModel().select(selectedIndex);
                });
                Platform.runLater(() -> AllVehiclesController.this.masker.setVisible(false));
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void editVehicle(Vehicle vehicle) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/editVehicle.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            EditVehicleController controller = (EditVehicleController)loader.getController();
            controller.setUser(this.getUser());
            controller.setVehicle(vehicle);
            stage.setTitle("Edit Vehicle");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AllVehiclesController.this.loadVehicles();
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit vehicle screen. Please contact support");
            alert.showAndWait();
        }
    }
}

