/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Employee;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.AcademicQualificationsController;
import controllers.EmployeeCardController;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.NotificationPane;

public class AllEmployeesController
implements Initializable {
    private int caretaker;
    Map<String, Object> params;
    private User user;
    ObservableList<Employee> myEmployees = FXCollections.observableArrayList();
    @FXML
    private StackPane holder;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private JFXButton deactivate;
    @FXML
    private JFXButton addEmployee;
    @FXML
    private JFXButton allEmployeesReport;
    @FXML
    private JFXButton editEmployee;
    @FXML
    private JFXButton academicQualifications;
    @FXML
    private JFXButton delete;
    @FXML
    private JFXButton refresh;
    @FXML
    private TableView<Employee> allEmployees;
    @FXML
    private TableColumn employeeNumber;
    @FXML
    private TableColumn employeeName;
    @FXML
    private TableColumn employeePhone;
    @FXML
    private TableColumn employeeEmail;
    @FXML
    private TableColumn jobTitle;
    @FXML
    private TableColumn employeeRegion;
    @FXML
    private MaskerPane masker;
    @FXML
    private TextField searchBar;
    @FXML
    private JFXButton clearFilter;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
        this.loadEmployees(params);
    }

    public int getCaretaker() {
        return this.caretaker;
    }

    public void setCaretaker(int caretaker) {
        this.caretaker = caretaker;
    }

    @FXML
    void onEnter(ActionEvent event) {
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        this.editEmployee.setOnAction(r -> {
            try {
                Employee xm = (Employee)this.allEmployees.getSelectionModel().getSelectedItem();
                if (!xm.equals(null) && !xm.getEmployeeNumber().equals("")) {
                    this.editEmployee(xm);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
        this.clearFilter.setOnAction(e -> {
            this.searchBar.setText("");
            this.loadEmployees(this.getParams());
        });
        this.searchBar.textProperty().addListener((observable, oldValue, newValue) -> {
            String searchString = newValue.trim().toLowerCase();
            ObservableList allEmployeesList = FXCollections.observableArrayList();
            for (int b = 0; b < this.myEmployees.size(); ++b) {
                Employee current = (Employee)this.myEmployees.get(b);
                String tEmployeeNo = "";
                String tEmployeeName = "";
                String tEmployeePhone = "";
                String tEmailAddress = "";
                String tJobTitle = "";
                String tProperty = "";
                try {
                    tEmployeeNo = current.getEmployeeNumber().toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tEmployeeName = current.getFullName().toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tEmployeePhone = current.getPhoneNumber().toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tEmailAddress = current.getEmail().toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    tJobTitle = current.getJobTitle().toLowerCase();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String myId = current.getIdNumber() + "";
                if (!tEmployeeNo.contains(searchString) && !tEmployeeName.contains(searchString) && !tEmployeePhone.contains(searchString) && !tEmailAddress.contains(searchString) && !tJobTitle.contains(searchString) && !(myId.contains(searchString) | tProperty.contains(searchString))) continue;
                allEmployeesList.add((Object)current);
            }
            this.allEmployees.getItems().removeAll((Collection)this.allEmployees.getItems());
            this.allEmployees.setItems(allEmployeesList);
        });
        this.deactivate.setOnAction(e -> {
            try {
                Employee myEmployee = (Employee)this.allEmployees.getSelectionModel().getSelectedItem();
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("employeeNo", myEmployee.getEmployeeNumber());
                String response = Config.loadDataFromPhp("masterupdate?type=deactivateemployee", params, this.getUser());
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    this.loadEmployees(this.getParams());
                }
                this.notificationPane.setText(jr.getMessage());
                this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                this.notificationPane.show();
            }
            catch (NullPointerException u) {
                this.notificationPane.setText("Please select an employee to deactivate");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
            catch (Exception u) {
                this.notificationPane.setText("We experienced an error while processing your request. Please try again");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        });
        this.allEmployeesReport.setOnAction(e -> {
            try {
                Map<Object, Object> reportVariables = new LinkedHashMap();
                reportVariables = this.getParams();
                reportVariables.put("saccoName", Config.saccoName);
                reportVariables.put("address", Config.companyAddress);
                new Config().getReport("All Employees List", "masterfetch?type=employees", this.getParams(), "allemployees.jasper", reportVariables, this.getUser());
            }
            catch (Exception y) {
                this.notificationPane.setText("We experienced an error while procesing your request");
                this.notificationPane.setGraphic((Node)Config.getTimesIcon());
                this.notificationPane.show();
            }
        });
        this.academicQualifications.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/academicQualifications.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                AcademicQualificationsController controller = (AcademicQualificationsController)loader.getController();
                controller.setUser(this.getUser());
                Employee employee = new Employee();
                try {
                    employee = (Employee)this.allEmployees.getSelectionModel().getSelectedItem();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                controller.setMyEmployee(employee);
                stage.setTitle("Academic Qualifications");
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AllEmployeesController.this.loadEmployees(AllEmployeesController.this.getParams());
                            }
                        });
                    }
                });
                stage.showAndWait();
            }
            catch (Exception p) {
                p.printStackTrace();
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("An error occurred");
                alert.setHeaderText("An error occurred while loading your employee qualifications screen. Please contact support");
                alert.showAndWait();
            }
        });
        this.allEmployees.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                // empty if block
            }
        });
        this.addEmployee.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/employeeCard.fxml").openStream());
                EmployeeCardController controller = (EmployeeCardController)loader.getController();
                controller.setPayroll(false);
                controller.setUser(this.getUser());
                Scene scene = new Scene((Parent)itemPane, itemPane.getPrefWidth(), itemPane.getPrefHeight());
                final Stage stage = new Stage();
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                try {
                    stage.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.setScene(scene);
                stage.setResizable(false);
                try {
                    stage.initModality(Modality.APPLICATION_MODAL);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                stage.setTitle("Add Employee");
                stage.show();
                stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                AllEmployeesController.this.loadEmployees(AllEmployeesController.this.getParams());
                            }
                        });
                    }
                });
            }
            catch (Exception j) {
                j.printStackTrace();
            }
        });
        this.employeeName.setCellValueFactory((Callback)new PropertyValueFactory("fullName"));
        this.employeeNumber.setCellValueFactory((Callback)new PropertyValueFactory("employeeNumber"));
        this.employeePhone.setCellValueFactory((Callback)new PropertyValueFactory("phoneNumber"));
        this.employeeEmail.setCellValueFactory((Callback)new PropertyValueFactory("email"));
        this.jobTitle.setCellValueFactory((Callback)new PropertyValueFactory("jobTitle"));
        this.employeeRegion.setCellValueFactory((Callback)new PropertyValueFactory("region"));
        this.refresh.setOnAction(e -> this.loadEmployees(this.getParams()));
        this.allEmployees.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Employee rowData = (Employee)row.getItem();
                    Employee member = (Employee)this.allEmployees.getSelectionModel().getSelectedItem();
                    if (!member.equals(null)) {
                        this.editEmployee(member);
                    }
                }
            });
            return row;
        });
    }

    public void loadEmployees(final Map<String, Object> params) {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> AllEmployeesController.this.masker.setVisible(true));
                AllEmployeesController.this.allEmployees.setItems(new Employee().getAllEmployees(params, AllEmployeesController.this.getUser()));
                AllEmployeesController.this.myEmployees = new Employee().getAllEmployees(params, AllEmployeesController.this.getUser());
                Platform.runLater(() -> AllEmployeesController.this.masker.setVisible(false));
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
        Thread thread1 = new Thread((Runnable)task1);
        thread1.setDaemon(true);
        thread1.start();
    }

    public void editEmployee(Employee employee) {
        try {
            FXMLLoader loader = new FXMLLoader();
            VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/employeeCard.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane, itemPane.getPrefWidth(), itemPane.getPrefHeight());
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            EmployeeCardController controller = (EmployeeCardController)loader.getController();
            controller.setUser(this.getUser());
            controller.setPayroll(false);
            controller.setEmployee(employee);
            stage.setTitle("Edit Employee");
            stage.setResizable(false);
            try {
                stage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stage.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AllEmployeesController.this.loadEmployees(AllEmployeesController.this.getParams());
                        }
                    });
                }
            });
            stage.showAndWait();
        }
        catch (Exception p) {
            p.printStackTrace();
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your edit employee screen. Please contact support");
            alert.showAndWait();
        }
    }
}

