/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.UnitOfMeasure;
import classes.User;
import com.google.gson.Gson;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddUnitOfMeasure
implements Initializable {
    private User user;
    private UnitOfMeasure uom;
    @FXML
    private VBox vbUOM;
    @FXML
    private VBox vbHolder;
    @FXML
    private Label labelId;
    @FXML
    private TextField tfName;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnCancel;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        Platform.runLater(() -> {
            ValidationSupport vs = new ValidationSupport();
            vs.registerValidator((Control)this.tfName, Validator.createEmptyValidator((String)"Required"));
            this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
        });
    }

    @FXML
    void cancel(ActionEvent event) {
        this.vbUOM.getScene().getWindow().hide();
    }

    @FXML
    void saveUOM(ActionEvent event) {
        String name = this.tfName.getText().trim();
        Gson g = new Gson();
        if (name.length() < 1) {
            this.notificationPane.setText("Unit of measure Name is required");
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("name", name);
            String id = this.labelId.getText().trim();
            if (id.length() != 0 || !id.equals("")) {
                map.put("id", id);
            }
            new Config();
            String response = Config.loadDataFromPhp("mastercreate?type=unitofmeasure", map, this.getUser());
            System.out.print(response);
            JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                this.vbUOM.getScene().getWindow().hide();
            } else {
                System.out.println("No Bingo " + jr.getMessage());
            }
        }
    }

    public void setUom(UnitOfMeasure uom) {
        this.uom = uom;
        this.labelId.setText(String.valueOf(uom.getId()));
        this.tfName.setText(uom.getName());
    }
}

