/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.Employee;
import classes.JsonResponses;
import classes.NumberSeries;
import classes.Property;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.controlsfx.control.NotificationPane;

public class AddProperty
implements Initializable {
    private User user;
    @FXML
    private VBox root;
    @FXML
    private NotificationPane notificationPane;
    @FXML
    private HBox holder;
    @FXML
    private Label labelId;
    @FXML
    private TextField propertyName;
    @FXML
    private ComboBox<Vendor> landlord;
    @FXML
    private Button searchLandlord;
    @FXML
    private TextField propertyLRNo;
    @FXML
    private TextField propertyLocation;
    @FXML
    private ComboBox<Employee> salesAgent;
    @FXML
    private Button searchSalesAgent;
    @FXML
    private ComboBox<Employee> propertyManager;
    @FXML
    private Button searchPropertyManager;
    @FXML
    private TextField agencyPercentage;
    @FXML
    private TextField disbursementDate;
    @FXML
    private TextField waterRate;
    @FXML
    private ImageView propertyImage;
    @FXML
    private TextField bankName;
    @FXML
    private TextField bankBranch;
    @FXML
    private TextField bankAccountNo;
    @FXML
    private TextField bankAccountName;
    @FXML
    private Button save;
    @FXML
    private Button cancel;
    String imagePath = "";

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.landlord.setItems(new Vendor().getAllVendors("landlord", user));
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("exited", 0);
        params.put("caretaker", 0);
        ObservableList<Employee> allEmployees = new Employee().getAllEmployees(params, user);
        this.salesAgent.setItems(allEmployees);
        this.propertyManager.setItems(allEmployees);
    }

    public void initialize(URL location, ResourceBundle resources) {
        String path = System.getProperty("user.dir");
        path = path.replace("\\", "/");
        this.imagePath = path + "/house.png";
        Platform.runLater(() -> {
            this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.holder);
        });
        final ContextMenu imageOptions = new ContextMenu();
        MenuItem upload = new MenuItem("Upload");
        upload.setOnAction(e -> {
            FileChooser chooser = new FileChooser();
            chooser.setTitle("Select Item Picture");
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All Images", new String[]{"*.jpg", "*.png"}), new FileChooser.ExtensionFilter("JPG", new String[]{"*.jpg"}), new FileChooser.ExtensionFilter("PNG", new String[]{"*.png"})});
            File file = chooser.showOpenDialog((Window)new Stage());
            if (file != null) {
                this.openFile(file);
            }
        });
        MenuItem reset = new MenuItem("Reset to Default");
        String myPath = path;
        reset.setOnAction(e -> {
            String fileLocation = myPath + "/holder.png";
            File imgFile = new File(fileLocation);
            this.openFile(imgFile);
        });
        imageOptions.getItems().addAll((Object[])new MenuItem[]{upload, reset});
        this.propertyImage.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent event) {
                imageOptions.show((Node)AddProperty.this.propertyImage, event.getScreenX(), event.getScreenY());
            }
        });
        this.searchLandlord.setOnAction(e -> {
            try {
                String response = new Config().getObjectFromSelection("landlord", this.getUser());
                Vendor vendor = (Vendor)new Gson().fromJson(response, Vendor.class);
                if (vendor.getVendorNumber().length() > 0) {
                    this.landlord.setValue((Object)vendor);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchSalesAgent.setOnAction(e -> {
            try {
                String response = new Config().getObjectFromSelection("employee", this.getUser());
                Employee employee = (Employee)new Gson().fromJson(response, Employee.class);
                if (employee.getEmployeeNumber().length() > 0) {
                    this.salesAgent.setValue((Object)employee);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.searchPropertyManager.setOnAction(e -> {
            try {
                String response = new Config().getObjectFromSelection("employee", this.getUser());
                Employee employee = (Employee)new Gson().fromJson(response, Employee.class);
                if (employee.getEmployeeNumber().length() > 0) {
                    this.propertyManager.setValue((Object)employee);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.cancel.setOnAction(event -> this.cancel());
        this.save.setOnAction(event -> this.save());
    }

    private void save() {
        String id = this.labelId.getText().trim();
        String name = this.propertyName.getText().trim();
        String tLrNo = this.propertyLRNo.getText().trim();
        String tLocation = this.propertyLocation.getText().trim();
        String tBankName = this.bankName.getText().trim();
        String tBankBranch = this.bankBranch.getText().trim();
        String tBankAccountNo = this.bankAccountNo.getText().trim();
        String tBankAccountName = this.bankAccountName.getText().trim();
        double tAgencyPercentage = 0.0;
        int tDisbursementDate = 0;
        double tWaterRate = 0.0;
        String tSalesAgent = "";
        String tPropertyManager = "";
        String tLandlord = "";
        String message = "";
        boolean error = false;
        if (name.length() < 1) {
            message = "Please enter the property name";
            error = true;
        }
        try {
            tLandlord = ((Vendor)this.landlord.getValue()).getVendorNumber();
            if (tLandlord.length() < 1) {
                throw new Exception();
            }
        }
        catch (Exception t) {
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please select the property's landlord";
            error = true;
        }
        try {
            tAgencyPercentage = Double.parseDouble(this.agencyPercentage.getText().trim());
        }
        catch (Exception t) {
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter the agency's percentage";
            error = true;
        }
        try {
            tWaterRate = Double.parseDouble(this.waterRate.getText().trim());
        }
        catch (Exception t) {
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter the property water";
            error = true;
        }
        try {
            tDisbursementDate = Integer.parseInt(this.disbursementDate.getText().trim());
        }
        catch (Exception t) {
            message = message + (message.length() > 0 ? "\n" : "");
            message = message + "Please enter the disbursement date";
            error = true;
        }
        try {
            tSalesAgent = ((Employee)this.salesAgent.getValue()).getEmployeeNumber();
        }
        catch (Exception t) {
            // empty catch block
        }
        try {
            tPropertyManager = ((Employee)this.propertyManager.getValue()).getEmployeeNumber();
        }
        catch (Exception t) {
            // empty catch block
        }
        if (error) {
            this.notificationPane.setText(message);
            this.notificationPane.setGraphic((Node)Config.getTimesIcon());
            this.notificationPane.show();
        } else {
            NumberSeries nb = new NumberSeries(49, this.getUser());
            boolean newProperty = false;
            String propertyCode = "";
            ByteArrayOutputStream ba = Config.convertFileToJson(this.imagePath);
            String photoJson = StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])ba.toByteArray()));
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            if (id.length() > 0) {
                propertyCode = id;
            } else {
                propertyCode = nb.getNextNumber();
                newProperty = true;
            }
            params.put("propertyCode", propertyCode);
            params.put("propertyName", name);
            params.put("lrNo", tLrNo);
            params.put("location", tLocation);
            params.put("bankName", tBankName);
            params.put("bankBranch", tBankBranch);
            params.put("bankAccountNo", tBankAccountNo);
            params.put("bankAccountName", tBankAccountName);
            params.put("agencyPercentage", tAgencyPercentage);
            params.put("disbursementDate", tDisbursementDate);
            params.put("waterRate", tWaterRate);
            params.put("salesAgent", tSalesAgent);
            params.put("propertyManager", tPropertyManager);
            params.put("landlord", tLandlord);
            params.put("photo", photoJson);
            String response = Config.loadDataFromPhp("mastercreate?type=property", params, this.getUser());
            System.out.println(response);
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            this.notificationPane.setText(jr.getMessage());
            this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
            this.notificationPane.show();
            if (jr.isStatus()) {
                if (newProperty) {
                    nb.updateLastUsed(propertyCode);
                }
                GeneralListController.publicNotificationPane.setText(jr.getMessage());
                GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                GeneralListController.publicNotificationPane.show();
                this.cancel();
            }
        }
    }

    private void cancel() {
        Stage stage = (Stage)this.root.getScene().getWindow();
        stage.close();
    }

    public void setProperty(Property property) {
        this.labelId.setText(property.getPropertyCode());
        this.propertyName.setText(property.getName());
        this.landlord.setValue((Object)property.getLandlord());
        this.propertyLRNo.setText(property.getLrNumber());
        this.propertyLocation.setText(property.getPropertyLocation());
        this.salesAgent.setValue((Object)property.getSalesAgent());
        this.propertyManager.setValue((Object)property.getPropertyManager());
        this.agencyPercentage.setText(property.getAgencyPercentage() + "");
        this.bankName.setText(property.getBankName());
        this.bankBranch.setText(property.getBankBranch());
        this.bankAccountNo.setText(property.getBankAccountNo());
        this.bankAccountName.setText(property.getBankAccountName());
        this.waterRate.setText(property.getWaterRate() + "");
        this.disbursementDate.setText(property.getRemittanceDate() + "");
    }

    private void openFile(File file) {
        try {
            Image image = new Image(file.toURI().toString());
            this.propertyImage.setImage(image);
            this.imagePath = file.getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

