/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Config;
import classes.JsonResponses;
import classes.LeaveType;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddLeaveType
implements Initializable {
    private User user;
    @FXML
    private VBox vbLeaveType;
    @FXML
    private VBox vbHolder;
    @FXML
    private Label labelNo;
    @FXML
    private TextField tfDescription;
    @FXML
    private ComboBox<String> cbGender;
    @FXML
    private CheckBox cbAnnual;
    @FXML
    private CheckBox cbHolidays;
    @FXML
    private CheckBox cbWeekends;
    @FXML
    private TextField tfMin;
    @FXML
    private TextField tfMax;
    @FXML
    private Button btnSave;
    @FXML
    private Button btnCancel;
    @FXML
    private NotificationPane notificationPane;
    private LeaveType leaveType;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
        this.btnSave.setDisable(false);
    }

    public void initialize(URL location, ResourceBundle resources) {
        Platform.runLater(() -> {
            this.notificationPane = new Config().setUpNotificationPane(this.notificationPane, (Node)this.vbHolder);
            ValidationSupport vs = new ValidationSupport();
            vs.registerValidator((Control)this.tfDescription, Validator.createEmptyValidator((String)"Required"));
            vs.registerValidator((Control)this.tfMax, Validator.createEmptyValidator((String)"Required"));
            vs.registerValidator((Control)this.tfMin, Validator.createEmptyValidator((String)"Required"));
            vs.registerValidator(this.cbGender, Validator.createEmptyValidator((String)"Required"));
            Config.setInputTypeNum(new TextField[]{this.tfMax, this.tfMin});
            Object[] genders = new String[]{"Male", "Female", "Both"};
            this.cbGender.setItems(FXCollections.observableArrayList((Object[])genders));
        });
    }

    @FXML
    void cancel(ActionEvent event) {
        Stage stage = (Stage)this.vbLeaveType.getScene().getWindow();
        stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    @FXML
    void save(ActionEvent event) {
        String description = "";
        String min = "";
        String max = "";
        String gender = "";
        String errorMessage = "";
        boolean error = false;
        boolean annual = this.cbAnnual.isSelected();
        boolean weekends = this.cbWeekends.isSelected();
        boolean holidays = this.cbHolidays.isSelected();
        try {
            description = this.tfDescription.getText().trim();
            if (description.equals("")) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage + "Enter a valid description";
        }
        try {
            min = this.tfMin.getText().trim();
            if (min.equals("")) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Enter a valid number for minimum days" : "\nEnter a valid number for minimum days");
        }
        try {
            max = this.tfMax.getText().trim();
            if (max.equals("")) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Enter a valid number for maximum days" : "\nEnter a valid number for maximum days");
        }
        try {
            gender = (String)this.cbGender.getValue();
        }
        catch (Exception e) {
            error = true;
            errorMessage = errorMessage.concat(errorMessage.equals("") ? "Select a valid gender" : "\nselect a valid gender");
        }
        if (error) {
            this.notificationPane.setText(errorMessage);
            this.notificationPane.show();
        } else {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                if (!this.labelNo.getText().equals("")) {
                    params.put("no", this.labelNo.getText());
                }
                params.put("description", description);
                params.put("gender", gender);
                params.put("annual", annual ? 1 : 0);
                params.put("includePublicHolidays", holidays ? 1 : 0);
                params.put("includeWeekends", weekends ? 1 : 0);
                params.put("minDays", min);
                params.put("maxDays", max);
                String url = this.labelNo.getText().equals("") ? "mastercreate" : "masterupdate";
                String response = Config.loadDataFromPhp(url + "?type=leavetypes", params, this.getUser());
                System.out.println(response);
                JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    Stage stage = (Stage)this.vbLeaveType.getScene().getWindow();
                    stage.fireEvent(new Event(WindowEvent.WINDOW_CLOSE_REQUEST));
                    GeneralListController.publicNotificationPane.setText(jr.getMessage());
                    GeneralListController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    GeneralListController.publicNotificationPane.show();
                } else {
                    this.notificationPane.setText(jr.getMessage());
                    this.notificationPane.setGraphic((Node)jr.getIconFromStatus());
                    this.notificationPane.show();
                }
            }
            catch (Exception u) {
                this.notificationPane.setText("We encountered an error while processing your request");
                this.notificationPane.setGraphic((Node)Config.getBanIcon());
                this.notificationPane.show();
            }
        }
    }

    public void setLeaveType(LeaveType leaveType) {
        this.leaveType = leaveType;
        this.tfDescription.setText(leaveType.getDescription());
        this.tfMin.setText(leaveType.getMinDays() + "");
        this.tfMax.setText(leaveType.getMaxDays() + "");
        this.labelNo.setText(leaveType.getNo() + "");
        this.cbAnnual.setSelected(leaveType.isAnnual());
        this.cbHolidays.setSelected(leaveType.isIncludePublicHolidays());
        this.cbWeekends.setSelected(leaveType.isIncludeWeekends());
        this.cbGender.getSelectionModel().select((Object)leaveType.getGender());
        this.btnSave.setDisable(false);
    }
}

