/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import com.jfoenix.controls.JFXButton;
import controllers.BanksController;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class AddBankController
implements Initializable {
    private User user;
    @FXML
    AnchorPane holder;
    @FXML
    private TextField bankName;
    @FXML
    private TextField bankBranch;
    @FXML
    private TextField accountNumber;
    @FXML
    private TextArea description;
    @FXML
    private ComboBox<Account> glAccount;
    @FXML
    private JFXButton addBank;
    @FXML
    private JFXButton reset;
    @FXML
    private NotificationPane notificationPane;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void initialize(URL location, ResourceBundle resources) {
        Platform.runLater(() -> this.glAccount.setItems(Account.getAccounts(this.getUser())));
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator((Control)this.bankName, Validator.createEmptyValidator((String)"Bank name is required"));
        validationSupport.registerValidator(this.glAccount, Validator.createEmptyValidator((String)"G/L Account is required"));
        this.notificationPane.setContent((Node)this.holder);
        this.notificationPane.showFromTopProperty();
        this.notificationPane.getStyleClass().add((Object)"dark");
        this.notificationPane.setCloseButtonVisible(true);
        this.reset.setOnAction(e -> {
            try {
                BanksController.addBankStage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.addBank.setOnAction(e -> {
            this.notificationPane.setGraphic((Node)new ProgressIndicator());
            this.notificationPane.setText("Please wait while we add the bank account");
            this.notificationPane.show();
            String tBankName = this.bankName.getText().trim();
            String tBankBranch = this.bankBranch.getText().trim();
            String tAccountNumber = this.accountNumber.getText().trim();
            Account tGlAccount = (Account)this.glAccount.getValue();
            String tDescription = this.description.getText().trim();
            boolean error = false;
            String message = "";
            try {
                if (tBankName.equals("") || tBankName.equals(null)) {
                    message = message + "Bank name is required";
                    error = true;
                }
            }
            catch (Exception t) {
                message = message + "There is an error in the bank name field";
                error = true;
            }
            try {
                if (tGlAccount.getAccountNumber().equals("") || tGlAccount.getAccountNumber().equals(null)) {
                    message = message + (message.length() == 0 ? "" : "\n");
                    message = message + "G/L Account is required";
                    error = true;
                }
            }
            catch (Exception t) {
                message = message + (message.length() == 0 ? "" : "\n");
                message = message + "There is an error in the G/L Account field";
                error = true;
            }
            if (!error) {
                try {
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("bankName", tBankName);
                    params.put("bankBranch", tBankBranch);
                    params.put("accountNumber", tAccountNumber);
                    params.put("glAccount", tGlAccount.getAccountNumber());
                    params.put("description", tDescription);
                    StringBuilder postData = new StringBuilder();
                    Gson g = new Gson();
                    String response2 = Config.loadDataFromPhp("mastercreate?type=bank", params, this.getUser());
                    JsonResponses myResponse = (JsonResponses)g.fromJson(response2, JsonResponses.class);
                    if (myResponse.isStatus()) {
                        try {
                            BanksController.addBankStage.close();
                        }
                        catch (Exception exception) {}
                    } else {
                        this.notificationPane.setText(myResponse.getMessage());
                        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TIMES);
                        icon.setStyle("-fx-fill: #d32f2f;");
                        icon.setSize("24.0");
                        this.notificationPane.setGraphic((Node)icon);
                    }
                    this.addBank.setDisable(false);
                }
                catch (Exception t) {
                    t.printStackTrace();
                    this.notificationPane.setText("We encountered an error while processing your request. Please try again later");
                    FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.BAN);
                    icon.setStyle("-fx-fill: #d32f2f;");
                    icon.setSize("24.0");
                    this.notificationPane.setGraphic((Node)icon);
                    this.addBank.setDisable(false);
                }
            } else {
                FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TIMES);
                icon.setStyle("-fx-fill: #d32f2f;");
                icon.setSize("24.0");
                this.notificationPane.setGraphic((Node)icon);
                this.notificationPane.setText(message);
                this.notificationPane.show();
            }
        });
    }
}

