/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import classes.Account;
import classes.Bank;
import classes.ChargeItem;
import classes.Customer;
import classes.DriverConductor;
import classes.Employee;
import classes.FixedAssets;
import classes.Investment;
import classes.Loan;
import classes.Member;
import classes.ShopItem;
import classes.User;
import classes.Vehicle;
import classes.Vendor;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.apache.poi.ss.formula.functions.T;
import org.controlsfx.control.MaskerPane;

public class AccountSelectionController
implements Initializable {
    private User user;
    private String options;
    List<T> myEntries = FXCollections.observableArrayList();
    private String object;
    private String dataList;
    Type listType;
    private String type;
    @FXML
    private JFXTextField search;
    @FXML
    private TableView<T> allEntries;
    @FXML
    private MaskerPane masker;
    @FXML
    private JFXButton ok;
    @FXML
    private JFXButton cancel;
    @FXML
    private JFXButton clear;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getDataList() {
        String tType;
        String tOptions = "";
        try {
            tOptions = this.getOptions().trim();
        }
        catch (Exception u) {
            tOptions = "";
        }
        if (tOptions.length() > 0) {
            return tOptions;
        }
        switch (tType = this.getType().toLowerCase()) {
            case "bank": {
                return new Gson().toJson(Bank.getAllBanks(this.getUser()));
            }
            case "charge_item": {
                return new Gson().toJson(new ChargeItem().getChargeItems(this.getUser()));
            }
            case "user": {
                return new Gson().toJson(new User().getAllUsers(this.getUser()));
            }
            case "customer": {
                return new Gson().toJson(new Customer().getAllCustomers(this.getUser()));
            }
            case "vendor": {
                return new Gson().toJson(new Vendor().getAllVendors(this.getUser()));
            }
            case "member": {
                return new Gson().toJson(new Member().getAllMembers(this.getUser()));
            }
            case "vehicle": {
                return new Gson().toJson(new Vehicle().getAllVehicles(this.getUser()));
            }
            case "glaccount": {
                return new Gson().toJson(Account.getAccounts(this.getUser()));
            }
            case "investment": {
                return new Gson().toJson(new Investment().getAllInvestments(this.getUser()));
            }
            case "loan": {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("issued", 1);
                return new Gson().toJson(new Loan().getAllLoans(params, this.getUser()));
            }
            case "fixedasset": {
                return new Gson().toJson(new FixedAssets().getAllAssets(this.getUser()));
            }
            case "employee": {
                return new Gson().toJson(new Employee().getAllEmployees(this.getUser()));
            }
            case "staff": {
                return new Gson().toJson(new DriverConductor().allEmployees(this.getUser()));
            }
            case "shopitem": {
                return new Gson().toJson(new ShopItem().getAllItems(this.getUser()));
            }
            case "driverconductor": {
                return new Gson().toJson(new DriverConductor().allEmployees(this.getUser()));
            }
        }
        return "";
    }

    public Type getListType() {
        return this.listType;
    }

    public void setListType(Type listType) {
        this.listType = listType;
    }

    public void setDataList1(String dataList) {
        this.dataList = dataList;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getType() {
        return this.type;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void setType(String type) {
        this.type = type;
        String myType = type;
        if (myType.equalsIgnoreCase("bank")) {
            String tOptions = "";
            try {
                tOptions = this.getOptions();
            }
            catch (Exception p) {
                tOptions = "";
            }
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Bank Name");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("bankName"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.35));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Bank Branch");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("bankBranch"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("Account Number");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("bankAccount"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column3);
                TableColumn column4 = new TableColumn("Account Balance");
                column4.setCellValueFactory((Callback)new PropertyValueFactory("balanceString"));
                column4.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column4);
            });
            this.setListType(new TypeToken<ArrayList<Bank>>(){}.getType());
        } else if (myType.equalsIgnoreCase("charge_item")) {
            String tOptions = "";
            try {
                tOptions = this.getOptions();
            }
            catch (Exception p) {
                tOptions = "";
            }
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Code");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("code"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Description");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("name"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.4));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("G/L Account");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("account"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.3));
                this.allEntries.getColumns().add((Object)column3);
            });
            this.setListType(new TypeToken<ArrayList<ChargeItem>>(){}.getType());
        } else if (myType.equalsIgnoreCase("user")) {
            String tOptions = "";
            try {
                tOptions = this.getOptions();
            }
            catch (Exception p) {
                tOptions = "";
            }
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Username");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("userName"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.3));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Full name");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("fullName"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.3));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("User Role");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("userRole"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column3);
            });
            this.setListType(new TypeToken<ArrayList<User>>(){}.getType());
        } else if (myType.equalsIgnoreCase("customer")) {
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Customer No");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("customerNumber"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Customer Name");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("customerName"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.35));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("Id/Reg No");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("customerId"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column3);
                TableColumn column4 = new TableColumn("Customer Balance");
                column4.setCellValueFactory((Callback)new PropertyValueFactory("balanceString"));
                column4.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column4);
            });
            this.setListType(new TypeToken<ArrayList<Customer>>(){}.getType());
        } else if (myType.equalsIgnoreCase("vendor")) {
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Vendor No");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("vendorNumber"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Vendor Name");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("vendorName"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.35));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("Id/Reg No");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("vendorId"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column3);
                TableColumn column4 = new TableColumn("Vendor Balance");
                column4.setCellValueFactory((Callback)new PropertyValueFactory("balanceString"));
                column4.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column4);
            });
            this.setListType(new TypeToken<ArrayList<Vendor>>(){}.getType());
        } else if (myType.equalsIgnoreCase("member")) {
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Member No");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("memberNumber"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Member Name");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("fullName"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.3));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("Id No");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("idNumber"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)column3);
                TableColumn column4 = new TableColumn("Phone Number");
                column4.setCellValueFactory((Callback)new PropertyValueFactory("PhoneNumber"));
                column4.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column4);
                TableColumn column5 = new TableColumn("Share Capital");
                column5.setCellValueFactory((Callback)new PropertyValueFactory("shareCapitalString"));
                column5.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)column5);
                TableColumn column6 = new TableColumn("Deposits");
                column6.setCellValueFactory((Callback)new PropertyValueFactory("contributionsString"));
                column6.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)column6);
                TableColumn column7 = new TableColumn("Savings");
                column7.setCellValueFactory((Callback)new PropertyValueFactory("savingsString"));
                column7.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)column7);
            });
            this.setListType(new TypeToken<ArrayList<Member>>(){}.getType());
        } else if (myType.equalsIgnoreCase("vehicle")) {
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Vehicle Reg. No");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("regNo"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Make");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("make"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("Model");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("model"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column3);
                TableColumn column4 = new TableColumn("Owner");
                column4.setCellValueFactory((Callback)new PropertyValueFactory("owner"));
                column4.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.35));
                this.allEntries.getColumns().add((Object)column4);
                TableColumn column5 = new TableColumn("Service Fee Arrears");
                column5.setCellValueFactory((Callback)new PropertyValueFactory("serviceArrearsString"));
                column5.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column5);
            });
            this.setListType(new TypeToken<ArrayList<Vehicle>>(){}.getType());
        } else if (myType.equalsIgnoreCase("glaccount")) {
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Account Number");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("accountNumber"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Account Name");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("accountName"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.35));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("Balance");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("accountBalanceString"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column3);
                TableColumn column4 = new TableColumn("No. of GL Entries");
                column4.setCellValueFactory((Callback)new PropertyValueFactory("noOfTransactionString"));
                column4.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column4);
                TableColumn column5 = new TableColumn("Last Transaction Date");
                column5.setCellValueFactory((Callback)new PropertyValueFactory("lastTransactionDate"));
                column5.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column5);
            });
            this.setListType(new TypeToken<ArrayList<Account>>(){}.getType());
        } else if (myType.equalsIgnoreCase("shopitem")) {
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Item Id");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("code"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Item Name");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("name"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.4));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("Brand");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("brand"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column3);
                TableColumn column4 = new TableColumn("Price");
                column4.setCellValueFactory((Callback)new PropertyValueFactory("priceString"));
                column4.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column4);
                TableColumn column5 = new TableColumn("Available");
                column5.setCellValueFactory((Callback)new PropertyValueFactory("available"));
                column5.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)column5);
            });
            this.setListType(new TypeToken<ArrayList<ShopItem>>(){}.getType());
        } else if (myType.equalsIgnoreCase("driverconductor")) {
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Staff No");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("employeeNo"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Staff Name");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("name"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.3));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("Id No");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("idNo"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column3);
                TableColumn column4 = new TableColumn("Phone No");
                column4.setCellValueFactory((Callback)new PropertyValueFactory("phoneNo"));
                column4.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column4);
                TableColumn column5 = new TableColumn("Position");
                column5.setCellValueFactory((Callback)new PropertyValueFactory("position"));
                column5.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)column5);
            });
            this.setListType(new TypeToken<ArrayList<DriverConductor>>(){}.getType());
        } else if (myType.equalsIgnoreCase("loan")) {
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Loan No");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("loanNumber"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Member Name");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("member"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("Loan Product");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("loanProduct"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column3);
                TableColumn column4 = new TableColumn("Principal Amount");
                column4.setCellValueFactory((Callback)new PropertyValueFactory("loanAmountString"));
                column4.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column4);
                TableColumn column5 = new TableColumn("Loan Balance");
                column5.setCellValueFactory((Callback)new PropertyValueFactory("loanBalanceString"));
                column5.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column5);
                TableColumn column6 = new TableColumn("Issued On");
                column6.setCellValueFactory((Callback)new PropertyValueFactory("issuedOn"));
                column6.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column6);
            });
            this.setListType(new TypeToken<ArrayList<Loan>>(){}.getType());
        } else if (myType.equalsIgnoreCase("investment")) {
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Investment No");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("investmentNo"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Investment Name");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("investmentName"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("Investment Description");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("description"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column3);
                TableColumn column4 = new TableColumn("Start Date");
                column4.setCellValueFactory((Callback)new PropertyValueFactory("startDate"));
                column4.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column4);
                TableColumn column5 = new TableColumn("Value");
                column5.setCellValueFactory((Callback)new PropertyValueFactory("valueString"));
                column5.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column5);
            });
            this.setListType(new TypeToken<ArrayList<Investment>>(){}.getType());
        } else if (myType.equalsIgnoreCase("fixedasset")) {
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("No");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("assetNo"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Serial No");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("assetSerial"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn nameColumn = new TableColumn("Name");
                nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("assetName"));
                nameColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.25));
                this.allEntries.getColumns().add((Object)nameColumn);
                TableColumn descriptionColumn = new TableColumn("Description");
                descriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("Description"));
                descriptionColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.25));
                this.allEntries.getColumns().add((Object)descriptionColumn);
                TableColumn column3 = new TableColumn("Date Acquired");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("dateAcquired"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                TableColumn column4 = new TableColumn("Book Value");
                column4.setCellValueFactory((Callback)new PropertyValueFactory("bookValueString"));
                column4.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                TableColumn column5 = new TableColumn("Location");
                column5.setCellValueFactory((Callback)new PropertyValueFactory("location"));
                column5.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column5);
                TableColumn column6 = new TableColumn("Assigned To");
                column6.setCellValueFactory((Callback)new PropertyValueFactory("assignedTo"));
                column6.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column6);
            });
            this.setListType(new TypeToken<ArrayList<FixedAssets>>(){}.getType());
        } else if (myType.equalsIgnoreCase("employee")) {
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Employee No");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("employeeNumber"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Employee Name");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("fullName"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.25));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("Phone No");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("phoneNumber"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column3);
                TableColumn column4 = new TableColumn("Email");
                column4.setCellValueFactory((Callback)new PropertyValueFactory("email"));
                column4.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column4);
                TableColumn column5 = new TableColumn("Job Title");
                column5.setCellValueFactory((Callback)new PropertyValueFactory("jobTitle"));
                column5.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column5);
                TableColumn column6 = new TableColumn("Assigned To");
                column6.setCellValueFactory((Callback)new PropertyValueFactory("assignedTo"));
                column6.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column6);
            });
            this.setListType(new TypeToken<ArrayList<Employee>>(){}.getType());
        } else if (myType.equalsIgnoreCase("staff")) {
            Platform.runLater(() -> {
                TableColumn myColumn = new TableColumn("Staff No");
                myColumn.setCellValueFactory((Callback)new PropertyValueFactory("employeeNo"));
                myColumn.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)myColumn);
                TableColumn column2 = new TableColumn("Staff Name");
                column2.setCellValueFactory((Callback)new PropertyValueFactory("name"));
                column2.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.25));
                this.allEntries.getColumns().add((Object)column2);
                TableColumn column3 = new TableColumn("Staff Id");
                column3.setCellValueFactory((Callback)new PropertyValueFactory("idNo"));
                column3.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column3);
                TableColumn column4 = new TableColumn("Phone No");
                column4.setCellValueFactory((Callback)new PropertyValueFactory("phoneNo"));
                column4.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.2));
                this.allEntries.getColumns().add((Object)column4);
                TableColumn column5 = new TableColumn("Position");
                column5.setCellValueFactory((Callback)new PropertyValueFactory("position"));
                column5.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.15));
                this.allEntries.getColumns().add((Object)column5);
                TableColumn column6 = new TableColumn("NHIF/NSSF");
                column6.setCellValueFactory((Callback)new PropertyValueFactory("NhifNssfContString"));
                column6.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)column6);
                TableColumn column7 = new TableColumn("KITTY");
                column7.setCellValueFactory((Callback)new PropertyValueFactory("DrKittyString"));
                column7.prefWidthProperty().bind((ObservableValue)this.allEntries.widthProperty().multiply(0.1));
                this.allEntries.getColumns().add((Object)column7);
            });
            this.setListType(new TypeToken<ArrayList<DriverConductor>>(){}.getType());
        }
        this.loadItems();
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.masker.setVisible(false);
        this.clear.setOnAction(e -> this.search.setText(""));
        this.allEntries.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    Object rowData = row.getItem();
                    this.setObject(new Gson().toJson(rowData));
                    Stage stage = (Stage)this.allEntries.getScene().getWindow();
                    stage.close();
                }
            });
            return row;
        });
        this.search.textProperty().addListener((observable, oldValue, newValue) -> {
            ObservableList afterSearch = FXCollections.observableArrayList();
            String searchString = newValue.toLowerCase();
            for (int b = 0; b < this.myEntries.size(); ++b) {
                try {
                    Gson g = new Gson();
                    String current = g.toJson((Object)this.myEntries.get(b));
                    current = current.toLowerCase();
                    if (!current.contains(searchString)) continue;
                    afterSearch.add((Object)this.myEntries.get(b));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.allEntries.getItems().removeAll((Collection)this.allEntries.getItems());
            this.allEntries.setItems(afterSearch);
        });
        this.cancel.setOnAction(e -> {
            try {
                Stage stage = (Stage)this.cancel.getScene().getWindow();
                stage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.ok.setOnAction(e -> {
            try {
                Object choice = this.allEntries.getSelectionModel().getSelectedItem();
                try {
                    this.setObject(new Gson().toJson(choice));
                }
                catch (Exception t) {
                    t.printStackTrace();
                }
                Stage stage = (Stage)this.ok.getScene().getWindow();
                stage.close();
            }
            catch (NullPointerException p) {
                Alert alert = new Alert(Alert.AlertType.ERROR);
                alert.setTitle("Please select a " + this.getType());
                alert.setContentText("Please select a " + this.getType() + " to confirm your selection");
                alert.showAndWait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void loadItems() {
        Task<Void> task1 = new Task<Void>(){

            public Void call() {
                Platform.runLater(() -> AccountSelectionController.this.masker.setVisible(true));
                String response = AccountSelectionController.this.getDataList();
                List yourClassList = (List)new Gson().fromJson(response, AccountSelectionController.this.getListType());
                AccountSelectionController.this.myEntries = (List)new Gson().fromJson(response, AccountSelectionController.this.getListType());
                Platform.runLater(() -> {
                    AccountSelectionController.this.allEntries.setItems(FXCollections.observableArrayList((Collection)yourClassList));
                    AccountSelectionController.this.masker.setVisible(false);
                });
                return null;
            }
        };
        Thread backgroundThread = new Thread((Runnable)task1);
        backgroundThread.setDaemon(true);
        backgroundThread.start();
    }
}

