/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Bank;
import classes.Config;
import classes.Customer;
import classes.Employee;
import classes.JsonResponses;
import classes.PricingGroup;
import classes.ShopLocation;
import classes.UserRoles;
import classes.Versions;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class User {
    private String userName;
    private String fullName;
    private String email;
    private String phone;
    private String userGroup;
    private String password;
    private String lastSeen;
    private String passwordLastChanged;
    private String status;
    private String addedOn;
    private Boolean loginStatus;
    private String loginMessage;
    private UserRoles userRole;
    private HashMap<String, Object> matrixDetails;
    private boolean update;
    private Versions[] versions;
    private Employee employee;
    private Customer receivablesAccount;
    private ShopLocation warehouse;
    private PricingGroup pricingGroup;
    private Bank defaultBank;
    private int store_location;

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(String userGroup) {
        this.userGroup = userGroup;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(String lastSeen) {
        this.lastSeen = lastSeen;
    }

    public String getPasswordLastChanged() {
        return this.passwordLastChanged;
    }

    public void setPasswordLastChanged(String passwordLastChanged) {
        this.passwordLastChanged = passwordLastChanged;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAddedOn() {
        return this.addedOn;
    }

    public void setAddedOn(String addedOn) {
        this.addedOn = addedOn;
    }

    public UserRoles getUserRole() {
        return this.userRole;
    }

    public void setUserRole(UserRoles userRole) {
        this.userRole = userRole;
    }

    public Boolean getLoginStatus() {
        return this.loginStatus;
    }

    public void setLoginStatus(Boolean loginStatus) {
        this.loginStatus = loginStatus;
    }

    public String getLoginMessage() {
        return this.loginMessage;
    }

    public void setLoginMessage(String loginMessage) {
        this.loginMessage = loginMessage;
    }

    public HashMap<String, Object> getMatrixDetails() {
        return this.matrixDetails;
    }

    public void setMatrixDetails(HashMap<String, Object> matrixDetails) {
        this.matrixDetails = matrixDetails;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public Versions[] getVersions() {
        return this.versions;
    }

    public void setVersions(Versions[] versions) {
        this.versions = versions;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Customer getReceivablesAccount() {
        return this.receivablesAccount;
    }

    public void setReceivablesAccount(Customer receivablesAccount) {
        this.receivablesAccount = receivablesAccount;
    }

    public ShopLocation getWarehouse() {
        return this.warehouse;
    }

    public void setWarehouse(ShopLocation warehouse) {
        this.warehouse = warehouse;
    }

    public PricingGroup getPricingGroup() {
        return this.pricingGroup;
    }

    public void setPricingGroup(PricingGroup pricingGroup) {
        this.pricingGroup = pricingGroup;
    }

    public Bank getDefaultBank() {
        return this.defaultBank;
    }

    public void setDefaultBank(Bank defaultBank) {
        this.defaultBank = defaultBank;
    }

    public int getStore_location() {
        return this.store_location;
    }

    public void setStore_location(int store_location) {
        this.store_location = store_location;
    }

    public ObservableList<User> getAllUsers(User user) {
        ObservableList allUsers = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String response = Config.loadDataFromPhp("masterfetch?type=user", params, user);
            Gson g = new Gson();
            allUsers = FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, User[].class)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allUsers;
    }

    public ObservableList<User> getAllUsers(boolean vsm, User user) {
        ObservableList allUsers = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("vsm", vsm ? 1 : 0);
            String response = Config.loadDataFromPhp("masterfetch?type=user", params, user);
            System.out.println(response);
            Gson g = new Gson();
            allUsers = FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, User[].class)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allUsers;
    }

    public String toString() {
        return this.fullName;
    }

    public JsonResponses blockUser(User userToBlock, User userBlocking) {
        JsonResponses jr = new JsonResponses();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("user", userToBlock.getUserName());
            String response = Config.loadDataFromPhp("masterupdate?type=blockUser", params, userBlocking);
            Gson g = new Gson();
            jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        }
        catch (Exception r) {
            jr.setMessage("We experienced an error while processing your request. Please try again later");
            jr.setStatus(false);
        }
        return jr;
    }

    public JsonResponses activateUser(User userToActivate, User userActivating) {
        JsonResponses jr = new JsonResponses();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("user", userToActivate.getUserName());
            String response = Config.loadDataFromPhp("masterupdate?type=activateUser", params, userActivating);
            Gson g = new Gson();
            jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        }
        catch (Exception r) {
            jr.setMessage("We experienced an error while processing your request. Please try again later");
            jr.setStatus(false);
            r.printStackTrace();
        }
        return jr;
    }
}

