/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.JsonResponses;
import classes.ShopItem;
import classes.User;
import com.google.gson.Gson;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;

public class StockTransferLine {
    private User user;
    private int id;
    private double unitPrice;
    private double quantity;
    private String transferCode;
    private ShopItem item;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(double unitPrice) {
        this.unitPrice = unitPrice;
    }

    public String getTransferCode() {
        return this.transferCode;
    }

    public void setTransferCode(String transferCode) {
        this.transferCode = transferCode;
    }

    public ShopItem getItem() {
        return this.item;
    }

    public void setItem(ShopItem item) {
        this.item = item;
    }

    public Button getRemove() {
        Button deleteBtn = new Button();
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TRASH);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("16.0");
        deleteBtn.setGraphic((Node)icon);
        deleteBtn.setOnAction(event -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("id", this.id);
            params.put("transferCode", this.transferCode);
            new Config();
            String response = Config.loadDataFromPhp("masterdelete?type=stocktransferline", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                // empty if block
            }
        });
        return deleteBtn;
    }

    public ObservableList<StockTransferLine> getAllLines(String code, User user) {
        ObservableList allLines = FXCollections.observableArrayList();
        ObservableList toReturn = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("transferCode", code);
            String response = Config.loadDataFromPhp("masterfetch?type=stocktransferlines", params, user);
            System.out.println(response);
            Gson g = new Gson();
            allLines = FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, StockTransferLine[].class)));
        }
        catch (Exception t) {
            t.printStackTrace();
        }
        for (StockTransferLine line : allLines) {
            line.setUser(user);
            toReturn.add((Object)line);
        }
        return toReturn;
    }
}

