/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.Contact;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.Arrays;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;

public class Sms {
    private User user;
    private String id;
    private String message;
    private String enteredOn;
    private String status;
    private String sentOn;
    private Contact contact;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMaskifiedMessage() {
        int length = this.message.length();
        String output = "";
        for (int pos = 0; pos < length; ++pos) {
            output = pos < 4 ? output.concat(String.valueOf(this.message.charAt(pos))) : (pos + 4 >= length ? output.concat(String.valueOf(this.message.charAt(pos))) : output.concat("."));
        }
        return output;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getEnteredOn() {
        return this.enteredOn;
    }

    public void setEnteredOn(String enteredOn) {
        this.enteredOn = enteredOn;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSentOn() {
        return this.sentOn;
    }

    public void setSentOn(String sentOn) {
        this.sentOn = sentOn;
    }

    public String getName() {
        return this.contact.getName();
    }

    public String getNumber() {
        return this.contact.getPhoneNumber();
    }

    public Button getSend() {
        Button sendBtn = new Button();
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.PLAY_CIRCLE_ALT);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("16.0");
        sendBtn.setGraphic((Node)icon);
        sendBtn.setOnAction(event -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("id", this.getId());
            params.put("recipientType", "Individual");
            params.put("recipient", this.contact.getId());
            params.put("recipientNo", this.contact.getPhoneNumber());
            params.put("message", this.message);
            params.put("status", "sent");
            String response = Config.loadDataFromPhp("mastercreate?type=sms", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
        });
        if (this.status.equals("sent")) {
            sendBtn.setDisable(true);
        }
        return sendBtn;
    }

    public ObservableList<Sms> getAllSms(User user) {
        new Config();
        ObservableList allSMs = FXCollections.observableList(Arrays.asList((Object[])new Gson().fromJson(Config.loadDataFromPhp("masterfetch?type=sms", new LinkedHashMap<String, Object>(), user), Sms[].class)));
        ObservableList toReturn = FXCollections.observableArrayList();
        for (Sms mySms : allSMs) {
            mySms.setUser(user);
            toReturn.add((Object)mySms);
        }
        return toReturn;
    }
}

