/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.FixedAssets;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class SalesLines {
    private User user;
    private int lineId;
    private String docNo;
    private String documentType;
    private String itemType;
    private String itemNo;
    private String description;
    private double unitPrice;
    private double quantity;
    private double discount;
    private double totalExclVAT;
    private double totalVAT;
    private double totalAmount;
    private String unitOfMeasure;
    private String details;
    private FixedAssets vehicle;
    private double kilometres;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getLineId() {
        return this.lineId;
    }

    public void setLineId(int lineId) {
        this.lineId = lineId;
    }

    public String getDocNo() {
        return this.docNo;
    }

    public void setDocNo(String docNo) {
        this.docNo = docNo;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemNo() {
        return this.itemNo;
    }

    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public double getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(double unitPrice) {
        this.unitPrice = unitPrice;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getTotalExclVAT() {
        return this.totalExclVAT;
    }

    public void setTotalExclVAT(double totalExclVAT) {
        this.totalExclVAT = totalExclVAT;
    }

    public double getTotalVAT() {
        return this.totalVAT;
    }

    public void setTotalVAT(double totalVAT) {
        this.totalVAT = totalVAT;
    }

    public double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public FixedAssets getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(FixedAssets vehicle) {
        this.vehicle = vehicle;
    }

    public double getKilometres() {
        return this.kilometres;
    }

    public void setKilometres(double kilometres) {
        this.kilometres = kilometres;
    }

    public ObservableList<SalesLines> getAllLines(String headerNo, String documentType, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("docNo", headerNo);
        params.put("docType", documentType);
        String response = Config.loadDataFromPhp("masterfetch?type=salesline", params, user);
        System.out.println(response);
        Gson g = new Gson();
        ObservableList allLines = FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, SalesLines[].class)));
        ObservableList toReturn = FXCollections.observableArrayList();
        for (SalesLines line : allLines) {
            line.setUser(user);
            toReturn.add((Object)line);
        }
        return toReturn;
    }

    public String getUnitPriceString() {
        return Config.formatNumber(this.unitPrice);
    }

    public String getTotalAmountString() {
        return Config.formatNumber(this.totalAmount);
    }

    public String getQuantityString() {
        return Config.formatNumber(this.quantity);
    }

    public String getDiscountString() {
        return Config.formatNumber(this.discount);
    }

    public String toString() {
        return "Description='" + this.description + '\'' + ", Amount=" + this.totalAmount;
    }
}

