/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Bank;
import classes.Config;
import classes.Customer;
import classes.JsonResponses;
import classes.Project;
import classes.SalesLines;
import classes.ShopLocation;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class SalesHeader {
    private String doc_no;
    private Customer customer;
    private String createdOn;
    private boolean posted;
    private String postedOn;
    private double totalExclVAT;
    private double totalVAT;
    private double totalAmount;
    private String payments;
    private String discounts;
    private String variance;
    private String sales_date;
    private String userFullName;
    private String totalExclVATString;
    private String totalVATString;
    private String totalAmountString;
    private String purpose;
    private String fromDate;
    private String toDate;
    private String activity;
    private String target;
    private double balance;
    private Project project;
    private Bank bank;
    private String externalRef;
    private String docNo;
    private String vsmName;
    private String docType;
    private String document_type;
    private String approvedBy;
    private boolean confirmedBySuperUser;
    private boolean confirmedByAccounts;
    private String status;
    private ShopLocation location;
    private User salesRep;
    private String serialNo;
    private String cuInvoiceNo;
    private String internalData;
    private String qrCode;
    private String receiptSignature;
    private String invoice;
    private String customerName;
    private String customerPin;
    private String comment;
    private String reference;
    private String paymentStatus;
    private ObservableList<SalesLines> lines;

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
    }

    public String getPostedOn() {
        return this.postedOn;
    }

    public void setPostedOn(String postedOn) {
        this.postedOn = postedOn;
    }

    public double getTotalExclVAT() {
        return this.totalExclVAT;
    }

    public void setTotalExclVAT(double totalExclVAT) {
        this.totalExclVAT = totalExclVAT;
    }

    public double getTotalVAT() {
        return this.totalVAT;
    }

    public void setTotalVAT(double totalVAT) {
        this.totalVAT = totalVAT;
    }

    public double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getTotalExclVATString() {
        return Config.formatNumber(this.totalExclVAT);
    }

    public String getTotalVATString() {
        return Config.formatNumber(this.totalVAT);
    }

    public ObservableList<SalesLines> getLines() {
        return this.lines;
    }

    public void setLines(ObservableList<SalesLines> lines) {
        this.lines = lines;
    }

    public String getTotalAmountString() {
        return Config.formatNumber(this.totalAmount);
    }

    public String getDoc_no() {
        return this.doc_no;
    }

    public void setDoc_no(String doc_no) {
        this.doc_no = doc_no;
    }

    public String getSales_date() {
        return this.sales_date;
    }

    public void setSales_date(String sales_date) {
        this.sales_date = sales_date;
    }

    public String getUserFullName() {
        return this.userFullName;
    }

    public void setUserFullName(String userFullName) {
        this.userFullName = userFullName;
    }

    public String getDocNo() {
        return this.docNo;
    }

    public void setDocNo(String docNo) {
        this.docNo = docNo;
    }

    public String getVsmName() {
        return this.vsmName;
    }

    public void setVsmName(String vsmName) {
        this.vsmName = vsmName;
    }

    public void setTotalExclVATString(String totalExclVATString) {
        this.totalExclVATString = totalExclVATString;
    }

    public void setTotalVATString(String totalVATString) {
        this.totalVATString = totalVATString;
    }

    public void setTotalAmountString(String totalAmountString) {
        this.totalAmountString = totalAmountString;
    }

    public double getBalance() {
        return this.balance;
    }

    public String getBalanceString() {
        return Config.formatNumber(this.balance);
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public String getToDate() {
        return this.toDate;
    }

    public void setToDate(String toDate) {
        this.toDate = toDate;
    }

    public String getActivity() {
        return this.activity;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public String getExternalRef() {
        return this.externalRef;
    }

    public void setExternalRef(String externalRef) {
        this.externalRef = externalRef;
    }

    public String getDocType() {
        return this.docType;
    }

    public void setDocType(String docType) {
        this.docType = docType;
    }

    public String getApprovedBy() {
        return this.approvedBy;
    }

    public void setApprovedBy(String approvedBy) {
        this.approvedBy = approvedBy;
    }

    public String getDocument_type() {
        return this.document_type;
    }

    public void setDocument_type(String document_type) {
        this.document_type = document_type;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public boolean isConfirmedBySuperUser() {
        return this.confirmedBySuperUser;
    }

    public void setConfirmedBySuperUser(boolean confirmedBySuperUser) {
        this.confirmedBySuperUser = confirmedBySuperUser;
    }

    public boolean isConfirmedByAccounts() {
        return this.confirmedByAccounts;
    }

    public void setConfirmedByAccounts(boolean confirmedByAccounts) {
        this.confirmedByAccounts = confirmedByAccounts;
    }

    public String getPayments() {
        return this.payments;
    }

    public void setPayments(String payments) {
        this.payments = payments;
    }

    public String getDiscounts() {
        return this.discounts;
    }

    public void setDiscounts(String discounts) {
        this.discounts = discounts;
    }

    public String getVariance() {
        return this.variance;
    }

    public void setVariance(String variance) {
        this.variance = variance;
    }

    public ShopLocation getLocation() {
        return this.location;
    }

    public void setLocation(ShopLocation location) {
        this.location = location;
    }

    public User getSalesRep() {
        return this.salesRep;
    }

    public void setSalesRep(User salesRep) {
        this.salesRep = salesRep;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public String getInternalData() {
        return this.internalData;
    }

    public void setInternalData(String internalData) {
        this.internalData = internalData;
    }

    public String getQrCode() {
        return this.qrCode;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    public String getReceiptSignature() {
        return this.receiptSignature;
    }

    public void setReceiptSignature(String receiptSignature) {
        this.receiptSignature = receiptSignature;
    }

    public String getCuInvoiceNo() {
        return this.cuInvoiceNo;
    }

    public void setCuInvoiceNo(String cuInvoiceNo) {
        this.cuInvoiceNo = cuInvoiceNo;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getInvoice() {
        return this.invoice;
    }

    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerPin() {
        return this.customerPin;
    }

    public void setCustomerPin(String customerPin) {
        this.customerPin = customerPin;
    }

    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    public void setPaymentStatus(String paymentStatus) {
        this.paymentStatus = paymentStatus;
    }

    public ObservableList<SalesHeader> getAllInvoices(boolean posted, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("posted", posted ? 1 : 0);
        String response = Config.loadDataFromPhp("masterfetch?type=salesheader", params, user);
        System.out.println(response);
        Gson g = new Gson();
        return FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, SalesHeader[].class)));
    }

    public ObservableList<SalesHeader> getCustomerPendingInvoices(boolean posted, User user, String customerNo) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("posted", posted ? 1 : 0);
        params.put("customerNo", customerNo);
        String response = Config.loadDataFromPhp("masterfetch?type=salesheader", params, user);
        System.out.println(response);
        Gson g = new Gson();
        return FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, SalesHeader[].class)));
    }

    public ObservableList<SalesHeader> getCustomerPendingInvoices(boolean posted, User user, String customerNo, String documentType) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("posted", posted ? 1 : 0);
        params.put("customerNo", customerNo);
        params.put("document_type", documentType);
        String response = Config.loadDataFromPhp("masterfetch?type=salesheader", params, user);
        System.out.println(response);
        Gson g = new Gson();
        return FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, SalesHeader[].class)));
    }

    public JsonResponses deleteInvoice(String invoiceNo, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("invoiceNo", invoiceNo);
        String response = Config.loadDataFromPhp("masterdelete?type=salesheader", params, user);
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        return jr;
    }

    public JsonResponses postDocument(String docNo, String documentType, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("docNo", docNo);
        params.put("docType", documentType);
        String response = Config.loadDataFromPhp("masterpost?type=salesheader", params, user);
        System.out.println("Posting Sales Header: " + response);
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        return jr;
    }

    public JsonResponses sendDocumentForApproval(String docNo, String documentType, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("docNo", docNo);
        params.put("docType", documentType);
        String response = Config.loadDataFromPhp("masterupdate?type=send_approval", params, user);
        System.out.println(response);
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        return jr;
    }

    public JsonResponses rejectDocument(String docNo, String documentType, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("docNo", docNo);
        params.put("docType", documentType);
        String response = Config.loadDataFromPhp("masterupdate?type=reject_document", params, user);
        System.out.println(response);
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        return jr;
    }

    public String toString() {
        return "Doc No : '" + this.doc_no + '\'' + ", Invoice Amount: " + Config.formatNumber(this.totalAmount) + ", Balance : " + Config.formatNumber(this.balance);
    }
}

