/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Bank;
import classes.Config;
import classes.JsonResponses;
import classes.Member;
import classes.PaymentMethod;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class Receipt {
    private String receiptNo;
    private Member member;
    private Bank bank;
    private PaymentMethod paymentMethod;
    private String externalRefNo;
    private String paymentDate;
    private String receivedFrom;
    private double amount;
    private String user;
    private boolean posted;
    private boolean reversed;
    private String formatedAmount;

    public Receipt(String receiptNo, Member member, Bank bank, PaymentMethod paymentMethod, String externalRefNo, String paymentDate, String receivedFrom, double amount, String user) {
        this.receiptNo = receiptNo;
        this.member = member;
        this.bank = bank;
        this.paymentMethod = paymentMethod;
        this.externalRefNo = externalRefNo;
        this.paymentDate = paymentDate;
        this.receivedFrom = receivedFrom;
        this.amount = amount;
        this.user = user;
    }

    public String getReceiptNo() {
        return this.receiptNo;
    }

    public void setReceiptNo(String receiptNo) {
        this.receiptNo = receiptNo;
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getExternalRefNo() {
        return this.externalRefNo;
    }

    public void setExternalRefNo(String externalRefNo) {
        this.externalRefNo = externalRefNo;
    }

    public String getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(String paymentDate) {
        this.paymentDate = paymentDate;
    }

    public String getReceivedFrom() {
        return this.receivedFrom;
    }

    public void setReceivedFrom(String receivedFrom) {
        this.receivedFrom = receivedFrom;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getFormatedAmount() {
        return Config.formatNumber(this.amount);
    }

    public void setFormatedAmount(String formatedAmount) {
        this.formatedAmount = formatedAmount;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public Receipt() {
    }

    public ObservableList<Receipt> getAllReceipts(boolean posted, boolean reversed, User user) {
        ObservableList allReceipts = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("posted", posted ? 1 : 0);
            params.put("reversed", reversed ? 1 : 0);
            String response = Config.loadDataFromPhp("masterfetch?type=memberreceipts", params, user);
            Gson g = new Gson();
            allReceipts = FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, Receipt[].class)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allReceipts;
    }

    public JsonResponses postReceipt(String receiptNumber, User user) {
        JsonResponses response = new JsonResponses();
        response.setStatus(false);
        response.setMessage("The receipt could not be posted");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("receiptNo", receiptNumber);
        String myResponse = Config.loadDataFromPhp("masterpost?type=receipt", params, user);
        Gson g = new Gson();
        response = (JsonResponses)g.fromJson(myResponse, JsonResponses.class);
        return response;
    }

    public JsonResponses reverseReceipt(String receiptNumber, User user) {
        JsonResponses response = new JsonResponses();
        response.setStatus(false);
        response.setMessage("The receipt could not be reverses");
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("receiptNo", receiptNumber);
        String myResponse = Config.loadDataFromPhp("masterpost?type=reversereceipt", params, user);
        Gson g = new Gson();
        response = (JsonResponses)g.fromJson(myResponse, JsonResponses.class);
        return response;
    }

    public boolean deleteReceipt(String receiptNumber, User user) {
        if (!receiptNumber.equals("") && !receiptNumber.equals(null)) {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("receiptNumber", receiptNumber);
                String response = Config.loadDataFromPhp("masterdelete?type=memberreceipt", params, user);
                Gson g = new Gson();
                JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    return true;
                }
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
    }
}

