/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.FixedAssets;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;

public class PurchaseLines {
    private User user;
    private int lineId;
    private String documentType;
    private String documentNumber;
    private String itemType;
    private String itemNo;
    private String itemDescription;
    private double unitPrice;
    private double quantity;
    private double discount;
    private double approvedQuantity;
    private double totalExclVAT;
    private double totalVAT;
    private double totalAmount;
    private User salesRep;
    private FixedAssets vehicle;
    private double kiloMetres;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getLineId() {
        return this.lineId;
    }

    public void setLineId(int lineId) {
        this.lineId = lineId;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemNo() {
        return this.itemNo;
    }

    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    public String getItemDescription() {
        return this.itemDescription;
    }

    public void setItemDescription(String itemDescription) {
        this.itemDescription = itemDescription;
    }

    public double getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(double unitPrice) {
        this.unitPrice = unitPrice;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getTotalExclVAT() {
        return this.totalExclVAT;
    }

    public void setTotalExclVAT(double totalExclVAT) {
        this.totalExclVAT = totalExclVAT;
    }

    public double getTotalVAT() {
        return this.totalVAT;
    }

    public void setTotalVAT(double totalVAT) {
        this.totalVAT = totalVAT;
    }

    public double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public User getSalesRep() {
        return this.salesRep;
    }

    public void setSalesRep(User salesRep) {
        this.salesRep = salesRep;
    }

    public FixedAssets getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(FixedAssets vehicle) {
        this.vehicle = vehicle;
    }

    public double getKiloMetres() {
        return this.kiloMetres;
    }

    public void setKiloMetres(double kiloMetres) {
        this.kiloMetres = kiloMetres;
    }

    public ObservableList<PurchaseLines> getAllLines(String invoiceNo, User user) {
        ObservableList toReturn = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("invoiceNo", invoiceNo);
        String response = Config.loadDataFromPhp("masterfetch?type=vendorinvoicelines", params, user);
        Gson g = new Gson();
        ObservableList allLines = FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, PurchaseLines[].class)));
        for (PurchaseLines myLine : allLines) {
            myLine.setUser(user);
            toReturn.add((Object)myLine);
        }
        return toReturn;
    }

    public String getUnitPriceString() {
        return Config.formatNumber(this.unitPrice);
    }

    public String getTotalAmountString() {
        return Config.formatNumber(this.totalAmount);
    }

    public String getDiscountString() {
        return Config.formatNumber(this.discount);
    }

    public String getQuantityString() {
        return Config.formatNumber(this.quantity);
    }

    public double getApprovedQuantity() {
        return this.approvedQuantity;
    }

    public String getApprovedQuantityString() {
        return Config.formatNumber(this.approvedQuantity);
    }

    public void setApprovedQuantity(double approvedQuantity) {
        this.approvedQuantity = approvedQuantity;
    }

    public Button getDelete() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TRASH);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("16.0");
        Button deleteButton = new Button();
        deleteButton.setGraphic((Node)icon);
        deleteButton.setOnAction(e -> {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("invoiceLine", this.getLineId());
                String response = Config.loadDataFromPhp("masterdelete?type=vendorinvoiceline", params, this.getUser());
                System.out.println(response);
                Gson g = new Gson();
                JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                if (jr.isStatus()) {
                    ObservableList<PurchaseLines> allLines = new PurchaseLines().getAllLines(this.getDocumentNumber(), this.getUser());
                    double tTotalExVAT = 0.0;
                    double tTotalVAT = 0.0;
                    double tTotalExAmount = 0.0;
                    for (PurchaseLines line : allLines) {
                        tTotalExVAT += line.getTotalExclVAT();
                        tTotalVAT += line.getTotalVAT();
                        tTotalExAmount += line.getTotalAmount();
                    }
                }
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        });
        return deleteButton;
    }
}

