/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.JsonResponses;
import classes.Project;
import classes.PurchaseLines;
import classes.ShopLocation;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class PurchaseHeader {
    private String documentType;
    private String documentNo;
    private Vendor vendor;
    private String createdOn;
    private String invoiceDate;
    private boolean posted;
    private String postedOn;
    private double totalExclVAT;
    private double totalVAT;
    private double totalAmount;
    private ShopLocation location;
    private ObservableList<PurchaseLines> lines;
    private Project project;
    private String lpoNo;
    private String externalDocNo;
    private String entryNo;
    private String comment;
    private String status;

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getDocumentNo() {
        return this.documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public Vendor getVendor() {
        return this.vendor;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
    }

    public String getPostedOn() {
        return this.postedOn;
    }

    public void setPostedOn(String postedOn) {
        this.postedOn = postedOn;
    }

    public double getTotalExclVAT() {
        return this.totalExclVAT;
    }

    public void setTotalExclVAT(double totalExclVAT) {
        this.totalExclVAT = totalExclVAT;
    }

    public double getTotalVAT() {
        return this.totalVAT;
    }

    public void setTotalVAT(double totalVAT) {
        this.totalVAT = totalVAT;
    }

    public double getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getTotalExclVATString() {
        return Config.formatNumber(this.totalExclVAT);
    }

    public String getTotalVATString() {
        return Config.formatNumber(this.totalVAT);
    }

    public ObservableList<PurchaseLines> getLines() {
        return this.lines;
    }

    public void setLines(ObservableList<PurchaseLines> lines) {
        this.lines = lines;
    }

    public String getTotalAmountString() {
        return Config.formatNumber(this.totalAmount);
    }

    public String getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(String invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public ShopLocation getLocation() {
        return this.location;
    }

    public void setLocation(ShopLocation location) {
        this.location = location;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getEntryNo() {
        return this.entryNo;
    }

    public void setEntryNo(String entryNo) {
        this.entryNo = entryNo;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getLpoNo() {
        return this.lpoNo;
    }

    public void setLpoNo(String lpoNo) {
        this.lpoNo = lpoNo;
    }

    public String getExternalDocNo() {
        return this.externalDocNo;
    }

    public void setExternalDocNo(String externalDocNo) {
        this.externalDocNo = externalDocNo;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ObservableList<PurchaseHeader> getAllInvoices(boolean posted, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("posted", posted);
        String response = Config.loadDataFromPhp("masterfetch?type=vendorinvoices", params, user);
        Gson g = new Gson();
        return FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, PurchaseHeader[].class)));
    }

    public ObservableList<PurchaseHeader> getVendorInvoices(Vendor vendor, boolean posted, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("vendor", vendor.getVendorNumber());
        params.put("posted", posted);
        String response = Config.loadDataFromPhp("masterfetch?type=vendorinvoices", params, user);
        Gson g = new Gson();
        return FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, PurchaseHeader[].class)));
    }

    public JsonResponses deleteInvoice(String invoiceNo, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("invoiceNo", invoiceNo);
        String response = Config.loadDataFromPhp("masterdelete?type=vendorinvoice", params, user);
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        return jr;
    }

    public JsonResponses postInvoice(String invoiceNo, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("invoiceNo", invoiceNo);
        String response = Config.loadDataFromPhp("masterpost?type=vendorinvoice", params, user);
        System.out.println(response);
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        return jr;
    }

    public void showInvoice(PurchaseHeader invoice, User user) {
        try {
            HashMap<String, Object> parameters2 = new HashMap<String, Object>();
            parameters2.put("saccoName", Config.saccoName);
            parameters2.put("companyAddress", Config.companyAddress);
            parameters2.put("invoiceNo", invoice.getDocumentNo());
            parameters2.put("invoiceDate", invoice.getInvoiceDate());
            Vendor vendor = invoice.getVendor();
            parameters2.put("vendorPhone", vendor.getVendorPhone());
            parameters2.put("vendorEmail", vendor.getVendorEmail());
            parameters2.put("vendorName", vendor.getFullName());
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("invoiceNo", invoice.getDocumentNo());
            new Config().getReport("Vendor Invoice", "masterfetch?type=vendorinvoicelines", params, "vendorinvoice.jasper", parameters2, user);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printInvoice(PurchaseHeader invoice, User user) {
        try {
            HashMap<String, Object> parameters2 = new HashMap<String, Object>();
            parameters2.put("saccoName", Config.saccoName);
            parameters2.put("companyAddress", Config.companyAddress);
            parameters2.put("invoiceNo", invoice.getDocumentNo());
            parameters2.put("invoiceDate", invoice.getInvoiceDate());
            Vendor vendor = invoice.getVendor();
            parameters2.put("vendorPhone", vendor.getVendorPhone());
            parameters2.put("vendorEmail", vendor.getVendorEmail());
            parameters2.put("vendorName", vendor.getFullName());
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("invoiceNo", invoice.getDocumentNo());
            new Config().printReport("Vendor Invoice", "masterfetch?type=vendorinvoicelines", params, "vendorinvoice.jasper", parameters2, user);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

