/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.ChargeItem;
import classes.Config;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class PropertyCharges {
    private int chargeId;
    private ChargeItem chargeItem;
    private String chargeType;
    private String propertyCode;
    private int unitCode;
    private double amount;
    private String status;

    public int getChargeId() {
        return this.chargeId;
    }

    public void setChargeId(int chargeId) {
        this.chargeId = chargeId;
    }

    public ChargeItem getChargeItem() {
        return this.chargeItem;
    }

    public void setChargeItem(ChargeItem chargeItem) {
        this.chargeItem = chargeItem;
    }

    public String getChargeType() {
        return this.chargeType;
    }

    public void setChargeType(String chargeType) {
        this.chargeType = chargeType;
    }

    public String getPropertyCode() {
        return this.propertyCode;
    }

    public void setPropertyCode(String propertyCode) {
        this.propertyCode = propertyCode;
    }

    public int getUnitCode() {
        return this.unitCode;
    }

    public void setUnitCode(int unitCode) {
        this.unitCode = unitCode;
    }

    public double getAmount() {
        return this.amount;
    }

    public String getAmountString() {
        return Config.formatNumber(this.amount);
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ObservableList<PropertyCharges> getCharges(String chargeType, String propertyCode, int unitCode, User user) {
        ObservableList allCharges = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("chargeType", chargeType);
            params.put("propertyCode", propertyCode);
            params.put("unitCode", unitCode);
            String response = Config.loadDataFromPhp("masterfetch?type=propertycharge", params, user);
            allCharges = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, PropertyCharges[].class)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allCharges;
    }
}

