/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.ChargeItem;
import classes.Config;
import classes.FixedAssets;
import classes.JsonResponses;
import classes.Region;
import classes.User;
import com.google.gson.Gson;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;

public class PettyCashVoucherLines {
    private User user;
    ChargeItem item;
    String pcvNo;
    double amount;
    double kilometres;
    private int code;
    private String description;
    private User salesRep;
    private Region region;
    private FixedAssets vehicle;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public ChargeItem getItem() {
        return this.item;
    }

    public void setItem(ChargeItem item) {
        this.item = item;
    }

    public String getPcvNo() {
        return this.pcvNo;
    }

    public void setPcvNo(String pcvNo) {
        this.pcvNo = pcvNo;
    }

    public double getAmount() {
        return this.amount;
    }

    public String getAmountString() {
        return Config.formatNumber(this.amount);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public double getKilometres() {
        return this.kilometres;
    }

    public void setKilometres(double kilometres) {
        this.kilometres = kilometres;
    }

    public User getSalesRep() {
        return this.salesRep;
    }

    public void setSalesRep(User salesRep) {
        this.salesRep = salesRep;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public FixedAssets getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(FixedAssets vehicle) {
        this.vehicle = vehicle;
    }

    public ObservableList<PettyCashVoucherLines> getLines(String pcvNo, User user) {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("pcvNo", pcvNo);
            String response = Config.loadDataFromPhp("masterfetch?type=pcvlines", params, user);
            ObservableList allLines = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, PettyCashVoucherLines[].class)));
            ObservableList toReturn = FXCollections.observableArrayList();
            for (PettyCashVoucherLines myLine : allLines) {
                myLine.setUser(user);
                toReturn.add((Object)myLine);
            }
            return toReturn;
        }
        catch (Exception e) {
            return null;
        }
    }

    public TextField getAmountTextfield() {
        TextField textField = new TextField();
        textField.setPromptText("Inactive Days");
        textField.setText(this.getAmount() + "");
        textField.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (!event.getCharacter().matches("[0123456789.]")) {
                    event.consume();
                }
            }
        });
        textField.focusedProperty().addListener((arg0, arg1, arg2) -> {
            if (!arg2.booleanValue()) {
                try {
                    double tAmount = Double.parseDouble(textField.getText().trim());
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("code", this.getCode());
                    params.put("amount", tAmount);
                    params.put("pcvNo", this.getPcvNo());
                    String response = Config.loadDataFromPhp("masterupdate?type=pcvlines", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    if (jr.isStatus()) {
                        ObservableList<PettyCashVoucherLines> lines = new PettyCashVoucherLines().getLines(this.getPcvNo(), this.getUser());
                        double tTotal = 0.0;
                        for (PettyCashVoucherLines line : lines) {
                            tTotal += line.getAmount();
                        }
                    }
                }
                catch (NumberFormatException y) {
                    textField.setText(this.getAmount() + "");
                }
            }
        });
        return textField;
    }

    public Button getDelete() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TRASH);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("16.0");
        Button deleteButton = new Button();
        deleteButton.setGraphic((Node)icon);
        deleteButton.setOnAction(e -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("code", this.getCode());
            params.put("pcvNo", this.getPcvNo());
            String response = Config.loadDataFromPhp("masterdelete?type=pcvlines", params, this.getUser());
            Gson g = new Gson();
            JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                ObservableList<PettyCashVoucherLines> pvcLines = this.getLines(this.getPcvNo(), this.getUser());
                Double tTotal = 0.0;
                for (PettyCashVoucherLines line : pvcLines) {
                    tTotal = tTotal + line.getAmount();
                }
            }
        });
        return deleteButton;
    }
}

