/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Bank;
import classes.Config;
import classes.JsonResponses;
import classes.PaymentMethod;
import classes.Region;
import classes.User;
import classes.Vendor;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class PaymentVoucher {
    private String pvNo;
    private Vendor vendor;
    private String paymentDate;
    private PaymentMethod paymentMethod;
    private double amount;
    private Bank bank;
    private String externalRef;
    private boolean posted;
    private boolean reversed;
    private String paymentDescription;
    private String createdOn;
    private Region region;

    public String getPvNo() {
        return this.pvNo;
    }

    public void setPvNo(String pvNo) {
        this.pvNo = pvNo;
    }

    public Vendor getVendor() {
        return this.vendor;
    }

    public void setVendor(Vendor vendor) {
        this.vendor = vendor;
    }

    public String getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(String paymentDate) {
        this.paymentDate = paymentDate;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
    }

    public String getExternalRef() {
        return this.externalRef;
    }

    public void setExternalRef(String externalRef) {
        this.externalRef = externalRef;
    }

    public String getPaymentDescription() {
        return this.paymentDescription;
    }

    public void setPaymentDescription(String paymentDescription) {
        this.paymentDescription = paymentDescription;
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(String createdOn) {
        this.createdOn = createdOn;
    }

    public String getAmountString() {
        return Config.formatNumber(this.amount);
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void showPaymentVoucher(PaymentVoucher pv) {
        try {
            Gson g = new Gson();
            String json = g.toJson((Object)pv);
            HashMap<String, Object> parameters2 = new HashMap<String, Object>();
            parameters2.put("saccoName", Config.saccoName);
            new Config().getReportWithJson("Payment Voucher", json, "paymentVoucher.jasper", parameters2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printPaymentVoucher(PaymentVoucher pv) {
        try {
            Gson g = new Gson();
            String json = g.toJson((Object)pv);
            HashMap<String, Object> parameters2 = new HashMap<String, Object>();
            parameters2.put("saccoName", Config.saccoName);
            new Config().printReportWithJson("Payment Voucher", json, "paymentvoucher.jasper", parameters2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ObservableList<PaymentVoucher> getAllPaymentVouchers(boolean posted, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("posted", posted ? 1 : 0);
        String response = Config.loadDataFromPhp("masterfetch?type=paymentvouchers", params, user);
        System.out.println(response);
        Gson g = new Gson();
        return FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, PaymentVoucher[].class)));
    }

    public JsonResponses deletePV(String pvNo, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("pvNo", pvNo);
        String response = Config.loadDataFromPhp("masterdelete?type=paymentVoucher", params, user);
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        return jr;
    }

    public JsonResponses postPV(String PVNo, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("PVNo", PVNo);
        String response = Config.loadDataFromPhp("masterpost?type=paymentvoucher", params, user);
        System.out.println(response);
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        return jr;
    }

    public JsonResponses voidPV(String PVNo, User user, int bouncedCheque) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("PVNo", PVNo);
        params.put("bouncedCheque", bouncedCheque);
        String response = Config.loadDataFromPhp("masterpost?type=void_payment_voucher", params, user);
        System.out.println(response);
        Gson g = new Gson();
        JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
        return jr;
    }
}

