/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import controllers.EditKinController;
import controllers.NextOfKinController;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class NextofKin {
    private User user;
    private int id;
    private String memberNo;
    private String name;
    private double age;
    private String relationship;
    private String address;
    private double percentage;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getMemberNo() {
        return this.memberNo;
    }

    public void setMemberNo(String memberNo) {
        this.memberNo = memberNo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getAge() {
        return this.age;
    }

    public void setAge(double age) {
        this.age = age;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    public Button getDelete() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TRASH);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("16.0");
        Button deleteButton = new Button();
        deleteButton.setGraphic((Node)icon);
        deleteButton.setOnAction(e -> {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("id", this.getId());
                String response = Config.loadDataFromPhp("masterdelete?type=nextofkin", params, this.getUser());
                Gson g = new Gson();
                JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                NextOfKinController.publicNotificationPane.setText(jr.getMessage());
                NextOfKinController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                NextOfKinController.publicNotificationPane.show();
                if (jr.isStatus()) {
                    ObservableList<NextofKin> allLines = new NextofKin().getKin(this.getMemberNo(), this.getUser());
                    NextOfKinController.publicKinTable.setItems(allLines);
                }
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        });
        return deleteButton;
    }

    public Button getEdit() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.EDIT);
        icon.setStyle("-fx-fill: #4CAF50;");
        icon.setSize("16.0");
        Button editButton = new Button();
        editButton.setGraphic((Node)icon);
        editButton.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/editnextofkin.fxml").openStream());
                Scene editMember = new Scene((Parent)itemPane);
                final Stage stage = new Stage();
                stage.initModality(Modality.APPLICATION_MODAL);
                editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(editMember);
                stage.setOnHiding(e3 -> {
                    ObservableList<NextofKin> allLines = new NextofKin().getKin(this.getMemberNo(), this.getUser());
                    NextOfKinController.publicKinTable.setItems(allLines);
                });
                EditKinController controller = (EditKinController)loader.getController();
                controller.setKin(this);
                controller.setUser(this.getUser());
                stage.setTitle("Edit Next of Kin");
                stage.setResizable(true);
                stage.show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return editButton;
    }

    public ObservableList<NextofKin> getKin(String memberNo, User user) {
        ObservableList allKin = FXCollections.observableArrayList();
        ObservableList toReturn = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("memberNo", memberNo);
            String response = Config.loadDataFromPhp("masterfetch?type=nextofkin", params, user);
            allKin = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, NextofKin[].class)));
            for (NextofKin myKin : allKin) {
                myKin.setUser(user);
                toReturn.add((Object)myKin);
            }
        }
        catch (Exception y) {
            y.printStackTrace();
        }
        return toReturn;
    }
}

