/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.User;
import com.google.gson.Gson;
import controllers.MemberSelectionController;
import filterscontrollers.AllMembersMonthlyFilter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class Member {
    private String memberNumber;
    private String firstName;
    private String middleName;
    private String lastName;
    private int idNumber;
    private String passportNumber;
    private String citizenship;
    private String pin;
    private String PhoneNumber;
    private String telephone;
    private String email;
    private String alternativeEmail;
    private String joinDate;
    private Boolean clearedJoiningFee;
    private Double ShareDeposit;
    private Double ShareCapital;
    private String dateOfBirth;
    private Image photo;
    private String bank;
    private String bankBranch;
    private String BankAccountNumber;
    private String status;
    private String nextInvoiceDate;
    private String prefferedCurrency;
    private User addedBy;
    private String addedOn;
    private String fullName;
    private String photoBlob;
    private String shareCapitalString;
    private String contributionsString;
    private double savings;
    private String savingsString;
    private double freeShares;

    public String getShareCapitalString() {
        try {
            return Config.formatNumber(this.ShareCapital);
        }
        catch (Exception y) {
            return "0";
        }
    }

    public void setShareCapitalString(String shareCapitalString) {
        this.shareCapitalString = shareCapitalString;
    }

    public String getContributionsString() {
        try {
            return Config.formatNumber(this.ShareDeposit);
        }
        catch (Exception y) {
            return "0";
        }
    }

    public void setContributionsString(String contributionsString) {
        this.contributionsString = contributionsString;
    }

    public double getFreeShares() {
        return this.freeShares;
    }

    public void setFreeShares(double freeShares) {
        this.freeShares = freeShares;
    }

    public String getPhotoBlob() {
        return this.photoBlob;
    }

    public void setPhotoBlob(String photoBlob) {
        this.photoBlob = photoBlob;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public User getAddedBy() {
        return this.addedBy;
    }

    public void setAddedBy(User addedBy) {
        this.addedBy = addedBy;
    }

    public String getAddedOn() {
        return this.addedOn;
    }

    public void setAddedOn(String addedOn) {
        this.addedOn = addedOn;
    }

    public String getMemberNumber() {
        return this.memberNumber;
    }

    public void setMemberNumber(String memberNumber) {
        this.memberNumber = memberNumber;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public int getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(int idNumber) {
        this.idNumber = idNumber;
    }

    public String getPassportNumber() {
        return this.passportNumber;
    }

    public void setPassportNumber(String passportNumber) {
        this.passportNumber = passportNumber;
    }

    public String getCitizenship() {
        return this.citizenship;
    }

    public void setCitizenship(String citizenship) {
        this.citizenship = citizenship;
    }

    public String getPin() {
        return this.pin;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    public String getPhoneNumber() {
        return this.PhoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.PhoneNumber = phoneNumber;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAlternativeEmail() {
        return this.alternativeEmail;
    }

    public void setAlternativeEmail(String alternativeEmail) {
        this.alternativeEmail = alternativeEmail;
    }

    public String getJoinDate() {
        return this.joinDate;
    }

    public void setJoinDate(String joinDate) {
        this.joinDate = joinDate;
    }

    public Boolean getClearedJoiningFee() {
        return this.clearedJoiningFee;
    }

    public void setClearedJoiningFee(Boolean clearedJoiningFee) {
        this.clearedJoiningFee = clearedJoiningFee;
    }

    public Double getShareDeposit() {
        return this.ShareDeposit;
    }

    public void setShareDeposit(Double shareDeposit) {
        this.ShareDeposit = shareDeposit;
    }

    public Double getShareCapital() {
        return this.ShareCapital;
    }

    public void setShareCapital(Double shareCapital) {
        this.ShareCapital = shareCapital;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(String dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public Image getPhoto() {
        return this.photo;
    }

    public void setPhoto(Image photo) {
        this.photo = photo;
    }

    public String getBank() {
        return this.bank;
    }

    public void setBank(String bank) {
        this.bank = bank;
    }

    public String getBankBranch() {
        return this.bankBranch;
    }

    public void setBankBranch(String bankBranch) {
        this.bankBranch = bankBranch;
    }

    public String getBankAccountNumber() {
        return this.BankAccountNumber;
    }

    public void setBankAccountNumber(String bankAccountNumber) {
        this.BankAccountNumber = bankAccountNumber;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getNextInvoiceDate() {
        return this.nextInvoiceDate;
    }

    public void setNextInvoiceDate(String nextInvoiceDate) {
        this.nextInvoiceDate = nextInvoiceDate;
    }

    public String getPrefferedCurrency() {
        return this.prefferedCurrency;
    }

    public void setPrefferedCurrency(String prefferedCurrency) {
        this.prefferedCurrency = prefferedCurrency;
    }

    public String getFullName() {
        return this.firstName + " " + this.middleName + " " + this.lastName;
    }

    public double getSavings() {
        return this.savings;
    }

    public void setSavings(double savings) {
        this.savings = savings;
    }

    public String getSavingsString() {
        return Config.formatNumber(this.savings);
    }

    public void setSavingsString(String savingsString) {
        this.savingsString = savingsString;
    }

    public Member() {
    }

    public Member(String memberNumber) {
        this.memberNumber = memberNumber;
    }

    public Member(String memberNumber, String firstName, String middleName, String lastName, int idNumber, String passportNumber, String citizenship, String pin, String phoneNumber, String telephone, String email, String alternativeEmail, String joinDate, Boolean clearedJoiningFee, Double shareDeposit, Double shareCapital, String dateOfBirth, String bank, String bankBranch, String bankAccountNumber, String status, String nextInvoiceDate, String prefferedCurrency, User addedBy, String addedOn) {
        this.memberNumber = memberNumber;
        this.firstName = firstName;
        this.middleName = middleName;
        this.lastName = lastName;
        this.idNumber = idNumber;
        this.passportNumber = passportNumber;
        this.citizenship = citizenship;
        this.pin = pin;
        this.PhoneNumber = phoneNumber;
        this.telephone = telephone;
        this.email = email;
        this.alternativeEmail = alternativeEmail;
        this.joinDate = joinDate;
        this.clearedJoiningFee = clearedJoiningFee;
        this.ShareDeposit = shareDeposit;
        this.ShareCapital = shareCapital;
        this.dateOfBirth = dateOfBirth;
        this.bank = bank;
        this.bankBranch = bankBranch;
        this.BankAccountNumber = bankAccountNumber;
        this.status = status;
        this.nextInvoiceDate = nextInvoiceDate;
        this.prefferedCurrency = prefferedCurrency;
        this.addedBy = addedBy;
        this.addedOn = addedOn;
    }

    public ObservableList<Member> getAllMembers(User user) {
        ObservableList allMembers = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String response2 = Config.loadDataFromPhp("masterfetch?type=members", params, user);
            Gson g = new Gson();
            Object[] memberFromJson = (Member[])g.fromJson(response2, Member[].class);
            allMembers = FXCollections.observableArrayList((Object[])memberFromJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allMembers;
    }

    public ObservableList<Member> getAllMembers(boolean withBalances, User user) {
        ObservableList allMembers = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("balances", withBalances ? 1 : 0);
            String response2 = Config.loadDataFromPhp("masterfetch?type=members", params, user);
            Gson g = new Gson();
            Object[] memberFromJson = (Member[])g.fromJson(response2, Member[].class);
            allMembers = FXCollections.observableArrayList((Object[])memberFromJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allMembers;
    }

    public ObservableList<Member> getAllMembers(Map<String, Object> params, User user) {
        ObservableList allMembers = FXCollections.observableArrayList();
        try {
            params.put("balances", 1);
            String response2 = Config.loadDataFromPhp("masterfetch?type=members", params, user);
            Gson g = new Gson();
            Object[] memberFromJson = (Member[])g.fromJson(response2, Member[].class);
            allMembers = FXCollections.observableArrayList((Object[])memberFromJson);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allMembers;
    }

    public String toString() {
        return this.getFullName();
    }

    public Member getMemberFromSelection(User user) {
        Member mMember = new Member();
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/fxml/memberselection.fxml").openStream());
            MemberSelectionController controller = (MemberSelectionController)loader.getController();
            controller.setUser(user);
            Scene addItemScene = new Scene((Parent)itemPane);
            Stage memberSelectionStage = new Stage();
            memberSelectionStage.setScene(addItemScene);
            memberSelectionStage.setTitle("Member Selection");
            memberSelectionStage.setResizable(false);
            try {
                memberSelectionStage.initModality(Modality.APPLICATION_MODAL);
            }
            catch (Exception exception) {
                // empty catch block
            }
            memberSelectionStage.showAndWait();
            return controller.getMember();
        }
        catch (Exception p) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("An error occurred");
            alert.setHeaderText("An error occurred while loading your member selection screen. Please contact support");
            alert.showAndWait();
            return mMember;
        }
    }

    public void getMemberStatement(User user) {
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("memberNumber", this.getMemberNumber());
            HashMap<String, Object> parameters2 = new HashMap<String, Object>();
            parameters2.put("saccoName", Config.saccoName);
            new Config().getReport("Member Statement", "masterfetch?type=memberstatement", params, "memberstatementmain.jasper", parameters2, user);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getMemberMonthlyStatement(User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/allmembersmonthly.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            AllMembersMonthlyFilter controller = (AllMembersMonthlyFilter)loader.getController();
            controller.setmMember(this);
            controller.setUser(user);
            stage.setTitle("Member monthly filter");
            stage.setResizable(false);
            stage.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getAllMembersMonthlyStatement(User user) {
        try {
            FXMLLoader loader = new FXMLLoader();
            AnchorPane itemPane = (AnchorPane)loader.load(this.getClass().getResource("/filtersfxml/allmembersmonthly.fxml").openStream());
            Scene editMember = new Scene((Parent)itemPane);
            final Stage stage = new Stage();
            editMember.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    KeyCode key = t.getCode();
                    if (key == KeyCode.ESCAPE) {
                        stage.close();
                    }
                }
            });
            stage.setScene(editMember);
            AllMembersMonthlyFilter controller = (AllMembersMonthlyFilter)loader.getController();
            controller.setUser(user);
            stage.setTitle("All Members Filter");
            stage.setResizable(false);
            stage.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

