/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.DashboardMatrix;
import classes.Styles;
import classes.User;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import controllers.Controller;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javafx.animation.FadeTransition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import javafx.util.Pair;
import org.controlsfx.control.MaskerPane;

public class Main
extends Application {
    ObservableList<ObservableList<String>> toImport = FXCollections.observableArrayList();
    Double screenHeight = Screen.getPrimary().getVisualBounds().getHeight();
    Double screenWidth = Screen.getPrimary().getVisualBounds().getWidth();
    Dialog<Pair<String, String>> dialog = new Dialog();
    GridPane grid = new GridPane();
    Label errorLabel = new Label();

    public void start(Stage primaryStage) throws Exception {
        try {
            Parent splashFxml = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("/fxml/splash.fxml"));
            Stage splash = new Stage();
            splashFxml.setStyle("-fx-background-color: transparent;");
            Scene splashScene = new Scene(splashFxml, (Paint)Color.TRANSPARENT);
            splash.initStyle(StageStyle.TRANSPARENT);
            splash.setScene(splashScene);
            splash.show();
            FadeTransition fadeIn = new FadeTransition(new Duration(3000.0), (Node)splashFxml);
            fadeIn.setFromValue(0.0);
            fadeIn.setToValue(3.0);
            fadeIn.setCycleCount(1);
            fadeIn.play();
            Stage stage = (Stage)this.dialog.getDialogPane().getScene().getWindow();
            stage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResource("login.png").toString()));
            this.dialog.setTitle("Login " + Config.saccoName);
            this.dialog.setHeaderText("Please Enter your Username and Password");
            this.dialog.setGraphic((Node)new ImageView(((Object)((Object)new Main())).getClass().getResource("login.png").toString()));
            ButtonType loginButtonType = new ButtonType("Login", ButtonBar.ButtonData.OK_DONE);
            ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
            this.dialog.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{loginButtonType, cancelButton});
            this.grid.setHgap(20.0);
            this.grid.setVgap(10.0);
            this.grid.setPadding(new Insets(20.0, 20.0, 10.0, 10.0));
            this.grid.setMinHeight(120.0);
            final TextField username = new TextField();
            username.setPromptText("Username");
            username.requestFocus();
            final PasswordField password = new PasswordField();
            password.setPromptText("Password");
            Label usernameLabel = new Label("Username");
            this.grid.add((Node)usernameLabel, 0, 1);
            this.grid.add((Node)username, 1, 1);
            this.grid.add((Node)new Label("Password:"), 0, 2);
            this.grid.add((Node)password, 1, 2);
            password.setMinWidth(300.0);
            Node cancelbutton = this.dialog.getDialogPane().lookupButton(cancelButton);
            cancelbutton.setStyle(Styles.cancelButtonStyle);
            Node loginButton = this.dialog.getDialogPane().lookupButton(loginButtonType);
            loginButton.setStyle(Styles.loginButtonStyle);
            username.textProperty().addListener((observable, oldValue, newValue) -> loginButton.setDisable(newValue.trim().isEmpty()));
            this.dialog.getDialogPane().setContent((Node)this.grid);
            Platform.runLater(() -> username.requestFocus());
            this.dialog.setResultConverter(dialogButton -> {
                if (dialogButton == loginButtonType) {
                    return new Pair((Object)username.getText(), (Object)password.getText());
                }
                return null;
            });
            EventHandler filter = event -> {
                event.consume();
                this.errorLabel.setMinWidth(370.0);
                this.errorLabel.setStyle(Styles.errorStyle);
                GridPane.setColumnSpan((Node)this.errorLabel, (Integer)2);
                this.errorLabel.setText("Please wait...");
                try {
                    this.grid.add((Node)this.errorLabel, 0, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MaskerPane masker = new MaskerPane();
                masker.setText("Please wait...");
                loginButton.setDisable(true);
                StackPane pane = new StackPane();
                pane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
                pane.getChildren().addAll((Object[])new Node[]{this.grid, masker});
                Platform.runLater(() -> this.dialog.getDialogPane().setContent((Node)pane));
                Task<User> loginTask = new Task<User>(){

                    protected User call() {
                        return Main.this.login(username.getText().trim(), password.getText().trim());
                    }
                };
                loginTask.setOnSucceeded(arg_0 -> this.lambda$null$10((Task)loginTask, username, password, primaryStage, loginButton, arg_0));
                loginTask.setOnFailed(arg_0 -> this.lambda$null$12((Task)loginTask, loginButton, arg_0));
                new Thread((Runnable)loginTask).start();
            };
            loginButton.addEventFilter(ActionEvent.ACTION, filter);
            fadeIn.setOnFinished(e -> {
                Platform.runLater(() -> {
                    Optional result = this.dialog.showAndWait();
                });
                splash.close();
            });
        }
        catch (Exception y) {
            y.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }

    public User login(String username, String password) {
        User user = new User();
        String myMessage = "";
        try {
            URL url = new URL(Config.getURL() + "login");
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("username", username);
            params.put("password", password);
            params.put("versionNo", Config.versionNo);
            StringBuilder postData = new StringBuilder();
            for (Map.Entry param : params.entrySet()) {
                if (postData.length() != 0) {
                    postData.append('&');
                }
                postData.append(URLEncoder.encode((String)param.getKey(), "UTF-8"));
                postData.append('=');
                postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
            }
            byte[] postDataBytes = postData.toString().getBytes("UTF-8");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            conn.setDoOutput(true);
            conn.getOutputStream().write(postDataBytes);
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            String readLine = "";
            StringBuffer response = new StringBuffer();
            while ((readLine = in.readLine()) != null) {
                response.append(readLine);
            }
            Gson g = new Gson();
            String response2 = response.toString();
            System.out.println(response2);
            myMessage = response2;
            user = (User)g.fromJson(response2, User.class);
            in.close();
        }
        catch (ConnectException t) {
            user.setLoginStatus(false);
            user.setLoginMessage("A connection to the server could not be established.\n Please contact ICT Support");
            t.printStackTrace();
        }
        catch (FileNotFoundException t) {
            user.setLoginStatus(false);
            user.setLoginMessage("A connection to the server could not be established.\n Please contact ICT Support");
            t.printStackTrace();
        }
        catch (JsonSyntaxException t) {
            user.setLoginStatus(false);
            user.setLoginMessage(myMessage);
        }
        catch (MalformedURLException t) {
            user.setLoginStatus(false);
            user.setLoginMessage("The credentials file is missing.");
        }
        catch (Exception t) {
            user.setLoginStatus(false);
            user.setLoginMessage("We experienced an error while processing your request");
            t.printStackTrace();
        }
        return user;
    }

    private /* synthetic */ void lambda$null$12(Task loginTask, Node loginButton, WorkerStateEvent workerStateEvent) {
        Throwable e = loginTask.getException();
        this.errorLabel.setText("We experienced an error while processing your request. Please try again later.");
        GridPane.setColumnSpan((Node)this.errorLabel, (Integer)2);
        if (e != null) {
            e.printStackTrace();
        }
        Platform.runLater(() -> {
            this.dialog.getDialogPane().setContent((Node)this.grid);
            loginButton.setDisable(false);
        });
    }

    private /* synthetic */ void lambda$null$10(Task loginTask, TextField username, PasswordField password, Stage primaryStage, Node loginButton, WorkerStateEvent workerStateEvent) {
        final User user = (User)loginTask.getValue();
        try {
            if (user.isUpdate()) {
                boolean update = Config.showConfirmDialog("System Ready to Update", "Your version of the system is too old and needs an update", "Would you like to update?");
                if (update) {
                    new ProcessBuilder(Config.getAutoUpdateProgram(), Config.versionNo + "", username.getText().trim(), password.getText().trim(), Config.getReportURL(), Config.getProgramRoot(), Config.getURL(), Config.getExeLocation()).start();
                    System.exit(0);
                } else {
                    System.exit(0);
                }
            } else if (user.getLoginStatus().booleanValue()) {
                Task<Void> processUserTask = new Task<Void>(){

                    protected Void call() {
                        ObservableList<DashboardMatrix> matrix = new DashboardMatrix().getMatrix(user, user.getUserRole().getId());
                        LinkedHashMap<String, Object> matrixDetails = new LinkedHashMap<String, Object>();
                        for (DashboardMatrix myMatrix : matrix) {
                            matrixDetails.put(myMatrix.getSubmodule().getSelectionCode() + "", myMatrix.isView() ? 1 : 0);
                        }
                        user.setMatrixDetails(matrixDetails);
                        return null;
                    }
                };
                processUserTask.setOnSucceeded(processEvent -> {
                    try {
                        FXMLLoader loader = new FXMLLoader();
                        Parent root = (Parent)loader.load(((Object)((Object)this)).getClass().getResource("/fxml/main.fxml").openStream());
                        Controller controller = (Controller)loader.getController();
                        controller.setUser(user);
                        primaryStage.setTitle("Kuza Systems and Solution Licensed to " + Config.saccoName);
                        primaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResource("kuzalogo.png").toString()));
                        primaryStage.setScene(new Scene(root, this.screenWidth.doubleValue(), this.screenHeight.doubleValue()));
                        primaryStage.show();
                        this.dialog.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.errorLabel.setText("Error occurred while launching the dashboard.");
                        GridPane.setColumnSpan((Node)this.errorLabel, (Integer)2);
                        Platform.runLater(() -> {
                            this.dialog.getDialogPane().setContent((Node)this.grid);
                            loginButton.setDisable(false);
                        });
                    }
                });
                processUserTask.setOnFailed(arg_0 -> this.lambda$null$7((Task)processUserTask, loginButton, arg_0));
                new Thread((Runnable)processUserTask).start();
            } else {
                this.errorLabel.setText(user.getLoginMessage());
                GridPane.setColumnSpan((Node)this.errorLabel, (Integer)2);
                Platform.runLater(() -> {
                    this.dialog.getDialogPane().setContent((Node)this.grid);
                    loginButton.setDisable(false);
                });
            }
        }
        catch (Exception e) {
            this.errorLabel.setText("We experienced an error while processing your request. Please try again later.");
            GridPane.setColumnSpan((Node)this.errorLabel, (Integer)2);
            e.printStackTrace();
            Platform.runLater(() -> {
                this.dialog.getDialogPane().setContent((Node)this.grid);
                loginButton.setDisable(false);
            });
        }
    }

    private /* synthetic */ void lambda$null$7(Task processUserTask, Node loginButton, WorkerStateEvent processEvent) {
        Throwable e = processUserTask.getException();
        if (e != null) {
            e.printStackTrace();
        }
        this.errorLabel.setText("An error occurred while processing user data.");
        GridPane.setColumnSpan((Node)this.errorLabel, (Integer)2);
        Platform.runLater(() -> {
            this.dialog.getDialogPane().setContent((Node)this.grid);
            loginButton.setDisable(false);
        });
    }
}

