/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class LoanProduct {
    private String loanProductCode;
    private String loanProductName;
    private double loanMinimumAmount;
    private double loanMaximumAmount;
    private int loanMinimumInstallments;
    private int loanMaximumInstallments;
    private double loanInterestRate;
    private String loanCalculationMethod;
    private String status;
    private int loanMinimumGuarantors;
    private int loanMaximumGuarantors;
    private double loanShareMultiplicationFactor;
    private int usedInLoans;
    private String formatedMinimumAmount;
    private String formatedMaximumAmount;

    public int getUsedInLoans() {
        return this.usedInLoans;
    }

    public void setUsedInLoans(int usedInLoans) {
        this.usedInLoans = usedInLoans;
    }

    public String getFormatedMinimumAmount() {
        return Config.formatNumber(this.loanMinimumAmount);
    }

    public void setFormatedMinimumAmount(String formatedMinimumAmount) {
        this.formatedMinimumAmount = formatedMinimumAmount;
    }

    public String getFormatedMaximumAmount() {
        return Config.formatNumber(this.loanMaximumAmount);
    }

    public void setFormatedMaximumAmount(String formatedMaximumAmount) {
        this.formatedMaximumAmount = formatedMaximumAmount;
    }

    public LoanProduct() {
    }

    public String getLoanProductCode() {
        return this.loanProductCode;
    }

    public void setLoanProductCode(String loanProductCode) {
        this.loanProductCode = loanProductCode;
    }

    public String getLoanProductName() {
        return this.loanProductName;
    }

    public void setLoanProductName(String loanProductName) {
        this.loanProductName = loanProductName;
    }

    public double getLoanMinimumAmount() {
        return this.loanMinimumAmount;
    }

    public void setLoanMinimumAmount(double loanMinimumAmount) {
        this.loanMinimumAmount = loanMinimumAmount;
        this.formatedMinimumAmount = Config.formatNumber(loanMinimumAmount);
    }

    public double getLoanMaximumAmount() {
        return this.loanMaximumAmount;
    }

    public void setLoanMaximumAmount(double loanMaximumAmount) {
        this.loanMaximumAmount = loanMaximumAmount;
        this.formatedMaximumAmount = Config.formatNumber(loanMaximumAmount);
    }

    public int getLoanMinimumInstallments() {
        return this.loanMinimumInstallments;
    }

    public void setLoanMinimumInstallments(int loanMinimumInstallments) {
        this.loanMinimumInstallments = loanMinimumInstallments;
    }

    public int getLoanMaximumInstallments() {
        return this.loanMaximumInstallments;
    }

    public void setLoanMaximumInstallments(int loanMaximumInstallments) {
        this.loanMaximumInstallments = loanMaximumInstallments;
    }

    public double getLoanInterestRate() {
        return this.loanInterestRate;
    }

    public void setLoanInterestRate(double loanInterestRate) {
        this.loanInterestRate = loanInterestRate;
    }

    public String getLoanCalculationMethod() {
        return this.loanCalculationMethod;
    }

    public void setLoanCalculationMethod(String loanCalculationMethod) {
        this.loanCalculationMethod = loanCalculationMethod;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getLoanMinimumGuarantors() {
        return this.loanMinimumGuarantors;
    }

    public void setLoanMinimumGuarantors(int loanMinimumGuarantors) {
        this.loanMinimumGuarantors = loanMinimumGuarantors;
    }

    public int getLoanMaximumGuarantors() {
        return this.loanMaximumGuarantors;
    }

    public void setLoanMaximumGuarantors(int loanMaximumGuarantors) {
        this.loanMaximumGuarantors = loanMaximumGuarantors;
    }

    public double getLoanShareMultiplicationFactor() {
        return this.loanShareMultiplicationFactor;
    }

    public LoanProduct(String loanProductCode, String loanProductName, double loanMinimumAmount, double loanMaximumAmount, int loanMinimumInstallments, int loanMaximumInstallments, double loanInterestRate, String loanCalculationMethod, String status, int loanMinimumGuarantors, int loanMaximumGuarantors, double loanShareMultiplicationFactor) {
        this.loanProductCode = loanProductCode;
        this.loanProductName = loanProductName;
        this.loanMinimumAmount = loanMinimumAmount;
        this.loanMaximumAmount = loanMaximumAmount;
        this.loanMinimumInstallments = loanMinimumInstallments;
        this.loanMaximumInstallments = loanMaximumInstallments;
        this.loanInterestRate = loanInterestRate;
        this.loanCalculationMethod = loanCalculationMethod;
        this.status = status;
        this.loanMinimumGuarantors = loanMinimumGuarantors;
        this.loanMaximumGuarantors = loanMaximumGuarantors;
        this.loanShareMultiplicationFactor = loanShareMultiplicationFactor;
        this.formatedMaximumAmount = Config.formatNumber(loanMaximumAmount);
        this.formatedMinimumAmount = Config.formatNumber(loanMinimumAmount);
    }

    public void setLoanShareMultiplicationFactor(double loanShareMultiplicationFactor) {
        this.loanShareMultiplicationFactor = loanShareMultiplicationFactor;
    }

    public ObservableList<LoanProduct> getAllLoanProducts(User user) {
        ObservableList allLoanProducts = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            String response = Config.loadDataFromPhp("masterfetch?type=loanproducts", params, user);
            Gson g = new Gson();
            Object[] loanProductsFromJson = (LoanProduct[])g.fromJson(response, LoanProduct[].class);
            allLoanProducts = FXCollections.observableArrayList((Object[])loanProductsFromJson);
        }
        catch (Exception t) {
            t.printStackTrace();
        }
        return allLoanProducts;
    }

    public String toString() {
        return this.loanProductName;
    }
}

