/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.Employee;
import classes.User;
import com.google.gson.Gson;
import controllers.GeneralListController;
import controllers.LeaveLedgerEntriesController;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Hyperlink;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class LeaveBalance {
    private int id;
    private double balance;
    private Employee employee;
    private String employeeNo;
    private String description;
    private User user;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public double getBalance() {
        return this.balance;
    }

    public void setBalance(double balance) {
        this.balance = balance;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public String getEmployeeNo() {
        try {
            return this.getEmployee().getEmployeeNumber();
        }
        catch (Exception j) {
            return "";
        }
    }

    public void setEmployeeNo(String employeeNo) {
        this.employeeNo = employeeNo;
    }

    public Hyperlink getBalanceHyperLink() {
        Hyperlink link = new Hyperlink();
        link.setText(this.getBalance() + "");
        link.setOnAction(e -> {
            try {
                FXMLLoader loader = new FXMLLoader();
                final Stage stage = new Stage();
                VBox itemPane = (VBox)loader.load(this.getClass().getResource("/fxml/leaveledgerentries.fxml").openStream());
                Scene scene = new Scene((Parent)itemPane);
                scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        KeyCode key = t.getCode();
                        if (key == KeyCode.ESCAPE) {
                            stage.close();
                        }
                    }
                });
                stage.setScene(scene);
                LeaveLedgerEntriesController controller = (LeaveLedgerEntriesController)loader.getController();
                controller.setUser(new User());
                controller.setMyEmployee(this.getEmployee());
                stage.setTitle("View Leave Ledger Entries");
                stage.showAndWait();
                stage.setResizable(false);
            }
            catch (Exception p) {
                GeneralListController.publicNotificationPane.setText("We encountered an error while loading the employee's leave ledger entries. Please try again");
                GeneralListController.publicNotificationPane.setGraphic((Node)Config.getBanIcon());
                GeneralListController.publicNotificationPane.show();
            }
        });
        return link;
    }

    public ObservableList<LeaveBalance> getAllLeaveBalances(User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        String response = Config.loadDataFromPhp("masterfetch?type=leavebalances", params, user);
        Gson g = new Gson();
        ObservableList allLines = FXCollections.observableArrayList((Object[])((Object[])g.fromJson(response, LeaveBalance[].class)));
        ObservableList toReturn = FXCollections.observableArrayList();
        for (LeaveBalance line : allLines) {
            line.setUser(user);
            toReturn.add((Object)line);
        }
        return toReturn;
    }
}

