/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.JsonResponses;
import classes.TransactionTypes;
import classes.User;
import com.google.gson.Gson;
import controllers.JournalCardController;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;

public class JournalLines {
    private User user;
    private int lineNo;
    private String journalNo;
    private String accountType;
    private TransactionTypes transactionType;
    private String accountNo;
    private String accountName;
    private String externalDocNo;
    private String description;
    private double amount;
    private String credit;
    private String debit;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(int lineNo) {
        this.lineNo = lineNo;
    }

    public String getJournalNo() {
        return this.journalNo;
    }

    public void setJournalNo(String journalNo) {
        this.journalNo = journalNo;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public TransactionTypes getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionTypes transactionType) {
        this.transactionType = transactionType;
    }

    public String getAccountNo() {
        return this.accountNo;
    }

    public void setAccountNo(String accountNo) {
        this.accountNo = accountNo;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getExternalDocNo() {
        return this.externalDocNo;
    }

    public void setExternalDocNo(String externalDocNo) {
        this.externalDocNo = externalDocNo;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public String getCredit() {
        return this.amount < 0.0 ? Config.formatNumber(this.amount * -1.0) : "";
    }

    public void setCredit(String credit) {
        this.credit = credit;
    }

    public String getDebit() {
        return this.amount > 0.0 ? Config.formatNumber(this.amount) : "";
    }

    public void setDebit(String debit) {
        this.debit = debit;
    }

    public ObservableList<JournalLines> loadLines(String journalNo, User user) {
        ObservableList myLines = FXCollections.observableArrayList();
        ObservableList toReturn = FXCollections.observableArrayList();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("journalNo", journalNo);
        String response = Config.loadDataFromPhp("masterfetch?type=journallines", params, user);
        myLines = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, JournalLines[].class)));
        for (JournalLines myLine : myLines) {
            myLine.setUser(user);
            toReturn.add((Object)myLine);
        }
        return toReturn;
    }

    public Button getRemove() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TRASH);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("16.0");
        Button deleteButton = new Button();
        deleteButton.setGraphic((Node)icon);
        deleteButton.setOnAction(e -> {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("lineNo", this.getLineNo());
                String response = Config.loadDataFromPhp("masterdelete?type=journalline", params, this.getUser());
                Gson g = new Gson();
                JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                JournalCardController.publicNotificationPane.setText(jr.getMessage());
                JournalCardController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                JournalCardController.publicNotificationPane.show();
                if (jr.isStatus()) {
                    ObservableList<JournalLines> allLines = new JournalLines().loadLines(this.getJournalNo(), this.getUser());
                    double tTotalAmount = 0.0;
                    for (JournalLines line : allLines) {
                        tTotalAmount += line.getAmount();
                    }
                    JournalCardController.publicLines.setItems(allLines);
                    JournalCardController.totalAmountPublic.setText(Config.formatNumber(tTotalAmount));
                }
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        });
        return deleteButton;
    }
}

