/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.JsonResponses;
import classes.Loan;
import classes.Member;
import classes.User;
import com.google.gson.Gson;
import controllers.LoanApplication;
import java.util.LinkedHashMap;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;

public class Guarantor {
    private User user;
    public Member member;
    public int id;
    public String amountToGuarantee;
    public String percentage;
    public Loan loan;
    public double percentageDouble;
    public double amountDouble;
    private String memberNumber;
    private String freeShares;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getFullName() {
        try {
            return this.getMember().getFullName();
        }
        catch (Exception t) {
            return "";
        }
    }

    public String getAmountString() {
        return Config.formatNumber(this.amountDouble);
    }

    public double getPercentageDouble() {
        return this.percentageDouble;
    }

    public void setPercentageDouble(double percentageDouble) {
        this.percentageDouble = percentageDouble;
    }

    public double getAmountDouble() {
        return this.amountDouble;
    }

    public void setAmountDouble(double amountDouble) {
        this.amountDouble = amountDouble;
    }

    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public String getAmountToGuarantee() {
        return this.amountToGuarantee;
    }

    public void setAmountToGuarantee(String amountToGuarantee) {
        this.amountToGuarantee = amountToGuarantee;
    }

    public String getPercentage() {
        return this.percentage;
    }

    public void setPercentage(String percentage) {
        this.percentage = percentage;
    }

    public Loan getLoan() {
        return this.loan;
    }

    public void setLoan(Loan loan) {
        this.loan = loan;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getMemberNumber() {
        try {
            return this.member.getMemberNumber();
        }
        catch (NullPointerException r) {
            return "";
        }
    }

    public void setMemberNumber(String memberNumber) {
        this.memberNumber = memberNumber;
    }

    public String getFreeShares() {
        try {
            return Config.formatNumber(this.member.getFreeShares());
        }
        catch (NullPointerException r) {
            return "";
        }
    }

    public TextField getEditAmount() {
        TextField textField = new TextField();
        textField.setPromptText("Amount ");
        textField.setText(this.getAmountDouble() + "");
        textField.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (!event.getCharacter().matches("[0123456789.]")) {
                    event.consume();
                }
            }
        });
        textField.focusedProperty().addListener((arg0, arg1, arg2) -> {
            if (!arg2.booleanValue()) {
                try {
                    Double amount = Double.parseDouble(textField.getText().trim());
                    LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                    params.put("loanNo", this.getLoan().getLoanNumber());
                    params.put("guarantor", this.getMember().getMemberNumber());
                    params.put("amountToGuarantee", amount);
                    String response = Config.loadDataFromPhp("mastercreate?type=guarantor", params, this.getUser());
                    JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
                    LoanApplication.publicNotificationPane.setText(jr.getMessage());
                    LoanApplication.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                    LoanApplication.publicNotificationPane.show();
                }
                catch (NumberFormatException amount) {
                }
                catch (Exception t) {
                    LoanApplication.publicNotificationPane.setText("We experienced an error while updating the guarantor");
                    LoanApplication.publicNotificationPane.setGraphic((Node)Config.getBanIcon());
                    LoanApplication.publicNotificationPane.show();
                }
            }
        });
        return textField;
    }

    public void setFreeShares(String freeShares) {
        this.freeShares = freeShares;
    }
}

