/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.Contact;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import controllers.CreateGroup;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;

public class GroupMember {
    private User user;
    private Contact contact;
    private String group;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Button getRemove() {
        Button deleteBtn = new Button();
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TRASH);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("16.0");
        deleteBtn.setGraphic((Node)icon);
        deleteBtn.setOnAction(event -> {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("contact", this.contact.getId());
            params.put("group", this.group);
            new Config();
            String response = Config.loadDataFromPhp("masterdelete?type=groupmember", params, this.getUser());
            JsonResponses jr = (JsonResponses)new Gson().fromJson(response, JsonResponses.class);
            if (jr.isStatus()) {
                CreateGroup.publicTable.setItems(new GroupMember().getAllMembers(this.group, this.getUser()));
            }
        });
        return deleteBtn;
    }

    public String getId() {
        return this.contact.getId();
    }

    public String getName() {
        return this.contact.getName();
    }

    public String getPhone() {
        return this.contact.getPhoneNumber();
    }

    public ObservableList<GroupMember> getAllMembers(String code, User user) {
        ObservableList allLines = FXCollections.observableArrayList();
        ObservableList toReturn = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("groupCode", code);
            String response = Config.loadDataFromPhp("masterfetch?type=groupmember", params, user);
            allLines = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, GroupMember[].class)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (GroupMember line : allLines) {
            line.setUser(user);
            toReturn.add((Object)line);
        }
        return toReturn;
    }
}

