/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Config;
import classes.JsonResponses;
import classes.User;
import com.google.gson.Gson;
import controllers.FloorController;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIconView;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;

public class Floor {
    private User user;
    private int floorId;
    private String floorNo;
    private String floorName;
    private String propertyCode;

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public int getFloorId() {
        return this.floorId;
    }

    public void setFloorId(int floorId) {
        this.floorId = floorId;
    }

    public String getFloorNo() {
        return this.floorNo;
    }

    public void setFloorNo(String floorNo) {
        this.floorNo = floorNo;
    }

    public String getFloorName() {
        return this.floorName;
    }

    public void setFloorName(String floorName) {
        this.floorName = floorName;
    }

    public String getPropertyCode() {
        return this.propertyCode;
    }

    public void setPropertyCode(String propertyCode) {
        this.propertyCode = propertyCode;
    }

    public String toString() {
        return this.floorNo + " - " + this.floorName;
    }

    public ObservableList<Floor> getAllFloors(String propertyCode, User user) {
        ObservableList allFloors = FXCollections.observableArrayList();
        try {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
            params.put("propertyCode", propertyCode);
            String response = Config.loadDataFromPhp("masterfetch?type=floor", params, user);
            allFloors = FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, Floor[].class)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return allFloors;
    }

    public Button getRemove() {
        FontAwesomeIconView icon = new FontAwesomeIconView(FontAwesomeIcon.TRASH);
        icon.setStyle("-fx-fill: #d32f2f;");
        icon.setSize("16.0");
        Button deleteButton = new Button();
        deleteButton.setGraphic((Node)icon);
        deleteButton.setOnAction(e -> {
            try {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("floorId", this.getFloorId());
                String response = Config.loadDataFromPhp("masterdelete?type=floor", params, this.getUser());
                Gson g = new Gson();
                JsonResponses jr = (JsonResponses)g.fromJson(response, JsonResponses.class);
                FloorController.publicNotificationPane.setText(jr.getMessage());
                FloorController.publicNotificationPane.setGraphic((Node)jr.getIconFromStatus());
                FloorController.publicNotificationPane.show();
                if (jr.isStatus()) {
                    ObservableList<Floor> allFloors = new Floor().getAllFloors(this.getPropertyCode(), this.getUser());
                    FloorController.publicFloors.setItems(allFloors);
                }
            }
            catch (Exception t) {
                t.printStackTrace();
            }
        });
        return deleteButton;
    }
}

