/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.Bank;
import classes.Config;
import classes.ShopLocation;
import classes.User;
import com.google.gson.Gson;
import java.util.LinkedHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class ExpressSale {
    private String code;
    private String saleDate;
    private String postedOn;
    private ShopLocation location;
    private boolean posted;
    private boolean reversed;
    private String reversedOn;
    private String reversedBy;
    private Bank bank;
    private String extDocNo;
    private double total;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ShopLocation getLocation() {
        return this.location;
    }

    public void setLocation(ShopLocation location) {
        this.location = location;
    }

    public String getPostedOn() {
        return this.postedOn;
    }

    public void setPostedOn(String postedOn) {
        this.postedOn = postedOn;
    }

    public boolean isPosted() {
        return this.posted;
    }

    public void setPosted(boolean posted) {
        this.posted = posted;
    }

    public String getSaleDate() {
        return this.saleDate;
    }

    public void setSaleDate(String saleDate) {
        this.saleDate = saleDate;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public String getReversedOn() {
        return this.reversedOn;
    }

    public void setReversedOn(String reversedOn) {
        this.reversedOn = reversedOn;
    }

    public String getReversedBy() {
        return this.reversedBy;
    }

    public void setReversedBy(String reversedBy) {
        this.reversedBy = reversedBy;
    }

    public Bank getBank() {
        return this.bank;
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }

    public String getExtDocNo() {
        return this.extDocNo;
    }

    public void setExtDocNo(String extDocNo) {
        this.extDocNo = extDocNo;
    }

    public double getTotal() {
        return this.total;
    }

    public String getTotalString() {
        return Config.formatNumber(this.total);
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public ObservableList<ExpressSalePayments> getPayments(String salesCode, User user) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("salesCode", salesCode);
        String response = Config.loadDataFromPhp("masterfetch?type=expresssalepayment", params, user);
        System.out.println(response);
        return FXCollections.observableArrayList((Object[])((Object[])new Gson().fromJson(response, ExpressSalePayments[].class)));
    }

    public class ExpressSalePayments {
        private int id;
        private Bank paymentMethod;
        private double amount;
        private String transactionRef;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public Bank getPaymentMethod() {
            return this.paymentMethod;
        }

        public void setPaymentMethod(Bank paymentMethod) {
            this.paymentMethod = paymentMethod;
        }

        public double getAmount() {
            return this.amount;
        }

        public String getAmountString() {
            return Config.formatNumber(this.amount);
        }

        public void setAmount(double amount) {
            this.amount = amount;
        }

        public String getTransactionRef() {
            return this.transactionRef;
        }

        public void setTransactionRef(String transactionRef) {
            this.transactionRef = transactionRef;
        }
    }
}

